/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.undo.CompoundEdit;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.util.GapList;
import org.netbeans.modules.editor.lib.EditorPackageAccessor;

public final class BeforeSaveTasks {
    private static final Logger LOG = Logger.getLogger(BeforeSaveTasks.class.getName());
    private final BaseDocument doc;
    private List<Task> tasks = new GapList(1);

    public static synchronized BeforeSaveTasks get(BaseDocument baseDocument) {
        BeforeSaveTasks beforeSaveTasks = (BeforeSaveTasks)baseDocument.getProperty(BeforeSaveTasks.class);
        if (beforeSaveTasks == null) {
            beforeSaveTasks = new BeforeSaveTasks(baseDocument);
            baseDocument.putProperty(BeforeSaveTasks.class, beforeSaveTasks);
        }
        return beforeSaveTasks;
    }

    private BeforeSaveTasks(BaseDocument baseDocument) {
        this.doc = baseDocument;
        Runnable runnable = (Runnable)baseDocument.getProperty("beforeSaveRunnable");
        if (runnable != null) {
            throw new IllegalStateException("\"beforeSaveRunnable\" property of document " + baseDocument + " is already occupied by " + runnable);
        }
        runnable = new Runnable(){

            public void run() {
                BeforeSaveTasks.this.runTasks();
            }
        };
        baseDocument.putProperty("beforeSaveRunnable", runnable);
    }

    public synchronized void addTask(Task task) {
        if (task == null) {
            throw new IllegalArgumentException("task must not be null");
        }
        this.tasks.add(task);
    }

    public synchronized boolean removeTask(Runnable runnable) {
        return this.tasks.remove(runnable);
    }

    private void runTasks() {
        this.doc.runAtomicAsUser(new Runnable(){

            public void run() {
                CompoundEdit compoundEdit = EditorPackageAccessor.get().markAtomicEditsNonSignificant(BeforeSaveTasks.this.doc);
                try {
                    for (Task task : BeforeSaveTasks.this.tasks) {
                        task.run(compoundEdit);
                    }
                }
                catch (Exception exception) {
                    LOG.log(Level.WARNING, "Exception thrown in before-save tasks", exception);
                }
            }
        });
    }

    public static interface Task {
        public void run(CompoundEdit var1);
    }
}

