/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.model;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.modules.soa.mappercore.model.Constant;
import org.netbeans.modules.soa.mappercore.model.Function;
import org.netbeans.modules.soa.mappercore.model.GraphSubset;
import org.netbeans.modules.soa.mappercore.model.Operation;
import org.netbeans.modules.soa.mappercore.model.Vertex;
import org.netbeans.modules.soa.mappercore.model.VertexItem;
import org.netbeans.modules.xml.xpath.ext.CoreFunctionType;
import org.netbeans.modules.xml.xpath.ext.CoreOperationType;
import org.netbeans.modules.xml.xpath.ext.XPathNumericLiteral;
import org.netbeans.modules.xml.xpath.ext.XPathStringLiteral;
import org.netbeans.modules.xml.xpath.ext.metadata.AbstractArgument;
import org.netbeans.modules.xml.xpath.ext.metadata.ArgumentDescriptor;
import org.netbeans.modules.xml.xpath.ext.metadata.ArgumentGroup;
import org.netbeans.modules.xml.xpath.ext.metadata.CoreFunctionMetadata;
import org.netbeans.modules.xml.xpath.ext.metadata.ExtFunctionMetadata;
import org.netbeans.modules.xml.xpath.ext.metadata.GeneralFunctionMetadata;
import org.netbeans.modules.xml.xpath.ext.metadata.OperationMetadata;
import org.netbeans.modules.xml.xpath.ext.metadata.StubExtFunction;
import org.netbeans.modules.xml.xpath.ext.metadata.XPathType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VertexFactory {
    private static VertexFactory singleton = new VertexFactory();
    private static final Icon NUMBER_ICON = new ImageIcon(VertexFactory.class.getResource("/org/netbeans/modules/bpel/mapper/palette/image/numeric.gif"));
    private static final Icon STRING_ICON = new ImageIcon(VertexFactory.class.getResource("/org/netbeans/modules/bpel/mapper/palette/image/string.gif"));

    public static VertexFactory getInstance() {
        return singleton;
    }

    public static Class getEditorClass(ArgumentDescriptor argumentDescriptor) {
        XPathType xPathType = argumentDescriptor.getArgumentType();
        if (xPathType == XPathType.STRING_TYPE) {
            return String.class;
        }
        if (xPathType == XPathType.NUMBER_TYPE) {
            return Number.class;
        }
        return null;
    }

    public static VertexItem constructVItem(Vertex vertex, ArgumentDescriptor argumentDescriptor) {
        String string = argumentDescriptor.getArgumentType().getName();
        VertexItem vertexItem = new VertexItem(vertex, (Object)argumentDescriptor, null, VertexFactory.getEditorClass(argumentDescriptor), string, false);
        return vertexItem;
    }

    public static VertexItem constructHairline(Vertex vertex, Object object) {
        VertexItem vertexItem = new VertexItem(vertex, object, null, null, null, true);
        return vertexItem;
    }

    private Vertex createVertex(Object object) {
        if (object instanceof CoreFunctionType) {
            return this.createCoreFunction((CoreFunctionType)object);
        }
        if (object instanceof ExtFunctionMetadata) {
            return this.createExtFunction((ExtFunctionMetadata)object);
        }
        if (object instanceof CoreOperationType) {
            return this.createCoreOperation((CoreOperationType)object);
        }
        if (object instanceof String) {
            return this.createStringLiteral((String)object);
        }
        if (object instanceof Number) {
            return this.createNumericLiteral((Number)object);
        }
        return null;
    }

    public GraphSubset createGraphSubset(Object object) {
        Vertex vertex = this.createVertex(object);
        if (vertex == null) {
            return null;
        }
        return new GraphSubset(vertex);
    }

    public Function createCoreFunction(CoreFunctionType coreFunctionType) {
        if (coreFunctionType == null) {
            return null;
        }
        CoreFunctionMetadata coreFunctionMetadata = coreFunctionType.getMetadata();
        Function function = new Function((Object)coreFunctionType, coreFunctionMetadata.getIcon(), coreFunctionMetadata.getDisplayName(), coreFunctionMetadata.getResultType().getName());
        this.addVertexItems((Vertex)function, (GeneralFunctionMetadata)coreFunctionMetadata);
        return function;
    }

    public Operation createCoreOperation(CoreOperationType coreOperationType) {
        if (coreOperationType == null) {
            return null;
        }
        OperationMetadata operationMetadata = coreOperationType.getMetadata();
        Operation operation = new Operation((Object)coreOperationType, operationMetadata.getIcon());
        this.addVertexItems((Vertex)operation, (GeneralFunctionMetadata)operationMetadata);
        return operation;
    }

    public Function createExtFunction(ExtFunctionMetadata extFunctionMetadata) {
        if (extFunctionMetadata == null || extFunctionMetadata == StubExtFunction.NULL_METADATA_STUB) {
            return null;
        }
        if (StubExtFunction.STUB_FUNC_NAME.equals(extFunctionMetadata.getName())) {
            return null;
        }
        XPathType xPathType = extFunctionMetadata.getResultType();
        if (xPathType == null) {
            xPathType = XPathType.ANY_TYPE;
        }
        Function function = new Function((Object)extFunctionMetadata, extFunctionMetadata.getIcon(), extFunctionMetadata.getDisplayName(), xPathType.getName());
        this.addVertexItems((Vertex)function, (GeneralFunctionMetadata)extFunctionMetadata);
        return function;
    }

    public Constant createNumericLiteral(Number number) {
        Constant constant = new Constant(XPathNumericLiteral.class, NUMBER_ICON);
        VertexItem vertexItem = new VertexItem((Vertex)constant, (Object)number, Number.class);
        constant.addItem(vertexItem);
        return constant;
    }

    public Constant createStringLiteral(String string) {
        Constant constant = new Constant(XPathStringLiteral.class, STRING_ICON);
        VertexItem vertexItem = new VertexItem((Vertex)constant, (Object)string, String.class);
        constant.addItem(vertexItem);
        return constant;
    }

    private void addVertexItems(Vertex vertex, GeneralFunctionMetadata generalFunctionMetadata) {
        List list = generalFunctionMetadata.getArguments();
        if (list == null) {
            return;
        }
        ArrayList<VertexItem> arrayList = new ArrayList<VertexItem>();
        this.populateArguments(list, vertex, arrayList, true);
        for (VertexItem vertexItem : arrayList) {
            vertex.addItem(vertexItem);
        }
    }

    private void populateArguments(List<AbstractArgument> list, Vertex vertex, List<VertexItem> list2, boolean bl) {
        for (AbstractArgument abstractArgument : list) {
            if (abstractArgument instanceof ArgumentDescriptor) {
                this.populateArgDescrItem(vertex, (ArgumentDescriptor)abstractArgument, list2, bl);
                continue;
            }
            if (!(abstractArgument instanceof ArgumentGroup)) continue;
            this.populateGroupItems(vertex, (ArgumentGroup)abstractArgument, list2, bl);
        }
    }

    private void populateArgDescrItem(Vertex vertex, ArgumentDescriptor argumentDescriptor, List<VertexItem> list, boolean bl) {
        String string = argumentDescriptor.getArgumentType().getName();
        if (!argumentDescriptor.isRepeated()) {
            VertexItem vertexItem = VertexFactory.constructVItem(vertex, argumentDescriptor);
            list.add(vertexItem);
        } else {
            int n = argumentDescriptor.getMinOccurs();
            if (n == 0) {
                n = 1;
            }
            if (bl) {
                VertexItem vertexItem = VertexFactory.constructHairline(vertex, argumentDescriptor);
                list.add(vertexItem);
            }
            boolean bl2 = true;
            for (int i = 0; i < n; ++i) {
                VertexItem vertexItem;
                if (bl2) {
                    bl2 = false;
                } else {
                    vertexItem = VertexFactory.constructHairline(vertex, argumentDescriptor);
                    list.add(vertexItem);
                }
                vertexItem = VertexFactory.constructVItem(vertex, argumentDescriptor);
                list.add(vertexItem);
            }
            if (bl) {
                VertexItem vertexItem = VertexFactory.constructHairline(vertex, argumentDescriptor);
                list.add(vertexItem);
            }
        }
    }

    private void populateGroupItems(Vertex vertex, ArgumentGroup argumentGroup, List<VertexItem> list, boolean bl) {
        List list2 = argumentGroup.getArgumentList();
        if (!argumentGroup.isRepeated()) {
            this.populateArguments(list2, vertex, list, bl);
        } else {
            int n = argumentGroup.getMinOccurs();
            if (n == 0) {
                n = 1;
            }
            if (bl) {
                VertexItem vertexItem = VertexFactory.constructHairline(vertex, argumentGroup);
                list.add(vertexItem);
            }
            boolean bl2 = true;
            for (int i = 0; i < n; ++i) {
                if (bl2) {
                    bl2 = false;
                } else {
                    VertexItem vertexItem = VertexFactory.constructHairline(vertex, argumentGroup);
                    list.add(vertexItem);
                }
                this.populateArguments(list2, vertex, list, false);
            }
            if (bl) {
                VertexItem vertexItem = VertexFactory.constructHairline(vertex, argumentGroup);
                list.add(vertexItem);
            }
        }
    }

    public List<VertexItem> createGroupItems(Vertex vertex, ArgumentGroup argumentGroup) {
        ArrayList<VertexItem> arrayList = new ArrayList<VertexItem>();
        this.populateGroupItems(vertex, argumentGroup, arrayList, false);
        return arrayList;
    }
}

