/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.multiview;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.modules.bpel.mapper.multiview.DesignContextController;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.events.ArrayUpdateEvent;
import org.netbeans.modules.bpel.model.api.events.ChangeEvent;
import org.netbeans.modules.bpel.model.api.events.ChangeEventListener;
import org.netbeans.modules.bpel.model.api.events.EntityInsertEvent;
import org.netbeans.modules.bpel.model.api.events.EntityRemoveEvent;
import org.netbeans.modules.bpel.model.api.events.EntityUpdateEvent;
import org.netbeans.modules.bpel.model.api.events.PropertyRemoveEvent;
import org.netbeans.modules.bpel.model.api.events.PropertyUpdateEvent;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;

public class BpelModelSynchListener
implements Runnable,
ChangeEventListener,
ComponentListener {
    private BpelModel bpelModel;
    private List<WSDLModel> wsdlModels;
    private List<SchemaModel> schemaModels;
    private DesignContextController mController;
    private EventObject scheduledEvent = null;

    public BpelModelSynchListener(DesignContextController designContextController) {
        assert (designContextController != null);
        this.mController = designContextController;
    }

    public void processDataObject(Object object) {
        if (object instanceof SchemaComponent) {
            this.register(((SchemaComponent)object).getModel());
        } else if (object instanceof Part) {
            this.register(((Part)object).getModel());
        } else if (object instanceof Message) {
            this.register(((Message)object).getModel());
        }
    }

    public void register(BpelModel bpelModel) {
        if (this.bpelModel != bpelModel) {
            if (this.bpelModel != null) {
                this.bpelModel.removeEntityChangeListener((ChangeEventListener)this);
            }
            if (bpelModel != null) {
                bpelModel.addEntityChangeListener((ChangeEventListener)this);
            }
            this.bpelModel = bpelModel;
        }
    }

    public void register(WSDLModel wSDLModel) {
        if (wSDLModel == null) {
            return;
        }
        if (this.wsdlModels == null) {
            this.wsdlModels = new ArrayList<WSDLModel>();
        }
        if (!this.wsdlModels.contains(wSDLModel)) {
            this.wsdlModels.add(wSDLModel);
            wSDLModel.addComponentListener((ComponentListener)this);
        }
    }

    public void register(SchemaModel schemaModel) {
        if (schemaModel == null) {
            return;
        }
        if (this.schemaModels == null) {
            this.schemaModels = new ArrayList<SchemaModel>();
        }
        if (!this.schemaModels.contains(schemaModel)) {
            this.schemaModels.add(schemaModel);
            schemaModel.addComponentListener((ComponentListener)this);
        }
    }

    public void unregisterAll() {
        if (this.bpelModel != null) {
            this.bpelModel.removeEntityChangeListener((ChangeEventListener)this);
            this.bpelModel = null;
        }
        if (this.wsdlModels != null) {
            for (WSDLModel wSDLModel : this.wsdlModels) {
                wSDLModel.removeComponentListener((ComponentListener)this);
            }
            this.wsdlModels.clear();
            this.wsdlModels = null;
        }
        if (this.schemaModels != null) {
            for (SchemaModel schemaModel : this.schemaModels) {
                schemaModel.removeComponentListener((ComponentListener)this);
            }
            this.schemaModels.clear();
            this.schemaModels = null;
        }
    }

    public void valueChanged(ComponentEvent componentEvent) {
        this.reloadMapper(componentEvent);
    }

    public void childrenAdded(ComponentEvent componentEvent) {
        this.reloadMapper(componentEvent);
    }

    public void childrenDeleted(ComponentEvent componentEvent) {
        this.reloadMapper(componentEvent);
    }

    public void notifyPropertyUpdated(PropertyUpdateEvent propertyUpdateEvent) {
        this.reloadMapper((ChangeEvent)propertyUpdateEvent);
    }

    public void notifyArrayUpdated(ArrayUpdateEvent arrayUpdateEvent) {
        this.reloadMapper((ChangeEvent)arrayUpdateEvent);
    }

    public void notifyEntityInserted(EntityInsertEvent entityInsertEvent) {
        this.reloadMapper((ChangeEvent)entityInsertEvent);
    }

    public void notifyEntityRemoved(EntityRemoveEvent entityRemoveEvent) {
        this.reloadMapper((ChangeEvent)entityRemoveEvent);
    }

    public void notifyEntityUpdated(EntityUpdateEvent entityUpdateEvent) {
        this.reloadMapper((ChangeEvent)entityUpdateEvent);
    }

    public void notifyPropertyRemoved(PropertyRemoveEvent propertyRemoveEvent) {
        this.reloadMapper((ChangeEvent)propertyRemoveEvent);
    }

    private void reloadMapper(final ChangeEvent changeEvent) {
        if (!changeEvent.isLastInAtomic()) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            if (this.bpelModel != null) {
                this.mController.reloadMapper((EventObject)changeEvent);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (BpelModelSynchListener.this.bpelModel != null) {
                        BpelModelSynchListener.this.mController.reloadMapper((EventObject)changeEvent);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadMapper(ComponentEvent componentEvent) {
        BpelModelSynchListener bpelModelSynchListener = this;
        synchronized (bpelModelSynchListener) {
            if (this.scheduledEvent == null) {
                this.scheduledEvent = componentEvent;
                SwingUtilities.invokeLater(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        EventObject eventObject;
        BpelModelSynchListener bpelModelSynchListener = this;
        synchronized (bpelModelSynchListener) {
            eventObject = this.scheduledEvent;
            this.scheduledEvent = null;
        }
        if (eventObject != null && this.bpelModel != null) {
            this.mController.reloadMapper(eventObject);
        }
    }
}

