/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.predicates;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.netbeans.modules.bpel.mapper.model.PathConverter;
import org.netbeans.modules.bpel.mapper.predicates.AbstractPredicate;
import org.netbeans.modules.bpel.mapper.tree.models.VariableTreeModel;
import org.netbeans.modules.soa.ui.tree.SoaTreeModel;
import org.netbeans.modules.soa.ui.tree.TreeItem;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.xpath.ext.XPathPredicateExpression;
import org.netbeans.modules.xml.xpath.ext.XPathUtils;
import org.netbeans.modules.xml.xpath.ext.schema.resolver.SchemaCompHolder;
import org.netbeans.modules.xml.xpath.ext.spi.XPathPseudoComp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredicateManager {
    private LinkedList<CachedPredicate> mPredicates = new LinkedList();

    public static PredicateManager getPredicateManager(SoaTreeModel soaTreeModel) {
        VariableTreeModel variableTreeModel = (VariableTreeModel)SoaTreeModel.MyUtils.findExtensionModel((SoaTreeModel)soaTreeModel, VariableTreeModel.class);
        if (variableTreeModel != null) {
            PredicateManager predicateManager = variableTreeModel.getPredicateManager();
            return predicateManager;
        }
        return null;
    }

    public List<AbstractPredicate> getPredicates(TreeItem treeItem, SchemaComponent schemaComponent) {
        ArrayList<AbstractPredicate> arrayList = new ArrayList<AbstractPredicate>();
        for (CachedPredicate cachedPredicate : this.mPredicates) {
            if (!cachedPredicate.hasSameBase(schemaComponent) || !cachedPredicate.hasSameLocation((Iterable)treeItem)) continue;
            arrayList.add(cachedPredicate.getPredicate());
        }
        return arrayList;
    }

    public List<AbstractPredicate> getPredicates(TreeItem treeItem, XPathPseudoComp xPathPseudoComp) {
        ArrayList<AbstractPredicate> arrayList = new ArrayList<AbstractPredicate>();
        for (CachedPredicate cachedPredicate : this.mPredicates) {
            if (!cachedPredicate.hasSameBase(xPathPseudoComp) || !cachedPredicate.hasSameLocation((Iterable)treeItem)) continue;
            arrayList.add(cachedPredicate.getPredicate());
        }
        return arrayList;
    }

    public boolean addPredicate(List<Object> list, AbstractPredicate abstractPredicate) {
        for (CachedPredicate cachedPredicate : this.mPredicates) {
            if (!cachedPredicate.hasSameLocation(list) || !cachedPredicate.hasSamePredicate(abstractPredicate)) continue;
            return false;
        }
        CachedPredicate cachedPredicate = new CachedPredicate(list, abstractPredicate);
        this.mPredicates.add(cachedPredicate);
        return true;
    }

    public boolean addPredicate(TreeItem treeItem, AbstractPredicate abstractPredicate) {
        List<Object> list = PathConverter.constructObjectLocationtList(treeItem, true, false);
        if (list != null) {
            return this.addPredicate(list, abstractPredicate);
        }
        return false;
    }

    public void removePredicate(AbstractPredicate abstractPredicate) {
        for (CachedPredicate cachedPredicate : this.mPredicates) {
            AbstractPredicate abstractPredicate2 = cachedPredicate.getPredicate();
            if (!abstractPredicate2.equals(abstractPredicate)) continue;
            this.mPredicates.remove(abstractPredicate2);
            break;
        }
    }

    public static String toString(XPathPredicateExpression[] xPathPredicateExpressionArray) {
        if (xPathPredicateExpressionArray != null && xPathPredicateExpressionArray.length != 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (XPathPredicateExpression xPathPredicateExpression : xPathPredicateExpressionArray) {
                stringBuilder.append(xPathPredicateExpression.getExpressionString());
            }
            return stringBuilder.toString();
        }
        return "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CachedPredicate {
        private List<Object> mParentPath;
        private AbstractPredicate mPred;
        private boolean isPersistent;

        public CachedPredicate(List<Object> list, AbstractPredicate abstractPredicate) {
            this.mParentPath = list;
            this.mPred = abstractPredicate;
        }

        public boolean isPersistent() {
            return this.isPersistent;
        }

        public void setPersistent(boolean bl) {
            this.isPersistent = bl;
        }

        public SchemaCompHolder getBaseType() {
            return this.mPred.getSCompHolder();
        }

        public AbstractPredicate getPredicate() {
            return this.mPred;
        }

        public List getParentPath() {
            return this.mParentPath;
        }

        public boolean hasSameBase(SchemaComponent schemaComponent) {
            SchemaCompHolder schemaCompHolder = this.getPredicate().getSCompHolder();
            if (schemaCompHolder.isPseudoComp()) {
                return false;
            }
            return schemaCompHolder.getSchemaComponent().equals(schemaComponent);
        }

        public boolean hasSameBase(XPathPseudoComp xPathPseudoComp) {
            SchemaCompHolder schemaCompHolder = this.getPredicate().getSCompHolder();
            if (schemaCompHolder.isPseudoComp()) {
                return schemaCompHolder.getHeldComponent().equals(xPathPseudoComp);
            }
            return false;
        }

        public boolean hasSameBase(SchemaCompHolder schemaCompHolder) {
            return this.getPredicate().getSCompHolder().equals(schemaCompHolder);
        }

        public boolean hasSameParams(SchemaCompHolder schemaCompHolder, XPathPredicateExpression[] xPathPredicateExpressionArray) {
            AbstractPredicate abstractPredicate = this.getPredicate();
            return abstractPredicate.getSCompHolder().equals(schemaCompHolder) && XPathUtils.samePredicatesArr((XPathPredicateExpression[])abstractPredicate.getPredicates(), (XPathPredicateExpression[])xPathPredicateExpressionArray);
        }

        public boolean hasSamePredicate(AbstractPredicate abstractPredicate) {
            AbstractPredicate abstractPredicate2 = this.getPredicate();
            return abstractPredicate2.equals(abstractPredicate);
        }

        public boolean hasSameLocation(Iterable iterable) {
            return this.hasSameLocationImpl(iterable.iterator());
        }

        private boolean hasSameLocationImpl(Iterator iterator) {
            Iterator<Object> iterator2 = this.mParentPath.iterator();
            boolean bl = true;
            while (iterator.hasNext() && iterator2.hasNext()) {
                Object object;
                Object e = iterator.next();
                if (e.equals(object = iterator2.next())) continue;
                bl = false;
                break;
            }
            if (bl && iterator2.hasNext()) {
                return false;
            }
            return bl;
        }

        public String toString() {
            String string = this.mPred.toString() + " persistent=" + this.isPersistent;
            String string2 = this.locationToString();
            if (string2 == null || string2.length() == 0) {
                return string;
            }
            return string2 + " " + string;
        }

        private String locationToString() {
            StringBuilder stringBuilder = new StringBuilder();
            ListIterator<Object> listIterator = this.mParentPath.listIterator(this.mParentPath.size());
            boolean bl = true;
            while (listIterator.hasPrevious()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append("/");
                }
                Object object = listIterator.previous();
                stringBuilder.append(object.toString());
            }
            return stringBuilder.toString();
        }

        public boolean equals(Object object) {
            if (!(object instanceof CachedPredicate)) {
                return false;
            }
            CachedPredicate cachedPredicate = (CachedPredicate)object;
            if (!cachedPredicate.getPredicate().equals(this.mPred)) {
                return false;
            }
            List list = cachedPredicate.getParentPath();
            if (list.size() != this.mParentPath.size()) {
                return false;
            }
            ListIterator<Object> listIterator = this.mParentPath.listIterator();
            ListIterator listIterator2 = list.listIterator();
            while (listIterator.hasNext()) {
                Object e;
                Object e2 = listIterator.next();
                if (e2.equals(e = listIterator2.next())) continue;
                return false;
            }
            return true;
        }
    }
}

