/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.predicates.editor;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.bpel.mapper.model.BpelMapperModel;
import org.netbeans.modules.bpel.mapper.model.GraphExpandProcessor;
import org.netbeans.modules.bpel.mapper.model.GraphInfoCollector;
import org.netbeans.modules.bpel.mapper.palette.Palette;
import org.netbeans.modules.bpel.mapper.predicates.AbstractPredicate;
import org.netbeans.modules.bpel.mapper.predicates.editor.PredicatesMapperFactory;
import org.netbeans.modules.bpel.mapper.tree.MapperSwingTreeModel;
import org.netbeans.modules.bpel.mapper.tree.search.FinderListBuilder;
import org.netbeans.modules.soa.mappercore.LeftTree;
import org.netbeans.modules.soa.mappercore.Mapper;
import org.netbeans.modules.soa.mappercore.model.Graph;
import org.netbeans.modules.soa.mappercore.model.MapperModel;
import org.netbeans.modules.soa.mappercore.model.Vertex;
import org.netbeans.modules.soa.ui.SoaUtil;
import org.netbeans.modules.soa.ui.form.EditorLifeCycleAdapter;
import org.netbeans.modules.soa.ui.form.valid.DefaultDialogDescriptor;
import org.netbeans.modules.soa.ui.form.valid.DefaultValidStateManager;
import org.netbeans.modules.soa.ui.form.valid.DefaultValidator;
import org.netbeans.modules.soa.ui.form.valid.SoaDialogDisplayer;
import org.netbeans.modules.soa.ui.form.valid.ValidStateManager;
import org.netbeans.modules.soa.ui.form.valid.Validator;
import org.netbeans.modules.soa.ui.tree.ExtTreeModel;
import org.netbeans.modules.soa.ui.tree.TreeItemFinder;
import org.netbeans.modules.soa.ui.tree.impl.TreeFinderProcessor;
import org.netbeans.modules.xml.xpath.ext.schema.resolver.XPathSchemaContext;
import org.openide.DialogDescriptor;
import org.openide.util.NbBundle;

public class PredicateEditor
extends EditorLifeCycleAdapter
implements Validator.Provider,
ValidStateManager.Provider {
    private Mapper mMapper;
    private MapperModel mMapperModel;
    private XPathSchemaContext mSContext;
    private AbstractPredicate mPred;
    private String mDlgTitle;
    private DefaultValidator mValidator;
    private ValidStateManager mVSM;
    private JButton btnGoToContext;
    private JTextField fldContext;
    private JLabel lblContext;
    private JPanel pnlMenu;

    public PredicateEditor(XPathSchemaContext xPathSchemaContext, AbstractPredicate abstractPredicate, MapperModel mapperModel) {
        this.mSContext = xPathSchemaContext;
        this.mPred = abstractPredicate;
        this.mMapperModel = mapperModel;
        this.createContent();
        this.initControls();
    }

    public Mapper getMapper() {
        return this.mMapper;
    }

    public void createContent() {
        assert (EventQueue.isDispatchThread());
        this.mMapper = PredicatesMapperFactory.createMapper(this.mMapperModel);
        this.initComponents();
        this.mDlgTitle = NbBundle.getMessage(PredicateEditor.class, (String)"PREDICATE_DLG_TITLE");
        this.btnGoToContext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PredicateEditor.this.mSContext != null) {
                    PredicateEditor.this.showSchemaContextInSourceTree();
                }
            }
        });
        SoaUtil.activateInlineMnemonics((Container)((Object)this));
    }

    public boolean initControls() {
        if (this.mSContext != null) {
            this.fldContext.setText(this.mSContext.toString());
            this.showSchemaContextInSourceTree();
            GraphExpandProcessor.expandAllGraphs(this.mMapper, this.mMapperModel);
        } else {
            this.fldContext.setText(NbBundle.getMessage(PredicateEditor.class, (String)"UNKNOWN_SCHEMA_CONTEXT"));
        }
        return true;
    }

    public String getDlgTitle() {
        return this.mDlgTitle;
    }

    public static boolean showDlg(PredicateEditor predicateEditor) {
        DefaultDialogDescriptor defaultDialogDescriptor = new DefaultDialogDescriptor((Object)predicateEditor, predicateEditor.getDlgTitle());
        Dialog dialog = SoaDialogDisplayer.getDefault().createDialog((DialogDescriptor)defaultDialogDescriptor);
        SoaUtil.setInitialFocusComponentFor((Container)((Object)predicateEditor));
        dialog.setVisible(true);
        return defaultDialogDescriptor.isOkHasPressed();
    }

    private JPanel createPalette() {
        return new Palette(this.mMapper).getPanel();
    }

    private void showSchemaContextInSourceTree() {
        if (this.mSContext == null) {
            return;
        }
        List<TreeItemFinder> list = FinderListBuilder.build(this.mSContext);
        TreeModel treeModel = this.mMapperModel.getLeftTreeModel();
        assert (treeModel instanceof MapperSwingTreeModel);
        TreeFinderProcessor treeFinderProcessor = new TreeFinderProcessor((ExtTreeModel)((MapperSwingTreeModel)((Object)treeModel)));
        TreePath treePath = treeFinderProcessor.findFirstNode(list);
        if (treePath != null) {
            LeftTree leftTree = this.mMapper.getLeftTree();
            leftTree.expandPath(treePath);
            leftTree.scrollPathToVisible(treePath);
            leftTree.setSelectionPath(treePath);
        }
    }

    public ValidStateManager getValidStateManager(boolean bl) {
        if (bl) {
            return null;
        }
        if (this.mVSM == null) {
            this.mVSM = new DefaultValidStateManager();
        }
        return this.mVSM;
    }

    public Validator getValidator() {
        if (this.mValidator == null) {
            this.mValidator = new DefaultValidator(this, PredicateEditor.class){

                public void doFastValidation() {
                }

                public void doDetailedValidation() {
                    assert (PredicateEditor.this.mMapperModel instanceof BpelMapperModel);
                    Map<TreePath, Graph> map = ((BpelMapperModel)PredicateEditor.this.mMapperModel).getGraphsInside(null);
                    int n = 0;
                    int n2 = 0;
                    for (Graph graph : map.values()) {
                        ArrayList<Vertex> arrayList;
                        GraphInfoCollector graphInfoCollector = new GraphInfoCollector(graph);
                        if (graphInfoCollector.noLinksAtAll()) {
                            ++n;
                        }
                        if ((arrayList = graphInfoCollector.getSecondryRoots()) == null || arrayList.isEmpty()) continue;
                        ++n2;
                    }
                    if (map.size() == n) {
                        this.addReasonKey(Validator.Severity.ERROR, "WARN_THERE_ARENT_ANY_CONNECTED_GRAPH");
                    } else if (n > 0) {
                        this.addReasonKey(Validator.Severity.WARNING, "WARN_THERE_ARE_UNCONNECTED_GRAPHS");
                    }
                    if (n2 > 0) {
                        this.addReasonKey(Validator.Severity.WARNING, "WARN_THERE_ARE_INCOMPLETE_GRAPHS");
                    }
                }
            };
        }
        return this.mValidator;
    }

    private void initComponents() {
        this.pnlMenu = this.createPalette();
        Mapper mapper = this.mMapper;
        this.lblContext = new JLabel();
        this.fldContext = new JTextField();
        this.btnGoToContext = new JButton();
        this.setPreferredSize(new Dimension(1000, 600));
        mapper.setBorder(BorderFactory.createBevelBorder(1));
        this.lblContext.setLabelFor(this.fldContext);
        this.lblContext.setText(NbBundle.getMessage(PredicateEditor.class, (String)"LBL_Context"));
        this.fldContext.setEditable(false);
        this.btnGoToContext.setText(NbBundle.getMessage(PredicateEditor.class, (String)"BTN_Context"));
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)mapper, -1, 976, Short.MAX_VALUE).add((Component)this.pnlMenu, -1, 976, Short.MAX_VALUE).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblContext).addPreferredGap(0).add((Component)this.fldContext, -1, 808, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.btnGoToContext))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.pnlMenu, -2, -1, -2).addPreferredGap(0).add((Component)mapper, -1, 551, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblContext).add((Component)this.btnGoToContext).add((Component)this.fldContext, -2, -1, -2))));
        this.fldContext.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PredicateEditor.class).getString("ACSN_TXTFLD_SchemaContext"));
        this.fldContext.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PredicateEditor.class).getString("ACSD_TXTFLD_SchemaContext"));
        this.btnGoToContext.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PredicateEditor.class).getString("ACSN_BTN_SetFocus"));
        this.btnGoToContext.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PredicateEditor.class).getString("ACSD_BTN_SetFocus"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PredicateEditor.class).getString("ACSN_DLG_PredicateEditor"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PredicateEditor.class).getString("ACSD_DLG_PredicateEditor"));
    }
}

