/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.tree.models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.mapper.tree.models.MapperConnectabilityProvider;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.PartnerLinkContainer;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.model.api.support.Roles;
import org.netbeans.modules.soa.ui.tree.SoaTreeExtensionModel;
import org.netbeans.modules.soa.ui.tree.TreeItem;
import org.netbeans.modules.soa.ui.tree.TreeItemActionsProvider;
import org.netbeans.modules.soa.ui.tree.TreeItemInfoProvider;
import org.netbeans.modules.soa.ui.tree.TreeStructureProvider;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartnerLinkTreeExtModel
implements SoaTreeExtensionModel,
TreeItemInfoProvider,
TreeStructureProvider,
TreeItemActionsProvider,
MapperConnectabilityProvider {
    private BpelEntity mContextEntity;
    private boolean mShowEndpointRef;

    public PartnerLinkTreeExtModel(BpelEntity bpelEntity, boolean bl) {
        this.mContextEntity = bpelEntity;
        this.mShowEndpointRef = bl;
    }

    public List getChildren(TreeItem treeItem) {
        Object object = treeItem.getDataObject();
        if (object == "Tree_Root") {
            Process process = this.mContextEntity.getBpelModel().getProcess();
            PartnerLinkContainer partnerLinkContainer = process.getPartnerLinkContainer();
            if (partnerLinkContainer != null) {
                return Collections.singletonList(partnerLinkContainer);
            }
            return null;
        }
        if (object instanceof PartnerLinkContainer) {
            PartnerLinkContainer partnerLinkContainer = (PartnerLinkContainer)object;
            if (partnerLinkContainer != null) {
                return this.filterPartnerLink((Roles)(!this.mShowEndpointRef ? Roles.PARTNER_ROLE : null), partnerLinkContainer);
            }
        } else if (this.mShowEndpointRef && object instanceof PartnerLink) {
            PartnerLink partnerLink = (PartnerLink)object;
            ArrayList<Roles> arrayList = new ArrayList<Roles>();
            if (partnerLink.getMyRole() != null) {
                arrayList.add(Roles.MY_ROLE);
            }
            if (partnerLink.getPartnerRole() != null) {
                arrayList.add(Roles.PARTNER_ROLE);
            }
            return arrayList;
        }
        return null;
    }

    private List<PartnerLink> filterPartnerLink(Roles roles, PartnerLinkContainer partnerLinkContainer) {
        ArrayList<PartnerLink> arrayList;
        block5: {
            int n;
            PartnerLink[] partnerLinkArray;
            block4: {
                if (partnerLinkContainer == null) {
                    return Collections.emptyList();
                }
                partnerLinkArray = partnerLinkContainer.getPartnerLinks();
                if (roles == null) {
                    return Arrays.asList(partnerLinkArray);
                }
                arrayList = new ArrayList<PartnerLink>();
                n = partnerLinkArray.length;
                if (!Roles.MY_ROLE.equals((Object)roles)) break block4;
                for (int i = 0; i < n; ++i) {
                    PartnerLink partnerLink = partnerLinkArray[i];
                    if (partnerLink == null || partnerLink.getMyRole() == null) continue;
                    arrayList.add(partnerLink);
                }
                break block5;
            }
            if (!Roles.PARTNER_ROLE.equals((Object)roles)) break block5;
            for (int i = 0; i < n; ++i) {
                PartnerLink partnerLink = partnerLinkArray[i];
                if (partnerLink == null || partnerLink.getPartnerRole() == null) continue;
                arrayList.add(partnerLink);
            }
        }
        return arrayList;
    }

    public Boolean isLeaf(TreeItem treeItem) {
        return null;
    }

    @Override
    public Boolean isConnectable(TreeItem treeItem) {
        Object object = treeItem.getDataObject();
        if (this.mShowEndpointRef) {
            return object instanceof Roles;
        }
        return object instanceof PartnerLink;
    }

    public TreeStructureProvider getTreeStructureProvider() {
        return this;
    }

    public TreeItemInfoProvider getTreeItemInfoProvider() {
        return this;
    }

    public TreeItemActionsProvider getTreeItemActionsProvider() {
        return this;
    }

    public String getDisplayName(TreeItem treeItem) {
        Object object = treeItem.getDataObject();
        if (object instanceof PartnerLinkContainer) {
            return NbBundle.getMessage(PartnerLinkTreeExtModel.class, (String)"PARTNER_LINK_CONTAINER");
        }
        if (object instanceof Roles) {
            return object.toString();
        }
        return null;
    }

    public Icon getIcon(TreeItem treeItem) {
        Object object = treeItem.getDataObject();
        if (object instanceof PartnerLinkContainer) {
            return NodeType.VARIABLE_CONTAINER.getIcon();
        }
        return null;
    }

    public List<Action> getMenuActions(TreeItem treeItem, Object object, TreePath treePath) {
        return null;
    }

    public String getToolTipText(TreeItem treeItem) {
        Object object = treeItem.getDataObject();
        if (object instanceof PartnerLink) {
            PartnerLink partnerLink = (PartnerLink)object;
            String string = "<html> <body> Partner Link ";
            if (partnerLink.getName() != null) {
                string = string + "<b><font color =#7C0000>" + partnerLink.getName() + "</font></b>";
            }
            if (partnerLink.getDocumentation() != null) {
                string = string + "<hr><p width = 486>" + partnerLink.getDocumentation() + "</p>";
            }
            if (partnerLink.getMyRole() != null) {
                string = string + "<hr><p><b><font color =#000099> myRole= </font></b>" + partnerLink.getMyRole().getRefString() + "</p>";
            }
            if (partnerLink.getPartnerRole() != null) {
                string = string + "<b><font color =#000099> partnerRole= </font></b>" + partnerLink.getPartnerRole().getRefString();
            }
            string = string + " </body>";
            return string;
        }
        if (object instanceof Roles) {
            Object object2;
            Object object3 = treeItem.getParent().getDataObject();
            String string = null;
            String string2 = null;
            if (object3 instanceof PartnerLink) {
                object2 = (PartnerLink)object3;
                if (Roles.MY_ROLE.equals(object)) {
                    string = object2.getMyRole().getRefString();
                    string2 = object2.getMyRole().getEffectiveNamespace();
                }
                if (Roles.PARTNER_ROLE.equals(object)) {
                    string = object2.getPartnerRole().getRefString();
                    string2 = object2.getPartnerRole().getEffectiveNamespace();
                }
            }
            object2 = "<html><body><b><font color =#000099>" + ((Roles)object).toString() + " = </font></b>";
            if (string != null) {
                object2 = (String)object2 + string;
            }
            if (string2 != null && string2.length() > 0) {
                object2 = (String)object2 + "<hr> NameSpace= " + string2;
            }
            object2 = (String)object2 + "</body>";
            return object2;
        }
        return null;
    }
}

