/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.client;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.text.NumberFormat;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.JTextComponent;
import javax.swing.text.NumberFormatter;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RequiredConfigurationHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class AdvancedConfigPanelClient
extends SectionInnerPanel {
    private WSDLModel serviceModel;
    private Binding binding;
    private boolean inSync = false;
    private static final String DEFAULT_LIFETIME = "36000";
    private static final String DEFAULT_RMRESENDINTERVAL = "2000";
    private static final String DEFAULT_RMCLOSETIMEOUT = "0";
    private static final String DEFAULT_RMREQUESTACKINTERVAL = "200";
    private DefaultFormatterFactory lifetimeDff = null;
    private DefaultFormatterFactory closeTimeoutDff = null;
    private DefaultFormatterFactory rmSendDff = null;
    private DefaultFormatterFactory rmReqDff = null;
    private DefaultFormatterFactory timeoutDff = null;
    private DefaultFormatterFactory freshnessDff = null;
    private DefaultFormatterFactory skewDff = null;
    private JFormattedTextField freshnessField;
    private JLabel freshnessLabel;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JLabel lifeTimeLabel;
    private JFormattedTextField lifeTimeTextField;
    private JFormattedTextField maxClockSkewField;
    private JLabel maxClockSkewLabel;
    private JCheckBox renewExpiredChBox;
    private JCheckBox requireCancelChBox;
    private JCheckBox revocationChBox;
    private JFormattedTextField rmAckRequestField;
    private JLabel rmAckRequestLabel;
    private JFormattedTextField rmCloseTimeoutField;
    private JLabel rmCloseTimeoutLabel;
    private JFormattedTextField rmResendField;
    private JLabel rmResendLabel;

    public AdvancedConfigPanelClient(SectionView sectionView, Binding binding, WSDLModel wSDLModel) {
        super(sectionView);
        this.serviceModel = wSDLModel;
        this.binding = binding;
        this.lifetimeDff = new DefaultFormatterFactory();
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        numberFormat.setGroupingUsed(false);
        numberFormat.setParseIntegerOnly(true);
        numberFormat.setMaximumFractionDigits(0);
        NumberFormatter numberFormatter = new NumberFormatter(numberFormat);
        numberFormatter.setCommitsOnValidEdit(true);
        numberFormatter.setMinimum(Integer.valueOf(0));
        this.lifetimeDff.setDefaultFormatter(numberFormatter);
        this.rmSendDff = new DefaultFormatterFactory();
        NumberFormat numberFormat2 = NumberFormat.getIntegerInstance();
        numberFormat2.setGroupingUsed(false);
        numberFormat2.setParseIntegerOnly(true);
        numberFormat2.setMaximumFractionDigits(0);
        NumberFormatter numberFormatter2 = new NumberFormatter(numberFormat2);
        numberFormatter2.setCommitsOnValidEdit(true);
        numberFormatter2.setMinimum(Integer.valueOf(0));
        this.rmSendDff.setDefaultFormatter(numberFormatter2);
        this.rmReqDff = new DefaultFormatterFactory();
        NumberFormat numberFormat3 = NumberFormat.getIntegerInstance();
        numberFormat3.setGroupingUsed(false);
        numberFormat3.setParseIntegerOnly(true);
        numberFormat3.setMaximumFractionDigits(0);
        NumberFormatter numberFormatter3 = new NumberFormatter(numberFormat3);
        numberFormatter3.setCommitsOnValidEdit(true);
        numberFormatter3.setMinimum(Integer.valueOf(0));
        this.rmReqDff.setDefaultFormatter(numberFormatter3);
        this.timeoutDff = new DefaultFormatterFactory();
        NumberFormat numberFormat4 = NumberFormat.getIntegerInstance();
        numberFormat4.setGroupingUsed(false);
        numberFormat4.setParseIntegerOnly(true);
        numberFormat4.setMaximumFractionDigits(0);
        NumberFormatter numberFormatter4 = new NumberFormatter(numberFormat4);
        numberFormatter4.setCommitsOnValidEdit(true);
        numberFormatter4.setMinimum(Integer.valueOf(0));
        this.timeoutDff.setDefaultFormatter(numberFormatter4);
        this.closeTimeoutDff = new DefaultFormatterFactory();
        NumberFormat numberFormat5 = NumberFormat.getIntegerInstance();
        numberFormat5.setGroupingUsed(false);
        numberFormat5.setParseIntegerOnly(true);
        numberFormat5.setMaximumFractionDigits(0);
        NumberFormatter numberFormatter5 = new NumberFormatter(numberFormat5);
        numberFormatter5.setCommitsOnValidEdit(true);
        numberFormatter5.setMinimum(Integer.valueOf(0));
        this.closeTimeoutDff.setDefaultFormatter(numberFormatter5);
        this.freshnessDff = new DefaultFormatterFactory();
        NumberFormat numberFormat6 = NumberFormat.getIntegerInstance();
        numberFormat6.setGroupingUsed(false);
        numberFormat6.setParseIntegerOnly(true);
        numberFormat6.setMaximumFractionDigits(0);
        NumberFormatter numberFormatter6 = new NumberFormatter(numberFormat6);
        numberFormatter6.setCommitsOnValidEdit(true);
        numberFormatter6.setMinimum(Integer.valueOf(0));
        this.freshnessDff.setDefaultFormatter(numberFormatter6);
        this.skewDff = new DefaultFormatterFactory();
        NumberFormat numberFormat7 = NumberFormat.getIntegerInstance();
        numberFormat7.setGroupingUsed(false);
        numberFormat7.setParseIntegerOnly(true);
        numberFormat7.setMaximumFractionDigits(0);
        NumberFormatter numberFormatter7 = new NumberFormatter(numberFormat7);
        numberFormatter7.setCommitsOnValidEdit(true);
        numberFormatter7.setMinimum(Integer.valueOf(0));
        this.skewDff.setDefaultFormatter(numberFormatter7);
        this.initComponents();
        this.lifeTimeLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.lifeTimeTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.renewExpiredChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.requireCancelChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.rmAckRequestField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.rmAckRequestLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.rmResendField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.rmResendLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.rmCloseTimeoutLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.rmCloseTimeoutField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.maxClockSkewField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.maxClockSkewLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.freshnessField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.freshnessLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.revocationChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.addImmediateModifier(this.rmAckRequestField);
        this.addImmediateModifier(this.rmCloseTimeoutField);
        this.addImmediateModifier(this.rmResendField);
        this.addImmediateModifier(this.lifeTimeTextField);
        this.addImmediateModifier(this.renewExpiredChBox);
        this.addImmediateModifier(this.requireCancelChBox);
        this.addImmediateModifier(this.maxClockSkewField);
        this.addImmediateModifier(this.freshnessField);
        this.addImmediateModifier(this.revocationChBox);
        this.sync();
    }

    public void sync() {
        this.inSync = true;
        String string = ProprietarySecurityPolicyModelHelper.getLifeTime(this.binding, true);
        if (string == null) {
            this.lifeTimeTextField.setText(DEFAULT_LIFETIME);
        } else {
            this.lifeTimeTextField.setText(string);
        }
        String string2 = ProprietarySecurityPolicyModelHelper.getMaxClockSkew(this.binding);
        if (string2 == null) {
            this.maxClockSkewField.setText("300000");
        } else {
            this.maxClockSkewField.setText(string2);
        }
        String string3 = ProprietarySecurityPolicyModelHelper.getTimestampFreshness(this.binding);
        if (string3 == null) {
            this.freshnessField.setText("300000");
        } else {
            this.freshnessField.setText(string3);
        }
        String string4 = RMModelHelper.getResendInterval(this.binding);
        if (string4 == null) {
            this.rmResendField.setText(DEFAULT_RMRESENDINTERVAL);
        } else {
            this.rmResendField.setText(string4);
        }
        String string5 = RMModelHelper.getCloseTimeout(this.binding);
        if (string5 == null) {
            this.rmCloseTimeoutField.setText(DEFAULT_RMCLOSETIMEOUT);
        } else {
            this.rmCloseTimeoutField.setText(string5);
        }
        String string6 = RMModelHelper.getAckRequestInterval(this.binding);
        if (string6 == null) {
            this.rmAckRequestField.setText(DEFAULT_RMREQUESTACKINTERVAL);
        } else {
            this.rmAckRequestField.setText(string6);
        }
        this.setChBox(this.renewExpiredChBox, ProprietarySecurityPolicyModelHelper.isRenewExpired(this.binding));
        this.setChBox(this.requireCancelChBox, ProprietarySecurityPolicyModelHelper.isRequireCancel(this.binding));
        this.setChBox(this.revocationChBox, ProprietarySecurityPolicyModelHelper.isRevocationEnabled(this.binding));
        this.enableDisable();
        this.inSync = false;
    }

    public void setValue(JComponent jComponent, Object object) {
        if (!this.inSync) {
            String string;
            Integer n;
            ConfigVersion configVersion = PolicyModelHelper.getConfigVersion((WSDLComponent)this.binding);
            RMModelHelper rMModelHelper = RMModelHelper.getInstance(configVersion);
            if (jComponent.equals(this.lifeTimeTextField)) {
                n = (Integer)this.lifeTimeTextField.getValue();
                String string2 = string = n == null ? null : n.toString();
                if (string == null || string.length() == 0 || DEFAULT_LIFETIME.equals(string)) {
                    ProprietarySecurityPolicyModelHelper.setLifeTime(this.binding, null, true);
                } else {
                    ProprietarySecurityPolicyModelHelper.setLifeTime(this.binding, string, true);
                }
            }
            if (jComponent.equals(this.maxClockSkewField)) {
                n = (Integer)this.maxClockSkewField.getValue();
                String string3 = string = n == null ? null : n.toString();
                if (string == null || string.length() == 0 || "300000".equals(string)) {
                    ProprietarySecurityPolicyModelHelper.setMaxClockSkew(this.binding, null, true);
                } else {
                    ProprietarySecurityPolicyModelHelper.setMaxClockSkew(this.binding, string, true);
                }
            }
            if (jComponent.equals(this.freshnessField)) {
                n = (Integer)this.freshnessField.getValue();
                String string4 = string = n == null ? null : n.toString();
                if (string == null || string.length() == 0 || "300000".equals(string)) {
                    ProprietarySecurityPolicyModelHelper.setTimestampFreshness(this.binding, null, true);
                } else {
                    ProprietarySecurityPolicyModelHelper.setTimestampFreshness(this.binding, string, true);
                }
            }
            if (jComponent.equals(this.rmResendField)) {
                n = (Integer)this.rmResendField.getValue();
                String string5 = string = n == null ? null : n.toString();
                if (string == null || string.length() == 0 || DEFAULT_RMRESENDINTERVAL.equals(string)) {
                    rMModelHelper.setResendInterval(this.binding, null);
                } else {
                    rMModelHelper.setResendInterval(this.binding, string);
                }
            }
            if (jComponent.equals(this.rmCloseTimeoutField)) {
                n = (Integer)this.rmCloseTimeoutField.getValue();
                String string6 = string = n == null ? null : n.toString();
                if (string == null || string.length() == 0 || DEFAULT_RMCLOSETIMEOUT.equals(string)) {
                    rMModelHelper.setCloseTimeout(this.binding, null);
                } else {
                    rMModelHelper.setCloseTimeout(this.binding, string);
                }
            }
            if (jComponent.equals(this.rmAckRequestField)) {
                n = (Integer)this.rmAckRequestField.getValue();
                String string7 = string = n == null ? null : n.toString();
                if (string == null || string.length() == 0 || DEFAULT_RMREQUESTACKINTERVAL.equals(string)) {
                    rMModelHelper.setAckRequestInterval(this.binding, null);
                } else {
                    rMModelHelper.setAckRequestInterval(this.binding, string);
                }
            }
            if (jComponent.equals(this.renewExpiredChBox)) {
                ProprietarySecurityPolicyModelHelper.setRenewExpired(this.binding, this.renewExpiredChBox.isSelected());
            }
            if (jComponent.equals(this.requireCancelChBox)) {
                ProprietarySecurityPolicyModelHelper.setRequireCancel(this.binding, this.requireCancelChBox.isSelected());
            }
            if (jComponent.equals(this.revocationChBox)) {
                ProprietarySecurityPolicyModelHelper.setRevocation(this.binding, this.revocationChBox.isSelected(), true);
            }
        }
    }

    private void enableDisable() {
        Binding binding = PolicyModelHelper.getBinding(this.serviceModel, this.binding.getName());
        boolean bl = RMModelHelper.getInstance(ConfigVersion.CONFIG_1_0).isRMEnabled((WSDLComponent)binding) || RMModelHelper.getInstance(ConfigVersion.CONFIG_1_3).isRMEnabled((WSDLComponent)binding);
        boolean bl2 = RequiredConfigurationHelper.isSecureConversationParamRequired((WSDLComponent)binding);
        this.rmAckRequestLabel.setEnabled(bl);
        this.rmAckRequestField.setEnabled(bl);
        this.rmResendLabel.setEnabled(bl);
        this.rmResendField.setEnabled(bl);
        this.rmCloseTimeoutField.setEnabled(bl);
        this.rmCloseTimeoutLabel.setEnabled(bl);
        this.lifeTimeTextField.setEnabled(bl2);
        this.lifeTimeLabel.setEnabled(bl2);
        this.renewExpiredChBox.setEnabled(bl2);
        this.requireCancelChBox.setEnabled(bl2);
        boolean bl3 = SecurityPolicyModelHelper.isSecurityEnabled((WSDLComponent)binding);
        this.requireCancelChBox.setEnabled(bl3);
        this.maxClockSkewField.setEnabled(bl3);
        this.freshnessField.setEnabled(bl3);
    }

    private void setChBox(JCheckBox jCheckBox, Boolean bl) {
        if (bl == null) {
            jCheckBox.setSelected(false);
        } else {
            jCheckBox.setSelected(bl);
        }
    }

    public void documentChanged(JTextComponent jTextComponent, String string) {
    }

    public void rollbackValue(JTextComponent jTextComponent) {
    }

    protected void endUIChange() {
    }

    public void linkButtonPressed(Object object, String string) {
    }

    public JComponent getErrorComponent(String string) {
        return null;
    }

    private void initComponents() {
        this.lifeTimeLabel = new JLabel();
        this.renewExpiredChBox = new JCheckBox();
        this.requireCancelChBox = new JCheckBox();
        this.rmResendLabel = new JLabel();
        this.rmAckRequestLabel = new JLabel();
        this.rmResendField = new JFormattedTextField();
        this.rmAckRequestField = new JFormattedTextField();
        this.lifeTimeTextField = new JFormattedTextField();
        this.rmCloseTimeoutLabel = new JLabel();
        this.rmCloseTimeoutField = new JFormattedTextField();
        this.maxClockSkewLabel = new JLabel();
        this.maxClockSkewField = new JFormattedTextField();
        this.freshnessLabel = new JLabel();
        this.freshnessField = new JFormattedTextField();
        this.revocationChBox = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.lifeTimeLabel.setLabelFor(this.lifeTimeTextField);
        Mnemonics.setLocalizedText((JLabel)this.lifeTimeLabel, (String)NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"LBL_AdvancedConfigPanel_SCTokenLifeTime"));
        Mnemonics.setLocalizedText((AbstractButton)this.renewExpiredChBox, (String)NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"LBL_AdvancedConfigPanel_RenewExpired"));
        this.renewExpiredChBox.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.requireCancelChBox, (String)NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"LBL_AdvancedConfigPanel_RequireCancel"));
        this.requireCancelChBox.setMargin(new Insets(0, 0, 0, 0));
        this.rmResendLabel.setLabelFor(this.rmResendField);
        Mnemonics.setLocalizedText((JLabel)this.rmResendLabel, (String)NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"LBL_AdvancedConfigPanel_ResendInterval"));
        this.rmAckRequestLabel.setLabelFor(this.rmAckRequestField);
        Mnemonics.setLocalizedText((JLabel)this.rmAckRequestLabel, (String)NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"LBL_AdvancedConfigPanel_AckRequestInterval"));
        this.rmResendField.setFormatterFactory(this.rmSendDff);
        this.rmAckRequestField.setFormatterFactory(this.rmReqDff);
        this.lifeTimeTextField.setFormatterFactory(this.lifetimeDff);
        this.rmCloseTimeoutLabel.setLabelFor(this.rmCloseTimeoutField);
        Mnemonics.setLocalizedText((JLabel)this.rmCloseTimeoutLabel, (String)NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"LBL_AdvancedConfigPanel_CloseTimeout"));
        this.rmCloseTimeoutField.setFormatterFactory(this.closeTimeoutDff);
        this.maxClockSkewLabel.setLabelFor(this.rmResendField);
        Mnemonics.setLocalizedText((JLabel)this.maxClockSkewLabel, (String)NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"LBL_AdvancedConfigPanel_MaxClockSkew"));
        this.maxClockSkewField.setFormatterFactory(this.skewDff);
        this.freshnessLabel.setLabelFor(this.rmResendField);
        Mnemonics.setLocalizedText((JLabel)this.freshnessLabel, (String)NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"LBL_AdvancedConfigPanel_TimestampFreshness"));
        this.freshnessField.setFormatterFactory(this.freshnessDff);
        Mnemonics.setLocalizedText((AbstractButton)this.revocationChBox, (String)NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"LBL_AdvancedConfigPanel_Revocation"));
        this.revocationChBox.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.rmResendLabel).add((Component)this.rmCloseTimeoutLabel).add((Component)this.rmAckRequestLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.rmResendField, -1, 87, Short.MAX_VALUE).add((Component)this.rmCloseTimeoutField, -1, 87, Short.MAX_VALUE).add(1, (Component)this.rmAckRequestField, -1, 87, Short.MAX_VALUE))).add((Component)this.jSeparator2, -1, 369, Short.MAX_VALUE).add(2, (Component)this.jSeparator1, -1, 369, Short.MAX_VALUE).add((Component)this.renewExpiredChBox).add((Component)this.requireCancelChBox).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lifeTimeLabel).add(50, 50, 50).add((Component)this.lifeTimeTextField, -1, 93, Short.MAX_VALUE)).add((Component)this.revocationChBox).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.maxClockSkewLabel).add((Component)this.freshnessLabel)).add(69, 69, 69).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.freshnessField, -1, 92, Short.MAX_VALUE).add((Component)this.maxClockSkewField, -1, 92, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.rmResendLabel).add((Component)this.rmResendField, -2, 20, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.rmCloseTimeoutLabel).add((Component)this.rmCloseTimeoutField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.rmAckRequestLabel).add((Component)this.rmAckRequestField, -2, -1, -2)).addPreferredGap(0).add((Component)this.jSeparator1, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lifeTimeLabel).add((Component)this.lifeTimeTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.renewExpiredChBox).addPreferredGap(0).add((Component)this.requireCancelChBox).addPreferredGap(0).add((Component)this.jSeparator2, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.maxClockSkewLabel).add((Component)this.maxClockSkewField, -2, 20, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.freshnessLabel).add((Component)this.freshnessField, -2, -1, -2)).addPreferredGap(0).add((Component)this.revocationChBox).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.linkSize(new Component[]{this.freshnessField, this.lifeTimeTextField, this.maxClockSkewField, this.rmAckRequestField, this.rmCloseTimeoutField, this.rmResendField}, 2);
        this.lifeTimeLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"ACSN_AdvancedConfigPanel_SCTokenLifeTime"));
        this.lifeTimeLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"ACSD_AdvancedConfigPanel_SCTokenLifeTime"));
        this.renewExpiredChBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"ACSN_AdvancedConfigPanel_RenewExpired"));
        this.renewExpiredChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"ACSD_AdvancedConfigPanel_RenewExpired"));
        this.requireCancelChBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"ACSN_AdvancedConfigPanel_RequireCancel"));
        this.requireCancelChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"ACSD_AdvancedConfigPanel_RequireCancel"));
        this.rmResendLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"ACSN_AdvancedConfigPanel_ResendInterval"));
        this.rmResendLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"ACSD_AdvancedConfigPanel_ResendInterval"));
        this.rmAckRequestLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"ACSN_AdvancedConfigPanel_AckRequestInterval"));
        this.rmAckRequestLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"ACSD_AdvancedConfigPanel_AckRequestInterval"));
        this.rmCloseTimeoutLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"ACSN_AdvancedConfigPanel_CloseTimeout"));
        this.rmCloseTimeoutLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"ACSD_AdvancedConfigPanel_CloseTimeout"));
    }
}

