/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.undo.UndoManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.wsitconf.ui.service.PanelFactory;
import org.netbeans.modules.websvc.wsitconf.ui.service.ServiceView;
import org.netbeans.modules.xml.multiview.ui.PanelView;
import org.netbeans.modules.xml.multiview.ui.ToolBarDesignEditor;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceTopComponent
extends TopComponent {
    static final long serialVersionUID = 6021472310161712674L;
    private boolean initialized = false;
    private static final Logger logger = Logger.getLogger(ServiceTopComponent.class.getName());
    private WSDLModel wsdlModel;
    private UndoManager undoManager;
    private Node node;
    private Service service;
    private boolean serviceOnly;
    private JaxWsModel jaxWsModel;
    private FileObject implClass;
    private Collection<Binding> bindings;

    public ServiceTopComponent(Service service, JaxWsModel jaxWsModel, WSDLModel wSDLModel, Node node, UndoManager undoManager) {
        this.setLayout(new BorderLayout());
        this.wsdlModel = wSDLModel;
        this.undoManager = undoManager;
        this.node = node;
        this.service = service;
        this.jaxWsModel = jaxWsModel;
    }

    public ServiceTopComponent(WSDLModel wSDLModel, UndoManager undoManager, Collection<Binding> collection, Node node) {
        this.setLayout(new BorderLayout());
        this.wsdlModel = wSDLModel;
        this.undoManager = undoManager;
        this.bindings = collection;
        this.node = node;
    }

    public ServiceTopComponent(Service service, JaxWsModel jaxWsModel, WSDLModel wSDLModel, FileObject fileObject, UndoManager undoManager, boolean bl) {
        this.setLayout(new BorderLayout());
        this.wsdlModel = wSDLModel;
        this.undoManager = undoManager;
        this.service = service;
        this.jaxWsModel = jaxWsModel;
        this.implClass = fileObject;
        this.serviceOnly = bl;
    }

    protected String preferredID() {
        return "WSITTopComponent";
    }

    private void doInitialize() {
        this.initAccessibility();
        ToolBarDesignEditor toolBarDesignEditor = new ToolBarDesignEditor();
        if (this.wsdlModel == null) {
            logger.log(Level.INFO, "WSDL Model not ready");
            return;
        }
        ModelSource modelSource = this.wsdlModel.getModelSource();
        FileObject fileObject = Utilities.getFileObject((ModelSource)modelSource);
        Project project = fileObject != null ? FileOwnerQuery.getOwner((FileObject)fileObject) : null;
        PanelFactory panelFactory = new PanelFactory(toolBarDesignEditor, this.node, this.undoManager, project, this.jaxWsModel);
        ServiceView serviceView = new ServiceView(panelFactory, this.wsdlModel, this.node, this.implClass, this.service, this.bindings, this.serviceOnly);
        toolBarDesignEditor.setContentView((PanelView)serviceView);
        this.add((Component)toolBarDesignEditor);
        this.setFocusable(true);
    }

    public int getPersistenceType() {
        return 0;
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServiceTopComponent.class, (String)"ACS_Tab_DESC"));
    }

    public void addNotify() {
        if (!this.initialized) {
            this.initialized = true;
            this.doInitialize();
        }
        super.addNotify();
    }

    protected void componentShowing() {
        if (!this.initialized) {
            this.initialized = true;
            this.doInitialize();
        }
        super.componentShowing();
    }
}

