/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.profiles;

import java.awt.Dialog;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.websvc.wsitconf.spi.features.ClientDefaultsFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.ServiceDefaultsFeature;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.ProfileBase;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.SAMLAuthorizationOverSSL;
import org.netbeans.modules.websvc.wsitconf.util.UndoCounter;
import org.netbeans.modules.websvc.wsitconf.wizard.SamlCallbackCreator;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProfilesModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;

public class SAMLAuthorizationOverSSLProfile
extends ProfileBase
implements ClientDefaultsFeature,
ServiceDefaultsFeature {
    private static final String PKGNAME = "samlcb";

    public int getId() {
        return 50;
    }

    public String getDisplayName() {
        return ComboConstants.PROF_SAMLSSL;
    }

    public String getDescription() {
        return ComboConstants.PROF_SAMLSSL_INFO;
    }

    public boolean isCurrentProfile(WSDLComponent wSDLComponent) {
        return this.getDisplayName().equals(ProfilesModelHelper.getWSITSecurityProfile(wSDLComponent));
    }

    public void displayConfig(WSDLComponent wSDLComponent, UndoManager undoManager) {
        UndoCounter undoCounter = new UndoCounter();
        WSDLModel wSDLModel = wSDLComponent.getModel();
        wSDLModel.addUndoableEditListener((UndoableEditListener)undoCounter);
        SAMLAuthorizationOverSSL sAMLAuthorizationOverSSL = new SAMLAuthorizationOverSSL(wSDLComponent, this);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)sAMLAuthorizationOverSSL, this.getDisplayName());
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.CANCEL_OPTION) {
            for (int i = 0; i < undoCounter.getCounter(); ++i) {
                if (!undoManager.canUndo()) continue;
                undoManager.undo();
            }
        }
        wSDLModel.removeUndoableEditListener((UndoableEditListener)undoCounter);
    }

    public boolean isProfileSupported(Project project, WSDLComponent wSDLComponent, boolean bl) {
        return true;
    }

    public void setClientDefaults(WSDLComponent wSDLComponent, WSDLComponent wSDLComponent2, Project project) {
        ProprietarySecurityPolicyModelHelper.setStoreLocation(wSDLComponent, null, false, true);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(wSDLComponent, null, true, true);
        ProprietarySecurityPolicyModelHelper.removeCallbackHandlerConfiguration((Binding)wSDLComponent);
        FileObject fileObject = null;
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        if (sourceGroupArray != null && sourceGroupArray.length > 0) {
            fileObject = sourceGroupArray[0].getRootFolder();
        }
        SamlCallbackCreator samlCallbackCreator = new SamlCallbackCreator();
        String string = this.getSamlVersion((Binding)wSDLComponent2);
        String string2 = "SamlCallbackHandler";
        if (fileObject != null) {
            if (fileObject.getFileObject(PKGNAME) == null) {
                try {
                    fileObject = fileObject.createFolder(PKGNAME);
                }
                catch (IOException iOException) {
                    Logger.getLogger("global").log(Level.SEVERE, null, iOException);
                }
            } else {
                fileObject = fileObject.getFileObject(PKGNAME);
            }
            if (ComboConstants.SAML_V2011.equals(string)) {
                string2 = "Saml20SVCallbackHandler";
                if (fileObject.getFileObject(string2, "java") == null) {
                    samlCallbackCreator.generateSamlCBHandler(fileObject, string2, "sv", "20");
                }
            } else {
                string2 = "Saml11SVCallbackHandler";
                if (fileObject.getFileObject(string2, "java") == null) {
                    samlCallbackCreator.generateSamlCBHandler(fileObject, string2, "sv", "11");
                }
            }
        }
        ProprietarySecurityPolicyModelHelper.setCallbackHandler((Binding)wSDLComponent, "samlHandler", "samlcb." + string2, null, true);
    }

    public void setServiceDefaults(WSDLComponent wSDLComponent, Project project) {
        ProprietarySecurityPolicyModelHelper.clearValidators(wSDLComponent);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(wSDLComponent, null, false, false);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(wSDLComponent, null, true, false);
    }

    public boolean isServiceDefaultSetupUsed(WSDLComponent wSDLComponent, Project project) {
        return !ProprietarySecurityPolicyModelHelper.isAnyValidatorSet(wSDLComponent);
    }

    public boolean isClientDefaultSetupUsed(WSDLComponent wSDLComponent, Binding binding, Project project) {
        if (ProprietarySecurityPolicyModelHelper.isAnyValidatorSet(wSDLComponent)) {
            return false;
        }
        String string = this.getSamlVersion(binding);
        String string2 = null;
        string2 = ComboConstants.SAML_V2011.equals(string) ? "Saml20SVCallbackHandler" : "Saml11SVCallbackHandler";
        String string3 = ProprietarySecurityPolicyModelHelper.getCallbackHandler((Binding)wSDLComponent, "samlHandler");
        return ("samlcb." + string2).equals(string3);
    }

    private String getSamlVersion(Binding binding) {
        WSDLComponent wSDLComponent = SecurityTokensModelHelper.getSupportingToken((WSDLComponent)binding, 1);
        WSDLComponent wSDLComponent2 = SecurityTokensModelHelper.getTokenTypeElement(wSDLComponent);
        return SecurityTokensModelHelper.getTokenProfileVersion(wSDLComponent2);
    }
}

