/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.util;

import java.awt.Component;
import java.awt.Container;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.websvc.jaxwsruntimemodel.JavaWsdlMapper;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.jaxws.JaxWs;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingFault;
import org.netbeans.modules.xml.wsdl.model.BindingInput;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.BindingOutput;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Input;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.Output;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;
import org.netbeans.modules.xml.wsdl.model.RequestResponseOperation;
import org.netbeans.modules.xml.wsdl.model.WSDLComponentFactory;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static final String LOGGER_GLOBAL = "global";
    private static final String WSSIP = "wssip";
    private static final String XWS_SECURITY_CLIENT = "xws-security-client";
    private static final String XWS_SECURITY_SERVER = "xws-security-server";
    private static final String SERVER_KEYSTORE_BUNDLED = "/org/netbeans/modules/websvc/wsitconf/resources/server-keystore.jks";
    private static final String SERVER_TRUSTSTORE_BUNDLED = "/org/netbeans/modules/websvc/wsitconf/resources/server-truststore.jks";
    private static final String CLIENT_KEYSTORE_BUNDLED = "/org/netbeans/modules/websvc/wsitconf/resources/client-keystore.jks";
    private static final String CLIENT_TRUSTSTORE_BUNDLED = "/org/netbeans/modules/websvc/wsitconf/resources/client-truststore.jks";
    private static final String PASSWORD = "changeit";
    private static final String STORE_FOLDER_NAME = "certs";
    private static final Logger logger = Logger.getLogger(Util.class.getName());
    public static final String BUNDLED_TOMCAT_SETTING = "J2EE/BundledTomcat/Setting";
    private static final String BUILD_SCRIPT = "/build.xml";
    private static final String BACKUP_EXT = ".bak";
    private static final String IMPORT_WSIT_DEPLOY_XML = "<import file=\"nbproject/wsit-deploy.xml\"/>";
    private static final String IMPORT_TAG = "<import";
    private static final String WSIT_DEPLOY_XML_PATH = "nbproject/wsit-deploy.xml";
    private static final String WSIT_DEPLOY_XSL = "org/netbeans/modules/websvc/wsitconf/resources/wsit-deploy.xsl";

    public static void changeLabelInComponent(JComponent jComponent, String string, String string2) {
        JLabel jLabel = Util.findLabel(jComponent, string);
        if (jLabel != null) {
            jLabel.setText(string2);
        }
    }

    public static void hideLabelAndLabelFor(JComponent jComponent, String string) {
        JLabel jLabel = Util.findLabel(jComponent, string);
        if (jLabel != null) {
            jLabel.setVisible(false);
            Component component = jLabel.getLabelFor();
            if (component != null) {
                component.setVisible(false);
            }
        }
    }

    public static void getAllComponents(Component[] componentArray, Collection<Component> collection) {
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] == null) continue;
            collection.add(componentArray[i]);
            if (((Container)componentArray[i]).getComponentCount() == 0) continue;
            Util.getAllComponents(((Container)componentArray[i]).getComponents(), collection);
        }
    }

    public static JLabel findLabel(JComponent jComponent, String string) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        Util.getAllComponents(jComponent.getComponents(), arrayList);
        for (Component component : arrayList) {
            JLabel jLabel;
            if (!(component instanceof JLabel) || !(jLabel = (JLabel)component).getText().equals(string)) continue;
            return jLabel;
        }
        return null;
    }

    public static SourceGroup[] getJavaSourceGroups(Project project) {
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        Set<SourceGroup> set = Util.getTestSourceGroups(sourceGroupArray);
        ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>();
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            if (set.contains(sourceGroupArray[i])) continue;
            arrayList.add(sourceGroupArray[i]);
        }
        return arrayList.toArray(new SourceGroup[arrayList.size()]);
    }

    private static Set<SourceGroup> getTestSourceGroups(SourceGroup[] sourceGroupArray) {
        Map map = Util.createFoldersToSourceGroupsMap(sourceGroupArray);
        HashSet<SourceGroup> hashSet = new HashSet<SourceGroup>();
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            hashSet.addAll(Util.getTestTargets(sourceGroupArray[i], map));
        }
        return hashSet;
    }

    private static Map createFoldersToSourceGroupsMap(SourceGroup[] sourceGroupArray) {
        Map<FileObject, SourceGroup> map;
        if (sourceGroupArray.length == 0) {
            map = Collections.emptyMap();
        } else {
            map = new HashMap(2 * sourceGroupArray.length, 0.5f);
            for (int i = 0; i < sourceGroupArray.length; ++i) {
                SourceGroup sourceGroup = sourceGroupArray[i];
                map.put(sourceGroup.getRootFolder(), sourceGroup);
            }
        }
        return map;
    }

    private static List<FileObject> getFileObjects(URL[] uRLArray) {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (int i = 0; i < uRLArray.length; ++i) {
            FileObject fileObject = URLMapper.findFileObject((URL)uRLArray[i]);
            if (fileObject != null) {
                arrayList.add(fileObject);
                continue;
            }
            if (!logger.isLoggable(Level.INFO)) continue;
            logger.log(Level.INFO, "No FileObject found for the following URL: " + uRLArray[i]);
        }
        return arrayList;
    }

    private static List<SourceGroup> getTestTargets(SourceGroup sourceGroup, Map map) {
        URL[] uRLArray = UnitTestForSourceQuery.findUnitTests((FileObject)sourceGroup.getRootFolder());
        if (uRLArray.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>();
        List<FileObject> list = Util.getFileObjects(uRLArray);
        for (int i = 0; i < list.size(); ++i) {
            FileObject fileObject = list.get(i);
            SourceGroup sourceGroup2 = (SourceGroup)map.get(fileObject);
            if (sourceGroup2 == null) continue;
            arrayList.add(sourceGroup2);
        }
        return arrayList;
    }

    public static boolean isPositiveNumber(String string, boolean bl, boolean bl2) {
        Integer n = null;
        if (string == null || "".equals(string)) {
            return bl2;
        }
        try {
            n = Integer.parseInt(string);
            if (n != null) {
                if (bl) {
                    return n >= 0;
                }
                return n > 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            logger.log(Level.FINE, null, numberFormatException);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getAliases(String string, char[] cArray, String string2) throws IOException {
        if (string == null || string2 == null) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            Object object;
            File file = new File(string);
            if (file == null || !file.exists()) {
                throw new IOException();
            }
            fileInputStream = new FileInputStream(file);
            KeyStore keyStore = KeyStore.getInstance(string2);
            keyStore.load(fileInputStream, cArray);
            Enumeration<String> enumeration = keyStore.aliases();
            ArrayList<Object> arrayList = new ArrayList<Object>(keyStore.size());
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                arrayList.add(object);
            }
            Collections.sort(arrayList);
            object = arrayList;
            return object;
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.log(Level.INFO, null, fileNotFoundException);
        }
        catch (KeyStoreException keyStoreException) {
            logger.log(Level.INFO, null, keyStoreException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.log(Level.INFO, null, noSuchAlgorithmException);
        }
        catch (CertificateException certificateException) {
            logger.log(Level.INFO, null, certificateException);
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        return null;
    }

    public static final String getPassword(Project project) {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider != null) {
            InstanceProperties instanceProperties = j2eeModuleProvider.getInstanceProperties();
            return instanceProperties.getProperty("password");
        }
        return "";
    }

    private static String getServerInstanceID(Project project) {
        J2eeModuleProvider j2eeModuleProvider;
        if (project != null && (j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class)) != null) {
            return j2eeModuleProvider.getServerInstanceID();
        }
        return null;
    }

    public static final boolean isWsitSupported(Project project) {
        J2eePlatform j2eePlatform;
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        ClassPath classPath = ClassPath.getClassPath((FileObject)sourceGroupArray[0].getRootFolder(), (String)"classpath/compile");
        FileObject fileObject = classPath.findResource("com/sun/xml/ws/policy/Policy.class");
        if (fileObject == null && (j2eePlatform = Util.getJ2eePlatform(project)) != null) {
            Collection collection = j2eePlatform.getLookup().lookupAll(WSStack.class);
            for (WSStack wSStack : collection) {
                if (!wSStack.isFeatureSupported((WSStack.Feature)JaxWs.Feature.WSIT)) continue;
                return true;
            }
        }
        return true;
    }

    public static J2eePlatform getJ2eePlatform(Project project) {
        String string = Util.getServerInstanceID(project);
        if (string != null && string.length() > 0) {
            try {
                return Deployment.getDefault().getServerInstance(string).getJ2eePlatform();
            }
            catch (InstanceRemovedException instanceRemovedException) {
                Exceptions.printStackTrace((Throwable)instanceRemovedException);
            }
        }
        return null;
    }

    public static boolean isJavaEE5orHigher(Project project) {
        J2eeModule j2eeModule;
        if (project == null) {
            return false;
        }
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider != null && (j2eeModule = j2eeModuleProvider.getJ2eeModule()) != null) {
            Object object = j2eeModule.getModuleType();
            double d = Double.parseDouble(j2eeModule.getModuleVersion());
            if (J2eeModule.EJB.equals(object) && d > 2.1) {
                return true;
            }
            if (J2eeModule.WAR.equals(object) && d > 2.4) {
                return true;
            }
            if (J2eeModule.CLIENT.equals(object) && d > 1.4) {
                return true;
            }
        }
        return false;
    }

    public static String getServerName(Project project) {
        String string = Util.getServerInstanceID(project);
        if (string != null) {
            try {
                J2eePlatform j2eePlatform = Deployment.getDefault().getServerInstance(string).getJ2eePlatform();
                return j2eePlatform.getDisplayName();
            }
            catch (InstanceRemovedException instanceRemovedException) {
                Exceptions.printStackTrace((Throwable)instanceRemovedException);
            }
        }
        return null;
    }

    public static boolean isEqual(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object != null && object2 != null) {
            return object.equals(object2);
        }
        return false;
    }

    public static String getStoreLocation(Project project, boolean bl, boolean bl2) {
        String string = null;
        if (project == null) {
            return string;
        }
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider != null) {
            String string2 = j2eeModuleProvider.getServerInstanceID();
            InstanceProperties instanceProperties = j2eeModuleProvider.getInstanceProperties();
            if (instanceProperties == null || "".equals(instanceProperties.getProperty("LOCATION"))) {
                return "";
            }
            string = Util.getStoreLocation(string2, bl, bl2);
        }
        return string;
    }

    private static String getStoreLocation(String string, boolean bl, boolean bl2) {
        String string2 = null;
        J2eePlatform j2eePlatform = null;
        File[] fileArray = null;
        String string3 = null;
        try {
            j2eePlatform = Deployment.getDefault().getServerInstance(string).getJ2eePlatform();
        }
        catch (InstanceRemovedException instanceRemovedException) {
            Exceptions.printStackTrace((Throwable)instanceRemovedException);
        }
        string3 = bl2 ? (bl ? "truststoreClient" : "keystoreClient") : (bl ? "truststore" : "keystore");
        fileArray = j2eePlatform.getToolClasspathEntries(string3);
        if (fileArray != null && fileArray.length > 0) {
            string2 = fileArray[0].getAbsolutePath();
        }
        return string2;
    }

    public static FileObject getTomcatLocation(Project project) {
        InstalledFileLocator installedFileLocator;
        String string = null;
        String string2 = null;
        File file = null;
        File file2 = null;
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        InstanceProperties instanceProperties = null;
        if (j2eeModuleProvider != null) {
            instanceProperties = j2eeModuleProvider.getInstanceProperties();
        }
        String string3 = instanceProperties.getProperty("url");
        int n = string3.indexOf("http://");
        int n2 = string3.indexOf("home=") + "home=".length();
        int n3 = string3.indexOf(":base=", n2);
        if (n2 >= "home=".length()) {
            FileSystem fileSystem;
            FileObject fileObject;
            int n4 = n3 > 0 ? n3 : (n > 0 ? n - 1 : string3.length());
            int n5 = n > 0 ? n - 1 : string3.length();
            string = string3.substring(n2, n4);
            if (n3 > 0) {
                string2 = string3.substring(n3 + ":base=".length(), n5);
            }
            if (string.length() > 0 && string.charAt(0) == '$' && (fileObject = (fileSystem = Repository.getDefault().getDefaultFileSystem()).findResource(BUNDLED_TOMCAT_SETTING)) != null) {
                string = fileObject.getAttribute(string.substring(1)).toString();
                if (string2 != null && string2.length() > 0 && string2.charAt(0) == '$') {
                    string2 = fileObject.getAttribute(string2.substring(1)).toString();
                }
            }
        }
        if (string == null) {
            throw new IllegalArgumentException("CATALINA_HOME must not be null.");
        }
        file = new File(string);
        if (!file.isAbsolute()) {
            InstalledFileLocator installedFileLocator2 = InstalledFileLocator.getDefault();
            file = installedFileLocator2.locate(string, null, false);
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("CATALINA_HOME directory does not exist.");
        }
        if (string2 != null && !(file2 = new File(string2)).isAbsolute() && (file2 = (installedFileLocator = InstalledFileLocator.getDefault()).locate(string2, null, false)) == null) {
            file2 = new File(System.getProperty("netbeans.user"), string2);
        }
        return file2 == null ? (file == null ? null : FileUtil.toFileObject((File)file)) : FileUtil.toFileObject(file2);
    }

    public static FileObject getServerXml(Project project) {
        String string = "conf/server.xml";
        FileObject fileObject = Util.getTomcatLocation(project);
        return fileObject == null ? null : fileObject.getFileObject(string);
    }

    public static FileObject getTomcatLocation(String string) {
        if (string == null) {
            return null;
        }
        FileObject fileObject = null;
        try {
            String string2;
            File file;
            int n = string.indexOf("home=") + 5;
            int n2 = string.indexOf(":", string.indexOf("home=") + 1);
            if (n2 <= n) {
                n2 = string.length();
            }
            if ((file = new File(string2 = string.substring(n, n2))) != null) {
                fileObject = FileUtil.toFileObject((File)file);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(LOGGER_GLOBAL).log(Level.INFO, string, exception);
        }
        return fileObject;
    }

    public static final void fillDefaultsToServer(String string) {
        boolean bl = Util.isGlassfish(string);
        String string2 = Util.getStoreLocation(string, false, false);
        String string3 = Util.getStoreLocation(string, true, false);
        String string4 = Util.getStoreLocation(string, false, true);
        String string5 = Util.getStoreLocation(string, true, true);
        if (!bl) {
            FileObject fileObject = Util.getTomcatLocation(string);
            try {
                Object object;
                Object object22;
                FileObject fileObject2;
                FileObject fileObject3 = FileUtil.createFolder((FileObject)fileObject, (String)STORE_FOLDER_NAME);
                DataFolder dataFolder = (DataFolder)DataObject.find((FileObject)fileObject3);
                FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
                FileObject fileObject4 = fileSystem.findResource("Templates/WebServices/client-keystore.jks");
                FileObject fileObject5 = fileSystem.findResource("Templates/WebServices/client-truststore.jks");
                FileObject fileObject6 = fileSystem.findResource("Templates/WebServices/server-keystore.jks");
                FileObject fileObject7 = fileSystem.findResource("Templates/WebServices/server-truststore.jks");
                for (Object object22 : fileObject2 = new FileObject[]{fileObject4, fileObject5, fileObject6, fileObject7}) {
                    if (object22 == null || (object = DataObject.find((FileObject)object22)) == null || fileObject3.getFileObject(object22.getName(), object22.getExt()) != null) continue;
                    object.createFromTemplate(dataFolder, object22.getNameExt());
                }
                FileObject fileObject8 = fileObject.getFileObject("conf/tomcat-users.xml");
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                object22 = documentBuilder.parse(FileUtil.toFile((FileObject)fileObject8));
                object = object22.getElementsByTagName("tomcat-users");
                if (object != null && object.getLength() > 0) {
                    Object object3;
                    Object object4;
                    Object object5;
                    Node node = object.item(0);
                    NodeList nodeList = object22.getElementsByTagName("user");
                    boolean bl2 = false;
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        object5 = nodeList.item(i);
                        if (!(object5 instanceof Element) || !"wsitUser".equals(object4 = (object3 = (Element)object5).getAttribute("name"))) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2) {
                        if (fileObject8.getParent().getFileObject("tomcat-users.backup", "xml") == null) {
                            FileUtil.copyFile((FileObject)fileObject8, (FileObject)fileObject8.getParent(), (String)"tomcat-users.backup");
                        }
                        Element element = object22.createElement("user");
                        element.setAttribute("name", "wsitUser");
                        element.setAttribute("password", PASSWORD);
                        element.setAttribute("roles", "tomcat");
                        node.appendChild(element);
                        object5 = TransformerFactory.newInstance().newTransformer();
                        ((Transformer)object5).setOutputProperty("indent", "yes");
                        object3 = new StreamResult(FileUtil.toFile((FileObject)fileObject8));
                        object4 = new DOMSource((Node)object22);
                        ((Transformer)object5).transform((Source)object4, (Result)object3);
                    }
                }
            }
            catch (Exception exception) {
                Logger.getLogger(LOGGER_GLOBAL).log(Level.INFO, null, exception);
            }
            return;
        }
        String string6 = Util.getDefaultPassword(string);
        try {
            Util.copyKey(SERVER_KEYSTORE_BUNDLED, XWS_SECURITY_SERVER, PASSWORD, PASSWORD, string2, XWS_SECURITY_SERVER, string6, false);
            Util.copyKey(SERVER_KEYSTORE_BUNDLED, WSSIP, PASSWORD, PASSWORD, string2, WSSIP, string6, false);
            Util.copyKey(SERVER_TRUSTSTORE_BUNDLED, "certificate-authority", PASSWORD, PASSWORD, string3, "xwss-certificate-authority", string6, true);
            Util.copyKey(SERVER_TRUSTSTORE_BUNDLED, XWS_SECURITY_CLIENT, PASSWORD, PASSWORD, string3, XWS_SECURITY_CLIENT, string6, true);
            Util.copyKey(SERVER_KEYSTORE_BUNDLED, XWS_SECURITY_SERVER, PASSWORD, PASSWORD, string3, XWS_SECURITY_SERVER, string6, true);
            Util.copyKey(CLIENT_KEYSTORE_BUNDLED, XWS_SECURITY_CLIENT, PASSWORD, PASSWORD, string4, XWS_SECURITY_CLIENT, string6, false);
            Util.copyKey(CLIENT_TRUSTSTORE_BUNDLED, XWS_SECURITY_SERVER, PASSWORD, PASSWORD, string5, XWS_SECURITY_SERVER, string6, true);
            Util.copyKey(CLIENT_TRUSTSTORE_BUNDLED, WSSIP, PASSWORD, PASSWORD, string5, WSSIP, string6, true);
        }
        catch (Exception exception) {
            Logger.getLogger(LOGGER_GLOBAL).log(Level.INFO, null, exception);
        }
    }

    public static final void fillDefaults(Project project, boolean bl, boolean bl2) {
        boolean bl3 = Util.isTomcat(project);
        boolean bl4 = Util.isGlassfish(project);
        if (bl3) {
            if (project != null) {
                FileObject fileObject = Util.getTomcatLocation(project);
                try {
                    Object object;
                    FileObject fileObject2;
                    FileObject fileObject3 = FileUtil.createFolder((FileObject)fileObject, (String)STORE_FOLDER_NAME);
                    DataFolder dataFolder = (DataFolder)DataObject.find((FileObject)fileObject3);
                    FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
                    FileObject fileObject4 = fileSystem.findResource("Templates/WebServices/client-keystore.jks");
                    FileObject fileObject5 = fileSystem.findResource("Templates/WebServices/client-truststore.jks");
                    FileObject fileObject6 = fileSystem.findResource("Templates/WebServices/server-keystore.jks");
                    FileObject fileObject7 = fileSystem.findResource("Templates/WebServices/server-truststore.jks");
                    for (Object object2 : fileObject2 = new FileObject[]{fileObject4, fileObject5, fileObject6, fileObject7}) {
                        if (object2 == null || (object = DataObject.find((FileObject)object2)) == null || fileObject3.getFileObject(object2.getName(), object2.getExt()) != null) continue;
                        object.createFromTemplate(dataFolder, object2.getNameExt());
                    }
                    if (!bl) {
                        Object object2;
                        FileObject fileObject8 = fileObject.getFileObject("conf/tomcat-users.xml");
                        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                        object2 = documentBuilder.parse(FileUtil.toFile((FileObject)fileObject8));
                        object = object2.getElementsByTagName("tomcat-users");
                        if (object != null && object.getLength() > 0) {
                            Object object3;
                            Object object4;
                            Object object5;
                            Node node = object.item(0);
                            NodeList nodeList = object2.getElementsByTagName("user");
                            boolean bl5 = false;
                            for (int i = 0; i < nodeList.getLength(); ++i) {
                                object5 = nodeList.item(i);
                                if (!(object5 instanceof Element) || !"wsitUser".equals(object4 = (object3 = (Element)object5).getAttribute("name"))) continue;
                                bl5 = true;
                                break;
                            }
                            if (!bl5) {
                                if (fileObject8.getParent().getFileObject("tomcat-users.backup", "xml") == null) {
                                    FileUtil.copyFile((FileObject)fileObject8, (FileObject)fileObject8.getParent(), (String)"tomcat-users.backup");
                                }
                                Element element = object2.createElement("user");
                                element.setAttribute("name", "wsitUser");
                                element.setAttribute("password", PASSWORD);
                                element.setAttribute("roles", "tomcat");
                                node.appendChild(element);
                                object5 = TransformerFactory.newInstance().newTransformer();
                                ((Transformer)object5).setOutputProperty("indent", "yes");
                                object3 = new StreamResult(FileUtil.toFile((FileObject)fileObject8));
                                object4 = new DOMSource((Node)object2);
                                ((Transformer)object5).transform((Source)object4, (Result)object3);
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(LOGGER_GLOBAL).log(Level.INFO, null, exception);
                }
            }
            return;
        }
        String string = Util.getDefaultPassword(project);
        if (bl4) {
            try {
                if (!bl && bl2) {
                    Util.refreshBuildScript(project);
                }
                String string2 = Util.getStoreLocation(project, false, false);
                String string3 = Util.getStoreLocation(project, true, false);
                String string4 = Util.getStoreLocation(project, false, true);
                String string5 = Util.getStoreLocation(project, true, true);
                Util.copyKey(SERVER_KEYSTORE_BUNDLED, XWS_SECURITY_SERVER, PASSWORD, PASSWORD, string2, XWS_SECURITY_SERVER, string, false);
                Util.copyKey(SERVER_KEYSTORE_BUNDLED, WSSIP, PASSWORD, PASSWORD, string2, WSSIP, string, false);
                Util.copyKey(SERVER_TRUSTSTORE_BUNDLED, "certificate-authority", PASSWORD, PASSWORD, string3, "xwss-certificate-authority", string, true);
                Util.copyKey(SERVER_TRUSTSTORE_BUNDLED, XWS_SECURITY_CLIENT, PASSWORD, PASSWORD, string3, XWS_SECURITY_CLIENT, string, true);
                Util.copyKey(SERVER_KEYSTORE_BUNDLED, XWS_SECURITY_SERVER, PASSWORD, PASSWORD, string3, XWS_SECURITY_SERVER, string, true);
                Util.copyKey(CLIENT_KEYSTORE_BUNDLED, XWS_SECURITY_CLIENT, PASSWORD, PASSWORD, string4, XWS_SECURITY_CLIENT, string, false);
                Util.copyKey(CLIENT_TRUSTSTORE_BUNDLED, XWS_SECURITY_SERVER, PASSWORD, PASSWORD, string5, XWS_SECURITY_SERVER, string, true);
                Util.copyKey(CLIENT_TRUSTSTORE_BUNDLED, WSSIP, PASSWORD, PASSWORD, string5, WSSIP, string, true);
            }
            catch (Exception exception) {
                Logger.getLogger(LOGGER_GLOBAL).log(Level.INFO, null, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyKey(String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        KeyStore keyStore2 = KeyStore.getInstance("JKS");
        keyStore.load(Util.class.getResourceAsStream(string), string3.toCharArray());
        FileInputStream fileInputStream = new FileInputStream(string5);
        try {
            keyStore2.load(fileInputStream, string7.toCharArray());
            Key key = keyStore.getKey(string2, string4.toCharArray());
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(string5);
            try {
                if (key == null || bl) {
                    keyStore2.setCertificateEntry(string6, keyStore.getCertificate(string2));
                } else {
                    Certificate certificate = keyStore.getCertificate(string2);
                    Certificate[] certificateArray = new Certificate[]{certificate};
                    keyStore2.setKeyEntry(string6, key, string7.toCharArray(), certificateArray);
                }
            }
            finally {
                if (fileOutputStream != null) {
                    keyStore2.store(fileOutputStream, string7.toCharArray());
                    ((OutputStream)fileOutputStream).close();
                }
            }
        }
        finally {
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
    }

    public static final boolean isTomcat(Project project) {
        String string = Util.getServerInstanceID(project);
        return string != null && string != null && string.toLowerCase().contains("tomcat");
    }

    public static final boolean isGlassfish(Project project) {
        if (project != null) {
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
            if (j2eeModuleProvider == null) {
                return false;
            }
            return Util.isGlassfish(j2eeModuleProvider.getServerInstanceID());
        }
        return false;
    }

    public static final boolean isGlassfish(String string) {
        return string != null && (string.toLowerCase().contains("appserv") || string.toLowerCase().contains("gfv3"));
    }

    public static final boolean isWebProject(Project project) {
        return Util.getProjectType(project) == ProjectType.WEB;
    }

    public static final boolean isJsr109Project(Project project) {
        return Util.getProjectType(project) == ProjectType.WEB || Util.getProjectType(project) == ProjectType.EJB;
    }

    private static J2eeModuleProvider getProvider(Project project) {
        if (project != null) {
            return (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        }
        return null;
    }

    public static final ProjectType getProjectType(Project project) {
        J2eeModule j2eeModule;
        J2eeModuleProvider j2eeModuleProvider = Util.getProvider(project);
        if (j2eeModuleProvider != null && (j2eeModule = j2eeModuleProvider.getJ2eeModule()) != null) {
            Object object = j2eeModule.getModuleType();
            if (J2eeModule.WAR.equals(object)) {
                return ProjectType.WEB;
            }
            if (J2eeModule.EJB.equals(object)) {
                return ProjectType.EJB;
            }
            if (J2eeModule.CLIENT.equals(object)) {
                return ProjectType.CLIENT;
            }
        }
        return ProjectType.UNKNOWN;
    }

    private static boolean isOperationInList(String string, Collection<BindingOperation> collection) {
        for (BindingOperation bindingOperation : collection) {
            if (bindingOperation == null || !string.equals(bindingOperation.getName())) continue;
            return true;
        }
        return false;
    }

    public static Collection<BindingOperation> refreshOperations(Binding binding, FileObject fileObject) {
        if (binding == null) {
            return null;
        }
        Collection collection = binding.getBindingOperations();
        if (fileObject == null) {
            return collection;
        }
        PortType portType = Util.getPortType(binding);
        List<String> list = JavaWsdlMapper.getOperationNames(fileObject);
        for (String string : list) {
            if (Util.isOperationInList(string, collection)) continue;
            Util.generateOperation(binding, portType, string, fileObject);
        }
        return binding.getBindingOperations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BindingOperation generateOperation(Binding binding, PortType portType, String string, FileObject fileObject) {
        BindingOperation bindingOperation;
        WSDLModel wSDLModel = binding.getModel();
        WSDLComponentFactory wSDLComponentFactory = wSDLModel.getFactory();
        Definitions definitions = (Definitions)binding.getParent();
        boolean bl = wSDLModel.isIntransaction();
        if (!bl) {
            wSDLModel.startTransaction();
        }
        try {
            bindingOperation = wSDLComponentFactory.createBindingOperation();
            bindingOperation.setName(string);
            binding.addBindingOperation(bindingOperation);
            Message message = wSDLComponentFactory.createMessage();
            message.setName(string);
            definitions.addMessage(message);
            Message message2 = wSDLComponentFactory.createMessage();
            message2.setName(string + "Response");
            definitions.addMessage(message2);
            RequestResponseOperation requestResponseOperation = wSDLComponentFactory.createRequestResponseOperation();
            requestResponseOperation.setName(string);
            portType.addOperation((Operation)requestResponseOperation);
            Input input = wSDLComponentFactory.createInput();
            requestResponseOperation.setInput(input);
            input.setMessage(input.createReferenceTo((ReferenceableWSDLComponent)message, Message.class));
            Output output = wSDLComponentFactory.createOutput();
            requestResponseOperation.setOutput(output);
            output.setMessage(output.createReferenceTo((ReferenceableWSDLComponent)message2, Message.class));
            BindingOutput bindingOutput = wSDLComponentFactory.createBindingOutput();
            bindingOperation.setBindingOutput(bindingOutput);
            BindingInput bindingInput = wSDLComponentFactory.createBindingInput();
            bindingOperation.setBindingInput(bindingInput);
            List<String> list = JavaWsdlMapper.getOperationFaults(fileObject, string);
            for (String string2 : list) {
                BindingFault bindingFault = wSDLComponentFactory.createBindingFault();
                bindingOperation.addBindingFault(bindingFault);
            }
        }
        finally {
            if (!bl) {
                wSDLModel.endTransaction();
            }
        }
        return bindingOperation;
    }

    public static PortType getPortType(Binding binding) {
        Definitions definitions = (Definitions)binding.getParent();
        QName qName = binding.getType().getQName();
        PortType portType = null;
        Collection collection = definitions.getPortTypes();
        for (PortType portType2 : collection) {
            if (portType2 == null || !qName.getLocalPart().equals(portType2.getName())) continue;
            portType = portType2;
            break;
        }
        return portType;
    }

    public static FileObject getFOForModel(WSDLModel wSDLModel) {
        if (wSDLModel == null) {
            return null;
        }
        ModelSource modelSource = wSDLModel.getModelSource();
        return Utilities.getFileObject((ModelSource)modelSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshBuildScript(Project project) {
        File file;
        String string = FileUtil.toFile((FileObject)project.getProjectDirectory()).getPath() + BUILD_SCRIPT;
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        String string2 = null;
        boolean bl = false;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.indexOf(IMPORT_WSIT_DEPLOY_XML) == -1) continue;
                bl = true;
                break;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger(LOGGER_GLOBAL).log(Level.INFO, null, fileNotFoundException);
        }
        catch (IOException iOException) {
            Logger.getLogger(LOGGER_GLOBAL).log(Level.INFO, null, iOException);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    Logger.getLogger(LOGGER_GLOBAL).log(Level.INFO, null, iOException);
                }
            }
        }
        if (!bl) {
            try {
                file = new File(string);
                file.renameTo(new File(string + BACKUP_EXT));
                bufferedReader = new BufferedReader(new FileReader(string + BACKUP_EXT));
                bufferedWriter = new BufferedWriter(new FileWriter(string));
                bl = false;
                int n = 0;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (!bl && (n = string2.indexOf(IMPORT_TAG)) != -1) {
                        StringBuffer stringBuffer = new StringBuffer(string2);
                        stringBuffer = stringBuffer.replace(n, string2.length(), IMPORT_WSIT_DEPLOY_XML);
                        bufferedWriter.write(stringBuffer.toString());
                        bufferedWriter.newLine();
                        bl = true;
                    }
                    bufferedWriter.write(string2);
                    bufferedWriter.newLine();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                Logger.getLogger(LOGGER_GLOBAL).log(Level.INFO, null, fileNotFoundException);
            }
            catch (IOException iOException) {
                Logger.getLogger(LOGGER_GLOBAL).log(Level.INFO, null, iOException);
            }
            finally {
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.flush();
                        bufferedWriter.close();
                    }
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    Logger.getLogger(LOGGER_GLOBAL).log(Level.INFO, null, iOException);
                }
            }
        }
        file = new GeneratedFilesHelper(project.getProjectDirectory());
        try {
            file.refreshBuildScript(WSIT_DEPLOY_XML_PATH, Util.class.getClassLoader().getResource(WSIT_DEPLOY_XSL), false);
        }
        catch (IOException iOException) {
            Logger.getLogger(LOGGER_GLOBAL).log(Level.INFO, null, iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unfillDefaults(Project project) {
        String string = FileUtil.toFile((FileObject)project.getProjectDirectory()).getPath() + BUILD_SCRIPT;
        FileObject fileObject = project.getProjectDirectory().getFileObject("nbproject/wsit.createuser");
        if (fileObject != null && fileObject.isValid() && !fileObject.isVirtual()) {
            try {
                fileObject.delete();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        String string2 = null;
        boolean bl = false;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.indexOf(IMPORT_WSIT_DEPLOY_XML) == -1) continue;
                bl = true;
                break;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger(LOGGER_GLOBAL).log(Level.INFO, null, fileNotFoundException);
        }
        catch (IOException iOException) {
            Logger.getLogger(LOGGER_GLOBAL).log(Level.INFO, null, iOException);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    Logger.getLogger(LOGGER_GLOBAL).log(Level.INFO, null, iOException);
                }
            }
        }
        if (bl) {
            try {
                File file = new File(string);
                file.renameTo(new File(string + BACKUP_EXT));
                bufferedReader = new BufferedReader(new FileReader(string + BACKUP_EXT));
                bufferedWriter = new BufferedWriter(new FileWriter(string));
                bl = false;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (string2.indexOf(IMPORT_WSIT_DEPLOY_XML) != -1) continue;
                    bufferedWriter.write(string2);
                    bufferedWriter.newLine();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                Logger.getLogger(LOGGER_GLOBAL).log(Level.INFO, null, fileNotFoundException);
            }
            catch (IOException iOException) {
                Logger.getLogger(LOGGER_GLOBAL).log(Level.INFO, null, iOException);
            }
            finally {
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.flush();
                        bufferedWriter.close();
                    }
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    Logger.getLogger(LOGGER_GLOBAL).log(Level.INFO, null, iOException);
                }
            }
        }
    }

    public static FileObject getSunDDFO(Project project) {
        J2eeModuleProvider j2eeModuleProvider = Util.getProvider(project);
        if (j2eeModuleProvider == null) {
            return null;
        }
        FileObject[] fileObjectArray = j2eeModuleProvider.getConfigurationFiles();
        if (fileObjectArray.length > 0) {
            return fileObjectArray[0];
        }
        return null;
    }

    public static Servlet getServlet(WebApp webApp, String string) {
        Servlet[] servletArray;
        for (Servlet servlet : servletArray = webApp.getServlet()) {
            if (!string.equals(servlet.getServletClass())) continue;
            return servlet;
        }
        return null;
    }

    public static String getDefaultPassword(Project project) {
        String string;
        String string2 = PASSWORD;
        if (Util.isGlassfish(project) && !Util.passwordOK(string = Util.getStoreLocation(project, false, false), string2) && !Util.passwordOK(string, string2 = Util.getPassword(project))) {
            string2 = "";
        }
        return string2;
    }

    public static String getDefaultPassword(String string) {
        String string2;
        String string3 = PASSWORD;
        if (Util.isGlassfish(string) && !Util.passwordOK(string2 = Util.getStoreLocation(string, false, false), string3) && !Util.passwordOK(string2, string3 = "adminadmin")) {
            string3 = "";
        }
        return string3;
    }

    private static boolean passwordOK(String string, String string2) {
        try {
            Util.getAliases(string, string2.toCharArray(), "JKS");
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProjectType {
        WEB,
        EJB,
        CLIENT,
        UNKNOWN;

    }
}

