/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.wsdlmodelext;

import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import javax.xml.namespace.QName;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.jaxwsruntimemodel.JavaWsdlMapper;
import org.netbeans.modules.websvc.wsitconf.WSITEditor;
import org.netbeans.modules.websvc.wsitconf.api.DesignerListenerProvider;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityProfile;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityProfileRegistry;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.ui.security.listmodels.ServiceProviderElement;
import org.netbeans.modules.websvc.wsitconf.util.AbstractTask;
import org.netbeans.modules.websvc.wsitconf.util.SourceUtils;
import org.netbeans.modules.websvc.wsitconf.util.UndoManagerHolder;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.AddressingModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProfilesModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMDeliveryAssurance;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMSequenceBinding;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.TransportModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.policy.Policy;
import org.netbeans.modules.websvc.wsitmodelext.policy.PolicyReference;
import org.netbeans.modules.websvc.wsitmodelext.security.proprietary.service.STSConfiguration;
import org.netbeans.modules.websvc.wsitmodelext.security.proprietary.service.ServiceProvider;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingFault;
import org.netbeans.modules.xml.wsdl.model.BindingInput;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.BindingOutput;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Fault;
import org.netbeans.modules.xml.wsdl.model.Import;
import org.netbeans.modules.xml.wsdl.model.Input;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.Output;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;
import org.netbeans.modules.xml.wsdl.model.RequestResponseOperation;
import org.netbeans.modules.xml.wsdl.model.Types;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLComponentFactory;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModelFactory;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModel;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSITModelSupport {
    public static final String CONFIG_WSDL_CLIENT_PREFIX = "wsit-client";
    public static final String CONFIG_WSDL_SERVICE_PREFIX = "wsit-";
    public static final String MAIN_CONFIG_EXTENSION = "xml";
    public static final String CONFIG_WSDL_EXTENSION = "xml";
    private static final Logger logger = Logger.getLogger(WSITModelSupport.class.getName());

    public static WSDLModel getModel(Node node, JaxWsModel jaxWsModel, UndoManagerHolder undoManagerHolder, boolean bl, Collection<FileObject> collection) throws MalformedURLException, Exception {
        Object object;
        WSDLModel wSDLModel = null;
        Client client = (Client)node.getLookup().lookup(Client.class);
        Service service = (Service)node.getLookup().lookup(Service.class);
        if (client != null) {
            object = (FileObject)node.getLookup().lookup(FileObject.class);
            Project project = FileOwnerQuery.getOwner((FileObject)object);
            wSDLModel = WSITModelSupport.getModelForClient(project, client, bl, collection);
        } else if (service != null) {
            object = (FileObject)node.getLookup().lookup(FileObject.class);
            if (jaxWsModel == null) {
                logger.log(Level.INFO, "JAX-WS Model is null: " + node);
                return null;
            }
            Project project = FileOwnerQuery.getOwner((FileObject)jaxWsModel.getJaxWsFile());
            wSDLModel = WSITModelSupport.getModelForService(service, object, project, bl, collection);
        } else {
            logger.log(Level.INFO, "Unable to identify node type: " + node);
        }
        if (wSDLModel != null && undoManagerHolder != null && undoManagerHolder.getUndoManager() == null) {
            object = new UndoManager();
            wSDLModel.addUndoableEditListener((UndoableEditListener)object);
            undoManagerHolder.setUndoManager((UndoManager)object);
        }
        return wSDLModel;
    }

    public static WSDLModel getModelForService(Service service, FileObject fileObject, Project project, boolean bl, Collection<FileObject> collection) {
        try {
            String string = service.getWsdlUrl();
            if (string == null) {
                if (fileObject == null || !fileObject.isValid() || fileObject.isVirtual()) {
                    logger.log(Level.INFO, "Implementation class is null or not valid, or just virtual: " + fileObject + ", service: " + service);
                    return null;
                }
                JAXWSSupport jAXWSSupport = JAXWSSupport.getJAXWSSupport((FileObject)fileObject);
                return WSITModelSupport.getModelForServiceFromJava(fileObject, jAXWSSupport, bl, collection);
            }
            if (project == null) {
                return null;
            }
            JAXWSSupport jAXWSSupport = JAXWSSupport.getJAXWSSupport((FileObject)project.getProjectDirectory());
            return WSITModelSupport.getModelForServiceFromWsdl(jAXWSSupport, service);
        }
        catch (IOException iOException) {
            logger.log(Level.INFO, null, iOException);
        }
        catch (Exception exception) {
            logger.log(Level.INFO, null, exception);
        }
        return null;
    }

    protected static WSDLModel getModelFromFO(FileObject fileObject, boolean bl) {
        WSDLModel wSDLModel = null;
        ModelSource modelSource = Utilities.getModelSource((FileObject)fileObject, (boolean)bl);
        try {
            wSDLModel = WSDLModelFactory.getDefault().getModel(modelSource);
            if (wSDLModel != null) {
                wSDLModel.sync();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return wSDLModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WSDLModel getModelForClient(Project project, Client client, boolean bl, Collection<FileObject> collection) throws IOException {
        WSDLModel wSDLModel;
        block13: {
            wSDLModel = null;
            FileObject fileObject = WSITEditor.getClientConfigFolder(project);
            FileObject fileObject2 = Utilities.getProjectCatalogFileObject((Project)project);
            ModelSource modelSource = Utilities.getModelSource((FileObject)fileObject2, (boolean)true);
            try {
                FileObject fileObject3;
                WSDLComponentFactory wSDLComponentFactory;
                CatalogModel catalogModel = Utilities.getCatalogModel((ModelSource)modelSource);
                ModelSource modelSource2 = catalogModel.getModelSource(URI.create(client.getWsdlUrl()));
                FileObject fileObject4 = Utilities.getFileObject((ModelSource)modelSource2);
                WSDLModel wSDLModel2 = WSITModelSupport.getModelFromFO(fileObject4, true);
                FileObject fileObject5 = fileObject.getFileObject(fileObject4.getName(), "xml");
                if (fileObject5 != null && fileObject5.isValid()) {
                    return WSITModelSupport.getModelFromFO(fileObject5, true);
                }
                if (!bl) break block13;
                FileObject fileObject6 = fileObject.getFileObject(CONFIG_WSDL_CLIENT_PREFIX, "xml");
                if (fileObject6 == null) {
                    fileObject6 = WSITModelSupport.createMainConfig(fileObject, collection);
                }
                WSITModelSupport.copyImports(wSDLModel2, fileObject, collection);
                WSDLModel wSDLModel3 = WSITModelSupport.getModelFromFO(fileObject6, true);
                wSDLModel3.startTransaction();
                try {
                    wSDLComponentFactory = wSDLModel3.getFactory();
                    fileObject3 = Utilities.getFileObject((ModelSource)wSDLModel2.getModelSource());
                    fileObject5 = fileObject.getFileObject(fileObject3.getName(), "xml");
                    boolean bl2 = false;
                    Collection collection2 = wSDLModel3.getDefinitions().getImports();
                    for (Import import_ : collection2) {
                        if (!import_.getLocation().equals(fileObject5.getNameExt())) continue;
                        bl2 = true;
                        break;
                    }
                    wSDLModel = WSITModelSupport.getModelFromFO(fileObject5, true);
                    if (!bl2) {
                        Import import_;
                        Import import_2 = wSDLComponentFactory.createImport();
                        import_2.setLocation(fileObject5.getNameExt());
                        import_2.setNamespace(wSDLModel.getDefinitions().getTargetNamespace());
                        import_ = wSDLModel3.getDefinitions();
                        import_.setName("mainclientconfig");
                        import_.addImport(import_2);
                    }
                }
                finally {
                    wSDLModel3.endTransaction();
                }
                wSDLComponentFactory = DataObject.find((FileObject)fileObject6);
                if (wSDLComponentFactory != null && wSDLComponentFactory.isModified()) {
                    fileObject3 = (SaveCookie)wSDLComponentFactory.getCookie(SaveCookie.class);
                    if (fileObject3 != null) {
                        fileObject3.save();
                    }
                    wSDLComponentFactory.setModified(false);
                }
                if ((fileObject3 = DataObject.find((FileObject)fileObject5)) != null && fileObject3.isModified()) {
                    SaveCookie saveCookie = (SaveCookie)fileObject3.getCookie(SaveCookie.class);
                    if (saveCookie != null) {
                        saveCookie.save();
                    }
                    fileObject3.setModified(false);
                }
            }
            catch (CatalogModelException catalogModelException) {
                logger.log(Level.INFO, null, catalogModelException);
            }
        }
        return wSDLModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyImports(WSDLModel wSDLModel, FileObject fileObject, Collection<FileObject> collection) throws CatalogModelException {
        FileObject fileObject2 = Utilities.getFileObject((ModelSource)wSDLModel.getModelSource());
        try {
            FileObject fileObject3 = FileUtil.copyFile((FileObject)fileObject2, (FileObject)fileObject, (String)fileObject2.getName(), (String)"xml");
            if (collection != null) {
                collection.add(fileObject3);
            }
            WSDLModel wSDLModel2 = WSITModelSupport.getModelFromFO(fileObject3, true);
            WSITModelSupport.removePolicies(wSDLModel2);
            WSITModelSupport.removeTypes(wSDLModel2);
            Collection collection2 = wSDLModel.getDefinitions().getImports();
            Collection collection3 = wSDLModel2.getDefinitions().getImports();
            Iterator iterator = collection3.iterator();
            for (Import import_ : collection2) {
                WSDLModel wSDLModel3 = import_.getImportedWSDLModel();
                FileObject fileObject4 = Utilities.getFileObject((ModelSource)wSDLModel3.getModelSource());
                wSDLModel2.startTransaction();
                try {
                    ((Import)iterator.next()).setLocation(fileObject4.getName() + "." + "xml");
                }
                finally {
                    wSDLModel2.endTransaction();
                }
                WSITModelSupport.copyImports(wSDLModel3, fileObject, collection);
            }
        }
        catch (IOException iOException) {
            logger.log(Level.FINE, null, iOException);
        }
    }

    private static FileObject createMainConfig(FileObject fileObject, Collection<FileObject> collection) {
        FileObject fileObject2 = null;
        try {
            fileObject2 = FileUtil.createData((FileObject)fileObject, (String)"wsit-client.xml");
            if (fileObject2 != null && fileObject2.isValid() && !fileObject2.isVirtual()) {
                if (collection != null) {
                    collection.add(fileObject2);
                }
                FileWriter fileWriter = new FileWriter(FileUtil.toFile((FileObject)fileObject2));
                fileWriter.write(NbBundle.getMessage(WSITEditor.class, (String)"EMPTY_WSDL"));
                fileWriter.close();
                fileObject2.refresh(true);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return fileObject2;
    }

    public static WSDLModel getMainClientModel(FileObject fileObject) {
        FileObject fileObject2;
        WSDLModel wSDLModel = null;
        if (fileObject != null && (fileObject2 = fileObject.getFileObject(CONFIG_WSDL_CLIENT_PREFIX, "xml")) != null) {
            wSDLModel = WSITModelSupport.getModelFromFO(fileObject2, true);
        }
        return wSDLModel;
    }

    public static WSDLModel getServiceModelForClient(JAXWSClientSupport jAXWSClientSupport, Client client) throws IOException, Exception {
        FileObject fileObject = jAXWSClientSupport.getLocalWsdlFolderForClient(client.getName(), false);
        FileObject fileObject2 = fileObject.getFileObject(client.getLocalWsdlFile());
        if (fileObject2 != null && fileObject2.isValid()) {
            return WSITModelSupport.getModelFromFO(fileObject2, true);
        }
        return null;
    }

    private static WSDLModel getModelForServiceFromWsdl(JAXWSSupport jAXWSSupport, Service service) throws IOException, Exception {
        String string = service.getLocalWsdlFile();
        FileObject fileObject = jAXWSSupport.getLocalWsdlFolderForService(service.getName(), false).getFileObject(string);
        return WSITModelSupport.getModelFromFO(fileObject, true);
    }

    public static WSDLModel getModelForServiceFromJava(FileObject fileObject, JAXWSSupport jAXWSSupport, boolean bl, Collection<FileObject> collection) throws IOException {
        JavaSource javaSource;
        FileObject fileObject2;
        WSDLModel wSDLModel = null;
        String string = CONFIG_WSDL_SERVICE_PREFIX;
        try {
            if (fileObject == null) {
                return null;
            }
            fileObject2 = new String[1];
            javaSource = JavaSource.forFileObject((FileObject)fileObject);
            javaSource.runUserActionTask((Task)new AbstractTask<CompilationController>((String[])fileObject2){
                final /* synthetic */ String[] val$result;
                {
                    this.val$result = stringArray;
                }

                public void run(CompilationController compilationController) throws IOException {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    SourceUtils sourceUtils = SourceUtils.newInstance(compilationController);
                    if (sourceUtils != null) {
                        this.val$result[0] = sourceUtils.getTypeElement().getQualifiedName().toString();
                    }
                }
            }, true);
            string = string + (String)fileObject2[0];
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        fileObject2 = jAXWSSupport.getWsdlFolder(bl);
        if (fileObject2 != null && fileObject2.isValid() && (javaSource = fileObject2.getParent().getFileObject(string, "xml")) != null && javaSource.isValid()) {
            return WSITModelSupport.getModelFromFO((FileObject)javaSource, true);
        }
        if (bl) {
            javaSource = fileObject2.getParent().getFileObject(string, "xml");
            if (javaSource == null || !FileUtil.toFile((FileObject)javaSource).exists()) {
                javaSource = fileObject2.getParent().createData(string, "xml");
                if (collection != null) {
                    collection.add((FileObject)javaSource);
                }
                FileWriter fileWriter = new FileWriter(FileUtil.toFile((FileObject)javaSource));
                fileWriter.write(NbBundle.getMessage(WSITEditor.class, (String)"EMPTY_WSDL"));
                fileWriter.close();
                javaSource.refresh(true);
            }
            wSDLModel = WSITModelSupport.createModelFromFO((FileObject)javaSource, fileObject);
            javaSource.refresh(true);
            DesignerListenerProvider.configCreated();
        }
        return wSDLModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WSDLModel createModelFromFO(FileObject fileObject, FileObject fileObject2) {
        WSDLModel wSDLModel;
        block11: {
            wSDLModel = null;
            ModelSource modelSource = Utilities.getModelSource((FileObject)fileObject, (boolean)true);
            try {
                QName qName;
                WSDLComponentFactory wSDLComponentFactory;
                Definitions definitions;
                wSDLModel = WSDLModelFactory.getDefault().getModel(modelSource);
                if (wSDLModel == null || (definitions = wSDLModel.getDefinitions()) == null) break block11;
                wSDLModel.startTransaction();
                try {
                    wSDLComponentFactory = wSDLModel.getFactory();
                    qName = JavaWsdlMapper.getServiceName(fileObject2);
                    String string = qName.getLocalPart();
                    String string2 = qName.getNamespaceURI();
                    definitions.setName(string);
                    definitions.setTargetNamespace(string2);
                    org.netbeans.modules.xml.wsdl.model.Service service = wSDLComponentFactory.createService();
                    service.setName(string);
                    definitions.addService(service);
                    Port port = wSDLComponentFactory.createPort();
                    QName qName2 = JavaWsdlMapper.getPortName(fileObject2, string2);
                    if (qName2 != null) {
                        port.setName(qName2.getLocalPart());
                    }
                    service.addPort(port);
                    Binding binding = wSDLComponentFactory.createBinding();
                    String string3 = JavaWsdlMapper.getBindingName(fileObject2, string2);
                    binding.setName(string3);
                    definitions.addBinding(binding);
                    port.setBinding(binding.createReferenceTo((ReferenceableWSDLComponent)binding, Binding.class));
                    PortType portType = wSDLComponentFactory.createPortType();
                    QName qName3 = JavaWsdlMapper.getPortTypeName(fileObject2);
                    portType.setName(qName3.getLocalPart());
                    definitions.addPortType(portType);
                    List<String> list = JavaWsdlMapper.getOperationNames(fileObject2);
                    for (String string4 : list) {
                        Object object;
                        Object object22;
                        Message message;
                        Collection collection;
                        String string52;
                        BindingOperation bindingOperation = wSDLComponentFactory.createBindingOperation();
                        bindingOperation.setName(string4);
                        binding.addBindingOperation(bindingOperation);
                        Message message2 = wSDLComponentFactory.createMessage();
                        message2.setName(string4);
                        definitions.addMessage(message2);
                        Message message3 = wSDLComponentFactory.createMessage();
                        message3.setName(string4 + "Response");
                        definitions.addMessage(message3);
                        RequestResponseOperation requestResponseOperation = wSDLComponentFactory.createRequestResponseOperation();
                        requestResponseOperation.setName(string4);
                        portType.addOperation((Operation)requestResponseOperation);
                        List<String> list2 = JavaWsdlMapper.getOperationFaults(fileObject2, string4);
                        for (String string52 : list2) {
                            collection = definitions.getMessages();
                            message = null;
                            for (Object object22 : collection) {
                                if (!object22.getName().equals(string52)) continue;
                                message = object22;
                                break;
                            }
                            if (message == null) {
                                message = wSDLComponentFactory.createMessage();
                                message.setName(string52);
                                definitions.addMessage(message);
                            }
                            object = wSDLComponentFactory.createFault();
                            object.setName(string52);
                            requestResponseOperation.addFault((Fault)object);
                            object.setMessage(object.createReferenceTo((ReferenceableWSDLComponent)message, Message.class));
                        }
                        Input input = wSDLComponentFactory.createInput();
                        requestResponseOperation.setInput(input);
                        input.setMessage(input.createReferenceTo((ReferenceableWSDLComponent)message2, Message.class));
                        string52 = wSDLComponentFactory.createOutput();
                        requestResponseOperation.setOutput((Output)string52);
                        string52.setMessage(string52.createReferenceTo((ReferenceableWSDLComponent)message3, Message.class));
                        collection = wSDLComponentFactory.createBindingOutput();
                        bindingOperation.setBindingOutput((BindingOutput)collection);
                        message = wSDLComponentFactory.createBindingInput();
                        bindingOperation.setBindingInput((BindingInput)message);
                        object = JavaWsdlMapper.getOperationFaults(fileObject2, string4);
                        object22 = object.iterator();
                        while (object22.hasNext()) {
                            String string6 = (String)object22.next();
                            BindingFault bindingFault = wSDLComponentFactory.createBindingFault();
                            bindingFault.setName(string6);
                            bindingOperation.addBindingFault(bindingFault);
                        }
                    }
                    binding.setType(binding.createReferenceTo((ReferenceableWSDLComponent)portType, PortType.class));
                }
                finally {
                    wSDLModel.endTransaction();
                }
                wSDLComponentFactory = DataObject.find((FileObject)fileObject);
                qName = (SaveCookie)wSDLComponentFactory.getCookie(SaveCookie.class);
                qName.save();
                wSDLComponentFactory.setModified(false);
            }
            catch (IOException iOException) {
                logger.log(Level.INFO, null, iOException);
            }
        }
        return wSDLModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeTypes(WSDLModel wSDLModel) {
        wSDLModel.startTransaction();
        try {
            Definitions definitions = wSDLModel.getDefinitions();
            Types types = definitions.getTypes();
            if (types != null) {
                types.getSchemas().retainAll(new ArrayList());
            }
        }
        finally {
            wSDLModel.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removePolicies(WSDLModel wSDLModel) {
        wSDLModel.startTransaction();
        try {
            WSITModelSupport.removePolicyElements((WSDLComponent)wSDLModel.getDefinitions());
        }
        finally {
            wSDLModel.endTransaction();
        }
    }

    public static boolean isServiceFromWsdl(Node node) {
        if (node != null) {
            Service service = (Service)node.getLookup().lookup(Service.class);
            return WSITModelSupport.isServiceFromWsdl(service);
        }
        return false;
    }

    public static boolean isServiceFromWsdl(Service service) {
        String string;
        return service != null && (string = service.getWsdlUrl()) != null;
    }

    private static void removePolicyElements(WSDLComponent wSDLComponent) {
        Object object;
        Object object22;
        List list = wSDLComponent.getExtensibilityElements(Policy.class);
        for (Object object22 : list) {
            wSDLComponent.removeExtensibilityElement((ExtensibilityElement)object22);
        }
        List list2 = wSDLComponent.getExtensibilityElements(PolicyReference.class);
        object22 = list2.iterator();
        while (object22.hasNext()) {
            object = (PolicyReference)object22.next();
            wSDLComponent.removeExtensibilityElement((ExtensibilityElement)object);
        }
        object22 = wSDLComponent.getChildren();
        object = object22.iterator();
        while (object.hasNext()) {
            WSDLComponent wSDLComponent2 = (WSDLComponent)object.next();
            WSITModelSupport.removePolicyElements(wSDLComponent2);
        }
    }

    public static void fillImportedBindings(WSDLModel wSDLModel, Collection<Binding> collection, Set<FileObject> set) {
        FileObject fileObject = Util.getFOForModel(wSDLModel);
        if (set.contains(fileObject)) {
            return;
        }
        set.add(fileObject);
        Collection collection2 = wSDLModel.getDefinitions().getBindings();
        collection.addAll(collection2);
        Collection collection3 = wSDLModel.getDefinitions().getImports();
        for (Import import_ : collection3) {
            try {
                WSDLModel wSDLModel2 = import_.getImportedWSDLModel();
                WSITModelSupport.fillImportedBindings(wSDLModel2, collection, set);
            }
            catch (CatalogModelException catalogModelException) {
                catalogModelException.printStackTrace();
            }
        }
    }

    public static void save(WSDLComponent wSDLComponent) {
        WSDLModel wSDLModel = wSDLComponent.getModel();
        WSITModelSupport.save(wSDLModel);
    }

    public static synchronized void save(WSDLModel wSDLModel) {
        try {
            if (wSDLModel != null) {
                WSDLModel wSDLModel2;
                Import import_2;
                Collection collection = wSDLModel.getDefinitions().getImports();
                for (Import import_2 : collection) {
                    wSDLModel2 = import_2.getImportedWSDLModel();
                    WSITModelSupport.save(wSDLModel2);
                }
                FileObject fileObject = Utilities.getFileObject((ModelSource)wSDLModel.getModelSource());
                if (fileObject == null) {
                    logger.log(Level.INFO, "Cannot find fileobject in lookup for: " + wSDLModel.getModelSource());
                }
                if ((import_2 = DataObject.find((FileObject)fileObject)) != null && import_2.isModified()) {
                    wSDLModel2 = (SaveCookie)import_2.getCookie(SaveCookie.class);
                    if (wSDLModel2 != null) {
                        wSDLModel2.save();
                    }
                    import_2.setModified(false);
                }
            }
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, null, exception);
        }
    }

    public static Binding getBinding(Service service, FileObject fileObject, Project project, boolean bl, Collection<FileObject> collection) {
        QName qName;
        String string = service.getPortName();
        String string2 = service.getServiceName();
        if (string2 == null && (qName = JavaWsdlMapper.getServiceName(fileObject)) != null) {
            string2 = qName.getLocalPart();
        }
        if (string2 == null) {
            return null;
        }
        qName = WSITModelSupport.getModelForService(service, fileObject, project, bl, collection);
        if (qName == null) {
            return null;
        }
        Definitions definitions = qName.getDefinitions();
        if (definitions == null) {
            return null;
        }
        Collection collection2 = definitions.getBindings();
        if (collection2 == null || collection2.isEmpty()) {
            return null;
        }
        if (collection2.size() == 1) {
            return (Binding)collection2.iterator().next();
        }
        Collection collection3 = definitions.getServices();
        for (org.netbeans.modules.xml.wsdl.model.Service service2 : collection3) {
            if (service2 == null || !string2.equals(service2.getName())) continue;
            Collection collection4 = service2.getPorts();
            if (string == null) {
                if (collection4 == null || collection4.isEmpty()) continue;
                Port port = (Port)collection4.iterator().next();
                Object object = port.getBinding().getQName();
                return (Binding)qName.findComponentByName((QName)object, Binding.class);
            }
            for (Object object : collection4) {
                if (!string.equals(object.getName())) continue;
                QName qName2 = object.getBinding().getQName();
                return (Binding)qName.findComponentByName(qName2, Binding.class);
            }
        }
        return null;
    }

    static void moveCurrentConfig(Binding binding, ConfigVersion configVersion, ConfigVersion configVersion2, Project project) {
        BindingOperation bindingOperation22;
        Object object;
        if (binding == null) {
            return;
        }
        boolean bl = AddressingModelHelper.isAddressingEnabled(binding);
        boolean bl2 = TransportModelHelper.isMtomEnabled(binding);
        boolean bl3 = TransportModelHelper.isTCPEnabled(binding);
        boolean bl4 = TransportModelHelper.isFIEnabled(binding);
        RMModelHelper rMModelHelper = RMModelHelper.getInstance(configVersion);
        boolean bl5 = rMModelHelper.isRMEnabled((WSDLComponent)binding);
        boolean bl6 = rMModelHelper.isOrderedEnabled(binding);
        boolean bl7 = RMModelHelper.isFlowControl(binding);
        RMSequenceBinding rMSequenceBinding = RMSequenceBinding.getValue(configVersion, binding);
        RMDeliveryAssurance rMDeliveryAssurance = RMDeliveryAssurance.getValue(configVersion, binding);
        String string = RMModelHelper.getMaxReceiveBufferSize(binding);
        String string2 = rMModelHelper.getInactivityTimeout(binding);
        String string3 = ProfilesModelHelper.getSecurityProfile((WSDLComponent)binding);
        boolean bl8 = SecurityPolicyModelHelper.isSecurityEnabled((WSDLComponent)binding);
        boolean bl9 = ProfilesModelHelper.isServiceDefaultSetupUsed(string3, binding, project);
        boolean bl10 = ProprietarySecurityPolicyModelHelper.isSTSEnabled(binding);
        ArrayList<ServiceProviderElement> arrayList = new ArrayList<ServiceProviderElement>();
        String string4 = null;
        String string5 = null;
        String string6 = null;
        boolean bl11 = false;
        boolean bl12 = false;
        if (bl10) {
            object = ProprietarySecurityPolicyModelHelper.getSTSConfiguration(binding);
            bindingOperation22 = ProprietarySecurityPolicyModelHelper.getSTSServiceProviders((STSConfiguration)object);
            for (ServiceProvider object2 : bindingOperation22) {
                String string7 = ProprietarySecurityPolicyModelHelper.getSPCertAlias(object2);
                String string8 = ProprietarySecurityPolicyModelHelper.getSPKeyType(object2);
                String string9 = ProprietarySecurityPolicyModelHelper.getSPTokenType(object2);
                String string10 = object2.getEndpoint();
                ServiceProviderElement serviceProviderElement = new ServiceProviderElement(string10, string7, string9, string8);
                arrayList.add(serviceProviderElement);
            }
            string4 = ProprietarySecurityPolicyModelHelper.getSTSIssuer(binding);
            string6 = ProprietarySecurityPolicyModelHelper.getSTSLifeTime(binding);
            string5 = ProprietarySecurityPolicyModelHelper.getSTSContractClass(binding);
            bl11 = ProprietarySecurityPolicyModelHelper.getSTSEncryptKey(binding);
            bl12 = ProprietarySecurityPolicyModelHelper.getSTSEncryptToken(binding);
        }
        PolicyModelHelper.removePolicyForElement((WSDLComponent)binding);
        for (BindingOperation bindingOperation22 : binding.getBindingOperations()) {
            BindingInput bindingInput = bindingOperation22.getBindingInput();
            BindingOutput bindingOutput = bindingOperation22.getBindingOutput();
            if (bindingInput != null) {
                PolicyModelHelper.removePolicyForElement((WSDLComponent)bindingInput);
            }
            if (bindingOutput != null) {
                PolicyModelHelper.removePolicyForElement((WSDLComponent)bindingOutput);
            }
            for (String string8 : bindingOperation22.getBindingFaults()) {
                PolicyModelHelper.removePolicyForElement((WSDLComponent)string8);
            }
            PolicyModelHelper.removePolicyForElement((WSDLComponent)bindingOperation22);
        }
        PolicyModelHelper.getInstance(configVersion2).createPolicy((WSDLComponent)binding, bl);
        TransportModelHelper.enableMtom(binding, bl2);
        TransportModelHelper.enableFI(binding, bl4);
        TransportModelHelper.enableTCP(binding, bl3);
        if (bl5) {
            object = RMModelHelper.getInstance(configVersion2);
            ((RMModelHelper)object).enableRM(binding, true);
            if (bl7) {
                ((RMModelHelper)object).enableFlowControl(binding, bl7);
            }
            if (bl6) {
                ((RMModelHelper)object).enableOrdered(binding, bl6);
            }
            if (string != null) {
                RMModelHelper.setMaxReceiveBufferSize(binding, string);
            }
            if (string2 != null) {
                ((RMModelHelper)object).setInactivityTimeout(binding, string2);
            }
            if (rMSequenceBinding != null) {
                rMSequenceBinding.set(configVersion2, binding);
            }
            if (rMDeliveryAssurance != null) {
                rMDeliveryAssurance.set(configVersion2, binding);
            }
        }
        if (bl8) {
            object = SecurityProfileRegistry.getDefault().getProfile(string3);
            if (object != null && !((SecurityProfile)object).isProfileSupported(project, (WSDLComponent)binding, bl10)) {
                ProfilesModelHelper.getInstance(configVersion2).setSecurityProfile((WSDLComponent)binding, ComboConstants.PROF_USERNAME, null, false);
            } else {
                ProfilesModelHelper.getInstance(configVersion2).setSecurityProfile((WSDLComponent)binding, string3, null, false);
                if (bl9) {
                    ProfilesModelHelper.setServiceDefaults(string3, binding, project);
                }
            }
        }
        if (bl10) {
            object = ProprietarySecurityPolicyModelHelper.getInstance(configVersion2);
            ((ProprietarySecurityPolicyModelHelper)object).enableSTS(binding, bl10);
            ProprietarySecurityPolicyModelHelper.setSTSIssuer(binding, string4);
            ProprietarySecurityPolicyModelHelper.setSTSContractClass(binding, string5);
            ProprietarySecurityPolicyModelHelper.setSTSLifeTime(binding, string6);
            ProprietarySecurityPolicyModelHelper.setSTSEncryptKey(binding, bl11);
            ProprietarySecurityPolicyModelHelper.setSTSEncryptToken(binding, bl12);
            bindingOperation22 = ProprietarySecurityPolicyModelHelper.getSTSConfiguration(binding);
            for (ServiceProviderElement serviceProviderElement : arrayList) {
                ProprietarySecurityPolicyModelHelper.addSTSServiceProvider((STSConfiguration)bindingOperation22, serviceProviderElement, configVersion2);
            }
        }
        PolicyModelHelper.getInstance(configVersion2).createPolicy((WSDLComponent)binding, false);
    }
}

