/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.provider;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Provider {
    public static final String TABLE_GENERATION_CREATE = "tableGenerationCreate";
    public static final String TABLE_GENERATION_DROPCREATE = "tableGenerationDropCreate";
    public static final String TABLE_GENERATTION_UNKOWN = "tableGenerationUnknown";
    private final String providerClass;
    private final Set vendorSpecificProperties;

    protected Provider(String string) {
        assert (null != string && !"".equals(string.trim())) : "Provider class must be given!";
        this.providerClass = string;
        this.vendorSpecificProperties = this.initPropertyNames();
    }

    public abstract String getDisplayName();

    public final String getProviderClass() {
        return this.providerClass;
    }

    private Set initPropertyNames() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(this.getJdbcDriver());
        hashSet.add(this.getJdbcUsername());
        hashSet.add(this.getJdbcUrl());
        hashSet.add(this.getJdbcPassword());
        hashSet.add(this.getTableGenerationPropertyName());
        for (String string : this.getUnresolvedVendorSpecificProperties().keySet()) {
            hashSet.add(string);
        }
        return hashSet;
    }

    public Set getPropertyNames() {
        return this.vendorSpecificProperties;
    }

    public final Property getTableGenerationProperty(String string) {
        if ("".equals(this.getTableGenerationPropertyName())) {
            return null;
        }
        Property property = new Property();
        property.setName(this.getTableGenerationPropertyName());
        if (TABLE_GENERATION_CREATE.equals(string)) {
            property.setValue(this.getTableGenerationCreateValue());
        } else if (TABLE_GENERATION_DROPCREATE.equals(string)) {
            property.setValue(this.getTableGenerationDropCreateValue());
        } else {
            return null;
        }
        return property;
    }

    public final String getDefaultJtaDatasource() {
        return "jdbc/__default";
    }

    public abstract String getJdbcUrl();

    public abstract String getJdbcDriver();

    public abstract String getJdbcUsername();

    public abstract String getJdbcPassword();

    public abstract String getTableGenerationPropertyName();

    public abstract String getTableGenerationCreateValue();

    public abstract String getTableGenerationDropCreateValue();

    public abstract Map getUnresolvedVendorSpecificProperties();

    public abstract Map getDefaultVendorSpecificProperties();

    public final Map<String, String> getConnectionPropertiesMap(DatabaseConnection databaseConnection) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(this.getJdbcDriver(), databaseConnection != null ? databaseConnection.getDriverClass() : "");
        hashMap.put(this.getJdbcUrl(), databaseConnection != null ? databaseConnection.getDatabaseURL() : "");
        hashMap.put(this.getJdbcUsername(), databaseConnection != null ? databaseConnection.getUser() : "");
        hashMap.put(this.getJdbcPassword(), databaseConnection != null && databaseConnection.getPassword() != null ? databaseConnection.getPassword() : "");
        return hashMap;
    }

    public final boolean supportsTableGeneration() {
        return this.getTableGenerationPropertyName() != null && !"".equals(this.getTableGenerationPropertyName().trim());
    }

    public String toString() {
        return this.getDisplayName();
    }

    public int hashCode() {
        return this.providerClass.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Provider)) {
            return false;
        }
        Provider provider = (Provider)object;
        return this.getClass().equals(provider.getClass()) && this.providerClass.equals(provider.providerClass);
    }
}

