/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.jpacontroller;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaControllerUtil {
    public static final int REL_NONE = 0;
    public static final int REL_TO_ONE = 1;
    public static final int REL_TO_MANY = 2;

    public static Charset getProjectEncoding(Project project, FileObject fileObject) {
        Charset charset = ((FileEncodingQueryImplementation)project.getLookup().lookup(FileEncodingQueryImplementation.class)).getEncoding(fileObject);
        if (charset == null) {
            charset = FileEncodingQuery.getDefaultEncoding();
            if (charset == null) {
                return Charset.forName("UTF-8");
            }
            return charset;
        }
        return charset;
    }

    public static String getProjectEncodingAsString(Project project, FileObject fileObject) {
        Charset charset = ((FileEncodingQueryImplementation)project.getLookup().lookup(FileEncodingQueryImplementation.class)).getEncoding(fileObject);
        if (charset == null) {
            charset = FileEncodingQuery.getDefaultEncoding();
            if (charset == null) {
                return "UTF-8";
            }
            return charset.name();
        }
        return charset.name();
    }

    public static String simpleClassName(String string) {
        int n = string.lastIndexOf(46);
        return n > 0 ? string.substring(n + 1) : string;
    }

    public static String readResource(InputStream inputStream, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = System.getProperty("line.separator");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string));
        String string3 = bufferedReader.readLine();
        while (string3 != null) {
            stringBuffer.append(string3);
            stringBuffer.append(string2);
            string3 = bufferedReader.readLine();
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFile(FileObject fileObject, String string, String string2) throws IOException {
        FileLock fileLock = fileObject.lock();
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileObject.getOutputStream(fileLock), string2));
            bufferedWriter.write(string);
            bufferedWriter.close();
        }
        finally {
            fileLock.releaseLock();
        }
    }

    public static boolean isFieldAccess(TypeElement typeElement) {
        boolean bl = false;
        boolean bl2 = false;
        TypeElement typeElement2 = typeElement;
        Name name = typeElement2.getQualifiedName();
        block0: while (typeElement2 != null) {
            if (JpaControllerUtil.isAnnotatedWith(typeElement2, "javax.persistence.Entity") || JpaControllerUtil.isAnnotatedWith(typeElement2, "javax.persistence.MappedSuperclass")) {
                for (Element element : typeElement2.getEnclosedElements()) {
                    if (!JpaControllerUtil.isAnnotatedWith(element, "javax.persistence.Id") && !JpaControllerUtil.isAnnotatedWith(element, "javax.persistence.EmbeddedId")) continue;
                    if (ElementKind.FIELD == element.getKind()) {
                        bl = true;
                    }
                    bl2 = true;
                    break block0;
                }
            }
            typeElement2 = JpaControllerUtil.getSuperclassTypeElement(typeElement2);
        }
        if (!bl2) {
            Logger.getLogger(JpaControllerUtil.class.getName()).log(Level.WARNING, "Failed to detect correct access type for class: " + name);
        }
        return bl;
    }

    public static boolean isAnnotatedWith(Element element, String string) {
        return JpaControllerUtil.findAnnotation(element, string) != null;
    }

    public static AnnotationMirror findAnnotation(Element element, String string) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            String string2 = JpaControllerUtil.getAnnotationQualifiedName(annotationMirror);
            if (!string2.equals(string)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static String getAnnotationQualifiedName(AnnotationMirror annotationMirror) {
        DeclaredType declaredType = annotationMirror.getAnnotationType();
        TypeElement typeElement = (TypeElement)declaredType.asElement();
        Name name = typeElement.getQualifiedName();
        return name.toString();
    }

    private static TypeElement getSuperclassTypeElement(TypeElement typeElement) {
        DeclaredType declaredType;
        Element element;
        TypeElement typeElement2 = null;
        TypeMirror typeMirror = typeElement.getSuperclass();
        if (typeMirror.getKind() == TypeKind.DECLARED && (element = (declaredType = (DeclaredType)typeMirror).asElement()).getKind() == ElementKind.CLASS && element instanceof TypeElement) {
            typeElement2 = (TypeElement)element;
        }
        return typeElement2;
    }

    public static String findAnnotationValueAsString(AnnotationMirror annotationMirror, String string) {
        String string2 = null;
        Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
        for (ExecutableElement executableElement : map.keySet()) {
            if (!string.equals(executableElement.getSimpleName().toString())) continue;
            AnnotationValue annotationValue = map.get(executableElement);
            string2 = annotationValue.getValue().toString();
            break;
        }
        return string2;
    }

    public static List<AnnotationMirror> findNestedAnnotations(AnnotationMirror annotationMirror, String string) {
        ArrayList<AnnotationMirror> arrayList = new ArrayList<AnnotationMirror>();
        JpaControllerUtil.findNestedAnnotationsInternal(annotationMirror, string, arrayList);
        return arrayList;
    }

    private static void findNestedAnnotationsInternal(Object object, String string, List<AnnotationMirror> list) {
        Object object2;
        Collection<? extends AnnotationValue> collection = null;
        if (object instanceof AnnotationMirror) {
            AnnotationMirror annotationMirror = (AnnotationMirror)object;
            String object3 = JpaControllerUtil.getAnnotationQualifiedName(annotationMirror);
            if (object3.equals(string)) {
                list.add(annotationMirror);
            } else {
                object2 = annotationMirror.getElementValues();
                collection = object2.values();
            }
        } else if (object instanceof List) {
            collection = (Collection<? extends AnnotationValue>)object;
        }
        if (collection != null) {
            for (AnnotationValue annotationValue : collection) {
                object2 = annotationValue.getValue();
                JpaControllerUtil.findNestedAnnotationsInternal(object2, string, list);
            }
        }
    }

    public static String fieldFromClassName(String string) {
        String string2;
        boolean bl = string.length() == 1 || !Character.isUpperCase(string.charAt(1));
        String string3 = string2 = bl ? string.substring(0, 1).toLowerCase() + string.substring(1) : string;
        if (!Utilities.isJavaIdentifier((String)string2)) {
            string2 = string2 + "1";
        }
        return string2;
    }

    public static String getPropNameFromMethod(String string) {
        boolean bl = string.length() < 5 || !Character.isUpperCase(string.charAt(4));
        return bl ? string.substring(3, 4).toLowerCase() + string.substring(4) : string.substring(3);
    }

    public static boolean isEmbeddableClass(TypeElement typeElement) {
        return JpaControllerUtil.isAnnotatedWith(typeElement, "javax.persistence.Embeddable");
    }

    public static int isRelationship(CompilationController compilationController, ExecutableElement executableElement, boolean bl) {
        ExecutableElement executableElement2;
        Element element = executableElement2 = bl ? JpaControllerUtil.guessField(compilationController, executableElement) : executableElement;
        if (executableElement2 != null) {
            if (JpaControllerUtil.isAnnotatedWith(executableElement2, "javax.persistence.OneToOne") || JpaControllerUtil.isAnnotatedWith(executableElement2, "javax.persistence.ManyToOne")) {
                return 1;
            }
            if (JpaControllerUtil.isAnnotatedWith(executableElement2, "javax.persistence.OneToMany") || JpaControllerUtil.isAnnotatedWith(executableElement2, "javax.persistence.ManyToMany")) {
                return 2;
            }
        }
        return 0;
    }

    public static ExecutableElement getOtherSideOfRelation(CompilationController compilationController, ExecutableElement executableElement, boolean bl) {
        TypeMirror typeMirror = executableElement.getReturnType();
        if (TypeKind.DECLARED != typeMirror.getKind() || !(typeMirror instanceof DeclaredType)) {
            return null;
        }
        Types types = compilationController.getTypes();
        TypeMirror typeMirror2 = JpaControllerUtil.stripCollection((DeclaredType)typeMirror, types);
        if (typeMirror2 == null) {
            return null;
        }
        TypeElement typeElement = (TypeElement)types.asElement(typeMirror2);
        ExecutableElement executableElement2 = bl ? JpaControllerUtil.guessField(compilationController, executableElement) : executableElement;
        String string = null;
        AnnotationMirror annotationMirror = JpaControllerUtil.findAnnotation(executableElement2, "javax.persistence.OneToOne");
        if (annotationMirror == null) {
            annotationMirror = JpaControllerUtil.findAnnotation(executableElement2, "javax.persistence.OneToMany");
        }
        if (annotationMirror == null) {
            annotationMirror = JpaControllerUtil.findAnnotation(executableElement2, "javax.persistence.ManyToOne");
        }
        if (annotationMirror == null) {
            annotationMirror = JpaControllerUtil.findAnnotation(executableElement2, "javax.persistence.ManyToMany");
        }
        if (annotationMirror != null) {
            string = JpaControllerUtil.findAnnotationValueAsString(annotationMirror, "mappedBy");
        }
        for (ExecutableElement executableElement3 : JpaControllerUtil.getEntityMethods(typeElement)) {
            Object object;
            Object object2;
            if (string != null && string.length() > 0) {
                object2 = string.length() > 1 ? string.substring(1) : "";
                object = "get" + string.substring(0, 1).toUpperCase() + (String)object2;
                if (!((String)object).equals(executableElement3.getSimpleName().toString())) continue;
                return executableElement3;
            }
            object2 = executableElement3.getReturnType();
            object2 = JpaControllerUtil.stripCollection((TypeMirror)object2, types);
            object = executableElement.getEnclosingElement().asType();
            if (!types.isSameType((TypeMirror)object, (TypeMirror)object2)) continue;
            return executableElement3;
        }
        return null;
    }

    public static TypeMirror stripCollection(TypeMirror typeMirror, Types types) {
        if (TypeKind.DECLARED != typeMirror.getKind() || !(typeMirror instanceof DeclaredType)) {
            return typeMirror;
        }
        TypeElement typeElement = (TypeElement)types.asElement(typeMirror);
        String string = typeElement.getQualifiedName().toString();
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz != null && Collection.class.isAssignableFrom(clazz)) {
            List<? extends TypeMirror> list = ((DeclaredType)typeMirror).getTypeArguments();
            if (list.size() == 0) {
                return typeMirror;
            }
            return list.get(0);
        }
        return typeMirror;
    }

    public static boolean isFieldOptionalAndNullable(CompilationController compilationController, ExecutableElement executableElement, boolean bl) {
        String[] stringArray;
        boolean bl2 = true;
        Boolean bl3 = null;
        Element element = bl ? JpaControllerUtil.guessField(compilationController, executableElement) : executableElement;
        Boolean bl4 = JpaControllerUtil.findAnnotationValueAsBoolean(element, stringArray = new String[]{"javax.persistence.ManyToOne", "javax.persistence.OneToOne", "javax.persistence.Basic"}, "optional");
        if (bl4 != null) {
            bl2 = bl4;
        }
        if (!bl2) {
            return false;
        }
        stringArray = new String[]{"javax.persistence.Column", "javax.persistence.JoinColumn"};
        bl3 = JpaControllerUtil.findAnnotationValueAsBoolean(element, stringArray, "nullable");
        if (bl3 != null) {
            return bl3;
        }
        boolean bl5 = true;
        AnnotationMirror annotationMirror = JpaControllerUtil.findAnnotation(element, "javax.persistence.JoinColumns");
        if (annotationMirror != null) {
            List<AnnotationMirror> list = JpaControllerUtil.findNestedAnnotations(annotationMirror, "javax.persistence.JoinColumn");
            for (AnnotationMirror annotationMirror2 : list) {
                String string = JpaControllerUtil.findAnnotationValueAsString(annotationMirror2, "nullable");
                if (string != null) {
                    bl5 = Boolean.parseBoolean(string);
                    if (!bl5) continue;
                    break;
                }
                bl5 = true;
                break;
            }
        }
        return bl5;
    }

    private static Boolean findAnnotationValueAsBoolean(Element element, String[] stringArray, String string) {
        Boolean bl = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            AnnotationMirror annotationMirror = JpaControllerUtil.findAnnotation(element, string2);
            if (annotationMirror == null) continue;
            String string3 = JpaControllerUtil.findAnnotationValueAsString(annotationMirror, string);
            if (string3 != null) {
                bl = Boolean.valueOf(string3);
                break;
            }
            bl = Boolean.TRUE;
            break;
        }
        return bl;
    }

    public static ExecutableElement getIdGetter(CompilationController compilationController, boolean bl, TypeElement typeElement) {
        ExecutableElement[] executableElementArray;
        for (ExecutableElement executableElement : executableElementArray = JpaControllerUtil.getEntityMethods(typeElement)) {
            ExecutableElement executableElement2;
            String string = executableElement.getSimpleName().toString();
            if (!string.startsWith("get")) continue;
            Element element = executableElement2 = bl ? JpaControllerUtil.guessField(compilationController, executableElement) : executableElement;
            if (executableElement2 == null || !JpaControllerUtil.isAnnotatedWith(executableElement2, "javax.persistence.Id") && !JpaControllerUtil.isAnnotatedWith(executableElement2, "javax.persistence.EmbeddedId")) continue;
            return executableElement;
        }
        Logger.getLogger(JpaControllerUtil.class.getName()).log(Level.WARNING, "Cannot find ID getter in class: " + typeElement.getQualifiedName());
        return null;
    }

    public static boolean isGenerated(CompilationController compilationController, ExecutableElement executableElement, boolean bl) {
        ExecutableElement executableElement2;
        Element element = executableElement2 = bl ? JpaControllerUtil.guessField(compilationController, executableElement) : executableElement;
        return executableElement2 != null && JpaControllerUtil.isAnnotatedWith(executableElement2, "javax.persistence.GeneratedValue");
    }

    public static boolean exceptionsThrownIncludes(WorkingCopy workingCopy, String string, String string2, List<String> list, String string3) {
        List<String> list2 = JpaControllerUtil.getExceptionsThrown(workingCopy, string, string2, list);
        for (String string4 : list2) {
            if (!string3.equals(string4)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getExceptionsThrown(WorkingCopy workingCopy, String string, String string2, List<String> list) {
        TypeElement typeElement;
        if (list == null) {
            list = Collections.emptyList();
        }
        ExecutableElement object3 = null;
        TypeElement typeElement2 = typeElement = workingCopy.getElements().getTypeElement(string);
        block0: while (typeElement2 != null) {
            for (ExecutableElement object22 : ElementFilter.methodsIn(typeElement2.getEnclosedElements())) {
                Object object;
                if (!object22.getSimpleName().contentEquals(string2) || (object = object22.getParameters()).size() != list.size()) continue;
                object3 = object22;
                break block0;
            }
            typeElement2 = JpaControllerUtil.getSuperclassTypeElement(typeElement2);
        }
        if (object3 == null) {
            throw new IllegalArgumentException("Could not find " + string2 + " in " + string);
        }
        ArrayList arrayList = new ArrayList();
        List<? extends TypeMirror> list2 = object3.getThrownTypes();
        for (TypeMirror typeMirror : list2) {
            if (typeMirror.getKind() == TypeKind.DECLARED) {
                DeclaredType declaredType = (DeclaredType)typeMirror;
                TypeElement typeElement3 = (TypeElement)declaredType.asElement();
                String string3 = typeElement3.getQualifiedName().toString();
                arrayList.add(string3);
                continue;
            }
            arrayList.add(null);
        }
        return arrayList;
    }

    public static ExecutableElement[] getEntityMethods(TypeElement typeElement) {
        LinkedList<ExecutableElement> linkedList = new LinkedList<ExecutableElement>();
        TypeElement typeElement2 = typeElement;
        while (typeElement2 != null) {
            if (JpaControllerUtil.isAnnotatedWith(typeElement2, "javax.persistence.Entity") || JpaControllerUtil.isAnnotatedWith(typeElement2, "javax.persistence.MappedSuperclass")) {
                linkedList.addAll(ElementFilter.methodsIn(typeElement2.getEnclosedElements()));
            }
            typeElement2 = JpaControllerUtil.getSuperclassTypeElement(typeElement2);
        }
        return linkedList.toArray(new ExecutableElement[linkedList.size()]);
    }

    public static VariableElement guessField(CompilationController compilationController, ExecutableElement executableElement) {
        String string = executableElement.getSimpleName().toString().substring(3);
        String string2 = string.substring(0, 1).toLowerCase() + string.substring(1);
        TypeElement typeElement = (TypeElement)executableElement.getEnclosingElement();
        for (VariableElement variableElement : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
            if (!variableElement.getSimpleName().contentEquals(string2)) continue;
            return variableElement;
        }
        Logger.getLogger(JpaControllerUtil.class.getName()).log(Level.WARNING, "Cannot detect the field associated with property: " + string2);
        return null;
    }

    public static class AnnotationInfo {
        private String type;
        private String[] argNames;
        private Object[] argValues;

        public AnnotationInfo(String string) {
            if (string == null) {
                throw new IllegalArgumentException();
            }
            this.type = string;
        }

        public AnnotationInfo(String string, String[] stringArray, Object[] objectArray) {
            if (string == null) {
                throw new IllegalArgumentException();
            }
            this.type = string;
            if (stringArray == null ? objectArray != null : objectArray == null || objectArray.length != stringArray.length) {
                throw new IllegalArgumentException();
            }
            this.argNames = stringArray;
            this.argValues = objectArray;
        }

        public String getType() {
            return this.type;
        }

        public String[] getArgNames() {
            return this.argNames;
        }

        public Object[] getArgValues() {
            return this.argValues;
        }
    }

    public static class MethodInfo {
        private String name;
        private int modifiers;
        private TypeInfo returnType;
        private TypeInfo[] exceptionTypes;
        private TypeInfo[] parameterTypes;
        private String[] parameterNames;
        private String methodBodyText;
        private AnnotationInfo[] annotations;
        private String commentText;

        public MethodInfo(String string, int n, TypeInfo typeInfo, TypeInfo[] typeInfoArray, TypeInfo[] typeInfoArray2, String[] stringArray, String string2, AnnotationInfo[] annotationInfoArray, String string3) {
            this.name = string;
            this.modifiers = n;
            this.returnType = typeInfo;
            this.exceptionTypes = typeInfoArray;
            this.parameterTypes = typeInfoArray2;
            this.parameterNames = stringArray;
            this.methodBodyText = string2;
            this.annotations = annotationInfoArray;
            this.commentText = string3;
        }

        public MethodInfo(String string, int n, String string2, String[] stringArray, String[] stringArray2, String[] stringArray3, String string3, AnnotationInfo[] annotationInfoArray, String string4) {
            this.name = string;
            this.modifiers = n;
            this.returnType = new TypeInfo(string2);
            this.exceptionTypes = TypeInfo.fromStrings(stringArray);
            this.parameterTypes = TypeInfo.fromStrings(stringArray2);
            this.parameterNames = stringArray3;
            this.methodBodyText = string3;
            this.annotations = annotationInfoArray;
            this.commentText = string4;
        }

        public String getName() {
            return this.name;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public TypeInfo getReturnType() {
            return this.returnType;
        }

        public TypeInfo[] getExceptionTypes() {
            return this.exceptionTypes;
        }

        public String getMethodBodyText() {
            return this.methodBodyText;
        }

        public TypeInfo[] getParameterTypes() {
            return this.parameterTypes;
        }

        public String[] getParameterNames() {
            return this.parameterNames;
        }

        public AnnotationInfo[] getAnnotations() {
            return this.annotations;
        }

        public String getCommentText() {
            return this.commentText;
        }
    }

    public static class TypeInfo {
        private String rawType;
        private TypeInfo[] declaredTypeParameters;

        public String getRawType() {
            return this.rawType;
        }

        public TypeInfo[] getDeclaredTypeParameters() {
            return this.declaredTypeParameters;
        }

        public TypeInfo(String string) {
            if (string == null) {
                throw new IllegalArgumentException();
            }
            this.rawType = string;
        }

        public TypeInfo(String string, TypeInfo[] typeInfoArray) {
            if (string == null) {
                throw new IllegalArgumentException();
            }
            this.rawType = string;
            if (typeInfoArray == null || typeInfoArray.length == 0) {
                return;
            }
            this.declaredTypeParameters = typeInfoArray;
        }

        public TypeInfo(String string, String[] stringArray) {
            if (string == null) {
                throw new IllegalArgumentException();
            }
            this.rawType = string;
            if (stringArray == null || stringArray.length == 0) {
                return;
            }
            this.declaredTypeParameters = TypeInfo.fromStrings(stringArray);
        }

        public static TypeInfo[] fromStrings(String[] stringArray) {
            if (stringArray == null || stringArray.length == 0) {
                return null;
            }
            TypeInfo[] typeInfoArray = new TypeInfo[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                typeInfoArray[i] = new TypeInfo(stringArray[i]);
            }
            return typeInfoArray;
        }
    }

    public static class TreeMakerUtils {
        public static ClassTree addVariable(ClassTree classTree, WorkingCopy workingCopy, String string, TypeInfo typeInfo, int n, Object object, AnnotationInfo[] annotationInfoArray) {
            Tree tree = TreeMakerUtils.createType(workingCopy, typeInfo);
            ModifiersTree modifiersTree = TreeMakerUtils.createModifiers(workingCopy, n, annotationInfoArray);
            TreeMaker treeMaker = workingCopy.getTreeMaker();
            VariableTree variableTree = treeMaker.Variable(modifiersTree, (CharSequence)string, tree, (ExpressionTree)treeMaker.Literal(object));
            return treeMaker.addClassMember(classTree, (Tree)variableTree);
        }

        public static ClassTree addVariable(ClassTree classTree, WorkingCopy workingCopy, String string, String string2, int n, Object object, AnnotationInfo[] annotationInfoArray) {
            return TreeMakerUtils.addVariable(classTree, workingCopy, string, new TypeInfo(string2), n, object, annotationInfoArray);
        }

        private static VariableTree createVariable(WorkingCopy workingCopy, String string, TypeInfo typeInfo) {
            return TreeMakerUtils.createVariable(workingCopy, string, TreeMakerUtils.createType(workingCopy, typeInfo));
        }

        private static VariableTree createVariable(WorkingCopy workingCopy, String string, Tree tree) {
            TreeMaker treeMaker = workingCopy.getTreeMaker();
            return treeMaker.Variable(TreeMakerUtils.createModifiers(workingCopy), (CharSequence)string, tree, null);
        }

        public static ClassTree addMethod(ClassTree classTree, WorkingCopy workingCopy, MethodInfo methodInfo) {
            MethodTree methodTree = TreeMakerUtils.createMethod(workingCopy, methodInfo);
            return workingCopy.getTreeMaker().addClassMember(classTree, (Tree)methodTree);
        }

        public static ClassTree modifyDefaultConstructor(ClassTree classTree, ClassTree classTree2, WorkingCopy workingCopy, MethodInfo methodInfo) {
            if (!"<init>".equals(methodInfo.getName())) {
                throw new IllegalArgumentException("modifiedConstructorInfo name must be <init>");
            }
            MethodTree methodTree = TreeMakerUtils.createMethod(workingCopy, methodInfo);
            MethodTree methodTree2 = null;
            for (Tree tree : classTree2.getMembers()) {
                if (Tree.Kind.METHOD != tree.getKind()) continue;
                MethodTree methodTree3 = (MethodTree)tree;
                List<? extends VariableTree> list = methodTree3.getParameters();
                if (!methodTree3.getName().toString().equals("<init>") || list != null && list.size() != 0 || workingCopy.getTreeUtilities().isSynthetic(workingCopy.getTrees().getPath(workingCopy.getCompilationUnit(), classTree))) continue;
                methodTree2 = methodTree3;
                break;
            }
            if (methodTree2 == null) {
                classTree2 = workingCopy.getTreeMaker().addClassMember(classTree2, (Tree)methodTree);
            } else {
                workingCopy.rewrite(methodTree2, (Tree)methodTree);
            }
            return classTree2;
        }

        private static MethodTree createMethod(WorkingCopy workingCopy, MethodInfo methodInfo) {
            Object object;
            TreeMaker treeMaker = workingCopy.getTreeMaker();
            TypeInfo[] typeInfoArray = methodInfo.getParameterTypes();
            String[] stringArray = methodInfo.getParameterNames();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; typeInfoArray != null && i < typeInfoArray.length; ++i) {
                object = TreeMakerUtils.createVariable(workingCopy, stringArray[i], typeInfoArray[i]);
                arrayList.add(object);
            }
            TypeInfo[] typeInfoArray2 = methodInfo.getExceptionTypes();
            object = new ArrayList();
            for (int i = 0; typeInfoArray2 != null && i < typeInfoArray2.length; ++i) {
                object.add((ExpressionTree)TreeMakerUtils.createType(workingCopy, typeInfoArray2[i]));
            }
            String string = methodInfo.getMethodBodyText();
            if (string == null) {
                string = "";
            }
            MethodTree methodTree = treeMaker.Method(TreeMakerUtils.createModifiers(workingCopy, methodInfo.getModifiers(), methodInfo.getAnnotations()), (CharSequence)methodInfo.getName(), TreeMakerUtils.createType(workingCopy, methodInfo.getReturnType()), Collections.emptyList(), arrayList, (List)object, "{" + string + "}", null);
            return methodTree;
        }

        private static Tree createType(WorkingCopy workingCopy, TypeInfo typeInfo) {
            if (typeInfo == null) {
                return null;
            }
            String string = typeInfo.getRawType();
            TreeMaker treeMaker = workingCopy.getTreeMaker();
            if (string.endsWith("[]")) {
                String string2 = string.substring(0, string.length() - 2);
                TypeInfo typeInfo2 = new TypeInfo(string2, typeInfo.getDeclaredTypeParameters());
                return treeMaker.ArrayType(TreeMakerUtils.createType(workingCopy, typeInfo2));
            }
            TypeKind typeKind = null;
            if ("boolean".equals(string)) {
                typeKind = TypeKind.BOOLEAN;
            } else if ("byte".equals(string)) {
                typeKind = TypeKind.BYTE;
            } else if ("short".equals(string)) {
                typeKind = TypeKind.SHORT;
            } else if ("int".equals(string)) {
                typeKind = TypeKind.INT;
            } else if ("long".equals(string)) {
                typeKind = TypeKind.LONG;
            } else if ("char".equals(string)) {
                typeKind = TypeKind.CHAR;
            } else if ("float".equals(string)) {
                typeKind = TypeKind.FLOAT;
            } else if ("double".equals(string)) {
                typeKind = TypeKind.DOUBLE;
            } else if ("void".equals(string)) {
                typeKind = TypeKind.VOID;
            }
            if (typeKind != null) {
                return treeMaker.PrimitiveType(typeKind);
            }
            TypeInfo[] typeInfoArray = typeInfo.getDeclaredTypeParameters();
            if (typeInfoArray == null || typeInfoArray.length == 0) {
                TypeElement typeElement = workingCopy.getElements().getTypeElement(string);
                if (typeElement == null) {
                    throw new IllegalArgumentException("Type " + string + " cannot be found");
                }
                return treeMaker.QualIdent((Element)typeElement);
            }
            TypeMirror typeMirror = TreeMakerUtils.getTypeMirror(workingCopy, typeInfo);
            return treeMaker.Type(typeMirror);
        }

        private static TypeMirror getTypeMirror(WorkingCopy workingCopy, TypeInfo typeInfo) {
            TreeMaker treeMaker = workingCopy.getTreeMaker();
            String string = typeInfo.getRawType();
            TypeElement typeElement = workingCopy.getElements().getTypeElement(string);
            if (typeElement == null) {
                throw new IllegalArgumentException("Type " + string + " cannot be found");
            }
            TypeInfo[] typeInfoArray = typeInfo.getDeclaredTypeParameters();
            if (typeInfoArray == null || typeInfoArray.length == 0) {
                treeMaker.QualIdent((Element)typeElement);
                return typeElement.asType();
            }
            TypeMirror[] typeMirrorArray = new TypeMirror[typeInfoArray.length];
            for (int i = 0; i < typeInfoArray.length; ++i) {
                typeMirrorArray[i] = TreeMakerUtils.getTypeMirror(workingCopy, typeInfoArray[i]);
            }
            DeclaredType declaredType = workingCopy.getTypes().getDeclaredType(typeElement, typeMirrorArray);
            return declaredType;
        }

        private static ModifiersTree createModifiers(WorkingCopy workingCopy) {
            return workingCopy.getTreeMaker().Modifiers(Collections.emptySet(), Collections.emptyList());
        }

        private static ModifiersTree createModifiers(WorkingCopy workingCopy, long l, AnnotationInfo[] annotationInfoArray) {
            if (annotationInfoArray == null || annotationInfoArray.length == 0) {
                return workingCopy.getTreeMaker().Modifiers(l, Collections.emptyList());
            }
            GenerationUtils generationUtils = GenerationUtils.newInstance((WorkingCopy)workingCopy);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (AnnotationInfo annotationInfo : annotationInfoArray) {
                Object[] objectArray;
                String[] stringArray = annotationInfo.getArgNames();
                if (stringArray != null && stringArray.length > 0) {
                    objectArray = annotationInfo.getArgValues();
                    ArrayList<ExpressionTree> arrayList2 = new ArrayList<ExpressionTree>();
                    for (int i = 0; i < stringArray.length; ++i) {
                        ExpressionTree expressionTree = generationUtils.createAnnotationArgument(stringArray[i], objectArray[i]);
                        arrayList2.add(expressionTree);
                    }
                    AnnotationTree annotationTree = generationUtils.createAnnotation(annotationInfo.getType(), arrayList2);
                    arrayList.add(annotationTree);
                    continue;
                }
                objectArray = generationUtils.createAnnotation(annotationInfo.getType());
                arrayList.add(objectArray);
            }
            return workingCopy.getTreeMaker().Modifiers(l, arrayList);
        }

        public static CompilationUnitTree createImport(WorkingCopy workingCopy, CompilationUnitTree compilationUnitTree, String string) {
            if (compilationUnitTree == null) {
                compilationUnitTree = workingCopy.getCompilationUnit();
            }
            List<? extends ImportTree> list = compilationUnitTree.getImports();
            boolean bl = false;
            for (ImportTree tree : list) {
                if (!string.equals(tree.getQualifiedIdentifier().toString())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                TreeMaker treeMaker = workingCopy.getTreeMaker();
                CompilationUnitTree compilationUnitTree2 = treeMaker.addCompUnitImport(compilationUnitTree, treeMaker.Import((Tree)treeMaker.Identifier((CharSequence)string), false));
                workingCopy.rewrite((Tree)workingCopy.getCompilationUnit(), (Tree)compilationUnitTree2);
                return compilationUnitTree2;
            }
            return compilationUnitTree;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmbeddedPkSupportInfo {
        private TypeElement type;
        private Map<String, ExecutableElement> joinColumnNameToRelationshipMethod = new HashMap<String, ExecutableElement>();
        private Map<ExecutableElement, List<String>> relationshipMethodToJoinColumnNames = new HashMap<ExecutableElement, List<String>>();
        private Map<String, String> joinColumnNameToReferencedColumnName = new HashMap<String, String>();
        private Map<String, String> columnNameToAccessorString = new HashMap<String, String>();
        private Map<ExecutableElement, String> pkAccessorMethodToColumnName = new HashMap<ExecutableElement, String>();
        private Map<ExecutableElement, String> pkAccessorMethodToPopulationCode = new HashMap<ExecutableElement, String>();
        private boolean isFieldAccess;

        public Set<ExecutableElement> getPkAccessorMethods() {
            return this.pkAccessorMethodToColumnName.keySet();
        }

        public ExecutableElement getRelationshipMethod(ExecutableElement executableElement) {
            String string = this.pkAccessorMethodToColumnName.get(executableElement);
            if (string == null) {
                return null;
            }
            return this.joinColumnNameToRelationshipMethod.get(string);
        }

        public String getReferencedColumnName(ExecutableElement executableElement) {
            String string = this.pkAccessorMethodToColumnName.get(executableElement);
            if (string == null) {
                return null;
            }
            return this.joinColumnNameToReferencedColumnName.get(string);
        }

        public String getAccessorString(String string) {
            return this.columnNameToAccessorString.get(string);
        }

        public String getCodeToPopulatePkField(ExecutableElement executableElement) {
            return this.pkAccessorMethodToPopulationCode.get(executableElement);
        }

        public void putCodeToPopulatePkField(ExecutableElement executableElement, String string) {
            this.pkAccessorMethodToPopulationCode.put(executableElement, string);
        }

        public boolean isRedundantWithPkFields(ExecutableElement executableElement) {
            List<String> list = this.relationshipMethodToJoinColumnNames.get(executableElement);
            if (list == null) {
                return false;
            }
            Collection<String> collection = this.pkAccessorMethodToColumnName.values();
            for (String string : list) {
                if (collection.contains(string)) continue;
                return false;
            }
            return true;
        }

        EmbeddedPkSupportInfo(CompilationController compilationController, TypeElement typeElement) {
            this.type = typeElement;
            this.isFieldAccess = JpaControllerUtil.isFieldAccess(typeElement);
            for (ExecutableElement executableElement : JpaControllerUtil.getEntityMethods(typeElement)) {
                String string;
                ExecutableElement executableElement2;
                String string2 = executableElement.getSimpleName().toString();
                if (!string2.startsWith("get")) continue;
                Element element = executableElement2 = this.isFieldAccess ? JpaControllerUtil.guessField(compilationController, executableElement) : executableElement;
                if (executableElement2 == null) continue;
                int n = -1;
                AnnotationMirror annotationMirror = null;
                String[] stringArray = new String[]{"javax.persistence.EmbeddedId", "javax.persistence.JoinColumns", "javax.persistence.JoinColumn", "javax.persistence.Column"};
                for (int i = 0; i < stringArray.length; ++i) {
                    String string3 = stringArray[i];
                    AnnotationMirror annotationMirror2 = JpaControllerUtil.findAnnotation(executableElement2, string3);
                    if (annotationMirror2 == null) continue;
                    n = i;
                    annotationMirror = annotationMirror2;
                    break;
                }
                if (n == 0) {
                    this.populateMapsForEmbedded(compilationController, executableElement);
                    continue;
                }
                if ((n == 1 || n == 2) && (JpaControllerUtil.isAnnotatedWith(executableElement2, "javax.persistence.OneToOne") || JpaControllerUtil.isAnnotatedWith(executableElement2, "javax.persistence.ManyToOne"))) {
                    this.populateJoinColumnNameMaps(executableElement, stringArray[n], annotationMirror);
                    continue;
                }
                if (n != 3 || (string = JpaControllerUtil.findAnnotationValueAsString(annotationMirror, "name")) == null) continue;
                this.columnNameToAccessorString.put(string, executableElement.getSimpleName().toString() + "()");
            }
        }

        private void populateMapsForEmbedded(CompilationController compilationController, ExecutableElement executableElement) {
            TypeMirror typeMirror = executableElement.getReturnType();
            if (TypeKind.DECLARED != typeMirror.getKind()) {
                return;
            }
            DeclaredType declaredType = (DeclaredType)typeMirror;
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            for (ExecutableElement executableElement2 : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                String string;
                ExecutableElement executableElement3;
                AnnotationMirror annotationMirror;
                String string2 = executableElement2.getSimpleName().toString();
                if (!string2.startsWith("get") || (annotationMirror = JpaControllerUtil.findAnnotation(executableElement3 = this.isFieldAccess ? JpaControllerUtil.guessField(compilationController, executableElement2) : executableElement2, "javax.persistence.Column")) == null || (string = JpaControllerUtil.findAnnotationValueAsString(annotationMirror, "name")) == null) continue;
                this.pkAccessorMethodToColumnName.put(executableElement2, string);
                this.columnNameToAccessorString.put(string, executableElement.getSimpleName().toString() + "()." + executableElement2.getSimpleName() + "()");
            }
        }

        private void populateJoinColumnNameMaps(ExecutableElement executableElement, String string, AnnotationMirror annotationMirror) {
            List<Object> list;
            if ("javax.persistence.JoinColumn".equals(string)) {
                list = new ArrayList();
                list.add(annotationMirror);
            } else {
                list = JpaControllerUtil.findNestedAnnotations(annotationMirror, "javax.persistence.JoinColumn");
            }
            for (AnnotationMirror annotationMirror2 : list) {
                String string2 = JpaControllerUtil.findAnnotationValueAsString(annotationMirror2, "name");
                if (string2 == null) continue;
                String string3 = JpaControllerUtil.findAnnotationValueAsString(annotationMirror2, "referencedColumnName");
                this.joinColumnNameToRelationshipMethod.put(string2, executableElement);
                this.joinColumnNameToReferencedColumnName.put(string2, string3);
                List<String> list2 = this.relationshipMethodToJoinColumnNames.get(executableElement);
                if (list2 == null) {
                    list2 = new ArrayList<String>();
                    this.relationshipMethodToJoinColumnNames.put(executableElement, list2);
                }
                list2.add(string2);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EmbeddedPkSupport {
        private Map<TypeElement, EmbeddedPkSupportInfo> typeToInfo = new HashMap<TypeElement, EmbeddedPkSupportInfo>();

        public Set<ExecutableElement> getPkAccessorMethods(CompilationController compilationController, TypeElement typeElement) {
            EmbeddedPkSupportInfo embeddedPkSupportInfo = this.getInfo(compilationController, typeElement);
            return embeddedPkSupportInfo.getPkAccessorMethods();
        }

        public String getCodeToPopulatePkField(CompilationController compilationController, TypeElement typeElement, ExecutableElement executableElement) {
            EmbeddedPkSupportInfo embeddedPkSupportInfo = this.getInfo(compilationController, typeElement);
            String string = embeddedPkSupportInfo.getCodeToPopulatePkField(executableElement);
            if (string != null) {
                return string;
            }
            string = "";
            ExecutableElement executableElement2 = embeddedPkSupportInfo.getRelationshipMethod(executableElement);
            String string2 = embeddedPkSupportInfo.getReferencedColumnName(executableElement);
            if (executableElement2 == null || string2 == null) {
                embeddedPkSupportInfo.putCodeToPopulatePkField(executableElement, string);
                return string;
            }
            TypeMirror typeMirror = executableElement2.getReturnType();
            if (TypeKind.DECLARED != typeMirror.getKind()) {
                embeddedPkSupportInfo.putCodeToPopulatePkField(executableElement, string);
                return string;
            }
            DeclaredType declaredType = (DeclaredType)typeMirror;
            TypeElement typeElement2 = (TypeElement)declaredType.asElement();
            EmbeddedPkSupportInfo embeddedPkSupportInfo2 = this.getInfo(compilationController, typeElement2);
            String string3 = embeddedPkSupportInfo2.getAccessorString(string2);
            if (string3 == null) {
                embeddedPkSupportInfo.putCodeToPopulatePkField(executableElement, string);
                return string;
            }
            string = executableElement2.getSimpleName().toString() + "()." + string3;
            embeddedPkSupportInfo.putCodeToPopulatePkField(executableElement, string);
            return string;
        }

        public boolean isRedundantWithRelationshipField(CompilationController compilationController, TypeElement typeElement, ExecutableElement executableElement) {
            return this.getCodeToPopulatePkField(compilationController, typeElement, executableElement).length() > 0;
        }

        public boolean isRedundantWithPkFields(CompilationController compilationController, TypeElement typeElement, ExecutableElement executableElement) {
            EmbeddedPkSupportInfo embeddedPkSupportInfo = this.getInfo(compilationController, typeElement);
            return embeddedPkSupportInfo.isRedundantWithPkFields(executableElement);
        }

        private EmbeddedPkSupportInfo getInfo(CompilationController compilationController, TypeElement typeElement) {
            EmbeddedPkSupportInfo embeddedPkSupportInfo = this.typeToInfo.get(typeElement);
            if (embeddedPkSupportInfo == null) {
                embeddedPkSupportInfo = new EmbeddedPkSupportInfo(compilationController, typeElement);
                this.typeToInfo.put(typeElement, embeddedPkSupportInfo);
            }
            return embeddedPkSupportInfo;
        }
    }
}

