/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.unit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.core.api.support.Strings;
import org.netbeans.modules.j2ee.persistence.provider.DefaultProvider;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.spi.datasource.JPADataSource;
import org.netbeans.modules.j2ee.persistence.spi.datasource.JPADataSourcePopulator;
import org.netbeans.modules.j2ee.persistence.util.PersistenceProviderComboboxHelper;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardDescriptor;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanel;
import org.openide.util.NbBundle;

public class PersistenceUnitWizardPanelDS
extends PersistenceUnitWizardPanel {
    private ButtonGroup buttonGroup1;
    private JLabel datasourceLabel;
    private JRadioButton ddlCreate;
    private JRadioButton ddlDropCreate;
    private JRadioButton ddlUnkown;
    private JComboBox dsCombo;
    private JLabel errorMessage;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JCheckBox jtaCheckBox;
    private JLabel persistenceProviderLabel;
    private JComboBox providerCombo;
    private ButtonGroup tableCreationButtonGroup;
    private JLabel unitNameLabel;
    private JTextField unitNameTextField;

    public PersistenceUnitWizardPanelDS(Project project, ChangeListener changeListener, boolean bl) {
        this(project, changeListener, bl, PersistenceUnitWizardPanel.TableGeneration.CREATE);
    }

    public PersistenceUnitWizardPanelDS(Project project, ChangeListener changeListener, boolean bl, PersistenceUnitWizardPanel.TableGeneration tableGeneration) {
        super(project);
        this.initComponents();
        this.setTableGeneration(tableGeneration);
        if (ProviderUtil.isValidServerInstanceOrNone(project)) {
            this.connectDatasources();
        }
        PersistenceProviderComboboxHelper persistenceProviderComboboxHelper = new PersistenceProviderComboboxHelper(project);
        persistenceProviderComboboxHelper.connect(this.providerCombo);
        this.unitNameTextField.setText(this.getCandidateName());
        this.unitNameTextField.selectAll();
        this.unitNameTextField.setVisible(bl);
        this.unitNameLabel.setVisible(bl);
        this.unitNameTextField.getDocument().addDocumentListener(new ValidationListener());
        this.errorMessage.setForeground(Color.RED);
    }

    private void setTableGeneration(PersistenceUnitWizardPanel.TableGeneration tableGeneration) {
        if (PersistenceUnitWizardPanel.TableGeneration.CREATE.equals((Object)tableGeneration)) {
            this.ddlCreate.setSelected(true);
        } else if (PersistenceUnitWizardPanel.TableGeneration.DROP_CREATE.equals((Object)tableGeneration)) {
            this.ddlDropCreate.setSelected(true);
        } else {
            this.ddlUnkown.setSelected(true);
        }
    }

    private void connectDatasources() {
        JPADataSourcePopulator jPADataSourcePopulator = (JPADataSourcePopulator)this.project.getLookup().lookup(JPADataSourcePopulator.class);
        jPADataSourcePopulator.connect(this.dsCombo);
        this.dsCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PersistenceUnitWizardPanelDS.this.checkValidity();
            }
        });
        ((JTextComponent)this.dsCombo.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                PersistenceUnitWizardPanelDS.this.checkValidity();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                PersistenceUnitWizardPanelDS.this.checkValidity();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                PersistenceUnitWizardPanelDS.this.checkValidity();
            }
        });
    }

    private void checkValidity() {
        if (this.isValidPanel()) {
            this.firePropertyChange("PersistenceUnitWizardPanel_isValid", false, true);
        } else {
            this.firePropertyChange("PersistenceUnitWizardPanel_isValid", true, false);
        }
    }

    public String getPersistenceUnitName() {
        return this.unitNameTextField.getText();
    }

    public String getDatasource() {
        return ((JTextComponent)this.dsCombo.getEditor().getEditorComponent()).getText();
    }

    public void setPreselectedDB(String string) {
        boolean bl = false;
        for (int i = 0; i < this.dsCombo.getItemCount(); ++i) {
            JPADataSource jPADataSource;
            if (!(this.dsCombo.getItemAt(i) instanceof JPADataSource) || !(jPADataSource = (JPADataSource)this.dsCombo.getItemAt(i)).getJndiName().equals(string)) continue;
            bl = true;
            break;
        }
        this.dsCombo.setSelectedItem(string);
        this.dsCombo.setEnabled(!bl);
    }

    public boolean isNonDefaultProviderEnabled() {
        return !(this.providerCombo.getSelectedItem() instanceof DefaultProvider);
    }

    public String getNonDefaultProvider() {
        return ((Provider)this.providerCombo.getSelectedItem()).getProviderClass();
    }

    public boolean isJTA() {
        return this.jtaCheckBox.isEnabled() && this.jtaCheckBox.isSelected();
    }

    public String getTableGeneration() {
        if (this.ddlCreate.isSelected()) {
            return "tableGenerationCreate";
        }
        if (this.ddlDropCreate.isSelected()) {
            return "tableGenerationDropCreate";
        }
        return "tableGenerationUnknown";
    }

    public boolean isValidPanel() {
        try {
            if (!this.isNameValid()) {
                return false;
            }
        }
        catch (InvalidPersistenceXmlException invalidPersistenceXmlException) {
            this.setErrorMessage(NbBundle.getMessage(PersistenceUnitWizardDescriptor.class, (String)"ERR_InvalidPersistenceXml", (Object)invalidPersistenceXmlException.getPath()));
            return false;
        }
        return true;
    }

    private boolean isNameValid() throws InvalidPersistenceXmlException {
        return Strings.isEmpty((String)this.getPersistenceUnitName()) ? false : this.isNameUnique();
    }

    public Provider getSelectedProvider() {
        return (Provider)this.providerCombo.getSelectedItem();
    }

    public void setErrorMessage(String string) {
        this.errorMessage.setText(string);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.tableCreationButtonGroup = new ButtonGroup();
        this.unitNameLabel = new JLabel();
        this.unitNameTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.ddlCreate = new JRadioButton();
        this.ddlDropCreate = new JRadioButton();
        this.ddlUnkown = new JRadioButton();
        this.datasourceLabel = new JLabel();
        this.jtaCheckBox = new JCheckBox();
        this.dsCombo = new JComboBox();
        this.persistenceProviderLabel = new JLabel();
        this.providerCombo = new JComboBox();
        this.errorMessage = new JLabel();
        this.setName(NbBundle.getMessage(PersistenceUnitWizardPanelDS.class, (String)"LBL_Step1"));
        this.unitNameLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle").getString("MN_UnitName").charAt(0));
        this.unitNameLabel.setLabelFor(this.unitNameTextField);
        this.unitNameLabel.setText(NbBundle.getMessage(PersistenceUnitWizardPanelDS.class, (String)"LBL_UnitName"));
        this.unitNameTextField.setColumns(40);
        this.unitNameTextField.setText("em");
        this.jLabel1.setText(NbBundle.getMessage(PersistenceUnitWizardPanelDS.class, (String)"LBL_SpecifyPersistenceProvider"));
        this.jLabel2.setText(NbBundle.getMessage(PersistenceUnitWizardPanelDS.class, (String)"LBL_TableGeneration"));
        this.tableCreationButtonGroup.add(this.ddlCreate);
        this.ddlCreate.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle").getString("CHB_Create_mnem").charAt(0));
        this.ddlCreate.setSelected(true);
        this.ddlCreate.setText(NbBundle.getMessage(PersistenceUnitWizardPanelDS.class, (String)"LBL_Create"));
        this.ddlCreate.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.tableCreationButtonGroup.add(this.ddlDropCreate);
        this.ddlDropCreate.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle").getString("CHB_DropCreate_mnem").charAt(0));
        this.ddlDropCreate.setText(NbBundle.getMessage(PersistenceUnitWizardPanelDS.class, (String)"LBL_DropCreate"));
        this.ddlDropCreate.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.tableCreationButtonGroup.add(this.ddlUnkown);
        this.ddlUnkown.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle").getString("CHB_None_mnem").charAt(0));
        this.ddlUnkown.setText(NbBundle.getMessage(PersistenceUnitWizardPanelDS.class, (String)"LBL_None"));
        this.ddlUnkown.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.datasourceLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle").getString("MN_DatasourceName").charAt(0));
        this.datasourceLabel.setLabelFor(this.dsCombo);
        this.datasourceLabel.setText(NbBundle.getMessage(PersistenceUnitWizardPanelDS.class, (String)"LBL_ServerDataSource"));
        this.jtaCheckBox.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle").getString("CHB_JTA_mnem").charAt(0));
        this.jtaCheckBox.setSelected(true);
        this.jtaCheckBox.setText(NbBundle.getMessage(PersistenceUnitWizardPanelDS.class, (String)"LBL_JTA"));
        this.jtaCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.dsCombo.setEditable(true);
        this.persistenceProviderLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle").getString("MN_Provider").charAt(0));
        this.persistenceProviderLabel.setLabelFor(this.providerCombo);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle");
        this.persistenceProviderLabel.setText(resourceBundle.getString("LBL_PersistenceProvider"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.unitNameLabel).add((Component)this.persistenceProviderLabel).add((Component)this.datasourceLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.unitNameTextField, -1, 380, Short.MAX_VALUE).add((Component)this.providerCombo, 0, 380, Short.MAX_VALUE).add((Component)this.dsCombo, 0, 380, Short.MAX_VALUE))).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.ddlCreate).addPreferredGap(0).add((Component)this.ddlDropCreate).addPreferredGap(0).add((Component)this.ddlUnkown)).add(1, (Component)this.jtaCheckBox).add(1, (Component)this.jLabel1).add((Component)this.errorMessage, -1, 543, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.unitNameLabel).add((Component)this.unitNameTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.jLabel1).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.persistenceProviderLabel).add((Component)this.providerCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.datasourceLabel).add((Component)this.dsCombo, -2, -1, -2)).addPreferredGap(0).add((Component)this.jtaCheckBox).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.ddlCreate).add((Component)this.ddlDropCreate).add((Component)this.ddlUnkown).add((Component)this.jLabel2)).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.errorMessage, -2, 22, -2).addContainerGap()));
        this.unitNameLabel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_UnitName"));
        this.unitNameTextField.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_UnitName"));
        this.jLabel2.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_TableGeneration"));
        this.ddlCreate.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_Create"));
        this.ddlDropCreate.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_DropCreate"));
        this.ddlUnkown.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_None"));
        this.datasourceLabel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_DatasourceName"));
        this.jtaCheckBox.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_JTA"));
        this.persistenceProviderLabel.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSD_Provider"));
        this.persistenceProviderLabel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_Provider"));
        this.providerCombo.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_Provider"));
    }

    private class ValidationListener
    implements DocumentListener {
        private ValidationListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            PersistenceUnitWizardPanelDS.this.checkValidity();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            PersistenceUnitWizardPanelDS.this.checkValidity();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            PersistenceUnitWizardPanelDS.this.checkValidity();
        }
    }
}

