/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.editor.semantic.RemoveUnusedImportFix;
import org.netbeans.modules.java.hints.ForbiddenImportsCustomizer;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Imports
extends AbstractHint
implements PreferenceChangeListener {
    private static final String DEFAULT_PACKAGE = "java.lang";
    private static final List<Fix> NO_FIXES = Collections.emptyList();
    private static Imports delegate;
    private Imports duplicate;
    private Imports defaultPackage;
    private Imports samePackage;
    private Imports forbiddenPackage;
    private Imports unused;
    private Imports star;
    private String IMPORTS_ID = "Imports_";
    private Set<Tree.Kind> treeKinds;
    private ImportHintKind kind;

    private Imports(ImportHintKind importHintKind) {
        super(importHintKind.defaultOn(), true, AbstractHint.HintSeverity.WARNING, new String[0]);
        this.kind = importHintKind;
        this.treeKinds = EnumSet.of(Tree.Kind.IMPORT);
    }

    public static Imports createDelegate() {
        return Imports.getDelegate();
    }

    public static Imports createDuplicate() {
        Imports imports = Imports.getDelegate();
        imports.duplicate = new Imports(ImportHintKind.DUPLICATE);
        return Imports.getDelegate();
    }

    public static Imports createDefaultPackage() {
        Imports imports = Imports.getDelegate();
        imports.defaultPackage = new Imports(ImportHintKind.DEFAULT_PACKAGE);
        return imports.defaultPackage;
    }

    public static Imports createForbidden() {
        Imports imports = Imports.getDelegate();
        imports.forbiddenPackage = new Imports(ImportHintKind.FORBIDDEN);
        return imports.forbiddenPackage;
    }

    public static Imports createSamePackage() {
        Imports imports = Imports.getDelegate();
        imports.samePackage = new Imports(ImportHintKind.SAME_PACKAGE);
        return imports.samePackage;
    }

    public static Imports createUnused() {
        Imports imports = Imports.getDelegate();
        imports.unused = new Imports(ImportHintKind.UNUSED);
        imports.unused.getPreferences(null);
        return imports.unused;
    }

    public static Imports createStar() {
        Imports imports = Imports.getDelegate();
        imports.star = new Imports(ImportHintKind.STAR);
        return imports.star;
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return this.treeKinds;
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        ArrayList<ErrorDescription> arrayList = new ArrayList<ErrorDescription>();
        Tree tree = treePath.getLeaf();
        if (tree.getKind() != Tree.Kind.IMPORT) {
            return null;
        }
        ImportTree importTree = (ImportTree)tree;
        if (importTree.isStatic() || !(importTree.getQualifiedIdentifier() instanceof MemberSelectTree)) {
            return null;
        }
        MemberSelectTree memberSelectTree = (MemberSelectTree)importTree.getQualifiedIdentifier();
        Fix fix = null;
        switch (this.kind) {
            case STAR: {
                Imports imports = Imports.getDelegate().star;
                if (imports == null || !imports.isEnabled() || !"*".equals(memberSelectTree.getIdentifier().toString())) break;
                arrayList.add(ErrorDescriptionFactory.createErrorDescription((Severity)imports.getSeverity().toEditorSeverity(), (String)imports.getDisplayName(), NO_FIXES, (FileObject)compilationInfo.getFileObject(), (int)((int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), importTree)), (int)((int)compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), importTree))));
                break;
            }
            case DEFAULT_PACKAGE: {
                Imports imports;
                fix = null;
                List<ImportTree> list = this.getAllImportsOfKind(compilationInfo, ImportHintKind.DEFAULT_PACKAGE);
                if (list.size() > 1) {
                    fix = this.createFix(compilationInfo, list, ImportHintKind.DEFAULT_PACKAGE);
                }
                if ((imports = Imports.getDelegate().defaultPackage) == null || !imports.isEnabled() || !memberSelectTree.getExpression().toString().equals(DEFAULT_PACKAGE)) break;
                ArrayList<Fix> arrayList2 = new ArrayList<Fix>();
                arrayList2.add(this.createFix(compilationInfo, importTree, ImportHintKind.DEFAULT_PACKAGE));
                if (fix != null) {
                    arrayList2.add(fix);
                }
                arrayList.add(ErrorDescriptionFactory.createErrorDescription((Severity)imports.getSeverity().toEditorSeverity(), (String)imports.getDisplayName(), arrayList2, (FileObject)compilationInfo.getFileObject(), (int)((int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), importTree)), (int)((int)compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), importTree))));
                break;
            }
            case SAME_PACKAGE: {
                Imports imports;
                ExpressionTree expressionTree = compilationInfo.getCompilationUnit().getPackageName();
                fix = null;
                List<ImportTree> list = this.getAllImportsOfKind(compilationInfo, ImportHintKind.SAME_PACKAGE);
                if (list.size() > 1) {
                    fix = this.createFix(compilationInfo, list, ImportHintKind.SAME_PACKAGE);
                }
                if ((imports = Imports.getDelegate().samePackage) == null || !imports.isEnabled() || expressionTree == null || !memberSelectTree.getExpression().toString().equals(expressionTree.toString())) break;
                ArrayList<Fix> arrayList3 = new ArrayList<Fix>();
                arrayList3.add(this.createFix(compilationInfo, importTree, ImportHintKind.SAME_PACKAGE));
                if (fix != null) {
                    arrayList3.add(fix);
                }
                arrayList.add(ErrorDescriptionFactory.createErrorDescription((Severity)imports.getSeverity().toEditorSeverity(), (String)imports.getDisplayName(), arrayList3, (FileObject)compilationInfo.getFileObject(), (int)((int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), importTree)), (int)((int)compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), importTree))));
                break;
            }
            case FORBIDDEN: {
                Imports imports = Imports.getDelegate().forbiddenPackage;
                String[] stringArray = this.getRegexps(imports.getPreferences(null));
                if (imports == null || !imports.isEnabled() || !Imports.isForbidden(memberSelectTree.getExpression().toString(), stringArray)) break;
                arrayList.add(ErrorDescriptionFactory.createErrorDescription((Severity)imports.getSeverity().toEditorSeverity(), (String)imports.getDisplayName(), NO_FIXES, (FileObject)compilationInfo.getFileObject(), (int)((int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), importTree)), (int)((int)compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), importTree))));
                break;
            }
            default: {
                return null;
            }
        }
        return arrayList;
    }

    private List<ImportTree> getAllImportsOfKind(CompilationInfo compilationInfo, ImportHintKind importHintKind) {
        assert (importHintKind == ImportHintKind.DEFAULT_PACKAGE || importHintKind == ImportHintKind.SAME_PACKAGE);
        CompilationUnitTree compilationUnitTree = compilationInfo.getCompilationUnit();
        ArrayList<ImportTree> arrayList = new ArrayList<ImportTree>(3);
        List<? extends ImportTree> list = compilationUnitTree.getImports();
        for (ImportTree importTree : list) {
            if (importTree.isStatic() || !(importTree.getQualifiedIdentifier() instanceof MemberSelectTree)) continue;
            MemberSelectTree memberSelectTree = (MemberSelectTree)importTree.getQualifiedIdentifier();
            if (importHintKind == ImportHintKind.DEFAULT_PACKAGE && Imports.getDelegate().defaultPackage != null && Imports.getDelegate().defaultPackage.isEnabled() && memberSelectTree.getExpression().toString().equals(DEFAULT_PACKAGE)) {
                arrayList.add(importTree);
            }
            if (importHintKind != ImportHintKind.SAME_PACKAGE) continue;
            ExpressionTree expressionTree = compilationUnitTree.getPackageName();
            if (Imports.getDelegate().samePackage == null || !Imports.getDelegate().samePackage.isEnabled() || expressionTree == null || !memberSelectTree.getExpression().toString().equals(expressionTree.toString())) continue;
            arrayList.add(importTree);
        }
        return arrayList;
    }

    @Override
    public void cancel() {
    }

    @Override
    public String getId() {
        return this.IMPORTS_ID + this.kind.toString();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(Imports.class, (String)("LBL_Imports_" + this.kind.toString()));
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(Imports.class, (String)("DSC_Imports_" + this.kind.toString()));
    }

    @Override
    public Preferences getPreferences(String string) {
        Preferences preferences = super.getPreferences(string);
        if (this.kind == ImportHintKind.UNUSED) {
            try {
                preferences.removePreferenceChangeListener(this);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            preferences.addPreferenceChangeListener(this);
        }
        return preferences;
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        if (this.kind == ImportHintKind.FORBIDDEN) {
            return new ForbiddenImportsCustomizer(preferences);
        }
        return super.getCustomizer(preferences);
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        if (this.kind == ImportHintKind.UNUSED) {
            RemoveUnusedImportFix.setEnabled((boolean)this.isEnabled());
            RemoveUnusedImportFix.setSeverity((Severity)Imports.getDelegate().unused.getSeverity().toEditorSeverity());
        }
    }

    private static synchronized Imports getDelegate() {
        if (delegate == null) {
            delegate = new Imports(ImportHintKind.DELEGATE);
        }
        return delegate;
    }

    private Fix createFix(CompilationInfo compilationInfo, ImportTree importTree, ImportHintKind importHintKind) {
        return this.createFix(compilationInfo, Collections.singletonList(importTree), importHintKind);
    }

    private Fix createFix(CompilationInfo compilationInfo, List<ImportTree> list, ImportHintKind importHintKind) {
        ArrayList<TreePathHandle> arrayList = new ArrayList<TreePathHandle>();
        Trees trees = compilationInfo.getTrees();
        CompilationUnitTree compilationUnitTree = compilationInfo.getCompilationUnit();
        for (ImportTree importTree : list) {
            arrayList.add(TreePathHandle.create((TreePath)trees.getPath(compilationUnitTree, importTree), (CompilationInfo)compilationInfo));
        }
        return new ImportsFix(compilationInfo.getFileObject(), arrayList, importHintKind);
    }

    private String[] getRegexps(Preferences preferences) {
        String[] stringArray = ForbiddenImportsCustomizer.getForbiddenImports(preferences);
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            string = string.replace(".", "\\.");
            string = string.replace("**", ";;");
            string = string.replace("*", "[^\\.]*");
            stringArray2[i] = string = string.replace(";;", ".*");
        }
        return stringArray2;
    }

    private static boolean isForbidden(String string, String[] stringArray) {
        for (String string2 : stringArray) {
            if (!Pattern.matches(string2, string)) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImportsFix
    implements Fix,
    Task<WorkingCopy> {
        FileObject file;
        List<TreePathHandle> tphList;
        ImportHintKind ihk;

        public ImportsFix(FileObject fileObject, List<TreePathHandle> list, ImportHintKind importHintKind) {
            this.file = fileObject;
            this.tphList = list;
            this.ihk = importHintKind;
        }

        public String getText() {
            if (this.tphList.size() == 1) {
                return NbBundle.getMessage(Imports.class, (String)("LBL_Imports_Fix_One_" + this.ihk.toString()));
            }
            return NbBundle.getMessage(Imports.class, (String)("LBL_Imports_Fix_All_" + this.ihk.toString()));
        }

        public ChangeInfo implement() throws IOException {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)this.file);
            javaSource.runModificationTask((Task)this).commit();
            return null;
        }

        public void run(WorkingCopy workingCopy) throws Exception {
            workingCopy.toPhase(JavaSource.Phase.PARSED);
            CompilationUnitTree compilationUnitTree = workingCopy.getCompilationUnit();
            TreeMaker treeMaker = workingCopy.getTreeMaker();
            CompilationUnitTree compilationUnitTree2 = compilationUnitTree;
            for (TreePathHandle treePathHandle : this.tphList) {
                TreePath treePath = treePathHandle.resolve((CompilationInfo)workingCopy);
                if (treePath == null || !(treePath.getLeaf() instanceof ImportTree)) continue;
                compilationUnitTree2 = treeMaker.removeCompUnitImport(compilationUnitTree2, (ImportTree)treePath.getLeaf());
            }
            workingCopy.rewrite((Tree)compilationUnitTree, (Tree)compilationUnitTree2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ImportHintKind {
        DELEGATE,
        UNUSED,
        DUPLICATE,
        SAME_PACKAGE,
        DEFAULT_PACKAGE,
        FORBIDDEN,
        STAR;


        boolean defaultOn() {
            switch (this) {
                case DEFAULT_PACKAGE: 
                case SAME_PACKAGE: 
                case FORBIDDEN: 
                case DELEGATE: 
                case UNUSED: {
                    return true;
                }
            }
            return false;
        }
    }
}

