/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.introduce.CopyFinder;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrongStringComparison
extends AbstractHint {
    private static String STRING_TYPE = "java.lang.String";
    private static final List<Fix> NO_FIXES = Collections.emptyList();
    private static final Set<Tree.Kind> TREE_KINDS = EnumSet.of(Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO);
    private AtomicBoolean cancel = new AtomicBoolean();

    public WrongStringComparison() {
        super(true, true, AbstractHint.HintSeverity.WARNING, new String[0]);
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return TREE_KINDS;
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        TypeMirror typeMirror;
        this.cancel.set(false);
        Tree tree = treePath.getLeaf();
        if (tree.getKind() != Tree.Kind.EQUAL_TO && tree.getKind() != Tree.Kind.NOT_EQUAL_TO) {
            return null;
        }
        BinaryTree binaryTree = (BinaryTree)tree;
        TreePath treePath2 = new TreePath(treePath, binaryTree.getLeftOperand());
        TreePath treePath3 = new TreePath(treePath, binaryTree.getRightOperand());
        Trees trees = compilationInfo.getTrees();
        TypeMirror typeMirror2 = treePath2 == null ? null : trees.getTypeMirror(treePath2);
        TypeMirror typeMirror3 = typeMirror = treePath3 == null ? null : trees.getTypeMirror(treePath3);
        if (typeMirror2 != null && typeMirror != null && STRING_TYPE.equals(((Object)typeMirror2).toString()) && STRING_TYPE.equals(((Object)typeMirror).toString())) {
            if (this.checkInsideGeneratedEquals(compilationInfo, treePath, treePath2.getLeaf(), treePath3.getLeaf())) {
                return null;
            }
            return Collections.singletonList(ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)this.getDisplayName(), NO_FIXES, (FileObject)compilationInfo.getFileObject(), (int)((int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), tree)), (int)((int)compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), tree))));
        }
        return null;
    }

    @Override
    public void cancel() {
        this.cancel.set(true);
    }

    @Override
    public String getId() {
        return "Wrong_String_Comparison";
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(WrongStringComparison.class, (String)"LBL_WrongStringComparison");
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(WrongStringComparison.class, (String)"DSC_WrongStringComparison");
    }

    private boolean checkInsideGeneratedEquals(CompilationInfo compilationInfo, TreePath treePath, Tree tree, Tree tree2) {
        TreePath treePath2 = treePath.getParentPath();
        if (treePath2.getLeaf().getKind() != Tree.Kind.CONDITIONAL_AND) {
            return false;
        }
        SourcePositions sourcePositions = compilationInfo.getTrees().getSourcePositions();
        Scope scope = compilationInfo.getTrees().getScope(treePath2);
        String string = compilationInfo.getText().substring((int)sourcePositions.getStartPosition(compilationInfo.getCompilationUnit(), tree), (int)sourcePositions.getEndPosition(compilationInfo.getCompilationUnit(), tree) + 1);
        String string2 = compilationInfo.getText().substring((int)sourcePositions.getStartPosition(compilationInfo.getCompilationUnit(), tree2), (int)sourcePositions.getEndPosition(compilationInfo.getCompilationUnit(), tree2) + 1);
        String string3 = string + " != " + string2 + " && (" + string + "== null || !" + string + ".equals(" + string2 + "))";
        ExpressionTree expressionTree = compilationInfo.getTreeUtilities().parseExpression(string3, new SourcePositions[1]);
        compilationInfo.getTreeUtilities().attributeTree((Tree)expressionTree, scope);
        TreePath treePath3 = new TreePath(treePath2.getParentPath(), expressionTree);
        String string4 = compilationInfo.getText().substring((int)sourcePositions.getStartPosition(compilationInfo.getCompilationUnit(), treePath2.getLeaf()), (int)sourcePositions.getEndPosition(compilationInfo.getCompilationUnit(), treePath2.getLeaf()) + 1);
        ExpressionTree expressionTree2 = compilationInfo.getTreeUtilities().parseExpression(string4, new SourcePositions[1]);
        compilationInfo.getTreeUtilities().attributeTree((Tree)expressionTree2, scope);
        TreePath treePath4 = new TreePath(treePath2.getParentPath(), expressionTree2);
        return CopyFinder.isDuplicate(compilationInfo, treePath4, treePath3, this.cancel);
    }
}

