/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.infrastructure.ErrorHintsProvider;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CreateEnumConstant
implements Fix {
    private String name;
    private String inFQN;
    private ClasspathInfo cpInfo;
    private FileObject targetFile;
    private ElementHandle<TypeElement> target;
    private CompilationInfo info;
    private TypeMirrorHandle<TypeMirror> proposedType;

    public CreateEnumConstant(CompilationInfo compilationInfo, String string, Set<Modifier> set, TypeElement typeElement, TypeMirror typeMirror, FileObject fileObject) {
        this.name = string;
        this.inFQN = typeElement.getQualifiedName().toString();
        this.info = compilationInfo;
        this.cpInfo = compilationInfo.getClasspathInfo();
        this.targetFile = fileObject;
        this.target = ElementHandle.create((Element)typeElement);
        if (typeMirror.getKind() == TypeKind.NULL) {
            typeMirror = compilationInfo.getElements().getTypeElement("java.lang.Object").asType();
        }
        this.proposedType = TypeMirrorHandle.create((TypeMirror)typeMirror);
    }

    public String getText() {
        return NbBundle.getMessage(CreateEnumConstant.class, (String)"LBL_FIX_Create_Enum_Constant", (Object)this.name, (Object)this.inFQN);
    }

    public ChangeInfo implement() throws Exception {
        JavaSource javaSource = JavaSource.create((ClasspathInfo)this.cpInfo, (FileObject[])new FileObject[]{this.targetFile});
        ModificationResult modificationResult = javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                TypeElement typeElement = (TypeElement)CreateEnumConstant.this.target.resolve((CompilationInfo)workingCopy);
                if (typeElement == null) {
                    ErrorHintsProvider.LOG.log(Level.INFO, "Cannot resolve target.");
                    return;
                }
                ClassTree classTree = workingCopy.getTrees().getTree(typeElement);
                if (classTree == null) {
                    ErrorHintsProvider.LOG.log(Level.INFO, "Cannot resolve target tree: " + typeElement.getQualifiedName() + ".");
                    return;
                }
                TypeMirror typeMirror = CreateEnumConstant.this.proposedType.resolve((CompilationInfo)workingCopy);
                if (typeMirror == null) {
                    ErrorHintsProvider.LOG.log(Level.INFO, "Cannot resolve proposed type.");
                    return;
                }
                ClassTree classTree2 = CreateEnumConstant.this.info.getTrees().getTree((TypeElement)CreateEnumConstant.this.target.resolve(CreateEnumConstant.this.info));
                TreeMaker treeMaker = workingCopy.getTreeMaker();
                int n = 16384;
                ModifiersTree modifiersTree = treeMaker.Modifiers((long)n, Collections.emptyList());
                VariableTree variableTree = treeMaker.Variable(modifiersTree, (CharSequence)CreateEnumConstant.this.name, treeMaker.Type(typeMirror), null);
                ArrayList<? extends Tree> arrayList = new ArrayList<Tree>();
                arrayList.addAll(classTree2.getMembers());
                arrayList.add(variableTree);
                ClassTree classTree3 = treeMaker.Enum(classTree2.getModifiers(), (CharSequence)classTree2.getSimpleName(), classTree2.getImplementsClause(), arrayList);
                workingCopy.rewrite((Tree)classTree, (Tree)classTree3);
            }
        });
        return Utilities.commitAndComputeChangeInfo(this.targetFile, modificationResult, null);
    }

    String toDebugString(CompilationInfo compilationInfo) {
        return "CreateEnumConstant:" + this.name + ":" + this.target.getQualifiedName() + ":" + ((Object)this.proposedType.resolve(compilationInfo)).toString();
    }
}

