/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.infrastructure;

import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.netbeans.modules.java.hints.infrastructure.Pair;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.modules.java.hints.spi.Rule;
import org.netbeans.modules.java.hints.spi.TreeRule;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RulesManager
implements FileChangeListener {
    public static Logger LOG = Logger.getLogger("org.netbeans.modules.java.hints");
    private static final String INSTANCE_EXT = ".instance";
    private static final String NON_GUI = "nonGUI";
    private static final String RULES_FOLDER = "org-netbeans-modules-java-hints/rules/";
    private static final String ERRORS = "errors";
    private static final String HINTS = "hints";
    private static final String SUGGESTIONS = "suggestions";
    private final Map<String, List<ErrorRule>> errors = new HashMap<String, List<ErrorRule>>();
    private final Map<Tree.Kind, List<TreeRule>> hints = new HashMap<Tree.Kind, List<TreeRule>>();
    private final Map<Tree.Kind, List<TreeRule>> suggestions = new HashMap<Tree.Kind, List<TreeRule>>();
    private TreeModel errorsTreeModel;
    private TreeModel hintsTreeModel;
    private TreeModel suggestionsTreeModel;
    private static RulesManager INSTANCE;
    private final RequestProcessor.Task refreshHints = new RequestProcessor(RulesManager.class.getName()).create(new Runnable(){

        public void run() {
            RulesManager.this.doInit();
        }
    });

    private RulesManager() {
        this.doInit();
    }

    public static synchronized RulesManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RulesManager();
        }
        return INSTANCE;
    }

    public synchronized Map<String, List<ErrorRule>> getErrors() {
        return this.errors;
    }

    public synchronized Map<Tree.Kind, List<TreeRule>> getHints() {
        return this.hints;
    }

    public synchronized Map<Tree.Kind, List<TreeRule>> getHints(boolean bl) {
        HashMap<Tree.Kind, List<TreeRule>> hashMap = new HashMap<Tree.Kind, List<TreeRule>>();
        for (Map.Entry<Tree.Kind, List<TreeRule>> entry : this.getHints().entrySet()) {
            LinkedList<TreeRule> linkedList = new LinkedList<TreeRule>();
            for (TreeRule treeRule : entry.getValue()) {
                if (!(treeRule instanceof AbstractHint)) {
                    if (bl) continue;
                    linkedList.add(treeRule);
                    continue;
                }
                AbstractHint abstractHint = (AbstractHint)treeRule;
                Preferences preferences = abstractHint.getPreferences(null);
                if (preferences == null) {
                    if (bl) continue;
                    linkedList.add(treeRule);
                    continue;
                }
                if (abstractHint.getSeverity() == AbstractHint.HintSeverity.CURRENT_LINE_WARNING) {
                    if (!bl) continue;
                    linkedList.add(treeRule);
                    continue;
                }
                if (bl) continue;
                linkedList.add(treeRule);
            }
            if (linkedList.isEmpty()) continue;
            hashMap.put(entry.getKey(), linkedList);
        }
        return hashMap;
    }

    public synchronized Map<Tree.Kind, List<TreeRule>> getSuggestions() {
        return this.suggestions;
    }

    public synchronized TreeModel getErrorsTreeModel() {
        return this.errorsTreeModel;
    }

    public synchronized TreeModel getHintsTreeModel() {
        return this.hintsTreeModel;
    }

    public synchronized TreeModel getSuggestionsTreeModel() {
        return this.suggestionsTreeModel;
    }

    private synchronized void doInit() {
        this.initErrors();
        this.initHints();
        this.initSuggestions();
    }

    private void initErrors() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        this.errorsTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.getRoot().getFileObject("org-netbeans-modules-java-hints/rules/errors");
        List<Pair<Rule, FileObject>> list = this.readRules(fileObject);
        RulesManager.categorizeErrorRules(list, this.errors, fileObject, defaultMutableTreeNode);
    }

    private void initHints() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        this.hintsTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.getRoot().getFileObject("org-netbeans-modules-java-hints/rules/hints");
        List<Pair<Rule, FileObject>> list = this.readRules(fileObject);
        RulesManager.categorizeTreeRules(list, this.hints, fileObject, defaultMutableTreeNode);
    }

    private void initSuggestions() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        this.suggestionsTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.getRoot().getFileObject("org-netbeans-modules-java-hints/rules/suggestions");
        List<Pair<Rule, FileObject>> list = this.readRules(fileObject);
        RulesManager.categorizeTreeRules(list, this.suggestions, fileObject, defaultMutableTreeNode);
    }

    private List<Pair<Rule, FileObject>> readRules(FileObject fileObject) {
        LinkedList<Pair<Rule, FileObject>> linkedList = new LinkedList<Pair<Rule, FileObject>>();
        if (fileObject == null) {
            return linkedList;
        }
        LinkedList<FileObject> linkedList2 = new LinkedList<FileObject>();
        linkedList2.offer(fileObject);
        while (!linkedList2.isEmpty()) {
            FileObject fileObject2 = (FileObject)linkedList2.poll();
            fileObject2.removeFileChangeListener((FileChangeListener)this);
            fileObject2.addFileChangeListener((FileChangeListener)this);
            if (fileObject2.isFolder()) {
                linkedList2.addAll(Arrays.asList(fileObject2.getChildren()));
                continue;
            }
            if (!fileObject2.isData()) continue;
            String string = fileObject2.getNameExt().toLowerCase();
            if (!fileObject2.canRead()) continue;
            Rule rule = null;
            if (string.endsWith(INSTANCE_EXT)) {
                rule = RulesManager.instantiateRule(fileObject2);
            }
            if (rule == null) continue;
            linkedList.add(new Pair<Rule, FileObject>(rule, fileObject2));
        }
        return linkedList;
    }

    private static void categorizeErrorRules(List<Pair<Rule, FileObject>> list, Map<String, List<ErrorRule>> map, FileObject fileObject, DefaultMutableTreeNode defaultMutableTreeNode) {
        map.clear();
        HashMap<FileObject, DefaultMutableTreeNode> hashMap = new HashMap<FileObject, DefaultMutableTreeNode>();
        hashMap.put(fileObject, defaultMutableTreeNode);
        for (Pair<Rule, FileObject> pair : list) {
            Rule rule = pair.getA();
            FileObject fileObject2 = pair.getB();
            if (rule instanceof ErrorRule) {
                RulesManager.addRule((ErrorRule)rule, map);
                FileObject fileObject3 = fileObject2.getParent();
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)hashMap.get(fileObject3);
                if (defaultMutableTreeNode2 == null) {
                    defaultMutableTreeNode2 = new DefaultMutableTreeNode(fileObject3);
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                    hashMap.put(fileObject3, defaultMutableTreeNode2);
                }
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(rule, false));
                continue;
            }
            LOG.log(Level.WARNING, "The rule defined in " + fileObject2.getPath() + "is not instance of ErrorRule");
        }
    }

    private static void categorizeTreeRules(List<Pair<Rule, FileObject>> list, Map<Tree.Kind, List<TreeRule>> map, FileObject fileObject, DefaultMutableTreeNode defaultMutableTreeNode) {
        map.clear();
        HashMap<FileObject, DefaultMutableTreeNode> hashMap = new HashMap<FileObject, DefaultMutableTreeNode>();
        hashMap.put(fileObject, defaultMutableTreeNode);
        for (Pair<Rule, FileObject> pair : list) {
            Rule rule = pair.getA();
            FileObject fileObject2 = pair.getB();
            if (rule instanceof TreeRule) {
                Object object = fileObject2.getAttribute(NON_GUI);
                boolean bl = true;
                if (object != null && object instanceof Boolean && ((Boolean)object).booleanValue()) {
                    bl = false;
                }
                RulesManager.addRule((TreeRule)rule, map);
                FileObject fileObject3 = fileObject2.getParent();
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)hashMap.get(fileObject3);
                if (defaultMutableTreeNode2 == null) {
                    defaultMutableTreeNode2 = new DefaultMutableTreeNode(fileObject3);
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                    hashMap.put(fileObject3, defaultMutableTreeNode2);
                }
                if (!bl) continue;
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(rule, false));
                continue;
            }
            LOG.log(Level.WARNING, "The rule defined in " + fileObject2.getPath() + "is not instance of TreeRule");
        }
    }

    private static void addRule(TreeRule treeRule, Map<Tree.Kind, List<TreeRule>> map) {
        for (Tree.Kind kind : treeRule.getTreeKinds()) {
            List<TreeRule> list = map.get((Object)kind);
            if (list == null) {
                list = new LinkedList<TreeRule>();
                map.put(kind, list);
            }
            list.add(treeRule);
        }
    }

    private static void addRule(ErrorRule errorRule, Map<String, List<ErrorRule>> map) {
        for (String string : errorRule.getCodes()) {
            List<ErrorRule> list = map.get(string);
            if (list == null) {
                list = new LinkedList<ErrorRule>();
                map.put(string, list);
            }
            list.add(errorRule);
        }
    }

    private static Rule instantiateRule(FileObject fileObject) {
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
            Object object = instanceCookie.instanceCreate();
            if (object instanceof Rule) {
                return (Rule)object;
            }
            return null;
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, null, iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOG.log(Level.INFO, null, classNotFoundException);
        }
        return null;
    }

    public void fileFolderCreated(FileEvent fileEvent) {
        this.hintsChanged();
    }

    public void fileDataCreated(FileEvent fileEvent) {
        this.hintsChanged();
    }

    public void fileChanged(FileEvent fileEvent) {
        this.hintsChanged();
    }

    public void fileDeleted(FileEvent fileEvent) {
        this.hintsChanged();
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        this.hintsChanged();
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        this.hintsChanged();
    }

    private void hintsChanged() {
        this.refreshHints.cancel();
        this.refreshHints.schedule(50);
    }
}

