/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans;

import java.util.ArrayList;
import org.netbeans.api.project.Project;
import org.netbeans.modules.spring.beans.ProjectSpringScopeProvider;
import org.netbeans.modules.spring.beans.RecommendedTemplatesImpl;
import org.netbeans.modules.spring.beans.SpringConfigFileLocationProviderImpl;
import org.netbeans.spi.project.LookupProvider;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class ProjectLookupProvider
implements LookupProvider {
    private final Kind kind;

    public static ProjectLookupProvider standard() {
        return new ProjectLookupProvider(Kind.NON_WEB);
    }

    public static ProjectLookupProvider web() {
        return new ProjectLookupProvider(Kind.WEB);
    }

    public static ProjectLookupProvider simple() {
        return new ProjectLookupProvider(Kind.SIMPLE);
    }

    private ProjectLookupProvider(Kind kind) {
        this.kind = kind;
    }

    public Lookup createAdditionalLookup(Lookup lookup) {
        Project project = (Project)lookup.lookup(Project.class);
        if (project == null) {
            throw new IllegalStateException("Lookup " + lookup + " does not contain a Project");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(3);
        arrayList.add(new ProjectSpringScopeProvider(project));
        if (this.kind != Kind.SIMPLE) {
            arrayList.add(new RecommendedTemplatesImpl(this.kind == Kind.WEB));
            arrayList.add(new SpringConfigFileLocationProviderImpl(project));
        }
        return Lookups.fixed((Object[])arrayList.toArray(new Object[arrayList.size()]));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Kind {
        NON_WEB,
        WEB,
        SIMPLE;

    }
}

