/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.completion;

import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.spring.beans.completion.CompletionContext;
import org.netbeans.modules.spring.beans.completion.Completor;
import org.netbeans.modules.spring.beans.completion.CompletorRegistry;
import org.netbeans.modules.spring.beans.completion.SpringCompletionResult;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;

public class SpringXMLConfigCompletionProvider
implements CompletionProvider {
    public CompletionTask createTask(int n, JTextComponent jTextComponent) {
        if ((n & 1) == 1) {
            return new AsyncCompletionTask((AsyncCompletionQuery)new SpringXMLConfigCompletionQuery(n), jTextComponent);
        }
        return null;
    }

    public int getAutoQueryTypes(JTextComponent jTextComponent, String string) {
        return 0;
    }

    private static class SpringXMLConfigCompletionQuery
    extends AsyncCompletionQuery {
        private final int queryType;
        private JTextComponent component;
        private volatile Completor completor;

        public SpringXMLConfigCompletionQuery(int n) {
            this.queryType = n;
        }

        protected void preQueryUpdate(JTextComponent jTextComponent) {
            this.component = jTextComponent;
        }

        protected void prepareQuery(JTextComponent jTextComponent) {
            this.component = jTextComponent;
        }

        protected void query(CompletionResultSet completionResultSet, Document document, int n) {
            CompletionContext completionContext = new CompletionContext(document, n, this.queryType);
            if (completionContext.getCompletionType() == CompletionContext.CompletionType.NONE) {
                completionResultSet.finish();
                return;
            }
            this.completor = CompletorRegistry.getDefault().getCompletor(completionContext);
            if (this.completor != null) {
                SpringCompletionResult springCompletionResult = this.completor.complete(completionContext);
                this.populateResultSet(completionResultSet, springCompletionResult);
            }
            completionResultSet.finish();
        }

        protected boolean canFilter(JTextComponent jTextComponent) {
            if (this.completor == null) {
                return false;
            }
            boolean bl = this.completor.canFilter(new CompletionContext(jTextComponent.getDocument(), jTextComponent.getCaretPosition(), this.queryType));
            if (!bl) {
                this.completor.cancel();
            }
            return bl;
        }

        protected void filter(CompletionResultSet completionResultSet) {
            CompletionContext completionContext = new CompletionContext(this.component.getDocument(), this.component.getCaretPosition(), this.queryType);
            SpringCompletionResult springCompletionResult = this.completor.filter(completionContext);
            this.populateResultSet(completionResultSet, springCompletionResult);
            completionResultSet.finish();
        }

        private void populateResultSet(CompletionResultSet completionResultSet, SpringCompletionResult springCompletionResult) {
            if (springCompletionResult == SpringCompletionResult.NONE) {
                return;
            }
            completionResultSet.addAllItems(springCompletionResult.getItems());
            if (this.completor.getAnchorOffset() != -1) {
                completionResultSet.setAnchorOffset(this.completor.getAnchorOffset());
            }
            if (springCompletionResult.hasAdditionalItems()) {
                completionResultSet.setHasAdditionalItems(true);
                completionResultSet.setHasAdditionalItemsText(springCompletionResult.getAdditionalItemsText());
            }
        }
    }
}

