/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.java;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.swing.text.Document;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.spring.java.Public;
import org.netbeans.modules.spring.java.Static;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaUtils {
    private static final String GET_PREFIX = "get";
    private static final String SET_PREFIX = "set";
    private static final String IS_PREFIX = "is";

    private JavaUtils() {
    }

    public static Collection<ExecutableElement> getMethodsFromHandles(CompilationInfo compilationInfo, Collection<ElementHandle<ExecutableElement>> collection) {
        ArrayList<ExecutableElement> arrayList = new ArrayList<ExecutableElement>(collection.size());
        for (ElementHandle<ExecutableElement> elementHandle : collection) {
            ExecutableElement executableElement = (ExecutableElement)elementHandle.resolve(compilationInfo);
            if (executableElement == null) continue;
            arrayList.add(executableElement);
        }
        return arrayList;
    }

    public static boolean isGetter(ExecutableElement executableElement) {
        String string = executableElement.getSimpleName().toString();
        TypeMirror typeMirror = executableElement.getReturnType();
        if (executableElement.getModifiers().contains((Object)Modifier.PRIVATE) || executableElement.getModifiers().contains((Object)Modifier.STATIC)) {
            return false;
        }
        boolean bl = string.startsWith(GET_PREFIX) && string.length() > GET_PREFIX.length() && typeMirror.getKind() != TypeKind.VOID;
        bl = bl || string.startsWith(IS_PREFIX) && string.length() > IS_PREFIX.length() && typeMirror.getKind() == TypeKind.BOOLEAN;
        return bl;
    }

    public static boolean isSetter(ExecutableElement executableElement) {
        String string = executableElement.getSimpleName().toString();
        TypeMirror typeMirror = executableElement.getReturnType();
        if (executableElement.getModifiers().contains((Object)Modifier.PRIVATE) || executableElement.getModifiers().contains((Object)Modifier.STATIC)) {
            return false;
        }
        return string.startsWith(SET_PREFIX) && string.length() > SET_PREFIX.length() && typeMirror.getKind() == TypeKind.VOID && executableElement.getParameters().size() == 1;
    }

    public static String getPropertyName(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith(GET_PREFIX) || string.startsWith(SET_PREFIX)) {
            return JavaUtils.convertToPropertyName(string.substring(3));
        }
        if (string.startsWith(IS_PREFIX)) {
            return JavaUtils.convertToPropertyName(string.substring(2));
        }
        return null;
    }

    private static String convertToPropertyName(String string) {
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toLowerCase(cArray[0]);
        return String.valueOf(cArray);
    }

    public static Collection<ElementHandle<ExecutableElement>> getOverridenMethodsAsHandles(ExecutableElement executableElement, CompilationInfo compilationInfo) {
        Collection<ExecutableElement> collection = JavaUtils.getOverridenMethods(executableElement, compilationInfo);
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ElementHandle<ExecutableElement>> arrayList = new ArrayList<ElementHandle<ExecutableElement>>(collection.size());
        for (ExecutableElement executableElement2 : collection) {
            arrayList.add((ElementHandle<ExecutableElement>)ElementHandle.create((Element)executableElement2));
        }
        return arrayList;
    }

    public static Collection<ExecutableElement> getOverridenMethods(ExecutableElement executableElement, CompilationInfo compilationInfo) {
        return JavaUtils.getOverridenMethods(executableElement, SourceUtils.getEnclosingTypeElement((Element)executableElement), compilationInfo);
    }

    private static Collection<ExecutableElement> getOverridenMethods(ExecutableElement executableElement, TypeElement typeElement, CompilationInfo compilationInfo) {
        ArrayList<ExecutableElement> arrayList = new ArrayList<ExecutableElement>();
        TypeMirror typeMirror = typeElement.getSuperclass();
        if (typeMirror.getKind() == TypeKind.DECLARED) {
            TypeElement typeElement2 = (TypeElement)((DeclaredType)typeMirror).asElement();
            ExecutableElement annotatedConstruct = JavaUtils.getMethod(executableElement, typeElement2, compilationInfo);
            arrayList.addAll(JavaUtils.getOverridenMethods(executableElement, typeElement2, compilationInfo));
            if (annotatedConstruct != null) {
                arrayList.add(annotatedConstruct);
            }
        }
        for (TypeMirror typeMirror2 : typeElement.getInterfaces()) {
            TypeElement typeElement2 = (TypeElement)((DeclaredType)typeMirror2).asElement();
            ExecutableElement executableElement2 = JavaUtils.getMethod(executableElement, typeElement2, compilationInfo);
            arrayList.addAll(JavaUtils.getOverridenMethods(executableElement, typeElement2, compilationInfo));
            if (executableElement2 == null) continue;
            arrayList.add(executableElement2);
        }
        return arrayList;
    }

    private static ExecutableElement getMethod(ExecutableElement executableElement, TypeElement typeElement, CompilationInfo compilationInfo) {
        for (ExecutableElement executableElement2 : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
            if (!compilationInfo.getElements().overrides(executableElement, executableElement2, typeElement)) continue;
            return executableElement2;
        }
        return null;
    }

    public static ElementHandle<ExecutableElement> findMethod(FileObject fileObject, String string, String string2, int n, Public public_, Static static_) {
        JavaSource javaSource = JavaUtils.getJavaSource(fileObject);
        if (javaSource != null) {
            try {
                MethodFinder methodFinder = new MethodFinder(string, string2, n, public_, static_);
                javaSource.runUserActionTask((Task)methodFinder, false);
                return methodFinder.getMethodHandle();
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.SEVERE, iOException.getMessage(), iOException);
            }
        }
        return null;
    }

    public static JavaSource getJavaSource(FileObject fileObject) {
        if (fileObject == null) {
            return null;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return null;
        }
        int n = 0;
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        SourceGroup[] sourceGroupArray2 = sourceGroupArray;
        int n2 = sourceGroupArray2.length;
        if (n < n2) {
            SourceGroup sourceGroup = sourceGroupArray2[n];
            return JavaSource.create((ClasspathInfo)ClasspathInfo.create((FileObject)sourceGroup.getRootFolder()), (FileObject[])new FileObject[0]);
        }
        return null;
    }

    public static JavaSource getJavaSource(Document document) {
        return JavaUtils.getJavaSource(NbEditorUtilities.getFileObject((Document)document));
    }

    public static TypeElement findClassElementByBinaryName(String string, CompilationController compilationController) {
        PackageElement packageElement;
        if (!string.contains("$")) {
            return compilationController.getElements().getTypeElement(string);
        }
        String string2 = "";
        int n = string.lastIndexOf(".");
        if (n != -1) {
            string2 = string.substring(0, n);
        }
        if ((packageElement = compilationController.getElements().getPackageElement(string2)) == null) {
            return null;
        }
        return (TypeElement)new BinaryNameTypeScanner().visit(packageElement, string);
    }

    public static void openMethodInEditor(FileObject fileObject, String string, String string2, int n, Public public_, Static static_) {
        if (string == null || string2 == null || fileObject == null) {
            return;
        }
        final JavaSource javaSource = JavaUtils.getJavaSource(fileObject);
        if (javaSource == null) {
            return;
        }
        final ElementHandle<ExecutableElement> elementHandle = JavaUtils.findMethod(fileObject, string, string2, n, public_, static_);
        if (elementHandle != null) {
            try {
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        ExecutableElement executableElement = (ExecutableElement)elementHandle.resolve((CompilationInfo)compilationController);
                        ElementOpen.open((ClasspathInfo)javaSource.getClasspathInfo(), (Element)executableElement);
                    }
                }, false);
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.SEVERE, iOException.getMessage(), iOException);
            }
        }
    }

    public static void findAndOpenJavaClass(final String string, FileObject fileObject) {
        final JavaSource javaSource = JavaUtils.getJavaSource(fileObject);
        if (javaSource != null) {
            try {
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        boolean bl = false;
                        TypeElement typeElement = JavaUtils.findClassElementByBinaryName(string, compilationController);
                        if (typeElement != null) {
                            bl = ElementOpen.open((ClasspathInfo)javaSource.getClasspathInfo(), (Element)typeElement);
                        }
                        if (!bl) {
                            String string2 = NbBundle.getMessage(JavaUtils.class, (String)"LBL_SourceNotFound", (Object)string);
                            StatusDisplayer.getDefault().setStatusText(string2);
                        }
                    }
                }, false);
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.SEVERE, iOException.getMessage(), iOException);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BinaryNameTypeScanner
    extends SimpleElementVisitor6<TypeElement, String> {
        private BinaryNameTypeScanner() {
        }

        @Override
        public TypeElement visitPackage(PackageElement packageElement, String string) {
            for (Element element : packageElement.getEnclosedElements()) {
                TypeElement typeElement;
                if (!element.getKind().isClass() || (typeElement = element.accept(this, string)) == null) continue;
                return typeElement;
            }
            return null;
        }

        @Override
        public TypeElement visitType(TypeElement typeElement, String string) {
            String string2 = ElementUtilities.getBinaryName((TypeElement)typeElement);
            if (string.equals(string2)) {
                return typeElement;
            }
            if (string.startsWith(string2)) {
                for (Element element : typeElement.getEnclosedElements()) {
                    TypeElement typeElement2;
                    if (!element.getKind().isClass() || (typeElement2 = element.accept(this, string)) == null) continue;
                    return typeElement2;
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MethodFinder
    implements Task<CompilationController> {
        private String classBinName;
        private String methodName;
        private int argCount;
        private Public publicFlag;
        private Static staticFlag;
        private ElementHandle<ExecutableElement> methodHandle;

        public MethodFinder(String string, String string2, int n, Public public_, Static static_) {
            this.classBinName = string;
            this.methodName = string2;
            this.argCount = n;
            this.publicFlag = public_;
            this.staticFlag = static_;
        }

        public void run(CompilationController compilationController) throws Exception {
            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            TypeElement typeElement = JavaUtils.findClassElementByBinaryName(this.classBinName, compilationController);
            while (typeElement != null) {
                Object object;
                List<ExecutableElement> list = ElementFilter.methodsIn(typeElement.getEnclosedElements());
                for (ExecutableElement executableElement : list) {
                    int n;
                    object = executableElement.getSimpleName().toString();
                    if (!((String)object).equals(this.methodName) || this.argCount != -1 && (n = executableElement.getParameters().size()) != this.argCount || this.staticFlag != Static.DONT_CARE && ((n = (int)(executableElement.getModifiers().contains((Object)Modifier.STATIC) ? 1 : 0)) != 0 && this.staticFlag == Static.NO || n == 0 && this.staticFlag == Static.YES) || this.publicFlag != Public.DONT_CARE && ((n = (int)(executableElement.getModifiers().contains((Object)Modifier.PUBLIC) ? 1 : 0)) != 0 && this.publicFlag == Public.NO || n == 0 && this.publicFlag == Public.YES)) continue;
                    this.methodHandle = ElementHandle.create((Element)executableElement);
                    return;
                }
                TypeMirror typeMirror = typeElement.getSuperclass();
                if (typeMirror instanceof DeclaredType) {
                    DeclaredType declaredType = (DeclaredType)typeMirror;
                    object = declaredType.asElement();
                    if (object.getKind() != ElementKind.CLASS) continue;
                    typeElement = (TypeElement)object;
                    continue;
                }
                typeElement = null;
            }
        }

        public ElementHandle<ExecutableElement> getMethodHandle() {
            return this.methodHandle;
        }
    }
}

