/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.util;

import java.io.File;
import java.net.URI;
import java.util.regex.Pattern;
import org.openide.filesystems.FileUtil;

public class ConfigFiles {
    private static final Pattern RELATIVE_SLASH_SEPARATED_PATH = Pattern.compile("[^:/\\\\.][^:/\\\\]*(/[^:/\\\\.][^:/\\\\]*)*");

    private ConfigFiles() {
    }

    public static String getRelativePath(File file, File file2) {
        String string = ConfigFiles.relativizeFile(file, file2);
        if (string == null) {
            string = file2.getAbsolutePath();
        }
        return string;
    }

    public static File resolveFile(File file, String string) throws IllegalArgumentException {
        File file2;
        if (file == null) {
            throw new NullPointerException("null basedir passed to resolveFile");
        }
        if (string == null) {
            throw new NullPointerException("null filename passed to resolveFile");
        }
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException("nonabsolute basedir passed to resolveFile: " + file);
        }
        if (RELATIVE_SLASH_SEPARATED_PATH.matcher(string).matches()) {
            file2 = new File(file, string.replace('/', File.separatorChar));
        } else {
            String string2 = string.replace('/', File.separatorChar).replace('\\', File.separatorChar);
            file2 = new File(string2);
            if (!file2.isAbsolute()) {
                file2 = new File(file, string2);
            }
            assert (file2.isAbsolute());
        }
        return FileUtil.normalizeFile((File)file2);
    }

    private static String relativizeFile(File file, File file2) {
        if (file.isFile()) {
            throw new IllegalArgumentException("Cannot relative w.r.t. a data file " + file);
        }
        if (file.equals(file2)) {
            return ".";
        }
        StringBuffer stringBuffer = new StringBuffer();
        File file3 = file;
        String string = file2.getAbsolutePath();
        while (!string.startsWith(ConfigFiles.slashify(file3.getAbsolutePath()))) {
            if ((file3 = file3.getParentFile()) == null) {
                return null;
            }
            if (file3.equals(file2)) {
                stringBuffer.append("..");
                return stringBuffer.toString();
            }
            stringBuffer.append("../");
        }
        URI uRI = file3.toURI().relativize(file2.toURI());
        assert (!uRI.isAbsolute()) : uRI + " from " + file + " and " + file2 + " with common root " + file3;
        stringBuffer.append(uRI.getPath());
        if (stringBuffer.charAt(stringBuffer.length() - 1) == '/') {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    private static String slashify(String string) {
        if (string.endsWith(File.separator)) {
            return string;
        }
        return string + File.separatorChar;
    }
}

