/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.javaee.sunresources;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.modules.compapp.javaee.sunresources.ResourceAggregator;
import org.netbeans.modules.compapp.javaee.sunresources.tool.archive.ArchiveConstants;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SunResourcesUtil {
    public static final String RES_DIR_PROPNAME = "resource.dir";

    public static void addJavaEEResourceMetaData(final Project project, final AntArtifact antArtifact) {
        final AntProjectHelper antProjectHelper = (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class);
        if (antProjectHelper == null) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(SunResourcesUtil.class, (String)"EXC_no_anthelper"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws IOException {
                    EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                    try {
                        Project project2 = antArtifact.getProject();
                        String string = SunResourcesUtil.getResourceDirRelative(project2);
                        String string2 = ProjectUtils.getInformation((Project)project2).getName();
                        String string3 = "resource." + string2;
                        String string4 = "${project." + string2 + "}/" + string;
                        editableProperties.setProperty(string3, string4);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
                    ProjectManager.getDefault().saveProject(project);
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            ErrorManager.getDefault().notify((Throwable)((IOException)mutexException.getException()));
        }
    }

    public static void removeJavaEEResourceMetaData(final Project project, final String string) {
        final AntProjectHelper antProjectHelper = (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class);
        if (antProjectHelper == null) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(SunResourcesUtil.class, (String)"EXC_no_anthelper"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws IOException {
                    EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                    String string2 = "resource." + string;
                    editableProperties.remove((Object)string2);
                    antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
                    ProjectManager.getDefault().saveProject(project);
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            ErrorManager.getDefault().notify((Throwable)((IOException)mutexException.getException()));
        }
    }

    public static String scanForSunResources(Project project) throws Exception {
        ResourceAggregator resourceAggregator = new ResourceAggregator();
        List<Project> list = SunResourcesUtil.getSubProjects(project);
        list.add(project);
        for (int i = 0; i < list.size(); ++i) {
            Project project2 = list.get(i);
            FileObject fileObject = SunResourcesUtil.getResourceDir(project2);
            FileObject[] fileObjectArray = fileObject.getChildren();
            for (int j = 0; j < fileObjectArray.length; ++j) {
                FileObject fileObject2 = fileObjectArray[j];
                if (fileObject2.isFolder() || !fileObject2.getExt().equalsIgnoreCase("sun-resource")) continue;
                resourceAggregator.addResource(fileObject2);
            }
        }
        return resourceAggregator.toSunResourcesXML();
    }

    public static String scanForSunResources(String string) throws Exception {
        if (string == null || "".equals(string)) {
            Logger logger = Logger.getLogger(SunResourcesUtil.class.getName());
            logger.warning(NbBundle.getMessage(SunResourcesUtil.class, (String)"EXC_resource_config_missisng"));
            return "";
        }
        ResourceAggregator resourceAggregator = new ResourceAggregator();
        File file = new File(string);
        if (file.exists() && file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (!file2.isFile() || !file2.getName().toLowerCase().endsWith("sun-resource")) continue;
                resourceAggregator.addResource(file2);
            }
        }
        return resourceAggregator.toSunResourcesXML();
    }

    public static String getResourceDirRelative(Project project) throws Exception {
        String string;
        Object object;
        String string2 = "setup";
        AntProjectHelper antProjectHelper = (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class);
        if (antProjectHelper == null && (object = project.getClass().getDeclaredMethod("getAntProjectHelper", new Class[0])) != null) {
            antProjectHelper = (AntProjectHelper)((Method)object).invoke((Object)project, new Object[0]);
        }
        if (antProjectHelper != null && (string = (object = antProjectHelper.getProperties("nbproject/project.properties")).getProperty(RES_DIR_PROPNAME)) != null) {
            string2 = string;
        }
        return string2;
    }

    public static FileObject getResourceDir(Project project) throws Exception {
        Object object;
        String string = "setup";
        AntProjectHelper antProjectHelper = (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class);
        if (antProjectHelper == null && (object = project.getClass().getDeclaredMethod("getAntProjectHelper", new Class[0])) != null) {
            antProjectHelper = (AntProjectHelper)((Method)object).invoke((Object)project, new Object[0]);
        }
        if (antProjectHelper != null) {
            object = antProjectHelper.getProperties("nbproject/project.properties");
            PropertyEvaluator propertyEvaluator = antProjectHelper.getStandardPropertyEvaluator();
            String string2 = object.getProperty(RES_DIR_PROPNAME);
            if (string2 != null && (string2 = propertyEvaluator.evaluate(string2)) != null) {
                string = string2;
            }
        }
        if ((object = project.getProjectDirectory().getFileObject(string)) == null) {
            object = project.getProjectDirectory().createFolder(string);
        }
        return object;
    }

    public static List<Project> getSubProjects(Project project) {
        ArrayList<Project> arrayList = new ArrayList<Project>();
        SubprojectProvider subprojectProvider = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
        if (subprojectProvider != null) {
            arrayList.addAll(subprojectProvider.getSubprojects());
        }
        return arrayList;
    }

    public static ArchiveConstants.ArchiveType getJavaEEProjectType(Project project) {
        String string = project.getClass().getName();
        if (string.toLowerCase().indexOf("earproject") > -1) {
            return ArchiveConstants.ArchiveType.EAR;
        }
        if (string.toLowerCase().indexOf("ejbjarproject") > -1) {
            return ArchiveConstants.ArchiveType.EJB;
        }
        if (string.toLowerCase().indexOf("web.project") > -1) {
            return ArchiveConstants.ArchiveType.WAR;
        }
        return ArchiveConstants.ArchiveType.UNKNOWN;
    }

    public static FileObject getProjectDistJar(Project project, String string) throws Exception {
        AntProjectHelper antProjectHelper = null;
        Method method = project.getClass().getDeclaredMethod("getAntProjectHelper", new Class[0]);
        if (method != null) {
            antProjectHelper = (AntProjectHelper)method.invoke((Object)project, new Object[0]);
        }
        if (antProjectHelper == null) {
            throw new Exception(NbBundle.getMessage(SunResourcesUtil.class, (String)"EXC_no_anthelper2", (Object)project.toString()));
        }
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        PropertyEvaluator propertyEvaluator = antProjectHelper.getStandardPropertyEvaluator();
        String string2 = editableProperties.getProperty(string);
        if (string2 != null && (string2 = propertyEvaluator.evaluate(string2)) != null) {
            return project.getProjectDirectory().getFileObject(string2);
        }
        return null;
    }

    public static void openSourceFile(Project project, String string) {
        Set set;
        Object object;
        assert (project != null);
        FileObject fileObject = SunResourcesUtil.findSourceInProject(project, string);
        if (fileObject == null && (object = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class)) != null) {
            Project project2;
            set = object.getSubprojects();
            Iterator iterator = set.iterator();
            while (iterator.hasNext() && (fileObject = SunResourcesUtil.findSourceInProject(project2 = (Project)iterator.next(), string)) == null) {
            }
        }
        if (fileObject == null) {
            object = NbBundle.getMessage(SunResourcesUtil.class, (String)"EXC_srcfile_notfound", (Object)string);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message(object));
        } else {
            try {
                object = DataObject.find((FileObject)fileObject);
                set = (EditorCookie.Observable)object.getCookie(EditorCookie.Observable.class);
                set.open();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static FileObject findSourceInProject(Project project, String string) {
        Sources sources = ProjectUtils.getSources((Project)project);
        if (sources == null) {
            return null;
        }
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            SourceGroup sourceGroup = sourceGroupArray[i];
            FileObject fileObject = sourceGroup.getRootFolder();
            FileObject fileObject2 = fileObject.getFileObject(string);
            if (fileObject2 == null) continue;
            return fileObject2;
        }
        return null;
    }
}

