/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.javaee.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.netbeans.modules.compapp.javaee.codegen.model.Endpoint;
import org.netbeans.modules.compapp.javaee.codegen.model.EndpointCfg;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointCfgReaderWriter {
    private static final String JAVAEE_EP_FILE_PFX = "java-cfg-";
    private static final String JAVAEE_EP_FILE_SFX = ".xml";
    private static final String JAVAEE_PROJECTS = "javaee-projects";
    private static final String JAVAEE_PROJECT = "javaee-project";
    private static final String PROVIDES = "provides";
    private static final String CONSUMES = "consumes";
    private static final String EP_PREFIX = "javaee_";
    private static final String EP_NAME = "endpoint-name";
    private static final String INT_NAME = "interface-name";
    private static final String SVC_NAME = "service-name";
    private static final String ENABLE_FOR_NMR = "enable-for-nmr";
    private static final String ENABLE_FOR_JAVAEE_HTTP = "enable-for-javaee-http";
    private static final String JBI_DEFAULT_NS = "http://java.sun.com/xml/ns/jbi/javaee/config/1/";
    private static final String ELEM_SERVICES = "services";
    private static final String MAPPING_PREFIX = "javaee_";

    public static synchronized List<EndpointCfg> readConfigs(File file, String string) {
        List<EndpointCfg> list = null;
        if (file != null) {
            FileUtil.refreshFor((File[])new File[]{file});
            File file2 = new File(file, JAVAEE_EP_FILE_PFX + string + JAVAEE_EP_FILE_SFX);
            if (file2.exists() && file2.isFile() && file2.length() > 10L) {
                JbiXmlReader jbiXmlReader = new JbiXmlReader();
                try {
                    jbiXmlReader.read(file2);
                    list = jbiXmlReader.getEpCfgs();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    Exceptions.printStackTrace((Throwable)parserConfigurationException);
                }
                catch (SAXException sAXException) {
                    Exceptions.printStackTrace((Throwable)sAXException);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
        return list;
    }

    private static Map<String, String> getNamespacePrefixes(List<EndpointCfg> list) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = null;
        int n = 0;
        Iterator<EndpointCfg> iterator = list.iterator();
        Endpoint endpoint = null;
        QName qName = null;
        while (iterator.hasNext()) {
            endpoint = iterator.next();
            qName = endpoint.getInterfaceName();
            if (qName != null && (string = qName.getNamespaceURI()) != null && hashMap.get(string) == null) {
                hashMap.put(string, "ns" + n++);
            }
            if ((qName = endpoint.getServiceName()) == null || (string = qName.getNamespaceURI()) == null || hashMap.get(string) != null) continue;
            hashMap.put(string, "ns" + n++);
        }
        return hashMap;
    }

    private static void writeJavaEEProjConfigs(OutputStream outputStream, String string, List<EndpointCfg> list) throws IOException {
        try {
            Map<String, String> map = EndpointCfgReaderWriter.getNamespacePrefixes(list);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement(JAVAEE_PROJECT);
            element.setAttribute("xmlns", JBI_DEFAULT_NS);
            String string2 = null;
            Iterator<Map.Entry<String, String>> iterator = null;
            Map.Entry<String, String> entry2 = null;
            for (Map.Entry<String, String> entry2 : map.entrySet()) {
                string2 = "xmlns:" + entry2.getValue();
                element.setAttribute(string2, entry2.getKey());
            }
            element.setAttribute("name", string);
            document.appendChild(element);
            Iterator<EndpointCfg> iterator2 = null;
            EndpointCfg endpointCfg2 = null;
            String string3 = null;
            Element element2 = null;
            Element element3 = null;
            element2 = document.createElement(ELEM_SERVICES);
            element.appendChild(element2);
            for (EndpointCfg endpointCfg2 : list) {
                if (!endpointCfg2.getEndPointType().equals((Object)Endpoint.EndPointType.Provider)) continue;
                element3 = document.createElement(PROVIDES);
                element3.setAttribute(ENABLE_FOR_JAVAEE_HTTP, endpointCfg2.isActivateJavaEEHttpPort() ? "true" : "false");
                element3.setAttribute(EP_NAME, "javaee_" + endpointCfg2.getEndPointName());
                string3 = map.get(endpointCfg2.getInterfaceName().getNamespaceURI());
                element3.setAttribute(INT_NAME, string3 + ":" + endpointCfg2.getInterfaceName().getLocalPart());
                string3 = map.get(endpointCfg2.getServiceName().getNamespaceURI());
                element3.setAttribute(SVC_NAME, string3 + ":" + endpointCfg2.getServiceName().getLocalPart());
                element2.appendChild(element3);
            }
            for (EndpointCfg endpointCfg2 : list) {
                if (!endpointCfg2.getEndPointType().equals((Object)Endpoint.EndPointType.Consumer)) continue;
                element3 = document.createElement(CONSUMES);
                element3.setAttribute(ENABLE_FOR_NMR, endpointCfg2.isActivateForNMR() ? "true" : "false");
                element3.setAttribute(EP_NAME, "javaee_" + endpointCfg2.getEndPointName());
                string3 = map.get(endpointCfg2.getInterfaceName().getNamespaceURI());
                element3.setAttribute(INT_NAME, string3 + ":" + endpointCfg2.getInterfaceName().getLocalPart());
                string3 = map.get(endpointCfg2.getServiceName().getNamespaceURI());
                element3.setAttribute(SVC_NAME, string3 + ":" + endpointCfg2.getServiceName().getLocalPart());
                element2.appendChild(element3);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(outputStream);
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("media-type", "text/xml");
            transformer.setOutputProperty("standalone", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(dOMSource, streamResult);
            outputStream.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException("Exception while writing jbi.xml:" + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void writeConfigs(File file, String string, List<EndpointCfg> list) {
        if (file != null) {
            FileUtil.refreshFor((File[])new File[]{file});
            File file2 = new File(file, JAVAEE_EP_FILE_PFX + string + JAVAEE_EP_FILE_SFX);
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file2);
                EndpointCfgReaderWriter.writeJavaEEProjConfigs(fileOutputStream, string, list);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Exceptions.printStackTrace((Throwable)fileNotFoundException);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JbiXmlReader
    extends DefaultHandler {
        private List<EndpointCfg> eps = new ArrayList<EndpointCfg>();
        private Map<String, String> prefix2URI = new HashMap<String, String>();
        private EndpointCfg ep = null;

        JbiXmlReader() {
        }

        private String getEPName(String string) {
            if (string != null && string.startsWith("javaee_")) {
                return string.substring(7);
            }
            return string;
        }

        private void readNamespaces(Attributes attributes) {
            int n = attributes.getLength();
            String string = null;
            String string2 = null;
            for (int i = 0; i < n; ++i) {
                string = attributes.getQName(i);
                if (string == null || !string.startsWith("xmlns:")) continue;
                string2 = attributes.getValue(i);
                this.prefix2URI.put(string.substring(6), string2);
            }
        }

        private String getURI(String string) {
            int n;
            if (string != null && (n = string.indexOf(":")) > 0) {
                return this.prefix2URI.get(string.substring(0, n));
            }
            return null;
        }

        private String getLocalName(String string) {
            int n;
            if (string != null && (n = string.indexOf(":")) > 0) {
                return string.substring(n + 1);
            }
            return string;
        }

        private EndpointCfg getEndpoint(Attributes attributes, Endpoint.EndPointType endPointType) {
            EndpointCfg endpointCfg = new EndpointCfg();
            endpointCfg.setEndPointType(endPointType);
            String string = null;
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                if (EndpointCfgReaderWriter.EP_NAME.equals(attributes.getQName(i))) {
                    endpointCfg.setEndPointName(this.getEPName(attributes.getValue(i)));
                }
                if (EndpointCfgReaderWriter.INT_NAME.equals(attributes.getQName(i))) {
                    string = attributes.getValue(i);
                    endpointCfg.setInterfaceName(new QName(this.getURI(string), this.getLocalName(string)));
                }
                if (EndpointCfgReaderWriter.SVC_NAME.equals(attributes.getQName(i))) {
                    string = attributes.getValue(i);
                    endpointCfg.setServiceName(new QName(this.getURI(string), this.getLocalName(string)));
                }
                if (EndpointCfgReaderWriter.ENABLE_FOR_NMR.equals(attributes.getQName(i)) && (string = attributes.getValue(i)) != null && (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("no"))) {
                    endpointCfg.setActivateForNMR(false);
                }
                if (!EndpointCfgReaderWriter.ENABLE_FOR_JAVAEE_HTTP.equals(attributes.getQName(i)) || (string = attributes.getValue(i)) == null || !string.equalsIgnoreCase("false") && !string.equalsIgnoreCase("no")) continue;
                endpointCfg.setActivateJavaEEHttpPort(false);
            }
            return endpointCfg;
        }

        @Override
        public void endDocument() throws SAXException {
            super.endDocument();
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            super.endElement(string, string2, string3);
            if ((EndpointCfgReaderWriter.PROVIDES.equals(string3) || EndpointCfgReaderWriter.CONSUMES.equals(string3)) && this.ep != null) {
                this.eps.add(this.ep);
                this.ep = null;
            }
        }

        @Override
        public void startDocument() throws SAXException {
            super.startDocument();
            this.prefix2URI.clear();
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            super.startElement(string, string2, string3, attributes);
            if (EndpointCfgReaderWriter.PROVIDES.equals(string3)) {
                this.ep = this.getEndpoint(attributes, Endpoint.EndPointType.Provider);
            } else if (EndpointCfgReaderWriter.CONSUMES.equals(string3)) {
                this.ep = this.getEndpoint(attributes, Endpoint.EndPointType.Consumer);
            } else if (EndpointCfgReaderWriter.JAVAEE_PROJECT.equals(string3)) {
                this.readNamespaces(attributes);
            } else {
                this.ep = null;
            }
        }

        public void read(File file) throws ParserConfigurationException, SAXException, IOException {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(false);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(file, (DefaultHandler)this);
        }

        public void read(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(false);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(inputStream, (DefaultHandler)this);
        }

        public List<EndpointCfg> getEpCfgs() {
            return this.eps;
        }
    }
}

