/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.jbi;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.compapp.projects.jbi.JbiActionProvider;
import org.netbeans.modules.compapp.projects.jbi.JbiProject;
import org.netbeans.modules.compapp.projects.jbi.api.JbiProjectHelper;
import org.netbeans.modules.compapp.projects.jbi.ui.customizer.JbiProjectProperties;
import org.netbeans.modules.compapp.projects.jbi.util.MyFileUtil;
import org.netbeans.spi.project.CopyOperationImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.MoveOperationImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class JbiProjectOperations
implements DeleteOperationImplementation,
CopyOperationImplementation,
MoveOperationImplementation {
    private JbiProject project;

    public JbiProjectOperations(JbiProject jbiProject) {
        this.project = jbiProject;
    }

    private static void addFile(FileObject fileObject, String string, List list) {
        FileObject fileObject2 = fileObject.getFileObject(string);
        if (fileObject2 != null) {
            list.add(fileObject2);
        }
    }

    public List getMetadataFiles() {
        FileObject fileObject = this.project.getProjectDirectory();
        ArrayList arrayList = new ArrayList();
        JbiProjectOperations.addFile(fileObject, "nbproject", arrayList);
        JbiProjectOperations.addFile(fileObject, "build.xml", arrayList);
        JbiProjectOperations.addFile(fileObject, "catalog.xml", arrayList);
        return arrayList;
    }

    public List getDataFiles() {
        FileObject fileObject;
        PropertyEvaluator propertyEvaluator;
        String string;
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        FileObject fileObject2 = this.project.getSourceDirectory();
        if (fileObject2 != null) {
            arrayList.add(fileObject2);
        }
        if ((string = (propertyEvaluator = this.project.evaluator()).getProperty("source.root")) != null) {
            fileObject = this.project.getProjectDirectory();
            FileObject fileObject3 = this.project.getAntProjectHelper().resolveFileObject(string);
            if (fileObject3 != null && fileObject != fileObject3 && !arrayList.contains(fileObject3)) {
                arrayList.add(fileObject3);
            }
        }
        if ((fileObject = this.project.getTestDirectory()) != null) {
            arrayList.add(fileObject);
        }
        return arrayList;
    }

    public void notifyDeleting() throws IOException {
        JbiActionProvider jbiActionProvider = (JbiActionProvider)this.project.getLookup().lookup(JbiActionProvider.class);
        assert (jbiActionProvider != null);
        Properties properties = new Properties();
        String[] stringArray = new String[]{"do-clean"};
        FileObject fileObject = this.project.getProjectDirectory();
        FileObject fileObject2 = fileObject.getFileObject("build.xml");
        assert (stringArray != null);
        assert (stringArray.length > 0);
        ActionUtils.runTarget((FileObject)fileObject2, (String[])stringArray, (Properties)properties).waitFinished();
    }

    public void notifyDeleted() throws IOException {
        this.project.getAntProjectHelper().notifyDeleted();
    }

    public void notifyCopying() {
    }

    public void notifyCopied(Project project, File file, String string) {
        if (project == null) {
            return;
        }
        this.project.getReferenceHelper().fixReferences(file);
        String string2 = this.project.getName();
        this.project.setName(string);
        this.fixOtherNameReferences(file, string2, string);
    }

    public void notifyMoving() throws IOException {
        this.notifyDeleting();
    }

    public void notifyMoved(Project project, File file, String string) {
        if (project == null) {
            this.project.getAntProjectHelper().notifyDeleted();
            return;
        }
        String string2 = this.project.getName();
        this.project.setName(string);
        this.project.getReferenceHelper().fixReferences(file);
        this.fixOtherNameReferences(file, string2, string);
    }

    private void fixOtherNameReferences(final File file, final String string, final String string2) {
        assert (string != null && string2 != null);
        if (string.equals(string2)) {
            return;
        }
        final File file2 = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                FileObject fileObject;
                FileObject fileObject2;
                String string5;
                String string22;
                String string3;
                AntProjectHelper antProjectHelper = JbiProjectOperations.this.project.getAntProjectHelper();
                EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                String string4 = editableProperties.getProperty("meta.inf");
                if (string4 != null && string4.startsWith(file.getAbsolutePath())) {
                    string3 = PropertyUtils.relativizeFile((File)file, (File)new File(string4));
                    string22 = new File(file2, string3).getAbsolutePath();
                    editableProperties.setProperty("meta.inf", string22);
                }
                if ((string3 = (String)editableProperties.get((Object)"dist.jar")).endsWith("/" + string + ".zip")) {
                    int n = string3.length() - string.length() - 4;
                    string5 = string3.substring(0, n);
                    editableProperties.put("dist.jar", string5 + string2 + ".zip");
                }
                JbiProjectHelper.setJbiProjectName(editableProperties, string2);
                JbiProjectHelper.updateServiceAssemblyDescription(editableProperties, string, string2);
                antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
                string22 = JbiProjectOperations.this.project.getProjectDirectory().getFileObject("src/conf");
                string5 = string22.getFileObject(string + ".casa");
                if (string5 != null) {
                    try {
                        MyFileUtil.replaceAll((FileObject)string5, "../jbiasa/" + string + ".wsdl#xpointer(", "../jbiasa/" + string2 + ".wsdl#xpointer(", false);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if ((fileObject2 = (fileObject = JbiProjectOperations.this.project.getSourceDirectory()).getFileObject(string + ".wsdl")) != null) {
                    try {
                        MyFileUtil.replaceAll(fileObject2, "\"http://enterprise.netbeans.org/casa/" + string + "\"", "\"http://enterprise.netbeans.org/casa/" + string2 + "\"", false);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    try {
                        FileUtil.moveFile((FileObject)fileObject2, (FileObject)fileObject, (String)string2);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                if (string5 != null) {
                    try {
                        FileUtil.moveFile((FileObject)string5, (FileObject)string22, (String)string2);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                JbiProjectProperties jbiProjectProperties = JbiProjectOperations.this.project.getProjectProperties();
                jbiProjectProperties.saveAssemblyInfo();
            }
        });
    }
}

