/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.jbi.api;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public abstract class InternalProjectTypePluginWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor wiz;
    private transient List<WizardDescriptor.Panel> mAddedPanels;
    private transient List<String> mAddedSteps;
    private transient FileObject mProjectFileObject;

    protected abstract void createProject(File var1, String var2, String var3) throws IOException;

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.wiz.putProperty("projdir", null);
        this.wiz.putProperty("name", null);
        this.wiz = null;
        this.panels = null;
    }

    public final String name() {
        return MessageFormat.format(NbBundle.getMessage(this.getClass(), (String)"LBL_WizardStepsCount"), new Integer(this.index + 1).toString(), new Integer(this.panels.length).toString());
    }

    public final boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public final boolean hasPrevious() {
        return this.index > 0;
    }

    public final void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public final void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public final WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final Set instantiate() throws IOException {
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        File file = (File)this.wiz.getProperty("projdir");
        String string = (String)this.wiz.getProperty("name");
        String string2 = (String)this.wiz.getProperty("j2eeLevel");
        this.createProject(file, string, string2);
        this.mProjectFileObject = FileUtil.toFileObject((File)file.getAbsoluteFile());
        hashSet.add(this.mProjectFileObject);
        return hashSet;
    }

    public final Project getProject() throws IOException {
        if (this.mProjectFileObject != null) {
            return ProjectManager.getDefault().findProject(this.mProjectFileObject);
        }
        return null;
    }

    public final boolean hasContent() {
        return this.mAddedPanels != null && this.mAddedSteps != null;
    }

    public final void initialize(WizardDescriptor wizardDescriptor) {
        this.wiz = wizardDescriptor;
        this.index = 0;
        this.panels = this.createPanels();
        String[] stringArray = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component component = this.panels[i].getComponent();
            if (stringArray[i] == null) {
                stringArray[i] = component.getName();
            }
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jComponent.putClientProperty("WizardPanel_contentData", stringArray);
        }
    }

    public final void addChangeListener(ChangeListener changeListener) {
    }

    public final void removeChangeListener(ChangeListener changeListener) {
    }

    protected final void addPanel(WizardDescriptor.Panel panel) {
        if (this.mAddedPanels == null) {
            this.mAddedPanels = new ArrayList<WizardDescriptor.Panel>();
        }
        this.mAddedPanels.add(panel);
    }

    protected final void addStep(String string) {
        if (this.mAddedSteps == null) {
            this.mAddedSteps = new ArrayList<String>();
        }
        this.mAddedSteps.add(string);
    }

    private WizardDescriptor.Panel[] createPanels() {
        if (this.mAddedPanels != null) {
            return this.mAddedPanels.toArray(new WizardDescriptor.Panel[this.mAddedPanels.size()]);
        }
        return new WizardDescriptor.Panel[0];
    }

    private String[] createSteps() {
        if (this.mAddedSteps != null) {
            return this.mAddedSteps.toArray(new String[this.mAddedSteps.size()]);
        }
        return new String[0];
    }
}

