/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.jbi.api;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.netbeans.modules.compapp.projects.jbi.api.JbiChoiceExtensionElement;
import org.netbeans.modules.compapp.projects.jbi.api.JbiExtensionAttribute;
import org.netbeans.modules.compapp.projects.jbi.api.JbiExtensionElement;
import org.netbeans.modules.compapp.projects.jbi.api.JbiExtensionInfo;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JbiInstalledExtensionInfo {
    public static final String EXT_FILE = "xsdFileName";
    public static final String EXT_TYPE = "extensionType";
    public static final String EXT_TARGET = "extensionTarget";
    public static final String EXT_PREFIX = "prefix";
    public static final String EXT_PROVIDER = "extensionClassProvider";
    public static final String EXT_NAMESPACE = "namespace";
    public static final String EXT_ICON = "SystemFileSystem.icon";
    public static final String ITEM_TYPE = "type";
    public static final String ITEM_CODEGEN = "codegen";
    public static final String ITEM_DESC = "description";
    public static final String JBI_EXTENSIONS = "JbiExtensions";
    private static final String CHOICE = "choice";
    private static final String DEFAULT_CHOICE = "default-choice";
    private static JbiInstalledExtensionInfo singleton = null;
    private List<JbiExtensionInfo> extensionList = new ArrayList<JbiExtensionInfo>();
    private Map<String, JbiExtensionInfo> extensionMap = new HashMap<String, JbiExtensionInfo>();
    private static final String ATTR_BUNDLE = "SystemFileSystem.localizingBundle";

    private JbiInstalledExtensionInfo() {
    }

    public static JbiInstalledExtensionInfo getInstalledExtensionInfo() {
        if (singleton == null) {
            FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
            return JbiInstalledExtensionInfo.getInstalledExtensionInfo(fileSystem);
        }
        return singleton;
    }

    static JbiInstalledExtensionInfo getInstalledExtensionInfo(FileSystem fileSystem) {
        if (singleton == null) {
            try {
                singleton = new JbiInstalledExtensionInfo();
                FileObject fileObject = fileSystem.findResource(JBI_EXTENSIONS);
                JbiInstalledExtensionInfo.loadJbiDefaultExtensionInfoFromFileObject(fileObject);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return singleton;
    }

    static void loadJbiDefaultExtensionInfoFromFileObject(FileObject fileObject) {
        if (fileObject != null) {
            DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
            for (DataObject dataObject : dataFolder.getChildren()) {
                Object object;
                if (!(dataObject instanceof DataFolder)) continue;
                String string = dataObject.getName();
                String string2 = dataObject.getNodeDelegate().getDisplayName();
                String string3 = JbiInstalledExtensionInfo.getLocalizedFileObjectAttribute(dataObject.getPrimaryFile(), ITEM_DESC);
                String string4 = "";
                String string5 = "";
                String string6 = "";
                String string7 = "";
                String string8 = "";
                URL uRL = null;
                FileObject fileObject2 = dataObject.getPrimaryFile();
                List[] listArray = fileObject2.getAttributes();
                while (listArray.hasMoreElements()) {
                    object = (String)listArray.nextElement();
                    Object object2 = fileObject2.getAttribute((String)object);
                    if (((String)object).equals(EXT_FILE)) {
                        string4 = (String)object2;
                        continue;
                    }
                    if (((String)object).equals(EXT_TYPE)) {
                        string5 = (String)object2;
                        continue;
                    }
                    if (((String)object).equals(EXT_TARGET)) {
                        string6 = (String)object2;
                        continue;
                    }
                    if (((String)object).equals(EXT_NAMESPACE)) {
                        string7 = (String)object2;
                        continue;
                    }
                    if (((String)object).equals(EXT_ICON)) {
                        uRL = (URL)object2;
                        continue;
                    }
                    if (!((String)object).equals(EXT_PROVIDER)) continue;
                    string8 = (String)object2;
                }
                listArray = JbiInstalledExtensionInfo.processElement((DataFolder)dataObject);
                object = new JbiExtensionInfo(string, string2, string5, string6, string4, string7, string3, uRL, string8, listArray[0]);
                JbiInstalledExtensionInfo.singleton.extensionList.add((JbiExtensionInfo)object);
                JbiInstalledExtensionInfo.singleton.extensionMap.put(string, (JbiExtensionInfo)object);
            }
        }
    }

    private static List[] processElement(DataFolder dataFolder) {
        List[] listArray = new ArrayList[2];
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<List[]> arrayList2 = new ArrayList<List[]>();
        for (DataObject dataObject : dataFolder.getChildren()) {
            Object object;
            Object object2;
            String string;
            FileObject fileObject = dataObject.getPrimaryFile();
            String string2 = dataObject.getName();
            String string3 = dataObject.getNodeDelegate().getDisplayName();
            String string4 = JbiInstalledExtensionInfo.getLocalizedFileObjectAttribute(fileObject, ITEM_DESC);
            if (fileObject.isFolder()) {
                string = (String)fileObject.getAttribute(CHOICE);
                object2 = JbiInstalledExtensionInfo.processElement((DataFolder)dataObject);
                List list = object2[0];
                List list2 = object2[1];
                if (string != null && string.equalsIgnoreCase("true")) {
                    String string5 = (String)fileObject.getAttribute(DEFAULT_CHOICE);
                    object = new JbiChoiceExtensionElement(string2, string3, list, list2, string4, string5);
                } else {
                    object = new JbiExtensionElement(string2, string3, list, list2, string4);
                }
                arrayList.add(object);
                continue;
            }
            object = (String)fileObject.getAttribute(ITEM_TYPE);
            string = (String)fileObject.getAttribute(ITEM_CODEGEN);
            object2 = new JbiExtensionAttribute(string2, string3, (String)object, string4, !"false".equalsIgnoreCase(string));
            arrayList2.add((List[])object2);
        }
        listArray[0] = arrayList;
        listArray[1] = arrayList2;
        return listArray;
    }

    public List<JbiExtensionInfo> getJbiExtensionList() {
        return this.extensionList;
    }

    public JbiExtensionInfo getExtensionInfo(String string) {
        return this.extensionMap.get(string);
    }

    private static String getLocalizedFileObjectAttribute(FileObject fileObject, String string) {
        String string2 = null;
        String string3 = (String)fileObject.getAttribute(ATTR_BUNDLE);
        if (string3 != null) {
            string3 = Utilities.translate((String)string3);
            ResourceBundle resourceBundle = NbBundle.getBundle((String)string3);
            String string4 = fileObject.getPath() + "@" + string;
            try {
                string2 = resourceBundle.getString(string4);
            }
            catch (MissingResourceException missingResourceException) {
                System.err.println("WARNING: Missing resource for " + string4);
            }
        }
        if (string2 == null && (string2 = (String)fileObject.getAttribute(string)) == null) {
            string2 = "";
        }
        return string2;
    }
}

