/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.jbi.descriptor;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(String string, Document document) throws TransformerConfigurationException, TransformerException, FileNotFoundException, UnsupportedEncodingException, IOException {
        File file = new File(string);
        FileObject fileObject = FileUtil.toFileObject((File)file);
        PrintWriter printWriter = new PrintWriter(file, "UTF-8");
        StreamResult streamResult = new StreamResult(printWriter);
        try {
            XmlUtil.writeTo(streamResult, document);
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
        if (fileObject != null) {
            fileObject.getFileSystem().refresh(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToOutputStream(OutputStream outputStream, Document document) throws TransformerConfigurationException, TransformerException, FileNotFoundException, UnsupportedEncodingException, IOException {
        StreamResult streamResult = new StreamResult(outputStream);
        try {
            XmlUtil.writeTo(streamResult, document);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFileObject(FileObject fileObject, Document document) throws TransformerConfigurationException, TransformerException, FileNotFoundException, UnsupportedEncodingException, IOException {
        FileLock fileLock = fileObject.lock();
        OutputStream outputStream = fileObject.getOutputStream(fileLock);
        try {
            XmlUtil.writeToOutputStream(outputStream, document);
        }
        finally {
            fileLock.releaseLock();
        }
    }

    private static void writeTo(Result result, Document document) throws TransformerConfigurationException, TransformerException, FileNotFoundException, UnsupportedEncodingException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource dOMSource = new DOMSource(document);
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("media-type", "text/xml");
        transformer.setOutputProperty("standalone", "yes");
        try {
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("indent", "yes");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        transformer.transform(dOMSource, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] writeToBytes(Document document) throws TransformerConfigurationException, TransformerException, Exception {
        byte[] byArray = null;
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource dOMSource = new DOMSource(document);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(byteArrayOutputStream);
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("media-type", "text/xml");
        transformer.setOutputProperty("standalone", "yes");
        try {
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("indent", "yes");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            transformer.transform(dOMSource, streamResult);
            byArray = byteArrayOutputStream.toByteArray();
        }
        finally {
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.flush();
                byteArrayOutputStream.close();
            }
        }
        return byArray;
    }

    private static Document createDocument(boolean bl, InputSource inputSource) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(inputSource);
        document.normalize();
        return document;
    }

    public static Document createDocument(boolean bl, File file) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        document.normalize();
        return document;
    }

    public static Document createDocumentFromXML(boolean bl, String string) throws Exception {
        return XmlUtil.createDocument(bl, new InputSource(new StringReader(string)));
    }

    public static Map<String, String> getNamespaceMap(Document document) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        NamedNodeMap namedNodeMap = document.getDocumentElement().getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            String string = ((Attr)node).getName();
            String string2 = ((Attr)node).getValue();
            if (string == null || string2 == null || !string.trim().startsWith("xmlns:")) continue;
            hashMap.put(string2, string.substring(6));
        }
        return hashMap;
    }

    public static QName getAttributeNSName(Element element, String string) {
        String string2 = element.getAttribute(string);
        return XmlUtil.getNSName(element, string2);
    }

    private static QName getNSName(Element element, String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(58);
        if (n > 0) {
            String string2 = string.substring(n + 1);
            String string3 = string.substring(0, n);
            return new QName(XmlUtil.getNamespaceURI(element, string3), string2);
        }
        return new QName(string);
    }

    public static String getNamespaceURI(Element element, String string) {
        if (string == null || string.length() < 1) {
            return "";
        }
        string = string.trim();
        try {
            NamedNodeMap namedNodeMap = element.getOwnerDocument().getDocumentElement().getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node = namedNodeMap.item(i);
                String string2 = ((Attr)node).getName();
                if (string2 == null || !string2.trim().equals("xmlns:" + string)) continue;
                return ((Attr)node).getValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }
}

