/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.jbi.ui;

import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.compapp.projects.jbi.JbiProject;
import org.netbeans.modules.compapp.projects.jbi.ui.ServiceCompositionNode;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.actions.FileSystemAction;
import org.openide.actions.FindAction;
import org.openide.actions.PasteAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

class JbiViews {
    private static final DataFilter VISIBILITY_QUERY_FILTER = new VisibilityQueryDataFilter();

    private JbiViews() {
    }

    static final class VisibilityQueryDataFilter
    implements ChangeListener,
    ChangeableDataFilter {
        EventListenerList ell = new EventListenerList();

        public VisibilityQueryDataFilter() {
            VisibilityQuery.getDefault().addChangeListener((ChangeListener)this);
        }

        public boolean acceptDataObject(DataObject dataObject) {
            FileObject fileObject = dataObject.getPrimaryFile();
            return VisibilityQuery.getDefault().isVisible(fileObject);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object[] objectArray = this.ell.getListenerList();
            ChangeEvent changeEvent2 = null;
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != ChangeListener.class) continue;
                if (changeEvent2 == null) {
                    changeEvent2 = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent2);
            }
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.ell.add(ChangeListener.class, changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.ell.remove(ChangeListener.class, changeListener);
        }
    }

    private static final class RootNode
    extends FilterNode {
        public RootNode(DataFolder dataFolder) {
            super(dataFolder.getNodeDelegate(), dataFolder.createNodeChildren(VISIBILITY_QUERY_FILTER));
            this.disableDelegation(172);
            this.setDisplayName(NbBundle.getMessage(RootNode.class, (String)"LBL_ProcessFiles"));
        }

        public Action[] getActions(boolean bl) {
            return new Action[]{CommonProjectActions.newFileAction(), null, SystemAction.get(FileSystemAction.class), null, SystemAction.get(FindAction.class), null, SystemAction.get(PasteAction.class), null, SystemAction.get(ToolsAction.class)};
        }

        public boolean canRename() {
            return false;
        }

        public boolean canCopy() {
            return false;
        }

        public boolean canCut() {
            return false;
        }

        public boolean canDestroy() {
            return false;
        }
    }

    private static class DocBaseChildren
    extends FilterNode.Children {
        DocBaseChildren(Node node) {
            super(node);
        }

        protected Node[] createNodes(Node node) {
            String string;
            if (node instanceof FilterNode && (string = ((FilterNode)node).getDisplayName()) != null && string.equalsIgnoreCase("CVS")) {
                return new Node[0];
            }
            return super.createNodes(node);
        }
    }

    static final class LogicalViewChildren
    extends Children.Keys
    implements FileChangeListener {
        private static final String KEY_SVC_COMP_NODE = "SvcCompNode";
        private static final String KEY_SOURCE_DIR = "srcDir";
        private static final String KEY_DOC_BASE = "docBase";
        private static final String KEY_JBIS = "jbiKey";
        private static final String KEY_SETUP_DIR = "setupDir";
        private AntProjectHelper helper;
        private final PropertyEvaluator evaluator;
        private FileObject projectDir;
        private Project project;

        public LogicalViewChildren(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, Project project) {
            assert (antProjectHelper != null);
            this.helper = antProjectHelper;
            this.projectDir = antProjectHelper.getProjectDirectory();
            this.evaluator = propertyEvaluator;
            this.project = project;
        }

        protected void addNotify() {
            super.addNotify();
            this.projectDir.addFileChangeListener((FileChangeListener)this);
            this.createNodes();
        }

        private void createNodes() {
            FileObject fileObject;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(KEY_SVC_COMP_NODE);
            DataFolder dataFolder = this.getFolder("src.dir");
            if (dataFolder != null) {
                arrayList.add(KEY_SOURCE_DIR);
            }
            if ((fileObject = this.getSetupFolder()) != null && fileObject.isFolder()) {
                arrayList.add(KEY_SETUP_DIR);
            }
            this.setKeys(arrayList);
        }

        private FileObject getSetupFolder() {
            return this.projectDir.getFileObject("setup");
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
            this.projectDir.removeFileChangeListener((FileChangeListener)this);
            super.removeNotify();
        }

        protected Node[] createNodes(Object object) {
            Node[] nodeArray;
            FilterNode filterNode = null;
            if (object == KEY_SOURCE_DIR) {
                FileObject fileObject = this.helper.resolveFileObject(this.evaluator.getProperty("src.dir"));
                Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
                SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
                for (int i = 0; i < sourceGroupArray.length; ++i) {
                    if (!sourceGroupArray[i].contains(fileObject)) continue;
                    try {
                        DataObject dataObject = DataObject.find((FileObject)sourceGroupArray[i].getRootFolder());
                        filterNode = new RootNode(DataFolder.findFolder((FileObject)sourceGroupArray[i].getRootFolder()));
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {}
                    break;
                }
            } else if (object == KEY_SETUP_DIR) {
                try {
                    DataObject dataObject = DataObject.find((FileObject)this.getSetupFolder());
                    filterNode = null;
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {}
            } else if (object == KEY_SVC_COMP_NODE && (filterNode = ServiceCompositionNode.createServiceCompositionNode((JbiProject)this.project)) != null) {
                filterNode.addNodeListener((NodeListener)new NodeAdapter(){

                    public void nodeDestroyed(NodeEvent nodeEvent) {
                        LogicalViewChildren.this.refreshKey(LogicalViewChildren.KEY_SVC_COMP_NODE);
                    }
                });
            }
            if (filterNode == null) {
                nodeArray = new Node[]{};
            } else {
                Node[] nodeArray2 = new Node[1];
                nodeArray = nodeArray2;
                nodeArray2[0] = filterNode;
            }
            return nodeArray;
        }

        private DataFolder getFolder(String string) {
            FileObject fileObject;
            String string2 = this.evaluator.getProperty(string);
            if (string2 != null && (fileObject = this.helper.resolveFileObject(string2)) != null) {
                DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
                return dataFolder;
            }
            return null;
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public void fileChanged(FileEvent fileEvent) {
        }

        public void fileDataCreated(FileEvent fileEvent) {
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.createNodes();
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            this.createNodes();
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.createNodes();
        }
    }
}

