/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.jbi.ui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.compapp.projects.jbi.ui.FoldersListSettings;
import org.netbeans.modules.compapp.projects.jbi.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.compapp.projects.jbi.ui.wizards.SettingsPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class PanelProjectLocationVisual
extends SettingsPanel
implements DocumentListener {
    private PanelConfigureProject panel;
    private JButton Button;
    private JLabel createdFolderLabel;
    private JTextField createdFolderTextField;
    private JLabel projectLocationLabel;
    private JTextField projectLocationTextField;
    private JLabel projectNameLabel;
    protected JTextField projectNameTextField;

    public PanelProjectLocationVisual(PanelConfigureProject panelConfigureProject) {
        this.initComponents();
        this.panel = panelConfigureProject;
        this.projectNameTextField.getDocument().addDocumentListener(this);
        this.projectLocationTextField.getDocument().addDocumentListener(this);
    }

    private void initComponents() {
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectLocationLabel = new JLabel();
        this.projectLocationTextField = new JTextField();
        this.Button = new JButton();
        this.createdFolderLabel = new JLabel();
        this.createdFolderTextField = new JTextField();
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_ProjectName_Label"));
        this.projectNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"ACS_LBL_NWP1_ProjectName_A11YDesc"));
        this.projectLocationLabel.setLabelFor(this.projectLocationTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLocationLabel, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_ProjectLocation_Label"));
        this.projectLocationTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"ACS_LBL_NPW1_ProjectLocation_A11YDesc"));
        Mnemonics.setLocalizedText((AbstractButton)this.Button, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_BrowseLocation_Button"));
        this.Button.setActionCommand("BROWSE");
        this.Button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PanelProjectLocationVisual.this.browseLocationAction(actionEvent);
            }
        });
        this.Button.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"ACS_LBL_NWP1_BrowseLocation_A11YDesc"));
        this.createdFolderLabel.setLabelFor(this.createdFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.createdFolderLabel, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_CreatedProjectFolder_Lablel"));
        this.createdFolderTextField.setEditable(false);
        this.createdFolderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"ACS_LBL_NWP1_CreatedProjectFolder_A11YDesc"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.projectNameLabel).add((Component)this.createdFolderLabel).add((Component)this.projectLocationLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.projectNameTextField, -1, 248, Short.MAX_VALUE).add((Component)this.createdFolderTextField, -1, 248, Short.MAX_VALUE).add(2, (Component)this.projectLocationTextField, -1, 248, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.Button)));
        groupLayout.linkSize(new Component[]{this.createdFolderLabel, this.projectLocationLabel, this.projectNameLabel}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectNameLabel).add((Component)this.projectNameTextField, -2, -1, -2)).add(10, 10, 10).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectLocationLabel).add((Component)this.projectLocationTextField, -2, -1, -2).add((Component)this.Button)).add(5, 5, 5).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.createdFolderLabel).add((Component)this.createdFolderTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void browseLocationAction(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("BROWSE".equals(string)) {
            File file;
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_SelectProjectLocation"));
            jFileChooser.setFileSelectionMode(1);
            String string2 = this.projectLocationTextField.getText();
            if (string2.length() > 0 && (file = new File(string2)).exists()) {
                jFileChooser.setSelectedFile(file);
            }
            if (0 == jFileChooser.showOpenDialog(this)) {
                file = jFileChooser.getSelectedFile();
                this.projectLocationTextField.setText(file.getAbsolutePath());
            }
            this.panel.fireChangeEvent();
        }
    }

    public void addNotify() {
        super.addNotify();
        this.projectNameTextField.requestFocus();
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        File file;
        if (this.projectNameTextField.getText().length() == 0 || this.projectNameTextField.getText().indexOf(47) > 0 || this.projectNameTextField.getText().indexOf(92) > 0 || this.projectNameTextField.getText().indexOf(58) > 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_IllegalProjectName"));
            return false;
        }
        File file2 = new File(this.projectLocationTextField.getText()).getAbsoluteFile();
        if (PanelProjectLocationVisual.getCanonicalFile(file2) == null) {
            String string = NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_IllegalProjectLocation");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string);
            return false;
        }
        File file3 = PanelProjectLocationVisual.getCanonicalFile(new File(this.createdFolderTextField.getText()));
        if (Utilities.isUnix() && file3 != null && file3.getParentFile().getParent() == null) {
            String string = NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_ProjectInRootNotSupported");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string);
            return false;
        }
        File file4 = new File(this.createdFolderTextField.getText()).getAbsoluteFile();
        if (PanelProjectLocationVisual.getCanonicalFile(file4) == null) {
            String string = NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_IllegalProjectLocation");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string);
            return false;
        }
        for (file = FileUtil.normalizeFile((File)file4); file != null && !file.exists(); file = file.getParentFile()) {
        }
        if (file == null || !file.canWrite()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_ProjectFolderReadOnly"));
            return false;
        }
        if (FileUtil.toFileObject((File)file) == null) {
            String string = NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_IllegalProjectLocation");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string);
            return false;
        }
        File[] fileArray = file4.listFiles();
        if (file4.exists() && fileArray != null && fileArray.length > 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_ProjectFolderExists"));
            return false;
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
        return true;
    }

    void store(WizardDescriptor wizardDescriptor) {
        String string = this.projectNameTextField.getText().trim();
        wizardDescriptor.putProperty("projdir", (Object)new File(this.createdFolderTextField.getText().trim()));
        wizardDescriptor.putProperty("name", (Object)string);
        File file = new File(this.projectLocationTextField.getText());
        if (file.isDirectory()) {
            ProjectChooser.setProjectsFolder((File)file);
        }
    }

    void read(WizardDescriptor wizardDescriptor) {
        File file = (File)wizardDescriptor.getProperty("projdir");
        file = file == null ? ProjectChooser.getProjectsFolder() : file.getParentFile();
        this.projectLocationTextField.setText(file.getAbsolutePath());
        String string = (String)wizardDescriptor.getProperty("name");
        if (string == null) {
            int n = FoldersListSettings.getDefault().getNewProjectCount() + 1;
            String string2 = NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NPW1_DefaultProjectName");
            while ((string = this.validFreeProjectName(file, string2, n)) == null) {
                ++n;
            }
        }
        this.projectNameTextField.setText(string);
        this.projectNameTextField.selectAll();
    }

    private static JFileChooser createChooser() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        return jFileChooser;
    }

    private String validFreeProjectName(File file, String string, int n) {
        String string2 = MessageFormat.format(string, new Integer(n));
        File file2 = new File(file, string2);
        return file2.exists() ? null : string2;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
    }

    private void updateTexts(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        if (document == this.projectNameTextField.getDocument() || document == this.projectLocationTextField.getDocument()) {
            String string = this.projectNameTextField.getText();
            String string2 = this.projectLocationTextField.getText();
            String string3 = FileUtil.normalizeFile((File)new File(string2)).getAbsolutePath();
            if (string3.endsWith(File.separator)) {
                this.createdFolderTextField.setText(string3 + string);
            } else {
                this.createdFolderTextField.setText(string3 + File.separator + string);
            }
        }
        this.panel.fireChangeEvent();
    }

    private String getCreatedFolderPath() {
        StringBuffer stringBuffer = new StringBuffer(this.projectLocationTextField.getText().trim());
        if (!this.projectLocationTextField.getText().endsWith(File.separator)) {
            stringBuffer.append(File.separatorChar);
        }
        stringBuffer.append(this.projectNameTextField.getText().trim());
        return stringBuffer.toString();
    }

    static File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

