/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.test.ui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JPanel;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.compapp.test.ui.wizards.ProjectUtil;
import org.netbeans.modules.compapp.test.ui.wizards.WsdlViewNodes;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class WsdlTreeViewPanel
extends JPanel
implements ExplorerManager.Provider {
    private static final Logger mLog = Logger.getLogger("org.netbeans.modules.compapp.test.ui.wizards.WsdlTreeViewPanel");
    private static final String SOURCES_TYPE_ICANPRO = "BIZPRO";
    private Project mProject;
    private ExplorerManager mManager;
    private BeanTreeView mBtv;
    private FileObject mSelectedWsdlFile;

    public WsdlTreeViewPanel(Project project) {
        this.mProject = project;
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.mManager = new ExplorerManager();
        this.mManager.addPropertyChangeListener((PropertyChangeListener)new ExplorerPropertyChangeListener());
        if (this.mProject != null) {
            Project project2;
            ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>();
            SourceGroup[] sourceGroupArray = this.getSourceGroups(this.mProject);
            Set set = ProjectUtil.getClasspathProjects(this.mProject);
            for (Project project2 : set) {
                SourceGroup[] sourceGroupArray2 = this.getSourceGroups(project2);
                if (sourceGroupArray2 == null || sourceGroupArray2.length <= 0) continue;
                for (int i = 0; i < sourceGroupArray2.length; ++i) {
                    arrayList.add(sourceGroupArray2[i]);
                }
            }
            project2 = new AbstractNode((Children)new WsdlViewNodes.SourceGroups(this.mProject, sourceGroupArray, arrayList.toArray(new SourceGroup[0])));
            this.mManager.setRootContext((Node)project2);
        }
        this.mBtv = new BeanTreeView();
        this.mBtv.getAccessibleContext().setAccessibleName(NbBundle.getMessage(WsdlTreeViewPanel.class, (String)"ACS_WsdlTreeView_A11YName"));
        this.mBtv.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WsdlTreeViewPanel.class, (String)"ACS_WsdlTreeView_A11YDesc"));
        this.mBtv.setRootVisible(false);
        this.mBtv.setSelectionMode(1);
        this.mBtv.setPopupAllowed(false);
        this.add((Component)this.mBtv, "Center");
    }

    private SourceGroup[] getSourceGroups(Project project) {
        Sources sources = ProjectUtils.getSources((Project)project);
        if (sources != null) {
            SourceGroup[] sourceGroupArray = sources.getSourceGroups(SOURCES_TYPE_ICANPRO);
            if (sourceGroupArray != null && sourceGroupArray.length > 0) {
                return sourceGroupArray;
            }
            sourceGroupArray = sources.getSourceGroups("JBI");
            if (sourceGroupArray != null && sourceGroupArray.length > 0) {
                return sourceGroupArray;
            }
            if (sourceGroupArray == null || sourceGroupArray.length < 1) {
                sourceGroupArray = sources.getSourceGroups("generic");
            }
            return sourceGroupArray;
        }
        return null;
    }

    public ExplorerManager getExplorerManager() {
        return this.mManager;
    }

    public BeanTreeView getTreeView() {
        return this.mBtv;
    }

    public FileObject getSelectedWsdlFile() {
        return this.mSelectedWsdlFile;
    }

    class ExplorerPropertyChangeListener
    implements PropertyChangeListener {
        ExplorerPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!propertyChangeEvent.getPropertyName().equals("selectedNodes")) {
                return;
            }
            Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
            if (nodeArray.length == 0) {
                return;
            }
            Node node = nodeArray[0];
            WsdlViewNodes.FileObjectCookie fileObjectCookie = (WsdlViewNodes.FileObjectCookie)node.getCookie(WsdlViewNodes.FileObjectCookie.class);
            if (fileObjectCookie != null) {
                WsdlTreeViewPanel.this.mSelectedWsdlFile = fileObjectCookie.getFileObject();
            } else {
                WsdlTreeViewPanel.this.mSelectedWsdlFile = null;
            }
        }
    }
}

