/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.test.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class FileNodeUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void overwriteFile(Node node, Node node2) throws IOException {
        InputStream inputStream;
        FileLock fileLock;
        DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
        FileObject fileObject = dataObject.getPrimaryFile();
        DataObject dataObject2 = (DataObject)node2.getLookup().lookup(DataObject.class);
        FileObject fileObject2 = dataObject2.getPrimaryFile();
        if (dataObject.isModified()) {
            fileLock = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(FileNodeUtil.class, (String)"MSG_SaveModifiedSource", (Object)fileObject.getNameExt()), NbBundle.getMessage(FileNodeUtil.class, (String)"TTL_SaveModifiedSource"), 2);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)fileLock) == NotifyDescriptor.OK_OPTION) {
                inputStream = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                inputStream.saveDocument();
            }
        }
        if (dataObject2.isModified()) {
            fileLock = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(FileNodeUtil.class, (String)"MSG_OverwriteModifiedDestination", (Object)fileObject2.getNameExt()), NbBundle.getMessage(FileNodeUtil.class, (String)"TTL_OverwriteModifiedDestination"), 2);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)fileLock) == NotifyDescriptor.CANCEL_OPTION) {
                return;
            }
            inputStream = (EditorCookie)dataObject2.getCookie(EditorCookie.class);
            InputStream inputStream2 = null;
            try {
                inputStream2 = fileObject.getInputStream();
                String string = FileNodeUtil.getInputStreamContents(inputStream2);
                StyledDocument styledDocument = inputStream.getDocument();
                try {
                    styledDocument.remove(0, styledDocument.getLength());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                styledDocument.insertString(0, string, null);
                inputStream.saveDocument();
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
                throw new IOException(badLocationException.getMessage());
            }
            finally {
                try {
                    if (inputStream2 != null) {
                        inputStream2.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        fileLock = fileObject2.lock();
        inputStream = null;
        OutputStream outputStream = null;
        try {
            outputStream = fileObject2.getOutputStream(fileLock);
            inputStream = fileObject.getInputStream();
            FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
                fileLock.releaseLock();
            }
            catch (Exception exception) {}
        }
    }

    public static void overwriteFile(FileObject fileObject, FileObject fileObject2) throws IOException {
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        Node node = dataObject.getNodeDelegate();
        DataObject dataObject2 = DataObject.find((FileObject)fileObject2);
        Node node2 = dataObject2.getNodeDelegate();
        FileNodeUtil.overwriteFile(node, node2);
    }

    public static void overwriteFile(FileObject fileObject, Node node) throws IOException {
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        Node node2 = dataObject.getNodeDelegate();
        FileNodeUtil.overwriteFile(node2, node);
    }

    public static void overwriteFile(Node node, FileObject fileObject) throws IOException {
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        Node node2 = dataObject.getNodeDelegate();
        FileNodeUtil.overwriteFile(node, node2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFileObjectContents(FileObject fileObject) throws IOException {
        InputStream inputStream = fileObject.getInputStream();
        try {
            String string = FileNodeUtil.getInputStreamContents(inputStream);
            return string;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static String getInputStreamContents(InputStream inputStream) throws IOException {
        int n = 512;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[n];
        int n2 = bufferedReader.read(cArray);
        while (n2 > 0) {
            stringBuffer.append(cArray, 0, n2);
            n2 = bufferedReader.read(cArray);
        }
        return stringBuffer.toString();
    }
}

