/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.dataconnectivity.model;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignContext;
import com.sun.rave.designtime.DesignProject;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.visualweb.api.j2ee.common.RequestedJdbcResource;
import org.netbeans.modules.visualweb.dataconnectivity.model.DataSourceInfo;
import org.netbeans.modules.visualweb.project.jsf.services.DesignTimeDataSourceService;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectDataSourceManager {
    private Project project = null;
    private DesignTimeDataSourceService dataSourceService = null;

    public ProjectDataSourceManager(DesignBean designBean) {
        DesignContext designContext = designBean.getDesignContext();
        DesignProject designProject = designContext.getProject();
        File file = null;
        try {
            file = designProject.getResourceFile(new URI("nbproject"));
        }
        catch (URISyntaxException uRISyntaxException) {
            ErrorManager.getDefault().notify(1, (Throwable)uRISyntaxException);
        }
        if (file != null) {
            this.project = FileOwnerQuery.getOwner((FileObject)FileUtil.toFileObject((File)file));
        }
        this.dataSourceService = (DesignTimeDataSourceService)Lookup.getDefault().lookup(DesignTimeDataSourceService.class);
    }

    public ProjectDataSourceManager(Project project) {
        this.project = project;
        this.dataSourceService = (DesignTimeDataSourceService)Lookup.getDefault().lookup(DesignTimeDataSourceService.class);
    }

    public boolean addDataSource(DataSourceInfo dataSourceInfo) {
        if (this.project != null && this.dataSourceService != null) {
            RequestedJdbcResource requestedJdbcResource = new RequestedJdbcResource("jdbc/" + dataSourceInfo.getName(), dataSourceInfo.getDriverClassName(), dataSourceInfo.getUrl(), dataSourceInfo.getUsername(), dataSourceInfo.getPassword());
            if (!this.dataSourceService.updateProjectDataSource(this.project, requestedJdbcResource)) {
                return false;
            }
            this.dataSourceService.updateResourceReference(this.project, requestedJdbcResource);
        }
        return true;
    }

    public boolean isRequestedJdbcResourceAvailable() {
        Object var1_1 = null;
        boolean bl = false;
        if (this.dataSourceService.getProjectDataSources(this.project).size() > 0) {
            bl = true;
        }
        return bl;
    }

    public Set<RequestedJdbcResource> findRequestedJdbcResources(DataSourceInfo dataSourceInfo) {
        HashSet<RequestedJdbcResource> hashSet = new HashSet<RequestedJdbcResource>();
        if (this.project != null && this.dataSourceService != null) {
            Object object2;
            Set set = this.dataSourceService.getProjectDataSources(this.project);
            for (Object object2 : set) {
                if (!this.matchDataSourceInfo((RequestedJdbcResource)object2, dataSourceInfo)) continue;
                hashSet.add((RequestedJdbcResource)object2);
            }
            object2 = this.dataSourceService.getServerDataSources(this.project);
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                RequestedJdbcResource requestedJdbcResource = (RequestedJdbcResource)iterator.next();
                if (!this.matchDataSourceInfo(requestedJdbcResource, dataSourceInfo)) continue;
                hashSet.add(requestedJdbcResource);
            }
        }
        return hashSet;
    }

    public RequestedJdbcResource getDataSourceWithName(String string) {
        String string2 = "";
        if (this.project != null && this.dataSourceService != null) {
            Object object;
            Object object22;
            Set set = this.dataSourceService.getProjectDataSources(this.project);
            for (Object object22 : set) {
                object = object22.getResourceName();
                if (((String)object).startsWith("jdbc")) {
                    string2 = ((String)object).replaceFirst("jdbc/", "");
                } else if (((String)object).startsWith("java:/jdbc")) {
                    string2 = ((String)object).replaceFirst("java:/jdbc/", "");
                }
                if (!string2.equals(string)) continue;
                return object22;
            }
            object22 = this.dataSourceService.getServerDataSources(this.project);
            object = object22.iterator();
            while (object.hasNext()) {
                RequestedJdbcResource requestedJdbcResource = (RequestedJdbcResource)object.next();
                string2 = requestedJdbcResource.getResourceName();
                if (string2.startsWith("jdbc")) {
                    string2 = string2.replaceFirst("jdbc/", "");
                } else if (string2.startsWith("java:/jdbc")) {
                    string2 = string2.replaceFirst("java:/jdbc/", "");
                }
                if (!string2.equals(string)) continue;
                return requestedJdbcResource;
            }
        }
        return null;
    }

    public boolean matchDataSourceInfo(RequestedJdbcResource requestedJdbcResource, DataSourceInfo dataSourceInfo) {
        String string = requestedJdbcResource.getUrl();
        String string2 = requestedJdbcResource.getDriverClassName();
        String string3 = requestedJdbcResource.getUsername();
        String string4 = requestedJdbcResource.getPassword();
        String string5 = dataSourceInfo.getUrl();
        String string6 = dataSourceInfo.getDriverClassName();
        String string7 = dataSourceInfo.getUsername();
        String string8 = dataSourceInfo.getPassword();
        return this.matchURL(string, string5, true) && this.matchString(string3, string7, false) && this.matchString(string4, string8, false);
    }

    private boolean matchString(String string, String string2, boolean bl) {
        if (string != null && string2 != null) {
            if (bl) {
                return string.trim().equalsIgnoreCase(string2.trim());
            }
            return string.trim().equals(string2.trim());
        }
        return string == null && string2 == null;
    }

    private boolean matchURL(String string, String string2, boolean bl) {
        String string3;
        if (bl) {
            string = string.toLowerCase();
            string2 = string2.toLowerCase();
        }
        if (string.equals(string2)) {
            return true;
        }
        if (string.contains("derby") && (string3 = string.substring(0, string.lastIndexOf(":")) + string.substring(string.lastIndexOf("/"))).equals(string2)) {
            return true;
        }
        int n = 0;
        if (string != null && string2 != null) {
            char[] cArray = string.toCharArray();
            char[] cArray2 = string2.toCharArray();
            for (int i = 0; i < cArray.length - 1; ++i) {
                if (cArray[i] != cArray2[i] && cArray[i] == ':') {
                    n = 1;
                    continue;
                }
                if (cArray[i + n] == cArray2[i]) continue;
                return false;
            }
        }
        return true;
    }

    public boolean removeDataSource(DesignProject designProject, DataSourceInfo dataSourceInfo) {
        throw new UnsupportedOperationException("Missing support in web/project");
    }

    public boolean modifyDataSource(DesignProject designProject, DataSourceInfo dataSourceInfo) {
        throw new UnsupportedOperationException("Missing support in web/project");
    }
}

