/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.dataconnectivity.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.sql.DataSource;
import org.netbeans.modules.visualweb.dataconnectivity.sql.ColumnMetaData;
import org.netbeans.modules.visualweb.dataconnectivity.sql.DesignTimeDataSource;
import org.netbeans.modules.visualweb.dataconnectivity.sql.ProcedureColumnMetaData;
import org.netbeans.modules.visualweb.dataconnectivity.sql.ProcedureMetaData;
import org.netbeans.modules.visualweb.dataconnectivity.sql.TableMetaData;

public class DatabaseMetaDataHelper {
    private static ResourceBundle rb = ResourceBundle.getBundle("org.netbeans.modules.visualweb.dataconnectivity.sql.Bundle", Locale.getDefault());
    private DataSource dataSource;
    private Connection connection;
    private DatabaseMetaData metaData;
    private String[] schemaNames;
    private String[] tableNames;
    private TableMetaData[] tableMetaData;
    private String[] viewNames;
    private TableMetaData[] viewMetaData;
    private String[] procedureNames;
    private ProcedureMetaData[] procedureMetaData;
    private Hashtable columnNames;
    private boolean instantiatedWithMetaData = false;

    public DatabaseMetaDataHelper(DataSource dataSource) throws SQLException {
        this.init();
        this.dataSource = dataSource;
    }

    public DatabaseMetaDataHelper(Connection connection) throws SQLException {
        this.init();
        this.connection = connection;
    }

    public DatabaseMetaDataHelper(DatabaseMetaData databaseMetaData) throws SQLException {
        this.init();
        this.metaData = databaseMetaData;
        this.instantiatedWithMetaData = true;
    }

    private void init() {
        this.dataSource = null;
        this.connection = null;
        this.metaData = null;
        this.schemaNames = null;
        this.tableNames = null;
        this.tableMetaData = null;
        this.viewNames = null;
        this.viewMetaData = null;
        this.procedureNames = null;
        this.columnNames = new Hashtable();
    }

    public TableMetaData[] getTableMetaData() throws SQLException {
        if (this.tableMetaData == null) {
            this.tableMetaData = this.getTablesInternal(new String[]{"TABLE"});
        }
        return this.tableMetaData;
    }

    public ProcedureMetaData[] getProcedureMetaData() throws SQLException {
        if (this.procedureMetaData == null) {
            this.procedureMetaData = this.getProceduresInternal();
        }
        return this.procedureMetaData;
    }

    public TableMetaData getTableMetaData(String string) throws SQLException {
        this.getTableMetaData();
        for (int i = 0; i < this.tableMetaData.length; ++i) {
            if (!this.getFullTableName(this.tableMetaData[i]).equals(string)) continue;
            return this.tableMetaData[i];
        }
        throw new SQLException(rb.getString("TABLE_NOT_FOUND") + ": " + string);
    }

    public ProcedureMetaData getProcedureMetaData(String string) throws SQLException {
        this.getProcedureMetaData();
        for (int i = 0; i < this.procedureMetaData.length; ++i) {
            if (!this.getFullProcedureName(this.procedureMetaData[i]).equals(string)) continue;
            return this.procedureMetaData[i];
        }
        throw new SQLException(rb.getString("PROCEDURE_NOT_FOUND") + ": " + string);
    }

    public TableMetaData getViewMetaData(String string) throws SQLException {
        this.getViewMetaData();
        for (int i = 0; i < this.viewMetaData.length; ++i) {
            if (!this.getFullTableName(this.viewMetaData[i]).equals(string)) continue;
            return this.viewMetaData[i];
        }
        throw new SQLException(rb.getString("VIEW_NOT_FOUND") + ": " + string);
    }

    public TableMetaData getTableOrViewMetaData(String string) throws SQLException {
        int n;
        this.getTableMetaData();
        for (n = 0; n < this.tableMetaData.length; ++n) {
            if (!this.getFullTableName(this.tableMetaData[n]).equals(string)) continue;
            return this.tableMetaData[n];
        }
        this.getViewMetaData();
        for (n = 0; n < this.viewMetaData.length; ++n) {
            if (!this.getFullTableName(this.viewMetaData[n]).equals(string)) continue;
            return this.viewMetaData[n];
        }
        throw new SQLException(rb.getString("TABLE_OR_VIEW_NOT_FOUND") + ": " + string);
    }

    private String getFullTableName(TableMetaData tableMetaData) throws SQLException {
        String string = tableMetaData.getMetaInfo(1);
        string = string == null || string.trim().equals("") ? "" : string + ".";
        return string + tableMetaData.getMetaInfo(2);
    }

    private String getFullProcedureName(ProcedureMetaData procedureMetaData) throws SQLException {
        String string = procedureMetaData.getMetaInfoAsString(1);
        string = string == null || string.trim().equals("") ? "" : string + ".";
        return string + procedureMetaData.getMetaInfo(2);
    }

    public String getNameForSelect(String string) throws SQLException {
        TableMetaData tableMetaData = null;
        tableMetaData = this.getTableOrViewMetaData(string);
        String string2 = tableMetaData.getMetaInfo(1);
        string2 = string2 == null || string2.trim().equals("") ? "" : string2 + ".";
        return string2 + tableMetaData.getMetaInfo(2);
    }

    public String getProcedureNameForExec(String string) throws SQLException {
        ProcedureMetaData procedureMetaData = null;
        procedureMetaData = this.getProcedureMetaData(string);
        String string2 = procedureMetaData.getMetaInfoAsString(1);
        string2 = string2 == null || string2.trim().equals("") ? "" : string2 + ".";
        return string2 + procedureMetaData.getMetaInfo(2);
    }

    public String getNoSchemaName(String string) throws SQLException {
        TableMetaData tableMetaData = null;
        tableMetaData = this.getTableOrViewMetaData(string);
        return tableMetaData.getMetaInfo(2);
    }

    public String getDisplayName(String string) throws SQLException {
        TableMetaData tableMetaData = null;
        tableMetaData = this.getTableOrViewMetaData(string);
        return tableMetaData.getMetaInfo(2);
    }

    public String[] getSchemas() throws SQLException {
        if (this.schemaNames == null) {
            ResultSet resultSet = this.getMetaData().getSchemas();
            ArrayList<String> arrayList = new ArrayList<String>();
            while (resultSet.next()) {
                String string = resultSet.getString("TABLE_SCHEM");
                if (string == null) continue;
                arrayList.add(string);
            }
            resultSet.close();
            this.schemaNames = arrayList.toArray(new String[0]);
        }
        return this.schemaNames;
    }

    public String[] getTables(String string) throws SQLException {
        return this.getTablesInternal(this.getTableMetaData(), string);
    }

    public String[] getViews(String string) throws SQLException {
        return this.getTablesInternal(this.getViewMetaData(), string);
    }

    public String[] getProcedures(String string) throws SQLException {
        return this.getProceduresInternal(this.getProcedureMetaData(), string);
    }

    boolean isEmpty(String string) throws SQLException {
        return this.isEmpty(string, new String[]{"TABLE"}) && this.isEmpty(string, new String[]{"VIEW"});
    }

    boolean isEmpty(String string, String[] stringArray) throws SQLException {
        ResultSet resultSet = this.getMetaData().getTables(null, string, "%", stringArray);
        boolean bl = !resultSet.next();
        resultSet.close();
        return bl;
    }

    String getValidationQuery(String string) throws SQLException {
        ResultSet resultSet = this.getMetaData().getTables(null, string, "%", new String[]{"TABLE", "VIEW"});
        String string2 = null;
        if (resultSet.next()) {
            String string3 = resultSet.getString("TABLE_SCHEM");
            String string4 = resultSet.getString("TABLE_NAME");
            if (string3 != null) {
                string4 = string3 + "." + string4;
            }
            string2 = DesignTimeDataSource.composeSelect(string4, this.getMetaData());
        }
        resultSet.close();
        return string2;
    }

    private String[] getTablesInternal(TableMetaData[] tableMetaDataArray, String string) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < tableMetaDataArray.length; ++i) {
            String string2 = tableMetaDataArray[i].getMetaInfo(1);
            if ((string != null || string2 != null) && (string == null || string2 == null || !string2.equals(string))) continue;
            arrayList.add(this.getFullTableName(tableMetaDataArray[i]));
        }
        return arrayList.toArray(new String[0]);
    }

    private String[] getProceduresInternal(ProcedureMetaData[] procedureMetaDataArray, String string) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < procedureMetaDataArray.length; ++i) {
            String string2 = procedureMetaDataArray[i].getMetaInfoAsString(1);
            if ((string != null || string2 != null) && (string == null || string2 == null || !string2.equals(string))) continue;
            arrayList.add(this.getFullProcedureName(procedureMetaDataArray[i]));
        }
        return arrayList.toArray(new String[0]);
    }

    public String[] getTables() throws SQLException {
        if (this.tableNames == null) {
            this.tableNames = new String[this.getTableMetaData().length];
            for (int i = 0; i < this.getTableMetaData().length; ++i) {
                this.tableNames[i] = this.getFullTableName(this.getTableMetaData()[i]);
            }
        }
        return this.tableNames;
    }

    public String[] getProcedures() throws SQLException {
        if (this.procedureNames == null) {
            this.procedureNames = new String[this.getProcedureMetaData().length];
            for (int i = 0; i < this.getProcedureMetaData().length; ++i) {
                this.procedureNames[i] = this.getFullProcedureName(this.getProcedureMetaData()[i]);
            }
        }
        return this.procedureNames;
    }

    public TableMetaData[] getViewMetaData() throws SQLException {
        if (this.viewMetaData == null) {
            this.viewMetaData = this.getTablesInternal(new String[]{"VIEW"});
        }
        return this.viewMetaData;
    }

    public String[] getViews() throws SQLException {
        if (this.viewNames == null) {
            this.viewNames = new String[this.getViewMetaData().length];
            for (int i = 0; i < this.getViewMetaData().length; ++i) {
                this.viewNames[i] = this.getFullTableName(this.getViewMetaData()[i]);
            }
        }
        return this.viewNames;
    }

    public String[] getColumns(String string) throws SQLException {
        return this.getTableOrViewMetaData(string).getColumns();
    }

    public String[] getProcedureColumns(String string) throws SQLException {
        return this.getProcedureMetaData(string).getColumns();
    }

    public ColumnMetaData[] getColumnMetaData(String string) throws SQLException {
        return this.getTableOrViewMetaData(string).getColumnMetaData();
    }

    public ColumnMetaData getColumnMetaData(String string, String string2) throws SQLException {
        return this.getTableOrViewMetaData(string).getColumnMetaData(string2);
    }

    public ProcedureColumnMetaData getProcedureColumnMetaData(String string, String string2) throws SQLException {
        return this.getProcedureMetaData(string).getProcedureColumnMetaData(string2);
    }

    public TableMetaData[] getTablesInternal(String[] stringArray) throws SQLException {
        ResultSet resultSet = this.getMetaData().getTables(null, null, "%", stringArray);
        ArrayList<TableMetaData> arrayList = new ArrayList<TableMetaData>();
        block0: while (resultSet.next()) {
            TableMetaData tableMetaData = new TableMetaData(resultSet, this.getMetaData());
            if (stringArray == null) {
                arrayList.add(tableMetaData);
                continue;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(tableMetaData.getMetaInfo(3))) continue;
                arrayList.add(tableMetaData);
                continue block0;
            }
        }
        resultSet.close();
        return arrayList.toArray(new TableMetaData[0]);
    }

    public ProcedureMetaData[] getProceduresInternal() throws SQLException {
        ResultSet resultSet = this.getMetaData().getProcedures(null, null, "%");
        ArrayList<ProcedureMetaData> arrayList = new ArrayList<ProcedureMetaData>();
        while (resultSet.next()) {
            arrayList.add(new ProcedureMetaData(resultSet, this.getMetaData()));
        }
        resultSet.close();
        return arrayList.toArray(new ProcedureMetaData[0]);
    }

    public void refresh() {
        if (this.dataSource != null && this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = null;
        }
        if (!this.instantiatedWithMetaData) {
            this.metaData = null;
        }
        this.schemaNames = null;
        this.tableNames = null;
        this.tableMetaData = null;
        this.viewMetaData = null;
        this.viewNames = null;
        this.procedureNames = null;
        this.columnNames.clear();
    }

    private Connection getConnection() throws SQLException {
        if (this.connection == null) {
            this.connection = this.dataSource.getConnection();
        }
        return this.connection;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.metaData == null) {
            this.metaData = this.getConnection().getMetaData();
        }
        return this.metaData;
    }

    public boolean isConnected() {
        return this.connection != null;
    }
}

