/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.dataconnectivity.sql;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import org.netbeans.modules.visualweb.dataconnectivity.sql.ColumnMetaData;

public class TableMetaData {
    private static ResourceBundle rb = ResourceBundle.getBundle("org.netbeans.modules.visualweb.dataconnectivity.sql.Bundle", Locale.getDefault());
    public static final int TABLE_CAT = 0;
    public static final int TABLE_SCHEM = 1;
    public static final int TABLE_NAME = 2;
    public static final int TABLE_TYPE = 3;
    public static final int REMARKS = 4;
    public static final int TYPE_CAT = 5;
    public static final int TYPE_SCHEM = 6;
    public static final int TYPE_NAME = 7;
    public static final int SELF_REFERENCING_COL_NAME = 8;
    public static final int REF_GENERATION = 9;
    private static final String[] metaNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS", "TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "SELF_REFERENCING_COL_NAME", "REF_GENERATION"};
    private String[] metaValues;
    private ColumnMetaData[] columnMetaData;
    private DatabaseMetaData dbmd;

    TableMetaData(ResultSet resultSet, DatabaseMetaData databaseMetaData) throws SQLException {
        this.dbmd = databaseMetaData;
        int n = 0;
        SQLException sQLException = null;
        this.metaValues = new String[metaNames.length];
        for (int i = 0; i < metaNames.length; ++i) {
            try {
                this.metaValues[i] = resultSet.getString(metaNames[i]);
                continue;
            }
            catch (SQLException sQLException2) {
                this.metaValues[i] = null;
                ++n;
                if (sQLException != null) continue;
                sQLException = sQLException2;
            }
        }
        if (n == metaNames.length) {
            throw sQLException;
        }
        this.columnMetaData = null;
    }

    public String getMetaInfo(String string) throws SQLException {
        for (int i = 0; i < metaNames.length; ++i) {
            if (!string.equals(metaNames[i])) continue;
            return this.metaValues[i];
        }
        throw new SQLException(rb.getString("NAME_NOT_FOUND") + ": " + string);
    }

    public String getMetaInfo(int n) throws SQLException {
        if (n < 0 || n > this.metaValues.length) {
            throw new SQLException(rb.getString("NO_SUCH_INDEX") + ": " + n);
        }
        return this.metaValues[n];
    }

    public ColumnMetaData[] getColumnMetaData() throws SQLException {
        if (this.columnMetaData == null) {
            ArrayList<ColumnMetaData> arrayList = new ArrayList<ColumnMetaData>();
            ResultSet resultSet = this.dbmd.getColumns(null, this.metaValues[1], this.metaValues[2], "%");
            while (resultSet.next()) {
                arrayList.add(new ColumnMetaData(resultSet));
            }
            resultSet.close();
            this.columnMetaData = arrayList.toArray(new ColumnMetaData[0]);
        }
        return this.columnMetaData;
    }

    public ColumnMetaData getColumnMetaData(String string) throws SQLException {
        for (int i = 0; i < this.getColumnMetaData().length; ++i) {
            if (!this.getColumnMetaData()[i].getMetaInfo(ColumnMetaData.COLUMN_NAME).equals(string)) continue;
            return this.getColumnMetaData()[i];
        }
        throw new SQLException(rb.getString("COLUMN_NOT_FOUND") + ": " + string);
    }

    public String[] getColumns() throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.getColumnMetaData().length; ++i) {
            arrayList.add(this.getColumnMetaData()[i].getMetaInfoAsString(ColumnMetaData.COLUMN_NAME));
        }
        return arrayList.toArray(new String[0]);
    }
}

