/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.javadoc.search.IndexBuilder;
import org.netbeans.modules.javadoc.search.JavadocURLMapper;
import org.openide.ErrorManager;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public final class IndexOverviewAction
extends SystemAction
implements Presenter.Menu {
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.javadoc.search.IndexOverviewAction.IndexMenu");

    public IndexOverviewAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public String getName() {
        return NbBundle.getMessage(IndexOverviewAction.class, (String)"CTL_INDICES_MenuItem");
    }

    protected String iconResource() {
        return null;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("javadoc.search");
    }

    public JMenuItem getMenuPresenter() {
        return new IndexMenu();
    }

    private final class IndexMenuItem
    extends JMenuItem
    implements ActionListener,
    HelpCtx.Provider {
        private URL u;
        private final Reference fsRef;
        private String foPath;

        public IndexMenuItem(String string, FileObject fileObject) throws FileStateInvalidException {
            super(string);
            this.fsRef = new WeakReference<FileSystem>(fileObject.getFileSystem());
            this.foPath = fileObject.getPath();
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            URL uRL = this.getURL();
            HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
        }

        private URL getURL() {
            if (this.u == null) {
                FileSystem fileSystem = (FileSystem)this.fsRef.get();
                assert (fileSystem != null);
                FileObject fileObject = fileSystem.findResource(this.foPath);
                assert (fileObject != null) : this.foPath;
                this.u = JavadocURLMapper.findURL(fileObject);
            }
            return this.u;
        }

        public HelpCtx getHelpCtx() {
            return IndexOverviewAction.this.getHelpCtx();
        }
    }

    private final class IndexMenu
    extends JMenu
    implements HelpCtx.Provider,
    DynamicMenuContent {
        private int itemHash = 0;

        public IndexMenu() {
            Mnemonics.setLocalizedText((AbstractButton)this, (String)IndexOverviewAction.this.getName());
            this.getModel().addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    if (IndexMenu.this.getModel().isSelected()) {
                        IndexMenu.this.getPopupMenu2();
                    }
                }
            });
        }

        public HelpCtx getHelpCtx() {
            return IndexOverviewAction.this.getHelpCtx();
        }

        public JComponent[] getMenuPresenters() {
            return new JComponent[]{this};
        }

        public JComponent[] synchMenuPresenters(JComponent[] jComponentArray) {
            return jComponentArray;
        }

        public void getPopupMenu2() {
            List[] listArray = IndexBuilder.getDefault().getIndices();
            int n = this.computeDataHash(listArray);
            if (n != this.itemHash) {
                if (err.isLoggable(1)) {
                    err.log("recreating popup menu (" + this.itemHash + " -> " + n + ")");
                }
                this.itemHash = n;
                this.removeAll();
                List list = listArray[0];
                List list2 = listArray[1];
                int n2 = list.size();
                if (n2 != list2.size()) {
                    throw new IllegalStateException();
                }
                if (n2 > 0) {
                    for (int i = 0; i < n2; ++i) {
                        try {
                            this.add(new IndexMenuItem((String)list.get(i), (FileObject)list2.get(i)));
                            continue;
                        }
                        catch (FileStateInvalidException fileStateInvalidException) {
                            err.notify(1, (Throwable)fileStateInvalidException);
                        }
                    }
                } else {
                    JMenuItem jMenuItem = new JMenuItem(NbBundle.getMessage(IndexOverviewAction.class, (String)"CTL_no_indices_found"));
                    jMenuItem.setEnabled(false);
                    this.add(jMenuItem);
                }
            }
        }

        private int computeDataHash(List[] listArray) {
            int n = ((Object)listArray[0]).hashCode();
            for (FileObject fileObject : listArray[1]) {
                try {
                    n += fileObject.getURL().hashCode();
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    err.notify(1, (Throwable)fileStateInvalidException);
                }
            }
            return n;
        }
    }
}

