/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.ref.WeakReference;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.properties.DesignPropertyEditor;
import org.netbeans.modules.vmd.midp.codegen.InstanceNameResolver;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.points.MethodPointCD;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class PropertyEditorInstanceName
extends DesignPropertyEditor {
    private static final String METHOD_NAME_TEXT = NbBundle.getMessage(PropertyEditorInstanceName.class, (String)"LBL_METHOD_NAME");
    private static final String INSTANCE_NAME_TEXT = NbBundle.getMessage(PropertyEditorInstanceName.class, (String)"LBL_INSTANCE_NAME");
    private TypeID typeID;
    private CustomEditor customEditor;
    private WeakReference<DesignComponent> component;

    private PropertyEditorInstanceName(TypeID typeID) {
        this.typeID = typeID;
        this.customEditor = new CustomEditor();
    }

    public static final DesignPropertyEditor createInstance(TypeID typeID) {
        return new PropertyEditorInstanceName(typeID);
    }

    public Component getCustomEditor() {
        PropertyValue propertyValue = (PropertyValue)super.getValue();
        if (propertyValue != null) {
            this.customEditor.setText(MidpTypes.getString(propertyValue));
        }
        return this.customEditor;
    }

    public void cleanUp(DesignComponent designComponent) {
        super.cleanUp(designComponent);
        if (this.customEditor != null) {
            this.customEditor.cleanUp();
            this.customEditor = null;
        }
        this.typeID = null;
    }

    public String getAsText() {
        PropertyValue propertyValue = (PropertyValue)super.getValue();
        return propertyValue == null ? PropertyEditorUserCode.NULL_TEXT : MidpTypes.getString(propertyValue);
    }

    public void setAsText(String string) {
        PropertyValue propertyValue = (PropertyValue)super.getValue();
        if (propertyValue == null) {
            return;
        }
        Object object = propertyValue.getPrimitiveValue();
        if (object != null && object.equals(string)) {
            return;
        }
        this.saveValue(string);
    }

    private void saveValue(final String string) {
        if (this.component != null && this.component.get() != null) {
            final DesignComponent designComponent = (DesignComponent)this.component.get();
            designComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

                public void run() {
                    PropertyValue propertyValue = InstanceNameResolver.createFromSuggested(designComponent, string);
                    PropertyEditorInstanceName.super.setValue(propertyValue);
                }
            });
        }
    }

    public void customEditorOKButtonPressed() {
        String string = this.customEditor.getText();
        if (string.length() > 0) {
            this.saveValue(string);
        }
    }

    public void init(DesignComponent designComponent) {
        this.component = new WeakReference<DesignComponent>(designComponent);
    }

    public boolean supportsDefaultValue() {
        return false;
    }

    public boolean canWrite() {
        if (this.component == null || this.component.get() == null) {
            return false;
        }
        final boolean[] blArray = new boolean[1];
        final DesignDocument designDocument = ((DesignComponent)this.component.get()).getDocument();
        designDocument.getTransactionManager().readAccess(new Runnable(){

            public void run() {
                blArray[0] = designDocument.getSelectedComponents().size() <= 1;
            }
        });
        return blArray[0];
    }

    private String getLabelName() {
        return MethodPointCD.TYPEID.equals((Object)this.typeID) ? METHOD_NAME_TEXT : INSTANCE_NAME_TEXT;
    }

    private final class CustomEditor
    extends JPanel {
        private JTextField textField;

        public CustomEditor() {
            this.initComponents();
        }

        void cleanUp() {
            this.textField = null;
            this.removeAll();
        }

        private void initComponents() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            JLabel jLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)jLabel, (String)PropertyEditorInstanceName.this.getLabelName());
            gridBagConstraints.insets = new Insets(12, 12, 3, 12);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            this.add((Component)jLabel, gridBagConstraints);
            this.textField = new JTextField();
            jLabel.setLabelFor(this.textField);
            gridBagConstraints.insets = new Insets(0, 12, 12, 12);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            this.add((Component)this.textField, gridBagConstraints);
            this.textField.getAccessibleContext().setAccessibleName(jLabel.getText());
            this.textField.getAccessibleContext().setAccessibleDescription(jLabel.getText());
            JPanel jPanel = new JPanel();
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            this.add((Component)jPanel, gridBagConstraints);
            this.setPreferredSize(new Dimension(300, 64));
        }

        public void setText(String string) {
            this.textField.setText(string);
        }

        public String getText() {
            return this.textField.getText();
        }
    }
}

