/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.Collections;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.propertyeditors.PropertyEditorGaugeMaxValue;
import org.netbeans.modules.vmd.midp.propertyeditors.PropertyEditorPreferredSize;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PropertyEditorNumber
extends PropertyEditorUserCode
implements PropertyEditorElement {
    public static final String NON_DIGITS_TEXT = NbBundle.getMessage(PropertyEditorGaugeMaxValue.class, (String)"MSG_NON_DIGIT_CHARS");
    private CustomEditor customEditor;
    private JRadioButton radioButton;
    private String label;
    private boolean positiveNumersOnly;

    private PropertyEditorNumber(boolean bl, String string, String string2) {
        super(string2);
        this.label = string;
        this.initComponents(bl);
        this.initElements(Collections.singleton(this));
    }

    private PropertyEditorNumber(boolean bl, String string, String string2, boolean bl2) {
        super(string2);
        this.label = string;
        this.initComponents(bl);
        this.positiveNumersOnly = bl2;
        this.initElements(Collections.singleton(this));
    }

    public void cleanUp(DesignComponent designComponent) {
        super.cleanUp(designComponent);
        if (this.customEditor != null) {
            this.customEditor.cleanUp();
            this.customEditor = null;
        }
        this.radioButton = null;
    }

    public static final PropertyEditorNumber createIntegerInstance(boolean bl, String string) {
        return new PropertyEditorNumber(bl, string, NbBundle.getMessage(PropertyEditorNumber.class, (String)"LBL_INTEGER_UCLABEL"));
    }

    public static final PropertyEditorNumber createPositiveIntegerInstance(boolean bl, String string) {
        return new PropertyEditorNumber(bl, string, NbBundle.getMessage(PropertyEditorNumber.class, (String)"LBL_INTEGER_UCLABEL"), true);
    }

    public static final PropertyEditorNumber createLongInstance(boolean bl, String string) {
        return new PropertyEditorNumber(bl, string, NbBundle.getMessage(PropertyEditorNumber.class, (String)"LBL_LONG_UCLABEL")){

            protected void saveValue(String string) {
                if (string.length() > 0) {
                    long l = 0L;
                    try {
                        string = this.prepareText(string);
                        l = Long.parseLong(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    super.setValue((Object)MidpTypes.createLongValue(l));
                }
            }
        };
    }

    public static final PropertyEditorNumber createByteInstance(boolean bl, String string) {
        return new PropertyEditorNumber(bl, string, NbBundle.getMessage(PropertyEditorNumber.class, (String)"LBL_BYTE_UCLABEL")){

            protected void saveValue(String string) {
                if (string.length() > 0) {
                    byte by = 0;
                    try {
                        string = this.prepareText(string);
                        by = Byte.parseByte(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    super.setValue((Object)MidpTypes.createByteValue(by));
                }
            }
        };
    }

    public static final PropertyEditorNumber createShortInstance(boolean bl, String string) {
        return new PropertyEditorNumber(bl, string, NbBundle.getMessage(PropertyEditorNumber.class, (String)"LBL_SHORT_UCLABEL")){

            protected void saveValue(String string) {
                if (string.length() > 0) {
                    short s = 0;
                    try {
                        string = this.prepareText(string);
                        s = Short.parseShort(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    super.setValue((Object)MidpTypes.createShortValue(s));
                }
            }
        };
    }

    public static final PropertyEditorNumber createFloatInstance(String string) {
        return new PropertyEditorNumber(false, string, NbBundle.getMessage(PropertyEditorNumber.class, (String)"LBL_FLOAT_UCLABEL")){

            protected boolean isTextCorrect(String string) {
                return Pattern.matches("[\\d\\-\\.]+", string);
            }

            protected String prepareText(String string) {
                return string.replaceAll("[^0-9\\-\\.]+", "");
            }

            protected void saveValue(String string) {
                if (string.length() > 0) {
                    float f = 0.0f;
                    try {
                        string = this.prepareText(string);
                        f = Float.parseFloat(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    super.setValue((Object)MidpTypes.createFloatValue(f));
                }
            }
        };
    }

    public static final PropertyEditorNumber createDoubleInstance(String string) {
        return new PropertyEditorNumber(false, string, NbBundle.getMessage(PropertyEditorNumber.class, (String)"LBL_DOUBLE_UCLABEL")){

            protected boolean isTextCorrect(String string) {
                return Pattern.matches("[\\d\\-\\.]+", string);
            }

            protected String prepareText(String string) {
                return string.replaceAll("[^0-9\\-\\.]+", "");
            }

            protected void saveValue(String string) {
                if (string.length() > 0) {
                    double d = 0.0;
                    try {
                        string = this.prepareText(string);
                        d = Double.parseDouble(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    super.setValue((Object)MidpTypes.createDoubleValue(d));
                }
            }
        };
    }

    public static final PropertyEditorNumber createCharInstance(boolean bl, String string) {
        return new PropertyEditorNumber(bl, string, NbBundle.getMessage(PropertyEditorNumber.class, (String)"LBL_CHAR_UCLABEL")){

            protected boolean isTextCorrect(String string) {
                return Pattern.matches("[\\d\\-]+", string);
            }

            protected String prepareText(String string) {
                return string.replaceAll("[^0-9\\-]+", "");
            }

            protected void saveValue(String string) {
                if (string.length() > 0) {
                    char c = '\u0000';
                    try {
                        string = this.prepareText(string);
                        c = string.charAt(0);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    super.setValue((Object)MidpTypes.createCharValue(c));
                }
            }
        };
    }

    private void initComponents(boolean bl) {
        this.radioButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)this.label);
        this.radioButton.getAccessibleContext().setAccessibleName(this.radioButton.getText());
        this.radioButton.getAccessibleContext().setAccessibleDescription(this.radioButton.getText());
        this.customEditor = new CustomEditor(bl);
    }

    protected boolean isTextCorrect(String string) {
        return Pattern.matches("[\\d\\-]+", string) || this.isHexFormat(string);
    }

    protected String prepareText(String string) {
        if (string == null) {
            return string;
        }
        if (this.isHexFormat(string)) {
            string = string.replaceAll("[^0-9\\-0xabcdefABCDEF]+", "");
            return string.replace("0x", "");
        }
        return string.replaceAll("[^0-9\\-]+", "");
    }

    protected void saveValue(String string) {
        if (string.length() > 0) {
            int n = 0;
            try {
                if (this.isHexFormat(string)) {
                    string = this.prepareText(string);
                    n = Integer.parseInt(string, 16);
                } else {
                    string = this.prepareText(string);
                    n = Integer.parseInt(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (this.positiveNumersOnly && n < 0) {
                n = 0;
            }
            super.setValue((Object)MidpTypes.createIntegerValue(n));
        }
    }

    private boolean isHexFormat(String string) {
        return string != null && string.matches("-?0x[\\d\\abcdefABCDEF]+");
    }

    public JComponent getCustomEditorComponent() {
        return this.customEditor;
    }

    public JRadioButton getRadioButton() {
        return this.radioButton;
    }

    public boolean isInitiallySelected() {
        return true;
    }

    public boolean isVerticallyResizable() {
        return false;
    }

    public String getAsText() {
        String string = super.getAsText();
        if (string != null) {
            return string;
        }
        PropertyValue propertyValue = (PropertyValue)super.getValue();
        return String.valueOf(propertyValue.getPrimitiveValue());
    }

    public void setTextForPropertyValue(String string) {
        this.saveValue(string);
    }

    public String getTextForPropertyValue() {
        return null;
    }

    public void updateState(PropertyValue propertyValue) {
        if (this.isCurrentValueANull() || propertyValue == null) {
            this.customEditor.setText(null);
        } else {
            this.customEditor.setText(String.valueOf(propertyValue.getPrimitiveValue()));
        }
        this.radioButton.setSelected(!this.isCurrentValueAUserCodeType());
    }

    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        if (this.radioButton.isSelected()) {
            this.saveValue(this.customEditor.getText());
        }
    }

    private class CustomEditor
    extends JPanel
    implements DocumentListener,
    ChangeListener,
    FocusListener {
        private JTextField textField;
        private JSpinner spinner;
        private boolean useSpinner;

        public CustomEditor(boolean bl) {
            this.useSpinner = bl;
            PropertyEditorNumber.this.radioButton.addFocusListener(this);
            this.initComponents();
            this.addHierarchyListener(new HierarchyListener(){

                public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                    JDialog jDialog = CustomEditor.this.getDialog();
                    if (jDialog == null) {
                        return;
                    }
                    jDialog.getAccessibleContext().setAccessibleName(PropertyEditorNumber.this.radioButton.getAccessibleContext().getAccessibleName());
                    jDialog.getAccessibleContext().setAccessibleDescription(PropertyEditorNumber.this.radioButton.getAccessibleContext().getAccessibleDescription());
                }
            });
        }

        void cleanUp() {
            if (this.textField != null && this.textField.getDocument() != null) {
                this.textField.getDocument().removeDocumentListener(this);
            }
            this.textField = null;
            this.spinner = null;
            this.removeAll();
        }

        private JDialog getDialog() {
            Container container = this;
            while ((container = container.getParent()) != null) {
                if (!(container instanceof JDialog)) continue;
                return (JDialog)container;
            }
            return null;
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            if (this.useSpinner) {
                this.spinner = new JSpinner();
                this.spinner.getModel().addChangeListener(this);
                this.spinner.addFocusListener(this);
                this.add((Component)this.spinner, "Center");
                this.spinner.getAccessibleContext().setAccessibleName(PropertyEditorNumber.this.radioButton.getAccessibleContext().getAccessibleName());
                this.spinner.getAccessibleContext().setAccessibleDescription(PropertyEditorNumber.this.radioButton.getAccessibleContext().getAccessibleDescription());
            } else {
                this.textField = new JTextField();
                this.textField.getDocument().addDocumentListener(this);
                this.textField.addFocusListener(this);
                this.add((Component)this.textField, "Center");
                this.textField.getAccessibleContext().setAccessibleName(PropertyEditorNumber.this.radioButton.getAccessibleContext().getAccessibleName());
                this.textField.getAccessibleContext().setAccessibleDescription(PropertyEditorNumber.this.radioButton.getAccessibleContext().getAccessibleDescription());
            }
        }

        public void setText(String string) {
            if (this.useSpinner) {
                Integer n = 0;
                try {
                    if (PropertyEditorNumber.this.isHexFormat(string)) {
                        string = PropertyEditorNumber.this.prepareText(string);
                        n = Integer.parseInt(string, 16);
                    } else {
                        string = PropertyEditorNumber.this.prepareText(string);
                        n = Integer.parseInt(string);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.spinner.setValue(n);
            } else {
                this.textField.setText(string);
            }
        }

        public String getText() {
            return this.useSpinner ? this.spinner.getValue().toString() : this.textField.getText();
        }

        private void checkNumberStatus() {
            if (!PropertyEditorNumber.this.isTextCorrect(this.getText())) {
                PropertyEditorNumber.this.displayWarning(NON_DIGITS_TEXT);
                return;
            }
            if (PropertyEditorNumber.this.positiveNumersOnly) {
                try {
                    int n = Integer.valueOf(this.textField.getText());
                    if (n < 0) {
                        PropertyEditorNumber.this.displayWarning(NbBundle.getMessage(PropertyEditorPreferredSize.class, (String)"MSG_POSITIVE_CHARS"));
                        return;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    PropertyEditorNumber.this.displayWarning(NON_DIGITS_TEXT);
                    return;
                }
            }
            PropertyEditorNumber.this.clearErrorStatus();
        }

        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.getSource() == this.textField || focusEvent.getSource() == this.spinner) {
                PropertyEditorNumber.this.radioButton.setSelected(true);
                this.checkNumberStatus();
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            PropertyEditorNumber.this.clearErrorStatus();
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (this.spinner.hasFocus()) {
                PropertyEditorNumber.this.radioButton.setSelected(true);
                this.checkNumberStatus();
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            if (this.textField.hasFocus()) {
                PropertyEditorNumber.this.radioButton.setSelected(true);
                this.checkNumberStatus();
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            if (this.textField.hasFocus()) {
                PropertyEditorNumber.this.radioButton.setSelected(true);
                this.checkNumberStatus();
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }
}

