/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collections;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.displayables.AlertCD;
import org.netbeans.modules.vmd.midp.propertyeditors.PropertyEditorNumber;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class PropertyEditorTimeout
extends PropertyEditorUserCode
implements PropertyEditorElement {
    private static final String FOREVER_TEXT = NbBundle.getMessage(PropertyEditorTimeout.class, (String)"LBL_TIMEOUTPE_FOREVER_TXT");
    private static final String FOREVER_NUM_TEXT = String.valueOf(AlertCD.FOREVER_VALUE.getPrimitiveValue());
    private CustomEditor customEditor;
    private JRadioButton radioButton;

    private PropertyEditorTimeout() {
        super(NbBundle.getMessage(PropertyEditorTimeout.class, (String)"LBL_TIMEOUT_UCLABEL"));
        this.initComponents();
        this.initElements(Collections.singleton(this));
    }

    public static final PropertyEditorTimeout createInstance() {
        return new PropertyEditorTimeout();
    }

    public void cleanUp(DesignComponent designComponent) {
        super.cleanUp(designComponent);
        if (this.customEditor != null) {
            this.customEditor.cleanUp();
            this.customEditor = null;
        }
        this.radioButton = null;
    }

    private void initComponents() {
        this.radioButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)NbBundle.getMessage(PropertyEditorTimeout.class, (String)"LBL_TIMEOUT_STR"));
        this.radioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertyEditorTimeout.class, (String)"ACSN_TIMEOUT_STR"));
        this.radioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertyEditorTimeout.class, (String)"ACSD_TIMEOUT_STR"));
        this.customEditor = new CustomEditor();
    }

    public JComponent getCustomEditorComponent() {
        return this.customEditor;
    }

    public JRadioButton getRadioButton() {
        return this.radioButton;
    }

    public boolean isInitiallySelected() {
        return true;
    }

    public boolean isVerticallyResizable() {
        return false;
    }

    public String getAsText() {
        String string = super.getAsText();
        if (string != null) {
            return string;
        }
        Object object = ((PropertyValue)super.getValue()).getPrimitiveValue();
        Object object2 = AlertCD.FOREVER_VALUE.getPrimitiveValue();
        if (object2.equals(object)) {
            return FOREVER_TEXT;
        }
        return String.valueOf(object);
    }

    public void setTextForPropertyValue(String string) {
        this.saveValue(string);
    }

    public String getTextForPropertyValue() {
        return null;
    }

    public void updateState(PropertyValue propertyValue) {
        if (this.isCurrentValueANull() || propertyValue == null) {
            this.customEditor.unsetForever(true);
        } else if (AlertCD.FOREVER_VALUE.getPrimitiveValue().equals(propertyValue.getPrimitiveValue())) {
            this.customEditor.setForever(true);
        } else {
            this.customEditor.unsetForever(true);
            this.customEditor.setText(String.valueOf(propertyValue.getPrimitiveValue()));
        }
        this.radioButton.setSelected(!this.isCurrentValueAUserCodeType());
    }

    private void saveValue(String string) {
        if (string.length() > 0) {
            if (FOREVER_TEXT.equals(string) || FOREVER_NUM_TEXT.equals(string)) {
                super.setValue((Object)AlertCD.FOREVER_VALUE);
                return;
            }
            int n = 0;
            try {
                string = string.replaceAll("[^0-9\\-]+", "");
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            super.setValue((Object)MidpTypes.createIntegerValue(n));
        }
    }

    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        if (this.radioButton.isSelected()) {
            this.saveValue(this.customEditor.getText());
        }
    }

    public Boolean canEditAsText() {
        if (!this.isCurrentValueAUserCodeType()) {
            PropertyValue propertyValue = (PropertyValue)super.getValue();
            if (propertyValue == null) {
                return false;
            }
            Object object = AlertCD.FOREVER_VALUE.getPrimitiveValue();
            return !object.equals(propertyValue.getPrimitiveValue());
        }
        return false;
    }

    private class CustomEditor
    extends JPanel
    implements ActionListener,
    DocumentListener,
    FocusListener {
        private JTextField textField;
        private JCheckBox foreverCheckBox;

        public CustomEditor() {
            PropertyEditorTimeout.this.radioButton.addFocusListener(this);
            this.initComponents();
        }

        void cleanUp() {
            if (this.textField != null && this.textField.getDocument() != null) {
                this.textField.getDocument().removeDocumentListener(this);
            }
            this.textField = null;
            this.foreverCheckBox = null;
            this.removeAll();
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.foreverCheckBox = new JCheckBox();
            this.foreverCheckBox.addActionListener(this);
            this.foreverCheckBox.addFocusListener(this);
            Mnemonics.setLocalizedText((AbstractButton)this.foreverCheckBox, (String)NbBundle.getMessage(PropertyEditorTimeout.class, (String)"LBL_TIMEOUTPE_FOREVER"));
            this.add((Component)this.foreverCheckBox, "North");
            this.foreverCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertyEditorTimeout.class, (String)"ACSN_TIMEOUTPE_FOREVER"));
            this.foreverCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertyEditorTimeout.class, (String)"ACSD_TIMEOUTPE_FOREVER"));
            this.textField = new JTextField();
            this.textField.getDocument().addDocumentListener(this);
            this.textField.addFocusListener(this);
            this.add((Component)this.textField, "South");
            this.textField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertyEditorTimeout.class, (String)"ACSN_TIMEOUTPE_VALUE"));
            this.textField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertyEditorTimeout.class, (String)"ACSD_TIMEOUTPE_VALUE"));
        }

        public void setText(String string) {
            this.textField.setText(string);
        }

        public String getText() {
            return this.textField.getText();
        }

        public void setForever(boolean bl) {
            this.setText(FOREVER_NUM_TEXT);
            this.textField.setEditable(false);
            if (bl) {
                this.foreverCheckBox.setSelected(true);
            }
        }

        public void unsetForever(boolean bl) {
            this.setText(null);
            this.textField.setEditable(true);
            if (bl) {
                this.foreverCheckBox.setSelected(false);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.foreverCheckBox.isSelected()) {
                this.setForever(false);
            } else {
                this.unsetForever(false);
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            if (this.textField.hasFocus()) {
                PropertyEditorTimeout.this.radioButton.setSelected(true);
                this.checkNumberStatus();
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            if (this.textField.hasFocus()) {
                PropertyEditorTimeout.this.radioButton.setSelected(true);
                this.checkNumberStatus();
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        private void checkNumberStatus() {
            if (!Pattern.matches("[\\d\\-]+", this.textField.getText())) {
                PropertyEditorTimeout.this.displayWarning(PropertyEditorNumber.NON_DIGITS_TEXT);
            } else {
                PropertyEditorTimeout.this.clearErrorStatus();
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.getSource() == PropertyEditorTimeout.this.radioButton || focusEvent.getSource() == this.textField || focusEvent.getSource() == this.foreverCheckBox) {
                this.checkNumberStatus();
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            PropertyEditorTimeout.this.clearErrorStatus();
        }
    }
}

