/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors.api.usercode;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.undo.UndoManager;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ui.DialogBinding;
import org.netbeans.editor.ActionFactory;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.ProjectUtils;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.properties.DesignPropertyEditor;
import org.netbeans.modules.vmd.midp.propertyeditors.CleanUp;
import org.netbeans.modules.vmd.midp.propertyeditors.MidpPropertyEditorSupport;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.CodeUtils;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorMessageAwareness;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyEditorUserCode
extends DesignPropertyEditor
implements PropertyEditorMessageAwareness {
    public static final PropertyValue NULL_VALUE = PropertyValue.createNull();
    public static final String NULL_TEXT = NbBundle.getMessage(PropertyEditorUserCode.class, (String)"LBL_STRING_NULL");
    public static final String USER_CODE_TEXT = NbBundle.getMessage(PropertyEditorUserCode.class, (String)"LBL_STRING_USER_CODE");
    private static final Icon ICON_WARNING = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/vmd/midp/resources/warning.gif"));
    private static final Icon ICON_ERROR = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/vmd/midp/resources/error.gif"));
    private CustomEditor customEditor;
    private JRadioButton userCodeRadioButton;
    private JLabel messageLabel;
    private String userCodeLabel;
    private String userCode = "";
    protected WeakReference<DesignComponent> component;

    public void cleanUp(DesignComponent designComponent) {
        super.cleanUp(designComponent);
        if (this.customEditor != null) {
            this.customEditor.cleanUp();
            this.customEditor = null;
        }
        this.userCodeRadioButton = null;
        this.messageLabel = null;
        this.component = null;
    }

    protected PropertyEditorUserCode(String string) {
        this.userCodeLabel = string;
        this.messageLabel = new JLabel(" ");
        Color color = UIManager.getColor("nb.errorForeground");
        if (color == null) {
            color = new Color(255, 0, 0);
        }
        this.messageLabel.setForeground(color);
        this.customEditor = new CustomEditor();
    }

    protected void initElements(Collection<PropertyEditorElement> collection) {
        this.customEditor.init(collection);
    }

    protected void initElements(LinkedHashMap<PropertyEditorElement, Integer> linkedHashMap) {
        this.customEditor.init(linkedHashMap);
    }

    protected JRadioButton getUserCodeRadioButton() {
        return this.userCodeRadioButton;
    }

    public void init(DesignComponent designComponent) {
        if (designComponent != null) {
            this.component = new WeakReference<DesignComponent>(designComponent);
        }
    }

    public Component getCustomEditor() {
        this.initCustomEditor();
        return this.customEditor;
    }

    private void initCustomEditor() {
        PropertyValue propertyValue = (PropertyValue)super.getValue();
        if (this.isCurrentValueAUserCodeType()) {
            this.customEditor.setUserCodeText(propertyValue.getUserCode());
            this.customEditor.updateState(null);
        } else {
            this.customEditor.setUserCodeText(null);
            this.customEditor.updateState(propertyValue);
        }
    }

    public boolean isExecuteInsideWriteTransactionUsed() {
        return false;
    }

    public String getAsText() {
        if (this.isCurrentValueAUserCodeType()) {
            return USER_CODE_TEXT;
        }
        if (this.isCurrentValueANull()) {
            return NULL_TEXT;
        }
        return null;
    }

    public void setAsText(String string) {
        if (this.canWrite()) {
            if (string.equals(NULL_TEXT)) {
                super.setValue((Object)NULL_VALUE);
            } else {
                this.customEditor.setText(string);
            }
        }
    }

    public Boolean canEditAsText() {
        if (this.isCurrentValueAUserCodeType()) {
            return false;
        }
        return MidpPropertyEditorSupport.singleSelectionEditAsTextOnly();
    }

    public boolean canWrite() {
        return MidpPropertyEditorSupport.singleSelectionEditAsTextOnly();
    }

    public void customEditorOKButtonPressed() {
        if (this.userCodeRadioButton.isSelected()) {
            this.customEditor.setNewValue();
            PropertyEditorUserCode.super.setValue(PropertyValue.createUserCode((String)this.userCode));
        }
    }

    protected boolean isCurrentValueAUserCodeType() {
        PropertyValue propertyValue = (PropertyValue)super.getValue();
        return propertyValue != null && propertyValue.getKind() == PropertyValue.Kind.USERCODE;
    }

    protected boolean isCurrentValueANull() {
        PropertyValue propertyValue = (PropertyValue)super.getValue();
        return propertyValue == null || propertyValue.getKind() == PropertyValue.Kind.NULL;
    }

    @Override
    public void displayWarning(String string) {
        this.messageLabel.setText(string);
        this.messageLabel.setIcon(ICON_WARNING);
    }

    @Override
    public void displayError(String string) {
        this.messageLabel.setText(string);
        this.messageLabel.setIcon(ICON_ERROR);
    }

    @Override
    public void clearErrorStatus() {
        this.messageLabel.setText(" ");
        this.messageLabel.setIcon(null);
    }

    private static void setupTextUndoRedo(JTextComponent jTextComponent) {
        String string = System.getProperty("os.name").toLowerCase();
        ActionFactory.RedoAction redoAction = null;
        KeyStroke[] keyStrokeArray = null;
        if (string.indexOf("mac") != -1) {
            redoAction = new ActionFactory.RedoAction[]{KeyStroke.getKeyStroke(65483, 0), KeyStroke.getKeyStroke(90, 4)};
            keyStrokeArray = new KeyStroke[]{KeyStroke.getKeyStroke(65481, 0), KeyStroke.getKeyStroke(89, 4)};
        } else {
            redoAction = new KeyStroke[]{KeyStroke.getKeyStroke(65483, 0), KeyStroke.getKeyStroke(90, 130)};
            keyStrokeArray = new KeyStroke[]{KeyStroke.getKeyStroke(65481, 0), KeyStroke.getKeyStroke(89, 130)};
        }
        Keymap keymap = jTextComponent.getKeymap();
        ActionFactory.UndoAction undoAction = new ActionFactory.UndoAction();
        for (KeyStroke keyStroke : redoAction) {
            keymap.removeKeyStrokeBinding(keyStroke);
            keymap.addActionForKeyStroke(keyStroke, (Action)undoAction);
        }
        ActionFactory.RedoAction redoAction2 = new ActionFactory.RedoAction();
        for (KeyStroke keyStroke : keyStrokeArray) {
            keymap.removeKeyStrokeBinding(keyStroke);
            keymap.addActionForKeyStroke(keyStroke, (Action)redoAction2);
        }
        Object object = jTextComponent.getDocument().getProperty("undo-manager");
        if (object instanceof UndoManager) {
            jTextComponent.getDocument().removeUndoableEditListener((UndoManager)object);
        }
        UndoManager undoManager = new UndoManager();
        jTextComponent.getDocument().addUndoableEditListener(undoManager);
        jTextComponent.getDocument().putProperty("undo-manager", undoManager);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CustomEditor
    extends JPanel
    implements DocumentListener,
    ActionListener,
    FocusListener {
        private Collection<PropertyEditorElement> elements;
        private Map<PropertyEditorElement, Integer> elementsMap;
        private JEditorPane userCodeEditorPane;

        private CustomEditor() {
        }

        public void init(Collection<PropertyEditorElement> collection) {
            this.elements = collection;
            this.initComponents();
        }

        public void init(Map<PropertyEditorElement, Integer> map) {
            this.elementsMap = map;
            this.elements = map.keySet();
            this.initComponents();
        }

        void cleanUp() {
            if (this.elementsMap != null) {
                for (PropertyEditorElement propertyEditorElement : this.elementsMap.keySet()) {
                    if (!(propertyEditorElement instanceof CleanUp)) continue;
                    ((CleanUp)((Object)propertyEditorElement)).clean(null);
                }
                this.elementsMap.clear();
                this.elementsMap = null;
            }
            if (this.elements != null) {
                this.elements = null;
            }
            if (this.userCodeEditorPane != null && this.userCodeEditorPane.getDocument() != null) {
                this.userCodeEditorPane.getDocument().removeDocumentListener(this);
                this.userCodeEditorPane = null;
            }
            this.removeAll();
        }

        private void initComponents() {
            this.setLayout(new GridBagLayout());
            ButtonGroup buttonGroup = new ButtonGroup();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            boolean bl = false;
            for (PropertyEditorElement object : this.elements) {
                if (this.elementsMap == null || this.elementsMap != null && this.elementsMap.get(object) == null) {
                    JRadioButton jRadioButton = object.getRadioButton();
                    buttonGroup.add(jRadioButton);
                    gridBagConstraints.insets = new Insets(12, 12, 6, 12);
                    gridBagConstraints.anchor = 18;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridy = -1;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.weighty = 0.0;
                    gridBagConstraints.fill = 2;
                    this.add((Component)jRadioButton, gridBagConstraints);
                    gridBagConstraints.insets = new Insets(0, 32, 12, 12);
                    gridBagConstraints.anchor = 18;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridy = -1;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.weighty = object.isVerticallyResizable() ? 1.0 : 0.0;
                    gridBagConstraints.fill = object.isVerticallyResizable() ? 1 : 2;
                    this.add((Component)object.getCustomEditorComponent(), gridBagConstraints);
                }
                if (!object.isVerticallyResizable()) continue;
                bl = true;
            }
            PropertyEditorUserCode.this.userCodeRadioButton = new JRadioButton();
            Mnemonics.setLocalizedText((AbstractButton)PropertyEditorUserCode.this.userCodeRadioButton, (String)NbBundle.getMessage(PropertyEditorUserCode.class, (String)"LBL_USER_CODE", (Object)PropertyEditorUserCode.this.userCodeLabel));
            PropertyEditorUserCode.this.userCodeRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertyEditorUserCode.class, (String)"ACSN_USER_CODE", (Object)PropertyEditorUserCode.this.userCodeLabel));
            PropertyEditorUserCode.this.userCodeRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertyEditorUserCode.class, (String)"ACSD_USER_CODE", (Object)PropertyEditorUserCode.this.userCodeLabel));
            PropertyEditorUserCode.this.userCodeRadioButton.addActionListener(this);
            buttonGroup.add(PropertyEditorUserCode.this.userCodeRadioButton);
            gridBagConstraints.insets = new Insets(12, 12, 6, 12);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = -1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            this.add((Component)PropertyEditorUserCode.this.userCodeRadioButton, gridBagConstraints);
            JScrollPane jScrollPane = new JScrollPane();
            this.userCodeEditorPane = new JEditorPane();
            this.userCodeEditorPane.getAccessibleContext().setAccessibleName(PropertyEditorUserCode.this.userCodeRadioButton.getAccessibleContext().getAccessibleName());
            this.userCodeEditorPane.getAccessibleContext().setAccessibleDescription(PropertyEditorUserCode.this.userCodeRadioButton.getAccessibleContext().getAccessibleDescription());
            this.userCodeEditorPane.addFocusListener(this);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CustomEditor.this.userCodeEditorPane.setContentType("text/x-java");
                    CustomEditor.this.userCodeEditorPane.getDocument().addDocumentListener(CustomEditor.this);
                }
            });
            jScrollPane.setViewportView(this.userCodeEditorPane);
            jScrollPane.setPreferredSize(new Dimension(400, 100));
            jScrollPane.setMinimumSize(new Dimension(400, 100));
            gridBagConstraints.insets = new Insets(0, 32, 12, 12);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = -1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = bl ? 0.0 : 1.0;
            gridBagConstraints.fill = bl ? 2 : 1;
            this.add((Component)jScrollPane, gridBagConstraints);
            for (PropertyEditorElement propertyEditorElement : this.elements) {
                if (this.elementsMap != null && this.elementsMap.get(propertyEditorElement) != null) {
                    JRadioButton jRadioButton = propertyEditorElement.getRadioButton();
                    buttonGroup.add(jRadioButton);
                    gridBagConstraints.insets = new Insets(12, 12, 6, 12);
                    gridBagConstraints.anchor = 18;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridy = -1;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.weighty = 0.0;
                    gridBagConstraints.fill = 2;
                    this.add((Component)jRadioButton, gridBagConstraints);
                    gridBagConstraints.insets = new Insets(0, 32, 12, 12);
                    gridBagConstraints.anchor = 18;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridy = -1;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.weighty = propertyEditorElement.isVerticallyResizable() ? 1.0 : 0.0;
                    gridBagConstraints.fill = propertyEditorElement.isVerticallyResizable() ? 1 : 2;
                    this.add((Component)propertyEditorElement.getCustomEditorComponent(), gridBagConstraints);
                }
                if (!propertyEditorElement.isVerticallyResizable()) continue;
                bl = true;
            }
            gridBagConstraints.insets = new Insets(0, 12, 0, 12);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = -1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            this.add((Component)PropertyEditorUserCode.this.messageLabel, gridBagConstraints);
            this.selectDefaultRadioButton();
        }

        public void initRetoucheStuff() {
            if (PropertyEditorUserCode.this.component == null || PropertyEditorUserCode.this.component.get() == null) {
                return;
            }
            DesignComponent designComponent = (DesignComponent)PropertyEditorUserCode.this.component.get();
            Document document = this.userCodeEditorPane.getDocument();
            if (document.getProperty(JavaSource.class) == null) {
                DataObjectContext dataObjectContext = ProjectUtils.getDataObjectContextForDocument((DesignDocument)designComponent.getDocument());
                document.putProperty("stream", dataObjectContext.getDataObject());
                int n = CodeUtils.getMethodOffset(dataObjectContext);
                DialogBinding.bindComponentToFile((FileObject)dataObjectContext.getDataObject().getPrimaryFile(), (int)n, (int)0, (JTextComponent)this.userCodeEditorPane);
                PropertyEditorUserCode.setupTextUndoRedo(this.userCodeEditorPane);
            }
        }

        public void updateState(PropertyValue propertyValue) {
            for (PropertyEditorElement propertyEditorElement : this.elements) {
                propertyEditorElement.updateState(propertyValue);
            }
        }

        public void setText(String string) {
            for (PropertyEditorElement propertyEditorElement : this.elements) {
                propertyEditorElement.setTextForPropertyValue(string);
            }
        }

        public void setUserCodeText(String string) {
            if (string != null) {
                this.userCodeEditorPane.setText(string);
                PropertyEditorUserCode.this.userCodeRadioButton.setSelected(true);
                PropertyEditorUserCode.this.userCodeRadioButton.requestFocus();
            } else {
                this.userCodeEditorPane.setText(null);
                this.selectDefaultRadioButton();
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            if (this.userCodeEditorPane.hasFocus()) {
                PropertyEditorUserCode.this.userCodeRadioButton.setSelected(true);
                this.setNewValue();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            if (this.userCodeEditorPane.hasFocus()) {
                PropertyEditorUserCode.this.userCodeRadioButton.setSelected(true);
                this.setNewValue();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.setNewValue();
        }

        @Override
        public void addNotify() {
            PropertyEditorUserCode.this.customEditor.initRetoucheStuff();
            super.addNotify();
        }

        private void setNewValue() {
            PropertyEditorUserCode.this.userCode = this.userCodeEditorPane.getText();
        }

        private void selectDefaultRadioButton() {
            boolean bl = false;
            for (PropertyEditorElement propertyEditorElement : this.elements) {
                if (!propertyEditorElement.isInitiallySelected()) continue;
                propertyEditorElement.getRadioButton().setSelected(true);
                propertyEditorElement.getRadioButton().requestFocus();
                bl = true;
                break;
            }
            PropertyEditorUserCode.this.userCodeRadioButton.setSelected(!bl);
            if (!bl) {
                this.userCodeEditorPane.requestFocus();
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.getSource() == this.userCodeEditorPane) {
                PropertyEditorUserCode.this.userCodeRadioButton.setSelected(true);
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }
    }
}

