/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.screen.display;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.common.AcceptSuggestion;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfo;
import org.netbeans.modules.vmd.api.screen.display.ScreenDisplayDataFlavorSupport;
import org.netbeans.modules.vmd.api.screen.display.ScreenDisplayPresenter;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyDescriptor;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyEditor;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.MidpValueSupport;
import org.netbeans.modules.vmd.midp.screen.display.ChoiceElementDisplayPresenter;
import org.netbeans.modules.vmd.midp.screen.display.ScreenFileObjectListener;
import org.netbeans.modules.vmd.midp.screen.display.ScreenMoveArrayAcceptSuggestion;
import org.netbeans.modules.vmd.midp.screen.display.ScreenSupport;
import org.netbeans.modules.vmd.midp.screen.display.property.ScreenBooleanPropertyEditor;
import org.netbeans.modules.vmd.midp.screen.display.property.ScreenStringPropertyEditor;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListElementEventSourceDisplayPresenter
extends ScreenDisplayPresenter {
    private static final String ICON_BROKEN_PATH = "org/netbeans/modules/vmd/midp/resources/screen/broken-image.png";
    private static final Icon ICON_BROKEN = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/vmd/midp/resources/screen/broken-image.png"));
    private JPanel view = new JPanel();
    private JLabel state;
    private JLabel image;
    private JLabel label;
    private ScreenFileObjectListener imageFileListener;
    private FileObject imageFileObject;

    public ListElementEventSourceDisplayPresenter() {
        this.view.setLayout(new BoxLayout(this.view, 0));
        this.view.setOpaque(false);
        this.state = new JLabel();
        this.view.add(this.state);
        this.image = new JLabel();
        this.view.add(this.image);
        this.label = new JLabel();
        this.view.add(this.label);
        this.view.add(Box.createHorizontalGlue());
    }

    public boolean isTopLevelDisplay() {
        return false;
    }

    public Collection<DesignComponent> getChildren() {
        return Collections.emptyList();
    }

    public JComponent getView() {
        return this.view;
    }

    public void reload(ScreenDeviceInfo screenDeviceInfo) {
        PropertyValue propertyValue = this.getComponent().getParentComponent().readProperty("listType");
        int n = !PropertyValue.Kind.USERCODE.equals((Object)propertyValue.getKind()) ? MidpTypes.getInteger(propertyValue) : 1;
        PropertyValue propertyValue2 = this.getComponent().readProperty("selected");
        boolean bl = propertyValue2.getKind() == PropertyValue.Kind.VALUE && MidpTypes.getBoolean(propertyValue2);
        switch (n) {
            case 1: {
                this.state.setIcon(bl ? ChoiceElementDisplayPresenter.ICON_RADIOBUTTON : ChoiceElementDisplayPresenter.ICON_EMPTY_RADIOBUTTON);
                break;
            }
            case 2: {
                this.state.setIcon(bl ? ChoiceElementDisplayPresenter.ICON_CHECKBOX : ChoiceElementDisplayPresenter.ICON_EMPTY_CHECKBOX);
                break;
            }
            default: {
                this.state.setIcon(null);
            }
        }
        DesignComponent designComponent = null;
        String string = null;
        propertyValue = this.getComponent().readProperty("image");
        if (!PropertyValue.Kind.USERCODE.equals((Object)propertyValue.getKind())) {
            designComponent = propertyValue.getComponent();
        }
        if (designComponent != null) {
            string = (String)designComponent.readProperty("resourcePath").getPrimitiveValue();
        }
        Icon icon = ScreenSupport.getIconFromImageComponent(designComponent);
        this.imageFileObject = ScreenSupport.getFileObjectFromImageComponent(designComponent);
        if (this.imageFileObject != null) {
            this.imageFileObject.removeFileChangeListener((FileChangeListener)this.imageFileListener);
            this.imageFileListener = new ScreenFileObjectListener(this.getRelatedComponent(), designComponent, "resourcePath");
            this.imageFileObject.addFileChangeListener((FileChangeListener)this.imageFileListener);
        }
        if (icon != null) {
            this.image.setIcon(icon);
        } else if (string != null) {
            this.image.setIcon(ICON_BROKEN);
        } else {
            this.image.setIcon(null);
        }
        String string2 = MidpValueSupport.getHumanReadableString(this.getComponent().readProperty("string"));
        this.label.setText(string2);
        propertyValue = this.getComponent().readProperty("font");
        if (!PropertyValue.Kind.USERCODE.equals((Object)propertyValue.getKind())) {
            DesignComponent designComponent2 = propertyValue.getComponent();
            this.label.setFont(ScreenSupport.getFont(screenDeviceInfo, designComponent2));
        }
    }

    public Shape getSelectionShape() {
        return new Rectangle(this.view.getSize());
    }

    public Collection<ScreenPropertyDescriptor> getPropertyDescriptors() {
        return Arrays.asList(new ScreenPropertyDescriptor(this.getComponent(), (JComponent)this.state, (ScreenPropertyEditor)new ScreenBooleanPropertyEditor("selected")), new ScreenPropertyDescriptor(this.getComponent(), (JComponent)this.label, (ScreenPropertyEditor)new ScreenStringPropertyEditor("string")));
    }

    public boolean isDraggable() {
        return true;
    }

    public AcceptSuggestion createSuggestion(Transferable transferable) {
        if (!transferable.isDataFlavorSupported(ScreenDisplayDataFlavorSupport.HORIZONTAL_POSITION_DATA_FLAVOR)) {
            return null;
        }
        if (!transferable.isDataFlavorSupported(ScreenDisplayDataFlavorSupport.VERTICAL_POSITION_DATA_FLAVOR)) {
            return null;
        }
        ScreenDeviceInfo.Edge edge = null;
        ScreenDeviceInfo.Edge edge2 = null;
        try {
            edge = (ScreenDeviceInfo.Edge)transferable.getTransferData(ScreenDisplayDataFlavorSupport.HORIZONTAL_POSITION_DATA_FLAVOR);
            edge2 = (ScreenDeviceInfo.Edge)transferable.getTransferData(ScreenDisplayDataFlavorSupport.VERTICAL_POSITION_DATA_FLAVOR);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            Exceptions.printStackTrace((Throwable)unsupportedFlavorException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return new ScreenMoveArrayAcceptSuggestion(edge, edge2);
    }
}

