/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.syntaxerr;

import java.util.ArrayList;
import java.util.Collection;
import javax.swing.text.Document;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorInfo;
import org.netbeans.modules.cnd.api.model.xref.CsmIncludeHierarchyResolver;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.modelutil.NamedEntity;
import org.netbeans.modules.cnd.modelutil.NamedEntityOptions;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public abstract class CsmErrorProvider
implements NamedEntity {
    private static final boolean ENABLE = CsmErrorProvider.getBoolean("cnd.csm.errors", true);
    private static final boolean ASYNC = CsmErrorProvider.getBoolean("cnd.csm.errors.async", true);
    private static CsmErrorProvider DEFAULT = ASYNC ? new AsynchronousMerger() : new SynchronousMerger();

    public final void getErrors(Request request, Response response) {
        if (this.validate(request)) {
            this.doGetErrors(request, response);
        }
        response.done();
    }

    protected boolean validate(Request request) {
        return NamedEntityOptions.instance().isEnabled((NamedEntity)this) && !request.isCancelled();
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    protected abstract void doGetErrors(Request var1, Response var2);

    public static boolean disableAsLibraryHeaderFile(CsmFile csmFile) {
        return CndUtils.isReleaseMode() && csmFile != null && csmFile.isHeaderFile() && csmFile.getProject() != null && csmFile.getProject().isArtificial();
    }

    public static final synchronized CsmErrorProvider getDefault() {
        return DEFAULT;
    }

    private static boolean getBoolean(String string, boolean bl) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            bl = Boolean.parseBoolean(string2);
        }
        return bl;
    }

    private static boolean isPartial(CsmFile csmFile) {
        Collection<CsmReference> collection = CsmIncludeHierarchyResolver.getDefault().getIncludes(csmFile);
        for (CsmReference csmReference : collection) {
            if (csmReference == null) continue;
            int n = csmReference.getStartOffset();
            CsmFile csmFile2 = csmReference.getContainingFile();
            if (csmFile2 == null) continue;
            for (CsmOffsetableDeclaration csmOffsetableDeclaration : csmFile2.getDeclarations()) {
                if (csmOffsetableDeclaration.getStartOffset() > n || n >= csmOffsetableDeclaration.getEndOffset()) continue;
                return true;
            }
        }
        return false;
    }

    private static class AsynchronousMerger
    extends BaseMerger {
        private AsynchronousMerger() {
        }

        public void getErrorsImpl(final Request request, final Response response) {
            ArrayList<RequestProcessor.Task> arrayList = new ArrayList<RequestProcessor.Task>();
            for (final CsmErrorProvider csmErrorProvider : this.res.allInstances()) {
                if (request.isCancelled()) break;
                RequestProcessor.Task task = RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        if (!request.isCancelled()) {
                            csmErrorProvider.getErrors(request, response);
                        }
                    }
                });
                arrayList.add(task);
            }
            for (RequestProcessor.Task task : arrayList) {
                task.waitFinished();
            }
        }
    }

    private static class SynchronousMerger
    extends BaseMerger {
        private SynchronousMerger() {
        }

        public void getErrorsImpl(Request request, Response response) {
            for (CsmErrorProvider csmErrorProvider : this.res.allInstances()) {
                if (request.isCancelled()) break;
                csmErrorProvider.getErrors(request, response);
            }
        }
    }

    private static abstract class BaseMerger
    extends CsmErrorProvider {
        protected final Lookup.Result<CsmErrorProvider> res = Lookup.getDefault().lookupResult(CsmErrorProvider.class);

        protected abstract void getErrorsImpl(Request var1, Response var2);

        protected boolean validate(Request request) {
            return ENABLE;
        }

        public void doGetErrors(Request request, Response response) {
            if (!CsmErrorProvider.isPartial(request.getFile())) {
                this.getErrorsImpl(request, response);
            }
        }

        public String getName() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    public static interface Response {
        public void addError(CsmErrorInfo var1);

        public void done();
    }

    public static interface Request {
        public CsmFile getFile();

        public boolean isCancelled();

        public Document getDocument();
    }
}

