/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.model.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.modules.cnd.api.model.CsmChangeEvent;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmModelListener;
import org.netbeans.modules.cnd.api.model.CsmProgressAdapter;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmStandaloneFileProvider;
import org.netbeans.modules.cnd.model.tasks.CsmFileTaskFactoryManager;
import org.netbeans.modules.cnd.model.tasks.OpenedEditors;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CsmFileTaskFactory {
    private final Map<FileObject, CsmFile> fobj2csm = new HashMap<FileObject, CsmFile>();
    private final Map<CsmFile, Pair> csm2task = new HashMap<CsmFile, Pair>();
    private final ProgressListener progressListener = new ProgressListener();
    private final ModelListener modelListener = new ModelListener();
    private static final int DELAY = 500;
    private static final int IMMEDIATELY = 0;
    private static RequestProcessor WORKER = new RequestProcessor("CsmFileTaskFactory", 1);
    private static RequestProcessor HIGH_PRIORITY_WORKER = new RequestProcessor("CsmHighPriorityFileTaskFactory", 1);
    private static RequestProcessor DECISION_WORKER = new RequestProcessor("CsmDecisionFileTaskFactory", 1);

    protected CsmFileTaskFactory() {
        CsmListeners.getDefault().addProgressListener((CsmProgressListener)this.progressListener);
        CsmListeners.getDefault().addModelListener((CsmModelListener)this.modelListener);
    }

    protected abstract PhaseRunner createTask(FileObject var1);

    protected abstract Collection<FileObject> getFileObjects();

    protected final void fileObjectsChanged() {
        final HashSet<FileObject> hashSet = new HashSet<FileObject>(this.getFileObjects());
        final long l = Math.round(100.0 * Math.random());
        final String string = this.getClass().getName();
        if (OpenedEditors.SHOW_TIME) {
            System.err.println("CsmFileTaskFactory: POST worker " + l);
        }
        DECISION_WORKER.post(new Runnable(){

            public void run() {
                long l2 = System.currentTimeMillis();
                if (OpenedEditors.SHOW_TIME) {
                    System.err.println("CsmFileTaskFactory: RUN worker " + l + " [" + string + "]");
                }
                CsmFileTaskFactory.this.stateChangedImpl(hashSet);
                if (OpenedEditors.SHOW_TIME) {
                    System.err.println("CsmFileTaskFactory: DONE worker " + l + " after " + (System.currentTimeMillis() - l2) + "ms.");
                }
            }
        });
    }

    private boolean checkMimeType(FileObject fileObject) {
        if (fileObject == null) {
            return false;
        }
        String string = fileObject.getMIMEType();
        return "text/x-c++".equals(string) || "text/x-c".equals(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stateChangedImpl(Collection<FileObject> collection) {
        Object object;
        Object object2;
        HashMap<CsmFile, Pair> hashMap = new HashMap<CsmFile, Pair>();
        HashMap<CsmFile, Pair> hashMap2 = new HashMap<CsmFile, Pair>();
        Iterator iterator = this;
        synchronized (iterator) {
            Object object3;
            Object object4;
            CsmFile csmFile;
            CsmFile csmFile2;
            Object object5;
            Map.Entry entry = new ArrayList<FileObject>(collection);
            object2 = new ArrayList<FileObject>(this.fobj2csm.keySet());
            entry.removeAll(this.fobj2csm.keySet());
            object2.removeAll(collection);
            object = object2.iterator();
            while (object.hasNext()) {
                object5 = (FileObject)object.next();
                csmFile2 = this.fobj2csm.remove(object5);
                if (csmFile2 == null) continue;
                hashMap.put(csmFile2, this.csm2task.remove(csmFile2));
            }
            object = new ArrayList<FileObject>(this.fobj2csm.keySet());
            object5 = object.iterator();
            while (object5.hasNext()) {
                csmFile2 = (FileObject)object5.next();
                if (csmFile2 == null || !csmFile2.isValid() || !this.checkMimeType((FileObject)csmFile2)) continue;
                csmFile = CsmUtilities.getCsmFile((FileObject)csmFile2, (boolean)false);
                if (csmFile == null) {
                    csmFile = CsmStandaloneFileProvider.getDefault().getCsmFile((FileObject)csmFile2);
                }
                if (csmFile == null || csmFile.equals(object4 = this.fobj2csm.get(csmFile2))) continue;
                this.fobj2csm.remove(csmFile2);
                hashMap.put(csmFile, this.csm2task.remove(object4));
                object3 = this.createTask((FileObject)csmFile2);
                Pair pair = new Pair((PhaseRunner)object3);
                hashMap2.put(csmFile, pair);
                this.fobj2csm.put((FileObject)csmFile2, csmFile);
                this.csm2task.put(csmFile, pair);
            }
            object5 = entry.iterator();
            while (object5.hasNext()) {
                csmFile2 = (FileObject)object5.next();
                if (csmFile2 == null || !csmFile2.isValid() || !this.checkMimeType((FileObject)csmFile2)) continue;
                csmFile = CsmUtilities.getCsmFile((FileObject)csmFile2, (boolean)false);
                if (csmFile == null) {
                    csmFile = CsmStandaloneFileProvider.getDefault().getCsmFile((FileObject)csmFile2);
                }
                if (csmFile == null) continue;
                object4 = this.createTask((FileObject)csmFile2);
                object3 = new Pair((PhaseRunner)object4);
                hashMap2.put(csmFile, (Pair)object3);
                this.fobj2csm.put((FileObject)csmFile2, csmFile);
                this.csm2task.put(csmFile, (Pair)object3);
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            if (OpenedEditors.SHOW_TIME) {
                System.err.println("CFTF: removing " + ((CsmFile)entry.getKey()).getAbsolutePath());
            }
            if (entry != null && entry.getValue() != null) {
                object2 = ((Pair)entry.getValue()).runner;
                object = ((Pair)entry.getValue()).task;
                object2.cancel();
                if (object != null) {
                    object.cancel();
                }
                this.post((Pair)entry.getValue(), (CsmFile)entry.getKey(), PhaseRunner.Phase.CLEANUP, 0);
            }
            CsmStandaloneFileProvider.getDefault().notifyClosed((CsmFile)entry.getKey());
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            if (OpenedEditors.SHOW_TIME) {
                System.err.println("CFTF: adding " + (Object)((Object)(((CsmFile)entry.getKey()).isParsed() ? PhaseRunner.Phase.PARSED : PhaseRunner.Phase.INIT)) + " " + ((Pair)entry.getValue()).runner.toString() + " " + ((CsmFile)entry.getKey()).getAbsolutePath());
            }
            this.post((Pair)entry.getValue(), (CsmFile)entry.getKey(), ((CsmFile)entry.getKey()).isParsed() ? PhaseRunner.Phase.PARSED : PhaseRunner.Phase.INIT, 500);
        }
    }

    public final synchronized void reschedule(FileObject fileObject) throws IllegalArgumentException {
        CsmFile csmFile = this.fobj2csm.get(fileObject);
        if (csmFile == null) {
            return;
        }
        this.runTask(csmFile, PhaseRunner.Phase.PARSED, 500);
    }

    private final void runTask(CsmFile csmFile, PhaseRunner.Phase phase, int n) {
        Pair pair = this.csm2task.get(csmFile);
        if (pair != null) {
            pair.runner.cancel();
            if (pair.task != null) {
                pair.task.cancel();
            }
            if (!pair.runner.isValid()) {
                FileObject fileObject = CsmUtilities.getFileObject((CsmFile)csmFile);
                PhaseRunner phaseRunner = this.createTask(fileObject);
                assert (phaseRunner.isValid());
                pair = new Pair(phaseRunner);
                this.csm2task.put(csmFile, pair);
            }
            this.post(pair, csmFile, phase, n);
        }
    }

    private final void post(Pair pair, CsmFile csmFile, PhaseRunner.Phase phase, int n) {
        if (pair.runner.isHighPriority()) {
            pair.task = CsmFileTaskFactory.HIGH_PRIORITY_WORKER.post((Runnable)new CsmSafeRunnable(CsmFileTaskFactory.getRunnable(pair.runner, phase), csmFile), n, 5);
        } else {
            pair.task = CsmFileTaskFactory.WORKER.post((Runnable)new CsmSafeRunnable(CsmFileTaskFactory.getRunnable(pair.runner, phase), csmFile), n);
        }
    }

    private static final Runnable getRunnable(final PhaseRunner phaseRunner, final PhaseRunner.Phase phase) {
        return new Runnable(){

            public void run() {
                phaseRunner.run(phase);
            }
        };
    }

    protected static PhaseRunner lazyRunner() {
        return new PhaseRunner(){

            public void run(PhaseRunner.Phase phase) {
            }

            public boolean isValid() {
                return true;
            }

            public void cancel() {
            }

            public boolean isHighPriority() {
                return false;
            }
        };
    }

    static {
        CsmFileTaskFactoryManager.ACCESSOR = new CsmFileTaskFactoryManager.Accessor(){

            public void fireChangeEvent(CsmFileTaskFactory csmFileTaskFactory) {
                csmFileTaskFactory.fileObjectsChanged();
            }
        };
    }

    private static final class CsmSafeRunnable
    implements Runnable {
        private CsmFile file;
        private Runnable run;

        public CsmSafeRunnable(Runnable runnable, CsmFile csmFile) {
            this.run = runnable;
            this.file = csmFile;
        }

        public void run() {
            if (this.file.isValid()) {
                this.run.run();
            }
        }
    }

    private static final class Pair {
        private final PhaseRunner runner;
        private RequestProcessor.Task task;

        private Pair(PhaseRunner phaseRunner) {
            this.runner = phaseRunner;
        }
    }

    public static interface PhaseRunner {
        public void run(Phase var1);

        public boolean isValid();

        public void cancel();

        public boolean isHighPriority();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Phase {
            INIT,
            PARSING_STARTED,
            PARSED,
            CLEANUP;

        }
    }

    private class ModelListener
    implements CsmModelListener {
        private ModelListener() {
        }

        public void projectOpened(CsmProject csmProject) {
        }

        public void projectClosed(CsmProject csmProject) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void modelChanged(CsmChangeEvent csmChangeEvent) {
            for (CsmFile csmFile : csmChangeEvent.getRemovedFiles()) {
                if (CsmFileTaskFactory.this.csm2task.get(csmFile) == null) continue;
                ModelListener modelListener = this;
                synchronized (modelListener) {
                    CsmFileTaskFactory.this.runTask(csmFile, PhaseRunner.Phase.CLEANUP, 0);
                    CsmFileTaskFactory.this.csm2task.put(csmFile, new Pair(CsmFileTaskFactory.lazyRunner()));
                }
            }
            if (!csmChangeEvent.getNewFiles().isEmpty()) {
                CsmFileTaskFactory.this.fileObjectsChanged();
            }
        }
    }

    private class ProgressListener
    extends CsmProgressAdapter {
        private ProgressListener() {
        }

        public void fileParsingFinished(CsmFile csmFile) {
            CsmFileTaskFactory.this.runTask(csmFile, PhaseRunner.Phase.PARSED, 0);
        }

        public void fileParsingStarted(CsmFile csmFile) {
            CsmFileTaskFactory.this.runTask(csmFile, PhaseRunner.Phase.PARSING_STARTED, 0);
        }
    }
}

