/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.samples.bundled.wizard;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.visualweb.samples.bundled.wizard.SamplesWebWizardPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

public final class SamplesWebWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private int index;
    private WizardDescriptor.Panel[] panels;
    protected WizardDescriptor wizard;

    public static SamplesWebWizardIterator createIterator() {
        return new SamplesWebWizardIterator();
    }

    private WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            this.panels = new WizardDescriptor.Panel[]{new SamplesWebWizardPanel()};
            String[] stringArray = new String[this.panels.length];
            for (int i = 0; i < this.panels.length; ++i) {
                Component component = this.panels[i].getComponent();
                stringArray[i] = component.getName();
                if (!(component instanceof JComponent)) continue;
                JComponent jComponent = (JComponent)component;
                jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jComponent.putClientProperty("WizardPanel_contentData", stringArray);
                jComponent.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    public Set instantiate() throws IOException {
        OpenCookie openCookie;
        Object object;
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        File file = FileUtil.normalizeFile((File)((File)this.wizard.getProperty("projdir")));
        FileUtil.createFolder((File)file);
        FileObject fileObject = Templates.getTemplate((WizardDescriptor)this.wizard);
        FileObject fileObject2 = FileUtil.toFileObject((File)file);
        SamplesWebWizardIterator.unZipFile(fileObject.getInputStream(), fileObject2);
        ProjectManager.getDefault().clearNonProjectCache();
        linkedHashSet.add(fileObject2);
        DataObject dataObject = DataObject.find((FileObject)fileObject2);
        Enumeration enumeration = fileObject2.getFolders(true);
        while (enumeration.hasMoreElements()) {
            object = (FileObject)enumeration.nextElement();
            if (!ProjectManager.getDefault().isProject((FileObject)object)) continue;
            linkedHashSet.add(object);
        }
        object = (Boolean)this.wizard.getProperty("setMainProject");
        File file2 = file.getParentFile();
        if (((Boolean)object).booleanValue() && file2 != null && file2.exists()) {
            ProjectChooser.setProjectsFolder((File)file2);
        }
        if ((openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class)) != null) {
            openCookie.open();
        }
        return linkedHashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unZipFile(InputStream inputStream, FileObject fileObject) throws IOException {
        try {
            ZipEntry zipEntry;
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) {
                    FileUtil.createFolder((FileObject)fileObject, (String)zipEntry.getName());
                    continue;
                }
                FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)zipEntry.getName());
                FileLock fileLock = fileObject2.lock();
                try {
                    OutputStream outputStream = fileObject2.getOutputStream(fileLock);
                    try {
                        FileUtil.copy((InputStream)zipInputStream, (OutputStream)outputStream);
                    }
                    finally {
                        outputStream.close();
                    }
                }
                finally {
                    fileLock.releaseLock();
                }
            }
        }
        finally {
            inputStream.close();
        }
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wizard = wizardDescriptor;
        FileObject fileObject = Templates.getTemplate((WizardDescriptor)wizardDescriptor);
        wizardDescriptor.putProperty("name", (Object)fileObject.getName());
        wizardDescriptor.putProperty("setMainProject", (Object)true);
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.wizard.putProperty("name", null);
        this.wizard.putProperty("projdir", null);
        this.wizard.putProperty("setMainProject", null);
        this.wizard = null;
        this.panels = null;
    }

    public WizardDescriptor.Panel current() {
        return this.getPanels()[this.index];
    }

    public String name() {
        return this.index + 1 + ". from " + this.getPanels().length;
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    private String[] createSteps() {
        String[] stringArray = null;
        Object object = this.wizard.getProperty("WizardPanel_contentData");
        if (object != null && object instanceof String[]) {
            stringArray = (String[])object;
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        String[] stringArray2 = new String[stringArray.length - 1 + this.panels.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = i < stringArray.length - 1 ? stringArray[i] : this.panels[i - stringArray.length + 1].getComponent().getName();
        }
        return stringArray2;
    }
}

