/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.io.File;
import javax.swing.JPanel;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.heapwalk.AbstractTopLevelController;
import org.netbeans.modules.profiler.heapwalk.AnalysisController;
import org.netbeans.modules.profiler.heapwalk.ClassesController;
import org.netbeans.modules.profiler.heapwalk.HeapWalker;
import org.netbeans.modules.profiler.heapwalk.InstancesController;
import org.netbeans.modules.profiler.heapwalk.NavigationHistoryManager;
import org.netbeans.modules.profiler.heapwalk.SummaryController;
import org.netbeans.modules.profiler.heapwalk.ui.HeapFragmentWalkerUI;

public class HeapFragmentWalker {
    private AnalysisController analysisController;
    private ClassesController classesController;
    private Heap heapFragment;
    private HeapFragmentWalkerUI walkerUI;
    private HeapWalker heapWalker;
    private InstancesController instancesController;
    private NavigationHistoryManager navigationHistoryManager;
    private SummaryController summaryController;

    public HeapFragmentWalker(Heap heap, HeapWalker heapWalker) {
        this.heapFragment = heap;
        this.heapWalker = heapWalker;
        this.summaryController = new SummaryController(this);
        this.classesController = new ClassesController(this);
        this.instancesController = new InstancesController(this);
        this.analysisController = new AnalysisController(this);
        this.navigationHistoryManager = new NavigationHistoryManager(this);
    }

    public AbstractTopLevelController getActiveController() {
        HeapFragmentWalkerUI heapFragmentWalkerUI = (HeapFragmentWalkerUI)this.getPanel();
        if (heapFragmentWalkerUI == null) {
            return null;
        }
        if (heapFragmentWalkerUI.isSummaryViewActive()) {
            return this.summaryController;
        }
        if (heapFragmentWalkerUI.isClassesViewActive()) {
            return this.classesController;
        }
        if (heapFragmentWalkerUI.isInstancesViewActive()) {
            return this.instancesController;
        }
        if (heapFragmentWalkerUI.isAnalysisViewActive()) {
            return this.analysisController;
        }
        return null;
    }

    public AnalysisController getAnalysisController() {
        return this.analysisController;
    }

    public ClassesController getClassesController() {
        return this.classesController;
    }

    public File getHeapDumpFile() {
        return this.heapWalker.getHeapDumpFile();
    }

    public Project getHeapDumpProject() {
        return this.heapWalker.getHeapDumpProject();
    }

    public Heap getHeapFragment() {
        return this.heapFragment;
    }

    public InstancesController getInstancesController() {
        return this.instancesController;
    }

    public boolean isNavigationBackAvailable() {
        return this.navigationHistoryManager.isNavigationBackAvailable();
    }

    public boolean isNavigationForwardAvailable() {
        return this.navigationHistoryManager.isNavigationForwardAvailable();
    }

    public JPanel getPanel() {
        if (this.walkerUI == null) {
            this.walkerUI = new HeapFragmentWalkerUI(this);
        }
        return this.walkerUI;
    }

    public SummaryController getSummaryController() {
        return this.summaryController;
    }

    public int getTotalLiveBytes() {
        return this.heapFragment.getSummary().getTotalLiveBytes();
    }

    public int getTotalLiveInstances() {
        return this.heapFragment.getSummary().getTotalLiveInstances();
    }

    public void createNavigationHistoryPoint() {
        HeapFragmentWalkerUI heapFragmentWalkerUI = (HeapFragmentWalkerUI)this.getPanel();
        if (heapFragmentWalkerUI == null) {
            return;
        }
        this.navigationHistoryManager.createNavigationHistoryPoint();
        heapFragmentWalkerUI.updateNavigationActions();
    }

    public void navigateBack() {
        HeapFragmentWalkerUI heapFragmentWalkerUI = (HeapFragmentWalkerUI)this.getPanel();
        if (heapFragmentWalkerUI == null) {
            return;
        }
        this.navigationHistoryManager.navigateBack();
        heapFragmentWalkerUI.updateNavigationActions();
    }

    public void navigateForward() {
        HeapFragmentWalkerUI heapFragmentWalkerUI = (HeapFragmentWalkerUI)this.getPanel();
        if (heapFragmentWalkerUI == null) {
            return;
        }
        this.navigationHistoryManager.navigateForward();
        heapFragmentWalkerUI.updateNavigationActions();
    }

    public void showInstancesForClass(JavaClass javaClass) {
        this.switchToInstancesView();
        this.instancesController.setClass(javaClass);
    }

    public void switchToAnalysisView() {
        ((HeapFragmentWalkerUI)this.getPanel()).showAnalysisView();
    }

    public void switchToClassesView() {
        ((HeapFragmentWalkerUI)this.getPanel()).showClassesView();
    }

    public void switchToHistoryAnalysisView() {
        ((HeapFragmentWalkerUI)this.getPanel()).showHistoryAnalysisView();
    }

    public void switchToHistoryClassesView() {
        ((HeapFragmentWalkerUI)this.getPanel()).showHistoryClassesView();
    }

    public void switchToHistoryInstancesView() {
        ((HeapFragmentWalkerUI)this.getPanel()).showHistoryInstancesView();
    }

    public void switchToHistorySummaryView() {
        ((HeapFragmentWalkerUI)this.getPanel()).showHistorySummaryView();
    }

    public void switchToInstancesView() {
        ((HeapFragmentWalkerUI)this.getPanel()).showInstancesView();
    }

    public void switchToSummaryView() {
        ((HeapFragmentWalkerUI)this.getPanel()).showSummaryView();
    }

    NavigationHistoryManager.NavigationHistoryCapable getNavigationHistorySource() {
        AbstractTopLevelController abstractTopLevelController = this.getActiveController();
        if (abstractTopLevelController instanceof NavigationHistoryManager.NavigationHistoryCapable) {
            return (NavigationHistoryManager.NavigationHistoryCapable)((Object)abstractTopLevelController);
        }
        return null;
    }
}

