/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.model;

import java.text.MessageFormat;
import javax.swing.ImageIcon;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.heapwalk.model.AbstractHeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.model.ChildrenComputer;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerInstanceNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.RootNode;
import org.openide.util.NbBundle;

public abstract class InstanceNode
extends AbstractHeapWalkerNode
implements HeapWalkerInstanceNode {
    private static final String LOOP_TO_STRING = NbBundle.getMessage(InstanceNode.class, (String)"InstanceNode_LoopToString");
    HeapWalkerNode loopTo;
    private Instance instance;
    private String name;

    public InstanceNode(Instance instance, String string, HeapWalkerNode heapWalkerNode) {
        this(instance, string, heapWalkerNode, heapWalkerNode == null ? 1 : heapWalkerNode.getMode());
    }

    public InstanceNode(Instance instance, String string, HeapWalkerNode heapWalkerNode, int n) {
        super(heapWalkerNode, n);
        this.instance = instance;
        this.name = string;
        this.loopTo = this.computeLoopTo();
    }

    public abstract boolean isArray();

    public Instance getInstance() {
        return this.instance;
    }

    public boolean isLeaf() {
        return !this.hasInstance() || this.isLoop();
    }

    public boolean isLoop() {
        return this.getLoopTo() != null;
    }

    public HeapWalkerNode getLoopTo() {
        return this.loopTo;
    }

    public boolean hasInstance() {
        return this.instance != null;
    }

    protected abstract ChildrenComputer getChildrenComputer();

    protected HeapWalkerNode[] computeChildren() {
        return BrowserUtils.lazilyCreateChildren(this, this.getChildrenComputer());
    }

    protected HeapWalkerNode computeLoopTo() {
        if (this.hasInstance()) {
            for (HeapWalkerNode heapWalkerNode = this.getParent(); heapWalkerNode != null && heapWalkerNode instanceof HeapWalkerInstanceNode; heapWalkerNode = heapWalkerNode.getParent()) {
                if (!((HeapWalkerInstanceNode)heapWalkerNode).getInstance().equals(this.instance)) continue;
                return heapWalkerNode;
            }
        }
        return null;
    }

    protected String computeName() {
        if (this.isLoop()) {
            return this.name + " " + MessageFormat.format(LOOP_TO_STRING, BrowserUtils.getFullNodeName(this.getLoopTo()));
        }
        return this.name;
    }

    protected String computeType() {
        if (!this.hasInstance()) {
            return "<object>";
        }
        return this.instance.getJavaClass().getName();
    }

    protected String computeValue() {
        JavaClass javaClass;
        HeapWalkerNode heapWalkerNode;
        if (!this.hasInstance()) {
            return "null";
        }
        if ("java.lang.Class".equals(this.instance.getJavaClass().getName()) && (heapWalkerNode = BrowserUtils.getRoot(this)) instanceof RootNode && (javaClass = ((RootNode)((Object)heapWalkerNode)).getJavaClassByID(this.instance.getInstanceId())) != null) {
            return "#" + this.instance.getInstanceNumber() + " (" + BrowserUtils.getSimpleType(javaClass.getName()) + ")";
        }
        return "#" + this.instance.getInstanceNumber();
    }

    protected ImageIcon processLoopIcon(ImageIcon imageIcon) {
        if (!this.isLoop()) {
            return imageIcon;
        }
        return BrowserUtils.createLoopIcon(imageIcon);
    }
}

