/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.modules.profiler.ppoints.ProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointsManager;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.openide.DialogDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ProfilingPointsDisplayer
extends JPanel
implements HelpCtx.Provider {
    private static final String PP_ACTIVE_MSG = NbBundle.getMessage(ProfilingPointsDisplayer.class, (String)"ProfilingPointsDisplayer_PpActiveMsg");
    private static final String NO_ACTIVE_PPS_STRING = NbBundle.getMessage(ProfilingPointsDisplayer.class, (String)"ProfilingPointsDisplayer_NoActivePpsString");
    private static final String HELP_CTX_KEY = "ProfilingPointsDisplayer.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("ProfilingPointsDisplayer.HelpCtx");
    private static ProfilingPointsDisplayer defaultInstance;
    private DefaultListModel listModel;
    private JList list;

    private ProfilingPointsDisplayer() {
        this.initComponents();
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public static void displayProfilingPoints(Project project, ProfilingSettings profilingSettings) {
        ProfilingPointsDisplayer profilingPointsDisplayer = ProfilingPointsDisplayer.getDefault();
        profilingPointsDisplayer.setupDisplay(project, profilingSettings);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)profilingPointsDisplayer, MessageFormat.format(PP_ACTIVE_MSG, profilingSettings.getSettingsName()), true, new Object[]{DialogDescriptor.OK_OPTION}, DialogDescriptor.OK_OPTION, 0, null, null);
        Dialog dialog = ProfilerDialogs.createDialog(dialogDescriptor);
        dialog.pack();
        dialog.setVisible(true);
        profilingPointsDisplayer.cleanup();
    }

    private static ProfilingPointsDisplayer getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new ProfilingPointsDisplayer();
        }
        return defaultInstance;
    }

    private void cleanup() {
        this.listModel.removeAllElements();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        this.list.getSelectionModel().setSelectionMode(2);
        this.list.setVisibleRowCount(6);
        this.list.setCellRenderer(Utils.getPresenterListRenderer());
        JScrollPane jScrollPane = new JScrollPane(this.list, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(350, jScrollPane.getPreferredSize().height));
        this.add((Component)jScrollPane, "Center");
    }

    private void setupDisplay(Project project, ProfilingSettings profilingSettings) {
        List<ProfilingPoint> list = ProfilingPointsManager.getDefault().getCompatibleProfilingPoints(project, profilingSettings, true);
        this.listModel.removeAllElements();
        if (list.size() == 0) {
            this.listModel.addElement(NO_ACTIVE_PPS_STRING);
        } else {
            for (ProfilingPoint profilingPoint : list) {
                this.listModel.addElement(profilingPoint);
            }
        }
    }
}

