/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.utils;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.profiler.projectsupport.utilities.SourceUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;

public class AppletSupport {
    private static final SpecificationVersion JDK_15 = new SpecificationVersion("1.5");
    private static final String HTML_EXT = "html";
    private static final String CLASS_EXT = "class";
    private static final String POLICY_FILE_NAME = "applet";
    private static final String POLICY_FILE_EXT = "policy";
    public static Boolean unitTestingSupport_isApplet = null;

    private AppletSupport() {
    }

    public static boolean isApplet(FileObject fileObject) {
        if (fileObject == null) {
            return false;
        }
        if (unitTestingSupport_isApplet != null) {
            return unitTestingSupport_isApplet;
        }
        return SourceUtils.isApplet((FileObject)fileObject);
    }

    public static URL generateHtmlFileURL(FileObject fileObject, FileObject fileObject2, FileObject fileObject3, String string) throws FileStateInvalidException {
        FileObject fileObject4 = null;
        IOException iOException = null;
        if (fileObject == null || fileObject2 == null || fileObject3 == null) {
            return null;
        }
        try {
            fileObject4 = AppletSupport.generateHtml(fileObject, fileObject2, fileObject3);
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        URL uRL = null;
        try {
            if (iOException == null) {
                boolean bl;
                JavaPlatformManager javaPlatformManager = JavaPlatformManager.getDefault();
                JavaPlatform javaPlatform = null;
                if (string == null) {
                    javaPlatform = javaPlatformManager.getDefaultPlatform();
                } else {
                    JavaPlatform[] javaPlatformArray = javaPlatformManager.getPlatforms(null, new Specification("j2se", null));
                    for (int i = 0; i < javaPlatformArray.length; ++i) {
                        String string2 = (String)javaPlatformArray[i].getProperties().get("platform.ant.name");
                        if (string2 == null || !string2.equals(string)) continue;
                        javaPlatform = javaPlatformArray[i];
                        break;
                    }
                }
                boolean bl2 = bl = javaPlatform != null && javaPlatform.getSpecification().getVersion().compareTo((Object)JDK_15) >= 0;
                if (bl) {
                    File file = FileUtil.toFile((FileObject)fileObject4);
                    try {
                        uRL = new URL("file", null, file.getAbsolutePath());
                    }
                    catch (MalformedURLException malformedURLException) {
                        ErrorManager.getDefault().notify((Throwable)malformedURLException);
                    }
                } else {
                    uRL = fileObject4.getURL();
                }
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            throw new FileStateInvalidException();
        }
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObject generateSecurityPolicy(FileObject fileObject, FileObject fileObject2) {
        FileObject fileObject3;
        block7: {
            fileObject3 = fileObject2.getFileObject(POLICY_FILE_NAME, POLICY_FILE_EXT);
            try {
                if (fileObject3 != null) break block7;
                FileObject fileObject4 = fileObject.getFileObject(POLICY_FILE_NAME, POLICY_FILE_EXT);
                if (fileObject4 != null) {
                    fileObject3 = FileUtil.copyFile((FileObject)fileObject4, (FileObject)fileObject2, (String)POLICY_FILE_NAME, (String)POLICY_FILE_EXT);
                    break block7;
                }
                fileObject3 = fileObject2.createData(POLICY_FILE_NAME, POLICY_FILE_EXT);
                FileLock fileLock = fileObject3.lock();
                PrintWriter printWriter = null;
                try {
                    printWriter = new PrintWriter(fileObject3.getOutputStream(fileLock));
                    AppletSupport.fillInPolicyFile(printWriter);
                }
                finally {
                    fileLock.releaseLock();
                    if (printWriter != null) {
                        printWriter.close();
                    }
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().log(1, "Failed to generate applet policy file: " + iOException);
            }
        }
        return fileObject3;
    }

    private static void fillInFile(PrintWriter printWriter, String string, String string2) {
        ResourceBundle resourceBundle = NbBundle.getBundle(AppletSupport.class);
        printWriter.println("<HTML>");
        printWriter.println("<HEAD>");
        printWriter.print("   <TITLE>");
        printWriter.print(resourceBundle.getString("GEN_title"));
        printWriter.println("</TITLE>");
        printWriter.println("</HEAD>");
        printWriter.println("<BODY>\n");
        printWriter.print(resourceBundle.getString("GEN_warning"));
        printWriter.print("<H3><HR WIDTH=\"100%\">");
        printWriter.print(resourceBundle.getString("GEN_header"));
        printWriter.println("<HR WIDTH=\"100%\"></H3>\n");
        printWriter.println("<P>");
        if (string2 == null) {
            printWriter.print("<APPLET code=");
        } else {
            printWriter.print("<APPLET " + string2 + " code=");
        }
        printWriter.print("\"");
        printWriter.print(string);
        printWriter.print("\"");
        printWriter.println(" width=350 height=200></APPLET>");
        printWriter.println("</P>\n");
        printWriter.print("<HR WIDTH=\"100%\"><FONT SIZE=-1><I>");
        printWriter.print(resourceBundle.getString("GEN_copy"));
        printWriter.println("</I></FONT>");
        printWriter.println("</BODY>");
        printWriter.println("</HTML>");
        printWriter.flush();
    }

    private static void fillInPolicyFile(PrintWriter printWriter) {
        printWriter.println("grant {");
        printWriter.println("permission java.security.AllPermission;");
        printWriter.println("};");
        printWriter.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileObject generateHtml(FileObject fileObject, FileObject fileObject2, FileObject fileObject3) throws IOException {
        FileObject fileObject4 = fileObject2.getFileObject(fileObject.getName(), HTML_EXT);
        if (fileObject4 == null) {
            fileObject4 = fileObject2.createData(fileObject.getName(), HTML_EXT);
        }
        FileLock fileLock = fileObject4.lock();
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(fileObject4.getOutputStream(fileLock));
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute");
            ClassPath classPath2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
            String string = FileUtil.getRelativePath((FileObject)classPath2.findOwnerRoot(fileObject), (FileObject)fileObject);
            string = string.substring(0, string.length() - 5);
            AppletSupport.fillInFile(printWriter, string + "." + CLASS_EXT, "codebase=\"" + fileObject3.getURL() + "\"");
        }
        finally {
            fileLock.releaseLock();
            if (printWriter != null) {
                printWriter.close();
            }
        }
        return fileObject4;
    }
}

