/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.ant.freeform.FreeformProject;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.filesystems.FileObject;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Subprojects
implements SubprojectProvider {
    private final FreeformProject project;

    public Subprojects(FreeformProject freeformProject) {
        this.project = freeformProject;
    }

    public Set<? extends Project> getSubprojects() {
        return new LazySubprojectsSet();
    }

    private Set<Project> createSubprojects(Set<Project> set) {
        Element element = this.project.getPrimaryConfigurationData();
        Element element2 = Util.findElement(element, "subprojects", "http://www.netbeans.org/ns/freeform-project/2");
        if (element2 != null) {
            for (Element element3 : Util.findSubElements(element2)) {
                FileObject fileObject;
                assert (element3.getLocalName().equals("project")) : "Bad element " + element3 + " in <subprojects> for " + this.project;
                String string = Util.findText(element3);
                assert (string != null) : "Need text content for <project> in " + this.project;
                String string2 = this.project.evaluator().evaluate(string);
                if (string2 == null || (fileObject = this.project.helper().resolveFileObject(string2)) == null) continue;
                try {
                    Project project = ProjectManager.getDefault().findProject(fileObject);
                    if (project == null) continue;
                    if (set == null) {
                        return Collections.emptySet();
                    }
                    set.add(project);
                }
                catch (IOException iOException) {
                    org.netbeans.modules.ant.freeform.Util.err.notify(1, (Throwable)iOException);
                }
            }
        }
        return set;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class LazySubprojectsSet
    implements Set<Project> {
        private Set<Project> delegateTo = null;

        private LazySubprojectsSet() {
        }

        private synchronized Set<Project> getDelegateTo() {
            if (this.delegateTo == null) {
                this.delegateTo = Subprojects.this.createSubprojects(new HashSet());
            }
            return this.delegateTo;
        }

        @Override
        public boolean contains(Object object) {
            return this.getDelegateTo().contains(object);
        }

        @Override
        public boolean add(Project project) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Project> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection collection) {
            return this.getDelegateTo().containsAll(collection);
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.getDelegateTo().toArray(TArray);
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.getDelegateTo().size();
        }

        @Override
        public synchronized boolean isEmpty() {
            if (this.delegateTo == null) {
                return Subprojects.this.createSubprojects(null) == null;
            }
            return this.delegateTo.isEmpty();
        }

        @Override
        public Iterator<Project> iterator() {
            return this.getDelegateTo().iterator();
        }

        @Override
        public Object[] toArray() {
            return this.getDelegateTo().toArray();
        }

        @Override
        public int hashCode() {
            return ((Object)this.getDelegateTo()).hashCode();
        }

        @Override
        public boolean equals(Object object) {
            return ((Object)this.getDelegateTo()).equals(object);
        }

        public String toString() {
            return this.getDelegateTo().toString();
        }
    }
}

