/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.netbeans.tax.CannotMergeException;
import org.netbeans.tax.InvalidArgumentException;
import org.netbeans.tax.ReadOnlyException;
import org.netbeans.tax.TreeException;
import org.netbeans.tax.TreeNode;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.TreeUnsupportedOperationException;
import org.netbeans.tax.Util;
import org.netbeans.tax.event.TreeEventManager;
import org.netbeans.tax.event.TreeNodeContentEventModel;

public class TreeObjectList
extends TreeObject
implements TreeNodeContentEventModel,
List {
    public static final String PROP_CONTENT_INSERT = "contentInsert";
    public static final String PROP_CONTENT_REMOVE = "contentRemove";
    public static final String PROP_CONTENT_ORDER = "contentOrder";
    private ContentManager contentManager;
    private List list;

    protected TreeObjectList(ContentManager contentManager) {
        this.contentManager = contentManager;
        this.list = new LinkedList();
    }

    protected TreeObjectList(TreeObjectList treeObjectList) {
        super(treeObjectList);
        this.contentManager = null;
        this.list = new LinkedList();
        Iterator iterator = treeObjectList.iterator();
        boolean bl = this.isReadOnly();
        if (bl) {
            this.setReadOnly(false);
        }
        while (iterator.hasNext()) {
            this.add(((TreeObject)iterator.next()).clone());
        }
        if (bl) {
            this.setReadOnly(true);
        }
    }

    public Object clone() {
        return new TreeObjectList(this);
    }

    public boolean equals(Object object, boolean bl) {
        if (!super.equals(object, bl)) {
            return false;
        }
        TreeObjectList treeObjectList = (TreeObjectList)object;
        if (this.list.size() != treeObjectList.list.size()) {
            return false;
        }
        Iterator iterator = this.list.iterator();
        Iterator iterator2 = treeObjectList.list.iterator();
        while (iterator.hasNext()) {
            Object e;
            Object e2 = iterator.next();
            if (Util.equals(e2, e = iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public void merge(TreeObject treeObject) throws CannotMergeException {
        super.merge(treeObject);
        TreeObjectList treeObjectList = (TreeObjectList)treeObject;
        boolean bl = this.isReadOnly();
        if (bl) {
            this.setReadOnly(false);
        }
        TreeObject[] treeObjectArray = this.list.toArray(new TreeObject[0]);
        this.list.clear();
        short s = 2;
        TreeEventManager treeEventManager = this.getEventManager();
        if (treeEventManager != null) {
            s = treeEventManager.getFirePolicy();
            treeEventManager.setFirePolicy((short)2);
        }
        boolean bl2 = true;
        int[] nArray = null;
        int n = 0;
        if (treeObjectArray.length == treeObjectList.list.size()) {
            nArray = new int[treeObjectArray.length];
        } else {
            bl2 = false;
        }
        Iterator iterator = treeObjectList.list.iterator();
        while (iterator.hasNext()) {
            TreeObject treeObject2 = (TreeObject)iterator.next();
            TreeObject treeObject3 = null;
            int n2 = this.findMergeCandidate(treeObject2, treeObjectArray);
            if (n2 >= 0) {
                treeObject3 = treeObjectArray[n2];
                treeObjectArray[n2] = null;
            }
            if (treeObject3 != null) {
                treeObject3.merge(treeObject2);
                this.addNoFire(treeObject3);
                if (nArray != null) {
                    nArray[n] = n2;
                }
            } else {
                treeObject3 = treeObject2;
                this.add(treeObject3);
                bl2 = false;
            }
            ++n;
        }
        if (bl2) {
            bl2 = false;
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == i) continue;
                bl2 = true;
                break;
            }
            if (bl2) {
                this.firePropertyOrder(nArray);
            }
        } else {
            for (int i = 0; i < treeObjectArray.length; ++i) {
                if (treeObjectArray[i] == null) continue;
                this.contentManagerObjectRemoved(treeObjectArray[i]);
                this.firePropertyRemove(treeObjectArray[i]);
            }
        }
        if (bl) {
            this.setReadOnly(true);
        }
        if (treeEventManager != null) {
            treeEventManager.setFirePolicy(s);
        }
    }

    protected int findMergeCandidate(TreeObject treeObject, TreeObject[] treeObjectArray) {
        for (int i = 0; i < treeObjectArray.length; ++i) {
            TreeObject treeObject2 = treeObjectArray[i];
            if (treeObject2 == null || !treeObject.getClass().equals(treeObject2.getClass())) continue;
            return i;
        }
        return -1;
    }

    protected void setReadOnly(boolean bl) {
        super.setReadOnly(bl);
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            TreeObject treeObject = (TreeObject)iterator.next();
            treeObject.setReadOnly(bl);
        }
    }

    public final boolean isInContext() {
        return true;
    }

    public final void removeFromContext() throws ReadOnlyException {
        if (this.isInContext()) {
            this.clear();
        }
    }

    public final ContentManager getContentManager() {
        return this.contentManager;
    }

    public final boolean isAssignableObject(Object object) {
        try {
            this.getContentManager().checkAssignableObject(object);
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public final void reorder(int[] nArray) throws ReadOnlyException, InvalidArgumentException {
        int n;
        if (this.equals(nArray)) {
            return;
        }
        this.checkReadOnly();
        this.checkReorder(nArray);
        LinkedList linkedList = new LinkedList();
        int n2 = this.size();
        int[] nArray2 = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray2[nArray[n]] = n;
        }
        for (n = 0; n < n2; ++n) {
            linkedList.add(this.list.get(nArray2[n]));
        }
        this.list = linkedList;
        this.contentManagerOrderChanged(nArray);
        this.firePropertyOrder(nArray);
    }

    protected final void checkReorder(int[] nArray) throws InvalidArgumentException {
        if (nArray == null) {
            throw new InvalidArgumentException(Util.THIS.getString("EXC_invalid_reorder_permutation"), new NullPointerException());
        }
        if (nArray.length != this.size()) {
            throw new InvalidArgumentException((Object)(nArray.length + " != " + this.size()), Util.THIS.getString("EXC_invalid_reorder_permutation"));
        }
    }

    protected final boolean equals(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == i) continue;
            return false;
        }
        return true;
    }

    public final void switchObjects(int n, int n2) throws ReadOnlyException, InvalidArgumentException {
        int n3 = this.size();
        int[] nArray = new int[n3];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        nArray[n] = n2;
        nArray[n2] = n;
        this.reorder(nArray);
    }

    protected final void checkUnsupportedOperation() throws TreeUnsupportedOperationException {
        try {
            this.checkReadOnly();
        }
        catch (TreeException treeException) {
            throw new TreeUnsupportedOperationException(treeException);
        }
    }

    public final void clear() {
        this.checkUnsupportedOperation();
        Iterator iterator = new LinkedList(this.list).iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            this.remove(e);
        }
    }

    public final boolean removeAll(Collection collection) throws UnsupportedOperationException {
        this.checkUnsupportedOperation();
        throw new UnsupportedOperationException();
    }

    public final Object get(int n) {
        return this.list.get(n);
    }

    public final int hashCode() {
        return ((Object)this.list).hashCode();
    }

    public final int size() {
        return this.list.size();
    }

    public final boolean retainAll(Collection collection) throws UnsupportedOperationException {
        this.checkUnsupportedOperation();
        throw new UnsupportedOperationException();
    }

    protected boolean removeImpl(Object object) {
        return this.list.remove(object);
    }

    public final boolean remove(Object object) {
        this.checkUnsupportedOperation();
        boolean bl = this.removeImpl(object);
        if (bl) {
            this.contentManagerObjectRemoved((TreeObject)object);
            this.firePropertyRemove((TreeObject)object);
        }
        return bl;
    }

    public final int indexOf(Object object) {
        return this.list.indexOf(object);
    }

    public final boolean contains(Object object) {
        return this.list.contains(object);
    }

    public final int lastIndexOf(Object object) {
        return this.list.lastIndexOf(object);
    }

    protected Object setImpl(int n, Object object) {
        return this.list.set(n, object);
    }

    public final Object set(int n, Object object) {
        this.checkUnsupportedOperation();
        this.contentManagerCheckAssignableObject(object);
        Object object2 = this.setImpl(n, object);
        this.contentManagerObjectRemoved((TreeObject)object2);
        this.firePropertyRemove((TreeObject)object2);
        this.contentManagerObjectInserted((TreeObject)object);
        this.firePropertyInsert((TreeObject)object);
        return object2;
    }

    public final ListIterator listIterator(int n) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public final boolean containsAll(Collection collection) {
        return this.list.containsAll(collection);
    }

    public final Iterator iterator() {
        return new LinkedList(this.list).iterator();
    }

    public final boolean addAll(Collection collection) {
        this.checkUnsupportedOperation();
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
            bl = true;
        }
        return bl;
    }

    protected Object removeImpl(int n) {
        return this.list.remove(n);
    }

    public final Object remove(int n) {
        this.checkUnsupportedOperation();
        Object object = this.removeImpl(n);
        if (object != null) {
            this.contentManagerObjectRemoved((TreeObject)object);
            this.firePropertyRemove((TreeObject)object);
        }
        return object;
    }

    public final boolean isEmpty() {
        return this.list.isEmpty();
    }

    protected void addImpl(int n, Object object) {
        this.list.add(n, object);
    }

    public final void add(int n, Object object) {
        this.checkUnsupportedOperation();
        this.contentManagerCheckAssignableObject(object);
        this.addImpl(n, object);
        this.contentManagerObjectInserted((TreeObject)object);
        this.firePropertyInsert((TreeObject)object);
    }

    public final boolean equals(Object object) {
        if (!(object instanceof TreeObjectList)) {
            return false;
        }
        return ((Object)this.list).equals(((TreeObjectList)object).list);
    }

    public final boolean addAll(int n, Collection collection) throws UnsupportedOperationException {
        this.checkUnsupportedOperation();
        throw new UnsupportedOperationException();
    }

    protected boolean addImpl(Object object) {
        return this.list.add(object);
    }

    private boolean addNoFire(Object object) {
        this.checkUnsupportedOperation();
        this.contentManagerCheckAssignableObject(object);
        return this.addImpl(object);
    }

    public final boolean add(Object object) {
        boolean bl = this.addNoFire(object);
        if (bl) {
            this.contentManagerObjectInserted((TreeObject)object);
            this.firePropertyInsert((TreeObject)object);
        }
        return bl;
    }

    public final Object[] toArray(Object[] objectArray) {
        return this.list.toArray(objectArray);
    }

    public final Object[] toArray() {
        return this.list.toArray();
    }

    public final ListIterator listIterator() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public final List subList(int n, int n2) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.list.toString();
    }

    public final TreeEventManager getEventManager() {
        TreeNode treeNode = this.contentManagerGetOwnerNode();
        if (treeNode == null) {
            return null;
        }
        return treeNode.getEventManager();
    }

    public final void addContentChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getEventChangeSupport().addPropertyChangeListener(PROP_CONTENT_INSERT, propertyChangeListener);
        this.getEventChangeSupport().addPropertyChangeListener(PROP_CONTENT_REMOVE, propertyChangeListener);
        this.getEventChangeSupport().addPropertyChangeListener(PROP_CONTENT_ORDER, propertyChangeListener);
    }

    public final void removeContentChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getEventChangeSupport().removePropertyChangeListener(PROP_CONTENT_INSERT, propertyChangeListener);
        this.getEventChangeSupport().removePropertyChangeListener(PROP_CONTENT_REMOVE, propertyChangeListener);
        this.getEventChangeSupport().removePropertyChangeListener(PROP_CONTENT_ORDER, propertyChangeListener);
    }

    public final boolean hasContentChangeListeners() {
        return this.getEventChangeSupport().hasPropertyChangeListeners(PROP_CONTENT_INSERT) || this.getEventChangeSupport().hasPropertyChangeListeners(PROP_CONTENT_REMOVE) || this.getEventChangeSupport().hasPropertyChangeListeners(PROP_CONTENT_ORDER);
    }

    public final void firePropertyInsert(TreeObject treeObject) {
        this.firePropertyChange(this.getEventChangeSupport().createEvent(PROP_CONTENT_INSERT, null, treeObject));
    }

    public final void firePropertyRemove(TreeObject treeObject) {
        this.firePropertyChange(this.getEventChangeSupport().createEvent(PROP_CONTENT_REMOVE, treeObject, null));
    }

    public final void firePropertyOrder(int[] nArray) {
        this.firePropertyChange(this.getEventChangeSupport().createEvent(PROP_CONTENT_ORDER, null, nArray));
    }

    protected final TreeNode contentManagerGetOwnerNode() {
        if (this.contentManager != null) {
            return this.contentManager.getOwnerNode();
        }
        return null;
    }

    protected final void contentManagerCheckAssignableObject(Object object) {
        if (this.contentManager != null) {
            this.contentManager.checkAssignableObject(object);
        }
    }

    protected final void contentManagerObjectInserted(TreeObject treeObject) {
        if (this.contentManager != null) {
            this.contentManager.objectInserted(treeObject);
        }
    }

    protected final void contentManagerObjectRemoved(TreeObject treeObject) {
        if (this.contentManager != null) {
            this.contentManager.objectRemoved(treeObject);
        }
    }

    protected final void contentManagerOrderChanged(int[] nArray) {
        if (this.contentManager != null) {
            this.contentManager.orderChanged(nArray);
        }
    }

    public static abstract class ContentManager {
        public abstract TreeNode getOwnerNode();

        public void checkAssignableObject(Object object) throws ClassCastException {
            if (!(object instanceof TreeObject)) {
                String string = Util.THIS.getString("EXC_invalid_instance_of_TreeObject");
                throw new ClassCastException(string);
            }
        }

        protected final void checkAssignableClass(Class clazz, Object object) throws ClassCastException {
            if (!clazz.isInstance(object)) {
                String string = Util.THIS.getString("EXC_is_not_assignable_to", clazz.getName());
                throw new ClassCastException(string);
            }
        }

        public abstract void objectInserted(TreeObject var1);

        public abstract void objectRemoved(TreeObject var1);

        public abstract void orderChanged(int[] var1);
    }
}

